/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.hibernate;

import java.util.Date;
import org.hibernate.Interceptor;
import org.hibernate.type.Type;
import org.springframework.core.annotation.AnnotationUtils;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.RelatedToAuditable;
import org.squashtest.tm.domain.audit.Auditable;
import org.squashtest.tm.domain.audit.AuditableSupport;
import org.squashtest.tm.security.UserContextHolder;

public class AuditLogInterceptor
implements Interceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuditLogInterceptor.class);

    public void onDelete(Object entity, Object id, Object[] state, String[] propertyNames, Type[] types) {
        LOGGER.debug("Deleting entity {}", new Object[]{entity});
        if (RelatedToAuditable.class.isAssignableFrom(entity.getClass())) {
            this.checkAndLogAuditableRelatedEntityModificationData(entity);
        }
    }

    public boolean onFlushDirty(Object entity, Object id, Object[] currentState, Object[] previousState, String[] propertyNames, Type[] types) {
        LOGGER.debug("Entity {} is dirty and will be flushed", new Object[]{entity});
        boolean currentStateIsModified = false;
        if (this.isAuditable(entity)) {
            this.checkAndLogModificationData(entity, currentState);
            currentStateIsModified = true;
        }
        if (RelatedToAuditable.class.isAssignableFrom(entity.getClass())) {
            this.checkAndLogAuditableRelatedEntityModificationData(entity);
        }
        return currentStateIsModified;
    }

    private boolean isAuditable(Object entity) {
        return AnnotationUtils.findAnnotation(entity.getClass(), Auditable.class) != null;
    }

    private void checkAndLogModificationData(Object entity, Object[] currentState) {
        try {
            AuditableSupport audit = this.findAudit(currentState);
            if (audit.isReadOnlyModifyAudit()) {
                LOGGER.debug("Updating read only audit {} of entity {}", new Object[]{audit, entity});
                audit.setLastModifiedBy(audit.getReadOnlyLastModifiedBy());
                audit.setLastModifiedOn(audit.getReadOnlyLastModifiedOn());
                return;
            }
            if (!audit.isSkipModifyAudit()) {
                LOGGER.debug("Updating audit {} of entity {}", new Object[]{audit, entity});
                audit.setLastModifiedBy(this.getCurrentUser());
                audit.setLastModifiedOn(new Date());
            }
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Non Auditable entity is : " + String.valueOf(entity), e);
        }
    }

    private AuditableSupport findAudit(Object[] state) {
        Object[] objectArray = state;
        int n = state.length;
        int n2 = 0;
        while (n2 < n) {
            Object field = objectArray[n2];
            if (field != null && AuditableSupport.class.isAssignableFrom(field.getClass())) {
                return (AuditableSupport)field;
            }
            ++n2;
        }
        throw new IllegalArgumentException("Could not find property of type '" + String.valueOf(AuditableSupport.class) + "'");
    }

    public boolean onSave(Object entity, Object id, Object[] state, String[] propertyNames, Type[] types) {
        LOGGER.debug("Saving entity {}", new Object[]{entity});
        boolean stateIsModified = false;
        if (this.isAuditable(entity)) {
            this.logCreationData(entity, state);
            stateIsModified = true;
        }
        if (RelatedToAuditable.class.isAssignableFrom(entity.getClass())) {
            this.checkAndLogAuditableRelatedEntityModificationData(entity);
        }
        return stateIsModified;
    }

    private void logCreationData(Object entity, Object[] state) {
        try {
            AuditableSupport audit = this.findAudit(state);
            if (audit.getCreatedBy() == null && audit.getCreatedOn() == null) {
                audit.setCreatedBy(this.getCurrentUser());
                audit.setCreatedOn(new Date());
            }
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Non Auditable entity is : " + String.valueOf(entity), e);
        }
    }

    private String getCurrentUser() {
        return UserContextHolder.getUsername();
    }

    private void checkAndLogAuditableRelatedEntityModificationData(Object entity) {
        RelatedToAuditable relatedToAuditable = (RelatedToAuditable)entity;
        relatedToAuditable.getAssociatedAuditableList().forEach(auditable -> {
            if (auditable == null) {
                throw new IllegalArgumentException("Could not update modification data. Unknown related auditable.");
            }
            LOGGER.debug("Updating auditable {} related to entity {}", new Object[]{auditable, entity});
            auditable.setLastModifiedOn(new Date());
            auditable.setLastModifiedBy(this.getCurrentUser());
        });
    }
}

