/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.foundation.collection;

import java.util.Collection;
import java.util.Iterator;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.squashtest.tm.core.foundation.collection.MultiSorting;
import org.squashtest.tm.core.foundation.collection.Sorting;

public final class SortingUtils {
    private static final Pattern HQL_ORDER_PATTERN = Pattern.compile("order\\s+by\\s+\\S+\\s+(asc|desc)");

    private SortingUtils() {
    }

    public static String addOrders(String hql, Collection<Sorting> sortings) {
        StringBuilder builder = new StringBuilder(hql);
        for (Sorting sorting : sortings) {
            SortingUtils.addOrder(builder, sorting);
        }
        return builder.toString();
    }

    public static void addOrder(StringBuilder hqlbuilder, Sorting sorting) {
        if (StringUtils.isBlank((CharSequence)sorting.getSortedAttribute())) {
            return;
        }
        SortingUtils.handlePreviousOrderClauses(hqlbuilder);
        hqlbuilder.append(sorting.getSortedAttribute()).append(" ").append(sorting.getSortOrder().getCode()).append(" nulls first");
    }

    public static String addOrder(String hql, Sorting sorting) {
        StringBuilder res = new StringBuilder(hql);
        SortingUtils.addOrder(res, sorting);
        return res.toString();
    }

    public static void addOrder(StringBuilder hqlbuilder, MultiSorting sortings) {
        if (sortings.getSortings().isEmpty()) {
            return;
        }
        SortingUtils.handlePreviousOrderClauses(hqlbuilder);
        Iterator iter = sortings.getSortings().iterator();
        while (iter.hasNext()) {
            Sorting sorting = (Sorting)iter.next();
            hqlbuilder.append(sorting.getSortedAttribute()).append(" ").append(sorting.getSortOrder().getCode());
            if (!iter.hasNext()) continue;
            hqlbuilder.append(", ");
        }
    }

    public static String addOrder(String hql, MultiSorting sorting) {
        StringBuilder res = new StringBuilder(hql);
        SortingUtils.addOrder(res, sorting);
        return res.toString();
    }

    private static void handlePreviousOrderClauses(StringBuilder hqlbuilder) {
        if (HQL_ORDER_PATTERN.matcher(hqlbuilder.toString()).find()) {
            hqlbuilder.append(", ");
        } else {
            hqlbuilder.append(" order by ");
        }
    }
}

