/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.feature.experimental;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.stereotype.Service;
import org.squashtest.tm.core.foundation.exception.FeatureFlagNotEnabledException;
import org.squashtest.tm.core.foundation.feature.ExperimentalFeature;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.service.feature.experimental.ExperimentalFeatureManager;
import org.squashtest.tm.service.internal.feature.experimental.ExperimentalFeatureConfig;

@Service
public class ExperimentalFeatureManagerImpl
implements ExperimentalFeatureManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExperimentalFeatureManagerImpl.class);
    private final ExperimentalFeatureConfig configuration;

    public ExperimentalFeatureManagerImpl(ExperimentalFeatureConfig configuration) {
        this.configuration = configuration;
    }

    @Override
    public List<ExperimentalFeature> getEnabledFeatures() {
        return this.configuration.getExperimental().entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).map(this::toExperimentalFeature).filter(Objects::nonNull).toList();
    }

    @Override
    public boolean isEnabled(ExperimentalFeature featureFlag) {
        return this.getEnabledFeatures().contains(featureFlag);
    }

    @Override
    public void checkIfEnabled(ExperimentalFeature featureFlag) {
        if (!this.isEnabled(featureFlag)) {
            throw new FeatureFlagNotEnabledException();
        }
    }

    private ExperimentalFeature toExperimentalFeature(String candidate) {
        try {
            return ExperimentalFeature.valueOf((String)candidate.toUpperCase().replace("-", "_"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("Unknown experimental feature: {}", new Object[]{candidate});
            }
            return null;
        }
    }
}

