/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.sprintgroup;

import java.util.Map;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.campaign.SprintGroup;
import org.squashtest.tm.service.annotation.CheckEntityExists;
import org.squashtest.tm.service.annotation.Id;
import org.squashtest.tm.service.campaign.SprintStatisticsService;
import org.squashtest.tm.service.display.sprintgroup.SprintGroupDisplayService;
import org.squashtest.tm.service.internal.display.dto.AttachmentListDto;
import org.squashtest.tm.service.internal.display.dto.sprintgroup.SprintGroupDto;
import org.squashtest.tm.service.internal.library.EntityPathHeaderService;
import org.squashtest.tm.service.internal.repository.display.AttachmentDisplayDao;
import org.squashtest.tm.service.internal.repository.display.SprintGroupDisplayDao;
import org.squashtest.tm.service.statistics.sprint.SprintStatisticsBundle;

@Service
@Transactional(readOnly=true)
public class SprintGroupDisplayServiceImpl
implements SprintGroupDisplayService {
    private final SprintGroupDisplayDao sprintGroupDisplayDao;
    private final AttachmentDisplayDao attachmentDisplayDao;
    private final EntityPathHeaderService entityPathHeaderService;
    private final SprintStatisticsService sprintStatisticsService;

    public SprintGroupDisplayServiceImpl(SprintGroupDisplayDao sprintGroupDisplayDao, AttachmentDisplayDao attachmentDisplayDao, EntityPathHeaderService entityPathHeaderService, SprintStatisticsService sprintStatisticsService) {
        this.sprintGroupDisplayDao = sprintGroupDisplayDao;
        this.attachmentDisplayDao = attachmentDisplayDao;
        this.entityPathHeaderService = entityPathHeaderService;
        this.sprintStatisticsService = sprintStatisticsService;
    }

    @Override
    @PreAuthorize(value="hasPermission(#sprintGroupId, 'org.squashtest.tm.domain.campaign.SprintGroup' ,'READ')  or hasRole('ROLE_ADMIN')")
    @CheckEntityExists(entityType=SprintGroup.class)
    public SprintGroupDto getSprintGroupView(@Id long sprintGroupId) {
        SprintGroupDto sprintGroupDto = this.sprintGroupDisplayDao.getSprintGroupDtoById(sprintGroupId);
        sprintGroupDto.setHasSynchronizedSprints(this.sprintGroupDisplayDao.checkIfHasSynchronizedSprints(sprintGroupId));
        AttachmentListDto attachmentList = this.attachmentDisplayDao.findAttachmentListById(sprintGroupDto.getAttachmentListId());
        sprintGroupDto.setAttachmentList(attachmentList);
        sprintGroupDto.setBreadcrumbs(this.entityPathHeaderService.getCampaignLibraryNodeHeaderBreadcrumbs(sprintGroupId, true));
        return sprintGroupDto;
    }

    @Override
    @PreAuthorize(value="hasPermission(#sprintGroupId, 'org.squashtest.tm.domain.campaign.SprintGroup' ,'READ')  or hasRole('ROLE_ADMIN')")
    public SprintStatisticsBundle getSprintGroupStatistics(long sprintGroupId, boolean lastExecutionScope) {
        Map<Long, String> sprintSyncKindBySprintIdMap = this.sprintGroupDisplayDao.getSprintsInSprintGroup(sprintGroupId);
        return this.sprintStatisticsService.gatherMultiStatisticsBundle(sprintSyncKindBySprintIdMap, lastExecutionScope);
    }
}

