/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.search.filter;

import com.google.common.collect.Sets;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.jpa.hibernate.HibernateQuery;
import java.util.List;
import java.util.Set;
import org.springframework.stereotype.Component;
import org.squashtest.tm.domain.jpql.ExtendedHibernateQuery;
import org.squashtest.tm.domain.requirement.QRequirement;
import org.squashtest.tm.domain.requirement.QRequirementVersion;
import org.squashtest.tm.domain.requirement.RequirementStatus;
import org.squashtest.tm.service.internal.display.grid.GridFilterValue;
import org.squashtest.tm.service.internal.display.grid.GridRequest;
import org.squashtest.tm.service.internal.display.search.filter.FilterHandler;

@Component
public class CurrentVersionFilterHandler
implements FilterHandler {
    private final Set<String> handledPrototypes = Sets.newHashSet((Object[])new String[]{"REQUIREMENT_VERSION_CURRENT_VERSION"});

    @Override
    public boolean canHandleFilter(GridFilterValue filter) {
        return this.handledPrototypes.contains(filter.getColumnPrototype());
    }

    @Override
    public void handleFilter(ExtendedHibernateQuery<?> query, GridFilterValue filter, GridRequest gridRequest) {
        CurrentVersionFilterValue currentVersionFilterValue = this.extractFilterValue(filter);
        if (currentVersionFilterValue.requireAdditionalFilterClause()) {
            this.addFilterClause(query, currentVersionFilterValue);
        }
    }

    private void addFilterClause(ExtendedHibernateQuery<?> query, CurrentVersionFilterValue currentVersionFilterValue) {
        QRequirementVersion outerVersion = QRequirementVersion.requirementVersion;
        QRequirement outerRequirement = QRequirement.requirement;
        QRequirement parent = new QRequirement("parent");
        QRequirementVersion initVersion = new QRequirementVersion("initVersion");
        QRequirementVersion maxVersion = new QRequirementVersion("maxVersion");
        HibernateQuery subquery = (HibernateQuery)((HibernateQuery)new ExtendedHibernateQuery().select((Expression)Expressions.ONE).from((EntityPath)initVersion)).where((Predicate)initVersion.id.eq((Expression)outerVersion.id).and((Predicate)initVersion.versionNumber.in((SubQueryExpression)((HibernateQuery)((HibernateQuery)((HibernateQuery)new ExtendedHibernateQuery().select((Expression)maxVersion.versionNumber.max()).from((EntityPath)maxVersion)).join((EntityPath)maxVersion.requirement, (Path)parent)).where((Predicate)this.getWhereClause(maxVersion, currentVersionFilterValue).and((Predicate)parent.id.eq((Expression)outerRequirement.id)))).groupBy((Expression)parent.id))));
        query.where((Predicate)subquery.exists());
    }

    private BooleanExpression getWhereClause(QRequirementVersion maxVersion, CurrentVersionFilterValue currentVersionFilterValue) {
        if (currentVersionFilterValue.equals((Object)CurrentVersionFilterValue.CURRENT)) {
            return Expressions.asNumber((Number)1).eq((Object)1);
        }
        return maxVersion.status.ne((Object)RequirementStatus.OBSOLETE);
    }

    private CurrentVersionFilterValue extractFilterValue(GridFilterValue filter) {
        List<String> values = filter.getValues();
        if (values.size() != 1) {
            throw new IllegalArgumentException("Invalid value for filter REQUIREMENT_VERSION_CURRENT_VERSION");
        }
        return CurrentVersionFilterValue.valueOf(values.get(0));
    }

    public static enum CurrentVersionFilterValue {
        ALL,
        LAST_NON_OBSOLETE,
        CURRENT;


        boolean requireAdditionalFilterClause() {
            return !this.equals((Object)ALL);
        }
    }
}

