/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.grid.columns;

import com.google.common.base.CaseFormat;
import com.google.common.base.Converter;
import org.jooq.Field;
import org.jooq.SortField;
import org.jooq.impl.DSL;
import org.squashtest.tm.service.internal.display.grid.GridSort;

public class GridColumn {
    protected final Field<?> aliasedField;
    protected final Field<?> nativeField;

    public GridColumn(String fieldAlias) {
        this(DSL.field((String)fieldAlias));
    }

    public GridColumn(Field<?> nativeField) {
        this.nativeField = nativeField;
        this.aliasedField = nativeField;
    }

    public GridColumn(Field<?> aliasedField, Field<?> nativeField) {
        this.nativeField = nativeField;
        this.aliasedField = aliasedField;
    }

    public Field<?> getAliasedField() {
        return this.aliasedField;
    }

    public Field<?> getNativeField() {
        return this.nativeField;
    }

    public String findRuntimeAlias() {
        Converter converter = CaseFormat.UPPER_UNDERSCORE.converterTo(CaseFormat.LOWER_CAMEL);
        return (String)converter.convert((Object)this.aliasedField.getName());
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that instanceof GridColumn) {
            return ((GridColumn)that).aliasedField.equals(this.aliasedField);
        }
        return super.equals(that);
    }

    public int hashCode() {
        int result = this.aliasedField != null ? this.aliasedField.hashCode() : 0;
        result = 31 * result + (this.nativeField != null ? this.nativeField.hashCode() : 0);
        return result;
    }

    public SortField<?> generateOrderClause(GridSort.SortDirection direction) {
        if (direction.equals((Object)GridSort.SortDirection.ASC)) {
            return this.aliasedField.asc();
        }
        return this.aliasedField.desc();
    }
}

