/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.grid.administration;

import java.util.Arrays;
import java.util.List;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.SelectField;
import org.jooq.SortField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.jooq.domain.tables.ThirdPartyServer;
import org.squashtest.tm.service.internal.display.grid.AbstractGrid;
import org.squashtest.tm.service.internal.display.grid.columns.GridColumn;

public class ProjectGrid
extends AbstractGrid {
    private static final Long PROJECT_CLASS_ID = 1L;
    private static final Long TEMPLATE_CLASS_ID = 5L;
    private static final ThirdPartyServer bugTrackerThirdPartyServer = Tables.THIRD_PARTY_SERVER.as("BUGTRACKER_THIRD_PARTY_SERVER");
    private static final ThirdPartyServer testAutomationThirdPartyServer = Tables.THIRD_PARTY_SERVER.as("TEST_AUTOMATION_THIRD_PARTY_SERVER");
    private final List<Long> projectIds;

    public ProjectGrid(List<Long> projectIds) {
        this.projectIds = projectIds;
    }

    @Override
    protected List<GridColumn> getColumns() {
        return Arrays.asList(new GridColumn((Field<?>)Tables.PROJECT.NAME), new GridColumn((Field<?>)Tables.PROJECT.PROJECT_ID), new GridColumn((Field<?>)Tables.PROJECT.LABEL), new GridColumn((Field<?>)Tables.PROJECT.CREATED_ON), new GridColumn((Field<?>)Tables.PROJECT.CREATED_BY), new GridColumn((Field<?>)Tables.PROJECT.LAST_MODIFIED_ON), new GridColumn((Field<?>)Tables.PROJECT.LAST_MODIFIED_BY), new GridColumn(this.getHasPermissions().as("HAS_PERMISSIONS")), new GridColumn(ProjectGrid.bugTrackerThirdPartyServer.NAME.as("BUGTRACKER_NAME")), new GridColumn(ProjectGrid.testAutomationThirdPartyServer.NAME.as("EXECUTION_SERVER")), new GridColumn(DSL.field((Condition)Tables.PROJECT.PROJECT_TYPE.eq((Object)"T")).as("IS_TEMPLATE")), new GridColumn((Field<?>)Tables.PROJECT.AUTOMATED_SUITES_LIFETIME));
    }

    @Override
    protected Table<?> getTable() {
        return Tables.PROJECT.leftJoin((TableLike)Tables.BUGTRACKER).on(Tables.PROJECT.BUGTRACKER_ID.eq((Field)Tables.BUGTRACKER.BUGTRACKER_ID)).leftJoin((TableLike)bugTrackerThirdPartyServer).on(ProjectGrid.bugTrackerThirdPartyServer.SERVER_ID.eq((Field)Tables.BUGTRACKER.BUGTRACKER_ID)).leftJoin((TableLike)Tables.TEST_AUTOMATION_SERVER).on(Tables.PROJECT.TA_SERVER_ID.eq((Field)Tables.TEST_AUTOMATION_SERVER.SERVER_ID)).leftJoin((TableLike)testAutomationThirdPartyServer).on(Tables.TEST_AUTOMATION_SERVER.SERVER_ID.eq((Field)ProjectGrid.testAutomationThirdPartyServer.SERVER_ID));
    }

    @Override
    protected Field<?> getIdentifier() {
        return Tables.PROJECT.PROJECT_ID;
    }

    @Override
    protected Field<?> getProjectIdentifier() {
        return Tables.PROJECT.PROJECT_ID;
    }

    @Override
    protected Condition craftInvariantFilter() {
        return Tables.PROJECT.PROJECT_ID.in(this.projectIds);
    }

    private Field<Boolean> getHasPermissions() {
        return DSL.select((SelectField)DSL.field((Condition)DSL.count((Field)Tables.ACL_RESPONSIBILITY_SCOPE_ENTRY.ID).gt((Object)0)).as("HAS_PERMISSIONS")).from((TableLike)Tables.ACL_RESPONSIBILITY_SCOPE_ENTRY).innerJoin((TableLike)Tables.ACL_OBJECT_IDENTITY).on(Tables.ACL_RESPONSIBILITY_SCOPE_ENTRY.OBJECT_IDENTITY_ID.eq((Field)Tables.ACL_OBJECT_IDENTITY.ID)).where(Tables.ACL_OBJECT_IDENTITY.CLASS_ID.eq((Object)PROJECT_CLASS_ID).and(Tables.ACL_OBJECT_IDENTITY.IDENTITY.eq((Field)Tables.PROJECT.PROJECT_ID))).or(Tables.ACL_OBJECT_IDENTITY.CLASS_ID.eq((Object)TEMPLATE_CLASS_ID)).and(Tables.ACL_OBJECT_IDENTITY.IDENTITY.eq((Field)Tables.PROJECT.PROJECT_ID)).asField();
    }

    @Override
    protected SortField<?> getDefaultOrder() {
        return DSL.upper((Field)Tables.PROJECT.NAME).asc();
    }
}

