/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.grid;

import java.util.ArrayList;
import java.util.List;
import org.squashtest.tm.service.internal.display.grid.DataRow;
import org.squashtest.tm.service.internal.display.grid.GridRequest;
import org.squashtest.tm.service.internal.utils.HTMLCleanupUtils;

public class GridResponse {
    private long count;
    private String idAttribute;
    private List<DataRow> dataRows = new ArrayList<DataRow>();
    private List<String> activeColumnIds;
    private Integer page;

    public static Integer getPageNumberWithinBounds(GridRequest gridRequest, Long totalCount) {
        return GridResponse.getPageNumberWithinBounds(gridRequest.getPage(), gridRequest.getSize(), totalCount);
    }

    public static Integer getPageNumberWithinBounds(Integer requestedPageNumber, Integer requestedPageSize, Long totalCount) {
        if (totalCount == null || requestedPageNumber == null || requestedPageSize == null) {
            return requestedPageNumber;
        }
        if (totalCount == 0L) {
            return 0;
        }
        int pageMax = (int)Math.floor(((double)totalCount.longValue() - 1.0) / (double)requestedPageSize.intValue());
        return Math.min(pageMax, requestedPageNumber);
    }

    public void sanitizeField(String fieldId) {
        this.dataRows.forEach(dataRow -> {
            Object fieldValue = dataRow.getData().get(fieldId);
            if (fieldValue != null) {
                String sanitized = HTMLCleanupUtils.htmlToTrimmedText(fieldValue.toString());
                dataRow.getData().put(fieldId, sanitized);
            }
        });
    }

    public long getCount() {
        return this.count;
    }

    public void setCount(long count) {
        this.count = count;
    }

    public List<DataRow> getDataRows() {
        return this.dataRows;
    }

    public void setDataRows(List<DataRow> dataRows) {
        this.dataRows = dataRows;
    }

    public void addDataRow(DataRow dataRow) {
        this.dataRows.add(dataRow);
    }

    public String getIdAttribute() {
        return this.idAttribute;
    }

    public void setIdAttribute(String idAttribute) {
        this.idAttribute = idAttribute;
    }

    public List<String> getActiveColumnIds() {
        return this.activeColumnIds;
    }

    public void setActiveColumnIds(List<String> activeColumnIds) {
        this.activeColumnIds = activeColumnIds;
    }

    public Integer getPage() {
        return this.page;
    }

    public void setPage(Integer page) {
        this.page = page;
    }
}

