/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.campaign.export;

import java.io.File;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jooq.CommonTableExpression;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.Name;
import org.jooq.OrderField;
import org.jooq.Record;
import org.jooq.Record2;
import org.jooq.Record3;
import org.jooq.ResultQuery;
import org.jooq.Select;
import org.jooq.SelectField;
import org.jooq.SelectFieldOrAsterisk;
import org.jooq.SelectHavingStep;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.jooq.impl.SQLDataType;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.jooq.domain.tables.InfoListItem;
import org.squashtest.tm.service.campaign.export.CampaignExportFull;
import org.squashtest.tm.service.campaign.export.CampaignExportWriter;
import org.squashtest.tm.service.feature.FeatureManager;
import org.squashtest.tm.service.internal.campaign.export.AbstractCampaignExport;
import org.squashtest.tm.service.internal.campaign.export.CampaignExportHeader;
import org.squashtest.tm.service.internal.campaign.export.CampaignExportMode;
import org.squashtest.tm.service.internal.campaign.export.CampaignExportRows;
import org.squashtest.tm.service.internal.dto.CustomFieldValueDto;
import org.squashtest.tm.service.internal.jooq.SubElementRecordProcessor;

@Service
@Transactional
public class CampaignExportFullImpl
extends AbstractCampaignExport
implements CampaignExportFull {
    private final Field<Long> testCaseHolderIdField = DSL.field((Name)DSL.name((String)"test_case_holder_id"), Long.class);
    private final Field<String> stepPathField = DSL.field((String)"step_path", String.class);
    private final Field<Long> executionCountField = DSL.field((String)"execution_count", Long.class);
    private final Field<Long> testCaseCoverageCountField = DSL.field((String)"tc_coverage_count", Long.class);
    private final Field<Long> testStepCoverageCountField = DSL.field((String)"ts_coverage_count", Long.class);
    private final Field<Long> executionIssueCountField = DSL.field((String)"execution_issue_count", Long.class);
    private final Field<Long> executionStepIssueCountField = DSL.field((String)"execution_step_issue_count", Long.class);
    private final Field<String> testCaseMilestoneLabels = DSL.field((String)"test_case_milestone_labels", String.class);
    private final InfoListItem testCaseNature = Tables.INFO_LIST_ITEM.as("test_case_nature");
    private final InfoListItem testCaseType = Tables.INFO_LIST_ITEM.as("test_case_type");

    public CampaignExportFullImpl(DSLContext dsl, CampaignExportWriter campaignExportWriter, FeatureManager featureManager) {
        super(dsl, campaignExportWriter, featureManager);
    }

    private Table<? extends Record> getTestCaseWithStep(Long campaignId) {
        String cteName = "test_case_cte";
        Field holderIdField = DSL.field((Name)DSL.name((String[])new String[]{cteName, "holder_id"}), Long.class);
        Field calledTcField = DSL.field((Name)DSL.name((String[])new String[]{cteName, "called_tc"}), Long.class);
        Field depthField = DSL.field((Name)DSL.name((String[])new String[]{cteName, "depth"}), Integer.class);
        Field isCallField = DSL.field((Name)DSL.name((String[])new String[]{cteName, "is_call"}), Boolean.class);
        CommonTableExpression cte = DSL.name((String)cteName).fields(Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID.getName(), holderIdField.getName(), Tables.TEST_CASE_STEPS.STEP_ID.getName(), this.stepPathField.getName(), depthField.getName(), isCallField.getName(), calledTcField.getName()).as((ResultQuery)DSL.select((SelectField)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID, (SelectField)Tables.TEST_CASE.TCLN_ID.as(holderIdField), (SelectField)Tables.TEST_CASE_STEPS.STEP_ID, (SelectField)DSL.lpad((Field)DSL.coalesce((Field)Tables.TEST_CASE_STEPS.STEP_ORDER, (Object)0).cast(String.class), (int)2, (char)'0').cast(SQLDataType.VARCHAR((int)128)).as(this.stepPathField), (SelectField)DSL.val((int)0).as(depthField), (SelectField)Tables.CALL_TEST_STEP.TEST_STEP_ID.isNotNull().as(isCallField), (SelectField)Tables.CALL_TEST_STEP.CALLED_TEST_CASE_ID.as(calledTcField)).from((TableLike)Tables.CAMPAIGN_ITERATION).join((TableLike)Tables.ITERATION).on(Tables.ITERATION.ITERATION_ID.eq((Field)Tables.CAMPAIGN_ITERATION.ITERATION_ID)).join((TableLike)Tables.TEST_PLAN_ITEM).on(Tables.TEST_PLAN_ITEM.TEST_PLAN_ID.eq((Field)Tables.ITERATION.TEST_PLAN_ID)).join((TableLike)Tables.TEST_CASE).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.TEST_PLAN_ITEM.TCLN_ID)).leftJoin((TableLike)Tables.TEST_CASE_STEPS).on(Tables.TEST_CASE_STEPS.TEST_CASE_ID.eq((Field)Tables.TEST_CASE.TCLN_ID)).leftJoin((TableLike)Tables.CALL_TEST_STEP).on(Tables.CALL_TEST_STEP.TEST_STEP_ID.eq((Field)Tables.TEST_CASE_STEPS.STEP_ID)).leftJoin((TableLike)Tables.EXECUTION).on(Tables.EXECUTION.TEST_PLAN_ITEM_ID.eq((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID)).where(Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID.eq((Object)campaignId)).and(Tables.EXECUTION.TEST_PLAN_ITEM_ID.isNull()).unionAll((Select)DSL.select((SelectField)DSL.field((Name)DSL.name((String[])new String[]{cteName, Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID.getName()}), Long.class), (SelectField)holderIdField, (SelectField)Tables.TEST_CASE_STEPS.STEP_ID, (SelectField)DSL.concat((Field[])new Field[]{this.stepPathField, DSL.val((String)"."), DSL.lpad((Field)DSL.coalesce((Field)Tables.TEST_CASE_STEPS.STEP_ORDER, (Object)0).cast(String.class), (int)2, (char)'0')}).cast(SQLDataType.VARCHAR((int)128)).as(this.stepPathField), (SelectField)depthField.add((Number)1).as(depthField), (SelectField)Tables.CALL_TEST_STEP.TEST_STEP_ID.isNotNull().as(isCallField), (SelectField)Tables.CALL_TEST_STEP.CALLED_TEST_CASE_ID.as(calledTcField)).from(DSL.name((String)cteName)).join((TableLike)Tables.TEST_CASE_STEPS).on(Tables.TEST_CASE_STEPS.TEST_CASE_ID.eq(calledTcField)).leftJoin((TableLike)Tables.CALL_TEST_STEP).on(Tables.CALL_TEST_STEP.TEST_STEP_ID.eq((Field)Tables.TEST_CASE_STEPS.STEP_ID)).where(isCallField.eq((Object)true)).and(depthField.lt((Object)50))));
        return this.dsl.withRecursive(new CommonTableExpression[]{cte}).select((SelectField)Objects.requireNonNull(cte.field((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID)).as((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID), (SelectField)holderIdField.as(this.testCaseHolderIdField), (SelectField)Objects.requireNonNull(cte.field((Field)Tables.TEST_CASE_STEPS.STEP_ID)).as((Field)Tables.TEST_CASE_STEPS.STEP_ID), this.stepPathField).from((TableLike)cte).where(Objects.requireNonNull(cte.field(isCallField)).eq((Object)false)).asTable();
    }

    private CommonTableExpression<? extends Record> getCampaignExportCte(Long campaignId) {
        Table<? extends Record> testCaseWithStepTable = this.getTestCaseWithStep(campaignId);
        Table<Record3<Long, Long, Integer>> lastExecutionTable = this.getLastestExecution(campaignId);
        return DSL.name((String)"cte").fields(Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID.getName(), Tables.CAMPAIGN_ITERATION.ITERATION_ORDER.getName(), Tables.ITERATION.ITERATION_ID.getName(), Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID.getName(), Tables.EXECUTION.EXECUTION_ID.getName(), Tables.EXECUTION_STEP.EXECUTION_STEP_ID.getName(), Tables.EXECUTION_EXECUTION_STEPS.EXECUTION_STEP_ORDER.getName(), Tables.TEST_CASE_STEPS.STEP_ID.getName(), Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.getName(), this.stepPathField.getName()).as((ResultQuery)DSL.select((SelectField)Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID, (SelectField)Tables.CAMPAIGN_ITERATION.ITERATION_ORDER, (SelectField)Tables.ITERATION.ITERATION_ID, (SelectField)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID, (SelectField)lastExecutionTable.field((Field)Tables.EXECUTION.EXECUTION_ID), (SelectField)Tables.EXECUTION_STEP.EXECUTION_STEP_ID, (SelectField)Tables.EXECUTION_EXECUTION_STEPS.EXECUTION_STEP_ORDER, (SelectField)Tables.TEST_CASE_STEPS.STEP_ID, (SelectField)Tables.TEST_PLAN_ITEM.TCLN_ID, (SelectField)DSL.val(null).as(this.stepPathField)).from((TableLike)Tables.CAMPAIGN_ITERATION).join((TableLike)Tables.ITERATION).on(Tables.ITERATION.ITERATION_ID.eq((Field)Tables.CAMPAIGN_ITERATION.ITERATION_ID)).join((TableLike)Tables.TEST_PLAN_ITEM).on(Tables.TEST_PLAN_ITEM.TEST_PLAN_ID.eq((Field)Tables.ITERATION.TEST_PLAN_ID)).join(lastExecutionTable).on(Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID.eq(lastExecutionTable.field((Field)Tables.EXECUTION.TEST_PLAN_ITEM_ID)).and(AbstractCampaignExport.EXECUTION_POSITION_FIELD.eq((Object)1))).leftJoin((TableLike)Tables.EXECUTION_EXECUTION_STEPS).on(Tables.EXECUTION_EXECUTION_STEPS.EXECUTION_ID.eq(lastExecutionTable.field((Field)Tables.EXECUTION.EXECUTION_ID))).leftJoin((TableLike)Tables.EXECUTION_STEP).on(Tables.EXECUTION_STEP.EXECUTION_STEP_ID.eq((Field)Tables.EXECUTION_EXECUTION_STEPS.EXECUTION_STEP_ID)).leftJoin((TableLike)Tables.TEST_CASE_STEPS).on(Tables.EXECUTION_STEP.TEST_STEP_ID.eq((Field)Tables.TEST_CASE_STEPS.STEP_ID)).where(Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID.eq((Object)campaignId)).unionAll((Select)DSL.select((SelectField)Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID, (SelectField)Tables.CAMPAIGN_ITERATION.ITERATION_ORDER, (SelectField)Tables.ITERATION.ITERATION_ID, (SelectField)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID, (SelectField)DSL.val(null).as((Field)Tables.EXECUTION.EXECUTION_ID), (SelectField)DSL.val(null).as((Field)Tables.EXECUTION_STEP.EXECUTION_STEP_ID), (SelectField)DSL.val(null).as((Field)Tables.EXECUTION_EXECUTION_STEPS.EXECUTION_STEP_ORDER), (SelectField)testCaseWithStepTable.field((Field)Tables.TEST_CASE_STEPS.STEP_ID), (SelectField)Tables.TEST_PLAN_ITEM.TCLN_ID, (SelectField)testCaseWithStepTable.field(this.stepPathField)).from((TableLike)Tables.CAMPAIGN_ITERATION).join((TableLike)Tables.ITERATION).on(Tables.ITERATION.ITERATION_ID.eq((Field)Tables.CAMPAIGN_ITERATION.ITERATION_ID)).join((TableLike)Tables.TEST_PLAN_ITEM).on(Tables.TEST_PLAN_ITEM.TEST_PLAN_ID.eq((Field)Tables.ITERATION.TEST_PLAN_ID)).join(testCaseWithStepTable).on(Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID.eq(testCaseWithStepTable.field((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID)))));
    }

    private Table<Record2<Long, Integer>> getExecutionCountsTable(CommonTableExpression<? extends Record> cte) {
        return DSL.select((SelectField)Objects.requireNonNull(cte.field((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID)).as((Field)Tables.EXECUTION.TEST_PLAN_ITEM_ID), (SelectField)DSL.countDistinct((Field)cte.field((Field)Tables.EXECUTION.EXECUTION_ID)).as(this.executionCountField)).from(cte).where(Objects.requireNonNull(cte.field((Field)Tables.EXECUTION.EXECUTION_ID)).isNotNull()).groupBy(new GroupField[]{cte.field((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID)}).asTable();
    }

    private Table<Record2<Long, Integer>> getTestCaseCoverageCountsTable(CommonTableExpression<? extends Record> cte) {
        SelectHavingStep testCaseTable = DSL.selectDistinct((SelectField)cte.field((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).from(cte).where(Objects.requireNonNull(cte.field((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).isNotNull()).groupBy(new GroupField[]{cte.field((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)});
        return DSL.select((SelectField)Objects.requireNonNull(testCaseTable.field((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).as((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID), (SelectField)DSL.count((Field)Tables.REQUIREMENT_VERSION_COVERAGE.REQUIREMENT_VERSION_COVERAGE_ID).as(this.testCaseCoverageCountField)).from((TableLike)testCaseTable).join((TableLike)Tables.REQUIREMENT_VERSION_COVERAGE).on(Tables.REQUIREMENT_VERSION_COVERAGE.VERIFYING_TEST_CASE_ID.eq(testCaseTable.field((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID))).groupBy(new GroupField[]{testCaseTable.field((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)}).asTable();
    }

    private Table<Record2<Long, Integer>> getTestStepCoverageCountsTable(CommonTableExpression<? extends Record> cte) {
        SelectHavingStep testStepTable = DSL.select((SelectField)cte.field((Field)Tables.TEST_CASE_STEPS.STEP_ID)).from(cte).where(Objects.requireNonNull(cte.field((Field)Tables.TEST_CASE_STEPS.STEP_ID)).isNotNull()).groupBy(new GroupField[]{cte.field((Field)Tables.TEST_CASE_STEPS.STEP_ID)});
        return this.dsl.select((SelectField)Objects.requireNonNull(testStepTable.field((Field)Tables.TEST_CASE_STEPS.STEP_ID)).as((Field)Tables.TEST_CASE_STEPS.STEP_ID), (SelectField)DSL.count((Field)Tables.VERIFYING_STEPS.REQUIREMENT_VERSION_COVERAGE_ID).as(this.testStepCoverageCountField)).from((TableLike)testStepTable).join((TableLike)Tables.VERIFYING_STEPS).on(Tables.VERIFYING_STEPS.TEST_STEP_ID.eq(testStepTable.field((Field)Tables.TEST_CASE_STEPS.STEP_ID))).groupBy(new GroupField[]{testStepTable.field((Field)Tables.TEST_CASE_STEPS.STEP_ID)}).asTable();
    }

    private Table<Record2<Long, Integer>> getIssueCountsTable(CommonTableExpression<? extends Record> cte, Table<? extends Record> issueHolderTable, Field<Long> issueHolderField, Field<Long> issueListIdField, Field<Long> issueCountField) {
        SelectHavingStep holderTable = DSL.select((SelectField)cte.field(issueHolderField)).from(cte).where(Objects.requireNonNull(cte.field(issueHolderField)).isNotNull()).groupBy(new GroupField[]{cte.field(issueHolderField)});
        return this.dsl.select((SelectField)Objects.requireNonNull(holderTable.field(issueHolderField)).as(issueHolderField), (SelectField)DSL.count((Field)Tables.ISSUE.ISSUE_ID).as(issueCountField)).from((TableLike)holderTable).join(issueHolderTable).on(issueHolderField.eq(holderTable.field(issueHolderField))).join((TableLike)Tables.ISSUE).on(Tables.ISSUE.ISSUE_LIST_ID.eq(holderTable.field(issueListIdField))).groupBy(new GroupField[]{holderTable.field(issueHolderField)}).asTable();
    }

    private Table<Record2<Long, String>> getTestCaseMilestone(CommonTableExpression<? extends Record> cte) {
        SelectHavingStep testCaseTable = DSL.select((SelectField)cte.field((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).from(cte).where(Objects.requireNonNull(cte.field((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).isNotNull()).groupBy(new GroupField[]{cte.field((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)});
        return this.dsl.select((SelectField)Objects.requireNonNull(testCaseTable.field((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).as((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID), (SelectField)DSL.groupConcat((Field)Tables.MILESTONE.LABEL).separator("|").as(this.testCaseMilestoneLabels)).from((TableLike)testCaseTable).join((TableLike)Tables.MILESTONE_TEST_CASE).on(Tables.MILESTONE_TEST_CASE.TEST_CASE_ID.eq(testCaseTable.field((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID))).join((TableLike)Tables.MILESTONE).on(Tables.MILESTONE.MILESTONE_ID.eq((Field)Tables.MILESTONE_TEST_CASE.MILESTONE_ID)).groupBy(new GroupField[]{testCaseTable.field((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)}).asTable();
    }

    @Override
    public ResultQuery<Record> getQuery(Long campaignId) {
        CommonTableExpression<? extends Record> cte = this.getCampaignExportCte(campaignId);
        Table<Record2<Long, Integer>> executionCountsTable = this.getExecutionCountsTable(cte);
        Table<Record2<Long, Integer>> testCaseCoverageCountsTable = this.getTestCaseCoverageCountsTable(cte);
        Table<Record2<Long, Integer>> testStepCoverageCountsTable = this.getTestStepCoverageCountsTable(cte);
        Table<Record2<Long, Integer>> executionIssueCountsTable = this.getIssueCountsTable(cte, (Table<? extends Record>)Tables.EXECUTION, (Field<Long>)Tables.EXECUTION.EXECUTION_ID, (Field<Long>)Tables.EXECUTION.ISSUE_LIST_ID, this.executionIssueCountField);
        Table<Record2<Long, Integer>> executionStepIssueCountsTable = this.getIssueCountsTable(cte, (Table<? extends Record>)Tables.EXECUTION_STEP, (Field<Long>)Tables.EXECUTION_STEP.EXECUTION_STEP_ID, (Field<Long>)Tables.EXECUTION_STEP.ISSUE_LIST_ID, this.executionStepIssueCountField);
        Table<Record2<Long, String>> testCaseMilestoneTable = this.getTestCaseMilestone(cte);
        return this.dsl.with(new CommonTableExpression[]{cte}).select(new SelectFieldOrAsterisk[]{Tables.CAMPAIGN.CLN_ID, Tables.CAMPAIGN.SCHEDULED_START_DATE, Tables.CAMPAIGN.SCHEDULED_END_DATE, Tables.CAMPAIGN.ACTUAL_START_DATE, Tables.CAMPAIGN.ACTUAL_END_DATE, Tables.MILESTONE.LABEL, Tables.ITERATION.ITERATION_ID, cte.field((Field)Tables.CAMPAIGN_ITERATION.ITERATION_ORDER), Tables.ITERATION.NAME, Tables.ITERATION.SCHEDULED_START_DATE, Tables.ITERATION.SCHEDULED_END_DATE, Tables.ITERATION.ACTUAL_START_DATE, Tables.ITERATION.ACTUAL_END_DATE, Tables.TEST_SUITE.NAME, Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID, Tables.TEST_PLAN_ITEM.ITEM_ORDER, Tables.TEST_PLAN_ITEM.EXECUTION_STATUS, Tables.TEST_PLAN_ITEM.LAST_EXECUTED_ON, Tables.CORE_USER.LOGIN, Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID, Tables.TEST_CASE_LIBRARY_NODE.NAME, Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID, Tables.TEST_CASE_LIBRARY_NODE.DESCRIPTION.as((Field)Tables.TEST_CASE_LIBRARY_NODE.DESCRIPTION), Tables.TEST_CASE.REFERENCE, Tables.TEST_CASE.TC_STATUS, Tables.TEST_CASE.IMPORTANCE, this.testCaseNature.CODE, this.testCaseType.CODE, Tables.DATASET.NAME, DSL.coalesce((Object)testCaseCoverageCountsTable.field(this.testCaseCoverageCountField), (Object[])new Serializable[]{Integer.valueOf(0)}).as(this.testCaseCoverageCountField), DSL.coalesce((Field)testCaseMilestoneTable.field(this.testCaseMilestoneLabels), (Object)"").as(this.testCaseMilestoneLabels), Objects.requireNonNull(cte.field((Field)Tables.TEST_CASE_STEPS.STEP_ID)).as((Field)Tables.TEST_CASE_STEPS.STEP_ID), Tables.PROJECT.NAME, Objects.requireNonNull(cte.field((Field)Tables.EXECUTION.EXECUTION_ID)).as((Field)Tables.EXECUTION.EXECUTION_ID), DSL.coalesce((Object)executionCountsTable.field(this.executionCountField), (Object[])new Serializable[]{Integer.valueOf(0)}).as(this.executionCountField), DSL.coalesce((Object)executionIssueCountsTable.field(this.executionIssueCountField), (Object[])new Serializable[]{Integer.valueOf(0)}).as(this.executionIssueCountField), Tables.EXECUTION_STEP.EXECUTION_STEP_ID, Tables.EXECUTION_STEP.EXECUTION_STATUS, Tables.EXECUTION_STEP.LAST_EXECUTED_ON, Tables.EXECUTION_STEP.LAST_EXECUTED_BY, DSL.coalesce((Object)testStepCoverageCountsTable.field(this.testStepCoverageCountField), (Object[])new Serializable[]{Integer.valueOf(0)}).as(this.testStepCoverageCountField), DSL.coalesce((Object)executionStepIssueCountsTable.field(this.executionStepIssueCountField), (Object[])new Serializable[]{Integer.valueOf(0)}).as(this.executionStepIssueCountField), Tables.EXECUTION_STEP.COMMENT}).from(cte).join((TableLike)Tables.CAMPAIGN).on(Tables.CAMPAIGN.CLN_ID.eq(cte.field((Field)Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID))).join((TableLike)Tables.ITERATION).on(Tables.ITERATION.ITERATION_ID.eq(cte.field((Field)Tables.ITERATION.ITERATION_ID))).join((TableLike)Tables.TEST_PLAN_ITEM).on(Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID.eq(cte.field((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID))).leftJoin((TableLike)Tables.DATASET).on(Tables.DATASET.DATASET_ID.eq((Field)Tables.TEST_PLAN_ITEM.DATASET_ID)).leftJoin((TableLike)Tables.CORE_USER).on(Tables.CORE_USER.LOGIN.eq((Field)Tables.TEST_PLAN_ITEM.LAST_EXECUTED_BY)).leftJoin((TableLike)Tables.MILESTONE_CAMPAIGN).on(Tables.MILESTONE_CAMPAIGN.CAMPAIGN_ID.eq(cte.field((Field)Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID))).leftJoin((TableLike)Tables.MILESTONE).on(Tables.MILESTONE.MILESTONE_ID.eq((Field)Tables.MILESTONE_CAMPAIGN.MILESTONE_ID)).leftJoin((TableLike)Tables.TEST_SUITE_TEST_PLAN_ITEM).on(Tables.TEST_SUITE_TEST_PLAN_ITEM.TPI_ID.eq(cte.field((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID))).leftJoin((TableLike)Tables.TEST_SUITE).on(Tables.TEST_SUITE.ID.eq((Field)Tables.TEST_SUITE_TEST_PLAN_ITEM.SUITE_ID)).leftJoin(executionCountsTable).on(Objects.requireNonNull(executionCountsTable.field((Field)Tables.EXECUTION.TEST_PLAN_ITEM_ID)).eq(cte.field((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID))).leftJoin(executionIssueCountsTable).on(Objects.requireNonNull(executionIssueCountsTable.field((Field)Tables.EXECUTION.EXECUTION_ID)).eq(cte.field((Field)Tables.EXECUTION.EXECUTION_ID))).leftJoin((TableLike)Tables.EXECUTION_STEP).on(Tables.EXECUTION_STEP.EXECUTION_STEP_ID.eq(cte.field((Field)Tables.EXECUTION_STEP.EXECUTION_STEP_ID))).leftJoin(executionStepIssueCountsTable).on(Objects.requireNonNull(executionStepIssueCountsTable.field((Field)Tables.EXECUTION_STEP.EXECUTION_STEP_ID)).eq(cte.field((Field)Tables.EXECUTION_STEP.EXECUTION_STEP_ID))).leftJoin(testStepCoverageCountsTable).on(Objects.requireNonNull(testStepCoverageCountsTable.field((Field)Tables.TEST_CASE_STEPS.STEP_ID)).eq(cte.field((Field)Tables.TEST_CASE_STEPS.STEP_ID))).leftJoin((TableLike)Tables.TEST_CASE).on(Tables.TEST_CASE.TCLN_ID.eq(cte.field((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID))).leftJoin((TableLike)this.testCaseNature).on(this.testCaseNature.ITEM_ID.eq((Field)Tables.TEST_CASE.TC_NATURE)).leftJoin((TableLike)this.testCaseType).on(this.testCaseType.ITEM_ID.eq((Field)Tables.TEST_CASE.TC_TYPE)).leftJoin((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.eq((Field)Tables.TEST_CASE.TCLN_ID)).leftJoin(testCaseMilestoneTable).on(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.eq(testCaseMilestoneTable.field((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID))).leftJoin(testCaseCoverageCountsTable).on(Objects.requireNonNull(testCaseCoverageCountsTable.field((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).eq(cte.field((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID))).leftJoin((TableLike)Tables.PROJECT).on(Tables.PROJECT.PROJECT_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID)).orderBy((OrderField)cte.field((Field)Tables.CAMPAIGN_ITERATION.ITERATION_ORDER), (OrderField)Tables.TEST_PLAN_ITEM.ITEM_ORDER, (OrderField)cte.field((Field)Tables.EXECUTION_EXECUTION_STEPS.EXECUTION_STEP_ORDER), (OrderField)cte.field(this.stepPathField));
    }

    @Override
    public void doExport(File exportFile, Long campaignId) {
        this.doExport(exportFile, campaignId, CampaignExportMode.FULL);
    }

    @Override
    protected List<BindableEntity> getBindableEntities() {
        return List.of(BindableEntity.CAMPAIGN, BindableEntity.ITERATION, BindableEntity.TEST_CASE, BindableEntity.EXECUTION, BindableEntity.EXECUTION_STEP);
    }

    @Override
    protected Map<BindableEntity, SubElementRecordProcessor<CustomFieldValueDto>> getCufProcessor(Long campaignId) {
        return Map.of(BindableEntity.CAMPAIGN, this.getCufProcessor(this.getCampaignCufQuery(campaignId)), BindableEntity.ITERATION, this.getCufProcessor(this.getIterationCufQuery(campaignId)), BindableEntity.TEST_CASE, this.getCufProcessor(this.getTestCaseCufQuery(campaignId)), BindableEntity.EXECUTION, this.getCufProcessor(this.getExecutionCufQuery(campaignId)), BindableEntity.EXECUTION_STEP, this.getCufProcessor(this.getExecutionStepCufQuery(campaignId)));
    }

    @Override
    protected Map<String, String> exportData(Record record, CampaignExportRows campaignExportRows, boolean milestonesEnabled, AbstractCampaignExport.CalculateOrder calculateOrder, Map<BindableEntity, SubElementRecordProcessor<CustomFieldValueDto>> cufProcessor, Map<BindableEntity, List<CustomFieldValueDto>> cufStorage) {
        this.addCampaign(record, campaignExportRows);
        this.addIteration(record, campaignExportRows, milestonesEnabled);
        this.addTestPlanItem(record, campaignExportRows);
        this.addTestCase(record, campaignExportRows, milestonesEnabled);
        this.addTestSuite(record, campaignExportRows);
        this.addExecution(record, campaignExportRows);
        this.addStep(record, campaignExportRows, calculateOrder);
        this.addCufs(record, campaignExportRows, cufProcessor, cufStorage);
        return campaignExportRows.getRow();
    }

    private void addCufs(Record record, CampaignExportRows campaignExportRows, Map<BindableEntity, SubElementRecordProcessor<CustomFieldValueDto>> cufProcessor, Map<BindableEntity, List<CustomFieldValueDto>> cufStorage) {
        this.addCufValue(record, (Field<Long>)Tables.CAMPAIGN.CLN_ID, campaignExportRows, BindableEntity.CAMPAIGN, cufProcessor, cufStorage);
        this.addCufValue(record, (Field<Long>)Tables.ITERATION.ITERATION_ID, campaignExportRows, BindableEntity.ITERATION, cufProcessor, cufStorage);
        this.addCufValue(record, (Field<Long>)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID, campaignExportRows, BindableEntity.TEST_CASE, cufProcessor, cufStorage);
        this.addCufValue(record, (Field<Long>)Tables.EXECUTION.EXECUTION_ID, campaignExportRows, BindableEntity.EXECUTION, cufProcessor, cufStorage);
        this.addCufValue(record, (Field<Long>)Tables.EXECUTION_STEP.EXECUTION_STEP_ID, campaignExportRows, BindableEntity.EXECUTION_STEP, cufProcessor, cufStorage);
    }

    private void addCampaign(Record record, CampaignExportRows campaignExportRows) {
        campaignExportRows.addValue(CampaignExportHeader.CPG_SCHEDULED_START_ON, (Date)record.get((Field)Tables.CAMPAIGN.SCHEDULED_START_DATE));
        campaignExportRows.addValue(CampaignExportHeader.CPG_SCHEDULED_END_ON, (Date)record.get((Field)Tables.CAMPAIGN.SCHEDULED_END_DATE));
        campaignExportRows.addValue(CampaignExportHeader.CPG_ACTUAL_START_ON, (Date)record.get((Field)Tables.CAMPAIGN.ACTUAL_START_DATE));
        campaignExportRows.addValue(CampaignExportHeader.CPG_ACTUAL_END_ON, (Date)record.get((Field)Tables.CAMPAIGN.ACTUAL_END_DATE));
    }

    private void addIteration(Record record, CampaignExportRows campaignExportRows, boolean milestonesEnabled) {
        campaignExportRows.addValue(CampaignExportHeader.IT_ID, record.get((Field)Tables.ITERATION.ITERATION_ID));
        campaignExportRows.addOrderValue(CampaignExportHeader.IT_NUM, (Integer)record.get((Field)Tables.CAMPAIGN_ITERATION.ITERATION_ORDER));
        campaignExportRows.addValue(CampaignExportHeader.IT_NAME, (String)record.get((Field)Tables.ITERATION.NAME));
        campaignExportRows.addValue(CampaignExportHeader.IT_SCHEDULED_START_ON, (Date)record.get((Field)Tables.ITERATION.SCHEDULED_START_DATE));
        campaignExportRows.addValue(CampaignExportHeader.IT_SCHEDULED_END_ON, (Date)record.get((Field)Tables.ITERATION.SCHEDULED_END_DATE));
        campaignExportRows.addValue(CampaignExportHeader.IT_ACTUAL_START_ON, (Date)record.get((Field)Tables.ITERATION.ACTUAL_START_DATE));
        campaignExportRows.addValue(CampaignExportHeader.IT_ACTUAL_END_ON, (Date)record.get((Field)Tables.ITERATION.ACTUAL_END_DATE));
        if (milestonesEnabled) {
            campaignExportRows.addValue(CampaignExportHeader.IT_MILESTONE, (String)record.get((Field)Tables.MILESTONE.LABEL));
        }
    }

    private void addTestPlanItem(Record record, CampaignExportRows campaignExportRows) {
        campaignExportRows.addValue(CampaignExportHeader.EXEC_STATUS, (String)record.get((Field)Tables.TEST_PLAN_ITEM.EXECUTION_STATUS));
        campaignExportRows.addValueOrEmpty(CampaignExportHeader.EXEC_LOGIN, record.get((Field)Tables.CORE_USER.LOGIN));
        campaignExportRows.addValue(CampaignExportHeader.EXECUTION_DATE, (Date)record.get((Field)Tables.TEST_PLAN_ITEM.LAST_EXECUTED_ON));
    }

    private void addTestCase(Record record, CampaignExportRows campaignExportRows, boolean milestonesEnabled) {
        campaignExportRows.addValue(CampaignExportHeader.TC_ID, record.get((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID));
        campaignExportRows.addValue(CampaignExportHeader.TC_NAME, (String)record.get((Field)Tables.TEST_CASE_LIBRARY_NODE.NAME));
        campaignExportRows.addValueLongText(CampaignExportHeader.DESCRIPTION, (String)record.get((Field)Tables.TEST_CASE_LIBRARY_NODE.DESCRIPTION));
        campaignExportRows.addValue(CampaignExportHeader.TC_PROJECT_ID, record.get((Field)Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID));
        campaignExportRows.addValue(CampaignExportHeader.TC_PROJECT, (String)record.get((Field)Tables.PROJECT.NAME));
        campaignExportRows.addValue(CampaignExportHeader.TC_WEIGHT, (String)record.get((Field)Tables.TEST_CASE.IMPORTANCE));
        campaignExportRows.addValue(CampaignExportHeader.TC_REF, (String)record.get((Field)Tables.TEST_CASE.REFERENCE));
        campaignExportRows.addValue(CampaignExportHeader.TC_NATURE, (String)record.get((Field)this.testCaseNature.CODE));
        campaignExportRows.addValue(CampaignExportHeader.TC_TYPE, (String)record.get((Field)this.testCaseType.CODE));
        campaignExportRows.addValue(CampaignExportHeader.TC_STATUS, (String)record.get((Field)Tables.TEST_CASE.TC_STATUS));
        campaignExportRows.addValue(CampaignExportHeader.COUNT_TC_COVERAGE, record.get(this.testCaseCoverageCountField));
        campaignExportRows.addValueOrEmpty(CampaignExportHeader.DATASET, record.get((Field)Tables.DATASET.NAME));
        if (milestonesEnabled) {
            campaignExportRows.addValue(CampaignExportHeader.TC_MILESTONE, (String)record.get(this.testCaseMilestoneLabels));
        }
    }

    private void addTestSuite(Record record, CampaignExportRows campaignExportRows) {
        campaignExportRows.addValueOrEmpty(CampaignExportHeader.TEST_SUITE, record.get((Field)Tables.TEST_SUITE.NAME));
    }

    private void addExecution(Record record, CampaignExportRows campaignExportRows) {
        campaignExportRows.addValue(CampaignExportHeader.COUNT_EXECUTIONS, record.get(this.executionCountField));
        campaignExportRows.addValue(CampaignExportHeader.COUNT_EXEC_ISSUES, record.get(this.executionIssueCountField));
    }

    private void addStep(Record record, CampaignExportRows campaignExportRows, AbstractCampaignExport.CalculateOrder calculateOrder) {
        campaignExportRows.addValue(CampaignExportHeader.STEP_NUM, calculateOrder.getNextStep((Long)record.get((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID)));
        campaignExportRows.addValue(CampaignExportHeader.COUNT_STEP_COVERAGE, record.get(this.testStepCoverageCountField));
        if (Objects.nonNull(record.get((Field)Tables.EXECUTION_STEP.EXECUTION_STEP_ID))) {
            campaignExportRows.addValue(CampaignExportHeader.STEP_ID, record.get((Field)Tables.EXECUTION_STEP.EXECUTION_STEP_ID));
            campaignExportRows.addValue(CampaignExportHeader.EXEC_STEP_STATUS, (String)record.get((Field)Tables.EXECUTION_STEP.EXECUTION_STATUS));
            campaignExportRows.addValue(CampaignExportHeader.EXEC_STEP_DATE, (Date)record.get((Field)Tables.EXECUTION_STEP.LAST_EXECUTED_ON));
            campaignExportRows.addValueOrEmpty(CampaignExportHeader.EXEC_STEP_USER, record.get((Field)Tables.EXECUTION_STEP.LAST_EXECUTED_BY));
            campaignExportRows.addValue(CampaignExportHeader.COUNT_EXEC_STEP_ISSUES, record.get(this.executionStepIssueCountField));
            campaignExportRows.addValueLongText(CampaignExportHeader.EXEC_STEP_COMMENT, (String)record.get((Field)Tables.EXECUTION_STEP.COMMENT));
        }
    }
}

