/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.campaign;

import java.util.List;
import org.jooq.DSLContext;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.core.foundation.exception.ActionException;
import org.squashtest.tm.domain.campaign.SprintReqVersion;
import org.squashtest.tm.domain.campaign.testplan.TestPlanItem;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.exception.execution.SprintReqVersionTestPlanHasDeletedTestCaseException;
import org.squashtest.tm.service.campaign.ExecutionCreationService;
import org.squashtest.tm.service.internal.campaign.AbstractTestPlanExecutionProcessingService;
import org.squashtest.tm.service.internal.campaign.CampaignNodeDeletionHandler;
import org.squashtest.tm.service.internal.deletion.jdbc.JdbcTestPlanItemDeletionHandlerFactory;
import org.squashtest.tm.service.internal.display.campaign.ReadUnassignedTestPlanHelper;
import org.squashtest.tm.service.internal.display.dto.execution.TestPlanResume;
import org.squashtest.tm.service.internal.display.grid.GridFilterValue;
import org.squashtest.tm.service.internal.display.grid.GridRequest;
import org.squashtest.tm.service.internal.display.grid.GridResponse;
import org.squashtest.tm.service.internal.display.grid.campaign.SprintReqVersionTestPlanGrid;
import org.squashtest.tm.service.internal.repository.CustomSprintReqVersionDao;
import org.squashtest.tm.service.internal.repository.SprintReqVersionDao;
import org.squashtest.tm.service.internal.repository.TestPlanItemDao;
import org.squashtest.tm.service.security.PermissionEvaluationService;

@Service
@Transactional
public class SprintReqVersionExecutionProcessingServiceImpl
extends AbstractTestPlanExecutionProcessingService<SprintReqVersion, TestPlanResume.SprintReqVersionTestPlanResume> {
    private static final String CAN_EXECUTE_BY_SPRINT_REQ_VERSION_ID = "hasPermission(#sprintReqVersionId, 'org.squashtest.tm.domain.campaign.SprintReqVersion', 'EXECUTE') or hasRole('ROLE_ADMIN')";
    private final ReadUnassignedTestPlanHelper readUnassignedTestPlanHelper;
    private final SprintReqVersionDao sprintReqVersionDao;
    private final CustomSprintReqVersionDao customSprintReqVersionDao;

    SprintReqVersionExecutionProcessingServiceImpl(CampaignNodeDeletionHandler campaignDeletionHandler, PermissionEvaluationService permissionEvaluationService, TestPlanItemDao testPlanItemDao, DSLContext dslContext, ExecutionCreationService executionCreationService, ReadUnassignedTestPlanHelper readUnassignedTestPlanHelper, SprintReqVersionDao sprintReqVersionDao, CustomSprintReqVersionDao customSprintReqVersionDao, JdbcTestPlanItemDeletionHandlerFactory deletionHandlerFactory) {
        super(campaignDeletionHandler, permissionEvaluationService, testPlanItemDao, dslContext, executionCreationService, deletionHandlerFactory);
        this.readUnassignedTestPlanHelper = readUnassignedTestPlanHelper;
        this.sprintReqVersionDao = sprintReqVersionDao;
        this.customSprintReqVersionDao = customSprintReqVersionDao;
    }

    @Override
    @PreAuthorize(value="hasPermission(#sprintReqVersionId, 'org.squashtest.tm.domain.campaign.SprintReqVersion', 'EXECUTE') or hasRole('ROLE_ADMIN')")
    public TestPlanResume.SprintReqVersionTestPlanResume startResume(long sprintReqVersionId) {
        return (TestPlanResume.SprintReqVersionTestPlanResume)this.commonStartResume(sprintReqVersionId);
    }

    @Override
    @PreAuthorize(value="hasPermission(#sprintReqVersionId, 'org.squashtest.tm.domain.campaign.SprintReqVersion', 'EXECUTE') or hasRole('ROLE_ADMIN')")
    public TestPlanResume.SprintReqVersionTestPlanResume relaunch(long sprintReqVersionId, boolean deletePrevious) {
        return (TestPlanResume.SprintReqVersionTestPlanResume)super.relaunch(sprintReqVersionId, deletePrevious);
    }

    @Override
    @PreAuthorize(value="hasPermission(#sprintReqVersionId, 'org.squashtest.tm.domain.campaign.SprintReqVersion', 'EXECUTE') or hasRole('ROLE_ADMIN')")
    public TestPlanResume relaunchFilteredTestPlan(long sprintReqVersionId, List<GridFilterValue> filters, boolean deletePrevious) {
        return super.relaunchFilteredTestPlan(sprintReqVersionId, filters, deletePrevious);
    }

    @Override
    @PreAuthorize(value="hasPermission(#sprintReqVersionId, 'org.squashtest.tm.domain.campaign.SprintReqVersion', 'EXECUTE') or hasRole('ROLE_ADMIN')")
    public TestPlanResume.SprintReqVersionTestPlanResume startResumeNextExecution(long sprintReqVersionId, long testPlanItemId, boolean deletePrevious) {
        return (TestPlanResume.SprintReqVersionTestPlanResume)super.startResumeNextExecution(sprintReqVersionId, testPlanItemId, deletePrevious);
    }

    @Override
    @PreAuthorize(value="hasPermission(#sprintReqVersionId, 'org.squashtest.tm.domain.campaign.SprintReqVersion', 'EXECUTE') or hasRole('ROLE_ADMIN')")
    public void deleteAllExecutions(long sprintReqVersionId) {
        super.deleteAllExecutions(sprintReqVersionId);
    }

    @Override
    SprintReqVersion createTransientTestPlanOwnerWithFilteredTestPlan(long sprintReqVersionId, List<TestPlanItem> filteredTestPlan) {
        SprintReqVersion sprintReqVersion = this.getTestPlanOwner(sprintReqVersionId);
        SprintReqVersion copySprintReqVersion = sprintReqVersion.createCopy(null);
        copySprintReqVersion.getTestPlan().clear();
        copySprintReqVersion.getTestPlan().addTransientItems(filteredTestPlan);
        return copySprintReqVersion;
    }

    @Override
    public List<TestPlanItem> getFilteredTestPlan(long sprintReqVersionId, List<GridFilterValue> filters) {
        String userToRestrictTo = this.readUnassignedTestPlanHelper.getUserToRestrictTo(sprintReqVersionId, SprintReqVersion.class.getName());
        SprintReqVersionTestPlanGrid testPlanGrid = new SprintReqVersionTestPlanGrid(sprintReqVersionId, userToRestrictTo);
        GridRequest gridRequest = this.prepareNonPaginatedGridRequest(filters);
        GridResponse gridResponse = testPlanGrid.getRows(gridRequest, this.dslContext);
        List<Long> itemIds = this.extractItemIdsFromGridResponse(gridResponse);
        return this.testPlanItemDao.findAllById(itemIds);
    }

    @Override
    public ActionException getTestPlanHasDeletedTestCaseException() {
        return new SprintReqVersionTestPlanHasDeletedTestCaseException();
    }

    @Override
    protected SprintReqVersion getTestPlanOwner(long sprintReqVersionId) {
        return this.customSprintReqVersionDao.loadForExecutionResume(sprintReqVersionId);
    }

    @Override
    protected TestPlanResume createNewTestPlanResume(long testPlanOwnerId, Execution execution, boolean hasNextTestCase, List<Long> partialTestPlanItemIds) {
        return new TestPlanResume.SprintReqVersionTestPlanResume(testPlanOwnerId, execution, hasNextTestCase, partialTestPlanItemIds);
    }

    @Override
    protected TestPlanResume.SprintReqVersionTestPlanResume createNewTestPlanResume(long testPlanOwnerId, Execution execution, boolean hasNextTestCase) {
        return new TestPlanResume.SprintReqVersionTestPlanResume(testPlanOwnerId, execution, hasNextTestCase);
    }

    @Override
    public boolean hasDeletedTestCaseInTestPlan(long testPlanOwnerId) {
        return this.sprintReqVersionDao.hasDeletedTestCaseInTestPlan(testPlanOwnerId);
    }

    @Override
    protected List<Long> getTestPlanItemIds(long testPlanOwnerId, String testerLogin) {
        if (testerLogin != null && !testerLogin.isBlank()) {
            return this.sprintReqVersionDao.getTestPlanItemIdsAssignedToUser(testPlanOwnerId, testerLogin);
        }
        return this.sprintReqVersionDao.getTestPlanItemIds(testPlanOwnerId);
    }

    @Override
    protected Class<?> getTestPlanOwnerClass() {
        return SprintReqVersion.class;
    }
}

