/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.bugtracker.adapter;

import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.squashtest.csp.core.bugtracker.core.BugTrackerRemoteException;
import org.squashtest.csp.core.bugtracker.core.ProjectNotFoundException;
import org.squashtest.tm.bugtracker.advanceddomain.DelegateCommand;
import org.squashtest.tm.bugtracker.advanceddomain.RemoteIssueSearchRequest;
import org.squashtest.tm.bugtracker.advanceddomain.RemoteIssueSearchTerm;
import org.squashtest.tm.bugtracker.definition.Attachment;
import org.squashtest.tm.bugtracker.definition.RemoteIssue;
import org.squashtest.tm.bugtracker.definition.RemoteProject;
import org.squashtest.tm.bugtracker.definition.context.RemoteIssueContext;
import org.squashtest.tm.domain.bugtracker.BugTracker;
import org.squashtest.tm.service.internal.bugtracker.RemoteRequirementAndProjectId;
import org.squashtest.tm.service.internal.bugtracker.adapter.AbstractInternalConnectorAdapter;
import org.squashtest.tm.service.spi.BugtrackerConnectorBase;
import org.squashtest.tm.service.spi.OslcBugTrackerConnector;

public class OslcBugtrackerConnectorAdapter
extends AbstractInternalConnectorAdapter {
    private OslcBugTrackerConnector connector;

    public OslcBugtrackerConnectorAdapter(OslcBugTrackerConnector connector) {
        this.connector = connector;
    }

    @Override
    public BugtrackerConnectorBase getConnector() {
        return this.connector;
    }

    @Override
    public URL makeViewIssueUrl(BugTracker bugTracker, String issueId) {
        return this.connector.makeViewIssueUrl(bugTracker, issueId);
    }

    @Override
    public RemoteProject findProject(String projectName) throws ProjectNotFoundException, BugTrackerRemoteException {
        return null;
    }

    @Override
    public RemoteProject findProjectById(String projectId) throws ProjectNotFoundException, BugTrackerRemoteException {
        return null;
    }

    @Override
    public RemoteIssue createIssue(RemoteIssue issue) throws BugTrackerRemoteException {
        return null;
    }

    @Override
    public RemoteIssue createReportIssueTemplate(String projectName, RemoteIssueContext context) {
        return this.connector.createReportIssueTemplate(projectName, context);
    }

    @Override
    public Optional<? extends RemoteIssue> searchIssue(RemoteIssueSearchRequest searchRequest) {
        if (searchRequest.getSearchTerms().isEmpty()) {
            throw new IllegalArgumentException("You should provide at least one search term.");
        }
        RemoteIssueSearchTerm firstSearchTerm = (RemoteIssueSearchTerm)searchRequest.getSearchTerms().get(0);
        return Optional.ofNullable(this.connector.findIssue(firstSearchTerm.getStringValue()));
    }

    @Override
    public RemoteIssue findIssue(String key) {
        return this.connector.findIssue(key);
    }

    @Override
    public List<RemoteIssue> findIssues(Collection<String> issueKeys) {
        return this.connector.findIssues(issueKeys);
    }

    @Override
    public void forwardAttachments(String remoteIssueKey, List<Attachment> attachments) {
    }

    @Override
    public Object executeDelegateCommand(DelegateCommand command) {
        return null;
    }

    @Override
    public void linkIssues(Long bugtrackerId, String remoteIssueKey, List<RemoteRequirementAndProjectId> remoteReqIds) {
    }
}

