/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.batchimport.excel;

import jakarta.validation.constraints.NotNull;
import java.lang.reflect.Field;
import org.springframework.util.ReflectionUtils;
import org.squashtest.tm.aspect.validation.NotNullValidatorAspect;
import org.squashtest.tm.service.internal.batchimport.excel.NullMandatoryValueException;
import org.squashtest.tm.service.internal.batchimport.excel.PropertySetter;

public final class ReflectionFieldSetter<VAL, TARGET>
implements PropertySetter<VAL, TARGET> {
    private final String fieldName;
    private boolean optionalValue = false;
    private Field field;

    private ReflectionFieldSetter(@NotNull String fieldName) {
        this.fieldName = fieldName;
    }

    public static <V, T> ReflectionFieldSetter<V, T> forField(@NotNull String name) {
        String string = name;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289((Object)string);
        return new ReflectionFieldSetter(name);
    }

    public static <V, T> ReflectionFieldSetter<V, T> forOptionalField(@NotNull String name) {
        String string = name;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289((Object)string);
        ReflectionFieldSetter res = new ReflectionFieldSetter(name);
        res.optionalValue = true;
        return res;
    }

    @Override
    public void set(VAL value, TARGET target) {
        if (this.optionalValue && value == null) {
            return;
        }
        if (!this.optionalValue && value == null) {
            throw new NullMandatoryValueException(this.fieldName);
        }
        if (this.field == null) {
            this.field = ReflectionUtils.findField(target.getClass(), (String)this.fieldName);
            if (this.field == null) {
                throw new IllegalStateException("Could not find field named '" + this.fieldName + "' in object of type '" + String.valueOf(target.getClass()) + "'. Maybe you mistyped field name.");
            }
            this.field.setAccessible(true);
        }
        ReflectionUtils.setField((Field)this.field, target, value);
    }
}

