/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.artificialintelligence.testcasegeneration;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.EntityReference;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.milestone.Milestone;
import org.squashtest.tm.domain.requirement.RequirementVersion;
import org.squashtest.tm.domain.testcase.RequirementVersionCoverage;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.service.annotation.IsUltimateLicenseAvailable;
import org.squashtest.tm.service.artificialintelligence.testcasegeneration.AiTestCaseCreationService;
import org.squashtest.tm.service.internal.dto.TestCasesCreationFromAiDto;
import org.squashtest.tm.service.internal.repository.AiTestCaseGenerationDao;
import org.squashtest.tm.service.internal.repository.RequirementVersionCoverageDao;
import org.squashtest.tm.service.internal.repository.RequirementVersionDao;
import org.squashtest.tm.service.milestone.ActiveMilestoneHolder;
import org.squashtest.tm.service.testcase.TestCaseLibraryNavigationService;

@Service
@Transactional
public class AiTestCaseCreationServiceImpl
implements AiTestCaseCreationService {
    private final AiTestCaseGenerationDao aiTestCaseGenerationDao;
    private final TestCaseLibraryNavigationService testCaseLibraryNavigationService;
    private final ActiveMilestoneHolder activeMilestoneHolder;
    private final RequirementVersionDao requirementVersionDao;
    private final RequirementVersionCoverageDao requirementVersionCoverageDao;

    public AiTestCaseCreationServiceImpl(AiTestCaseGenerationDao aiTestCaseGenerationDao, TestCaseLibraryNavigationService testCaseLibraryNavigationService, ActiveMilestoneHolder activeMilestoneHolder, RequirementVersionDao requirementVersionDao, RequirementVersionCoverageDao requirementVersionCoverageDao) {
        this.aiTestCaseGenerationDao = aiTestCaseGenerationDao;
        this.testCaseLibraryNavigationService = testCaseLibraryNavigationService;
        this.activeMilestoneHolder = activeMilestoneHolder;
        this.requirementVersionDao = requirementVersionDao;
        this.requirementVersionCoverageDao = requirementVersionCoverageDao;
    }

    @Override
    @IsUltimateLicenseAvailable
    public Long findTargetTestCaseLibraryId(Long projectId) {
        return this.aiTestCaseGenerationDao.findTargetTestCaseLibraryId(projectId);
    }

    @Override
    @PreAuthorize(value="hasPermission(#targetLibraryId, 'org.squashtest.tm.domain.testcase.TestCaseLibrary' , 'CREATE' ) or hasRole('ROLE_ADMIN')")
    @IsUltimateLicenseAvailable
    public void persistTestCasesFromAi(long targetLibraryId, Long requirementVersionId, TestCasesCreationFromAiDto testCasesData) {
        EntityReference destinationEntityReference = EntityReference.fromNodeId((String)testCasesData.getDestinationFolderId());
        List<TestCase> newTestCases = this.createNewTestCases(testCasesData, destinationEntityReference);
        this.doPersistTestCases(destinationEntityReference, newTestCases);
        RequirementVersion requirementVersion = this.requirementVersionDao.loadForCoverageAddition(requirementVersionId);
        ArrayList<RequirementVersionCoverage> coverages = new ArrayList<RequirementVersionCoverage>();
        for (TestCase testCase : newTestCases) {
            coverages.add(new RequirementVersionCoverage(requirementVersion, testCase));
        }
        this.requirementVersionCoverageDao.saveAll(coverages);
    }

    private void doPersistTestCases(EntityReference destinationEntityReference, List<TestCase> generatedTestCases) {
        List<Long> milestoneIds = this.findMilestoneIds();
        Long parentId = destinationEntityReference.getId();
        switch (destinationEntityReference.getType()) {
            case TEST_CASE_LIBRARY: {
                this.testCaseLibraryNavigationService.addTestCasesToLibrary(parentId, generatedTestCases, milestoneIds);
                break;
            }
            case TEST_CASE_FOLDER: {
                this.testCaseLibraryNavigationService.addTestCasesToFolder(parentId, generatedTestCases, milestoneIds);
                break;
            }
            default: {
                throw new IllegalArgumentException("This entity type is not handled " + String.valueOf(destinationEntityReference.getType()));
            }
        }
    }

    private List<TestCase> createNewTestCases(TestCasesCreationFromAiDto testCasesData, EntityReference destinationEntityReference) {
        ArrayList<String> parentContentNames = new ArrayList<String>(this.fetchParentContentNames(destinationEntityReference));
        return testCasesData.getTestCasesFromAi().stream().map(testCaseFromAiDto -> testCaseFromAiDto.toTestCase(parentContentNames)).toList();
    }

    private List<String> fetchParentContentNames(EntityReference destinationEntityReference) {
        Long parentId = destinationEntityReference.getId();
        return switch (destinationEntityReference.getType()) {
            case EntityType.TEST_CASE_LIBRARY -> this.testCaseLibraryNavigationService.findContentNamesByLibraryId(parentId);
            case EntityType.TEST_CASE_FOLDER -> this.testCaseLibraryNavigationService.findContentNamesByFolderIds(Collections.singletonList(parentId)).getOrDefault(parentId, new ArrayList());
            default -> throw new IllegalArgumentException("This entity type is not handled " + String.valueOf(destinationEntityReference.getType()));
        };
    }

    private List<Long> findMilestoneIds() {
        ArrayList<Long> milestoneIds = new ArrayList<Long>();
        Optional<Milestone> activeMilestone = this.activeMilestoneHolder.getActiveMilestone();
        activeMilestone.ifPresent(milestone -> {
            boolean bl = milestoneIds.add(milestone.getId());
        });
        return milestoneIds;
    }
}

