/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.api.repository;

import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.PersistenceUnit;
import java.util.List;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.SessionFactory;
import org.hibernate.StatelessSession;
import org.hibernate.Transaction;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.Query;
import org.springframework.stereotype.Service;
import org.squashtest.tm.api.repository.SqlQueryRunner;
import org.squashtest.tm.service.internal.api.repository.NamedParamsListExecution;
import org.squashtest.tm.service.internal.api.repository.NamedParamsUniqueResultExecution;
import org.squashtest.tm.service.internal.api.repository.QueryExecution;

@Service(value="squash.api.repository.SqlQueryRunner")
public class HibernateSqlQueryRunner
implements SqlQueryRunner {
    private static final String UNCHECKED = "unchecked";
    private static final QueryExecution<Query<?>> EXECUTE_LIST = new QueryExecution<Query<?>>(){

        @Override
        public <R> R executeQuery(Query<?> query) {
            return (R)query.list();
        }
    };
    private static final QueryExecution<Query<?>> EXECUTE_SINGLE = new QueryExecution<Query<?>>(){

        @Override
        public <R> R executeQuery(Query<?> query) {
            return (R)query.uniqueResult();
        }
    };
    @PersistenceUnit
    EntityManagerFactory entityManagerFactory;

    public <T> List<T> executeSelect(String selectQuery) {
        return (List)this.executeQuery(selectQuery, EXECUTE_LIST);
    }

    private <T> T executeQuery(String selectQuery, QueryExecution<Query<?>> execution) {
        SessionFactory sessionFactory = (SessionFactory)this.entityManagerFactory.unwrap(SessionFactory.class);
        StatelessSession s = sessionFactory.openStatelessSession();
        Transaction tx = s.beginTransaction();
        T res = null;
        try {
            try {
                NativeQuery q = s.createNativeQuery(selectQuery, Object.class);
                res = (T)execution.executeQuery((Query<?>)q);
                tx.commit();
            }
            catch (ClassCastException | HibernateException e) {
                tx.rollback();
                throw e;
            }
        }
        finally {
            s.close();
        }
        return res;
    }

    public <T> T executeUniqueSelect(String selectQuery) {
        return this.executeQuery(selectQuery, EXECUTE_SINGLE);
    }

    public <T> List<T> executeSelect(String selectQuery, Map<String, ?> namedParameters) {
        return (List)this.executeQuery(selectQuery, new NamedParamsListExecution(namedParameters));
    }

    public <T> T executeUniqueSelect(String selectQuery, Map<String, ?> namedParameters) {
        return this.executeQuery(selectQuery, new NamedParamsUniqueResultExecution(namedParameters));
    }
}

