/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.api.repository;

import java.lang.invoke.MethodHandles;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.event.internal.DefaultDirtyCheckEventListener;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.FlushEvent;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.EntityPrinter;
import org.jboss.logging.Logger;

public class CustomDirtyCheckEventListener
extends DefaultDirtyCheckEventListener {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger((MethodHandles.Lookup)MethodHandles.lookup(), CoreMessageLogger.class, (String)CustomDirtyCheckEventListener.class.getName());

    protected void logFlushResults(FlushEvent event) {
        if (LOG.isDebugEnabled()) {
            EventSource session = event.getSession();
            PersistenceContext persistenceContext = session.getPersistenceContextInternal();
            LOG.debugf("Flushed: %s insertions, %s updates, %s deletions to %s objects", new Object[]{session.getActionQueue().numberOfInsertions(), session.getActionQueue().numberOfUpdates(), session.getActionQueue().numberOfDeletions(), persistenceContext.getNumberOfManagedEntities()});
            LOG.debugf("Flushed: %s (re)creations, %s updates, %s removals to %s collections", new Object[]{session.getActionQueue().numberOfCollectionCreations(), session.getActionQueue().numberOfCollectionUpdates(), session.getActionQueue().numberOfCollectionRemovals(), persistenceContext.getCollectionEntriesSize()});
            if (persistenceContext.getNumberOfManagedEntities() > 0 && persistenceContext.getEntityHoldersByKey() != null) {
                new EntityPrinter(session.getFactory()).toString(persistenceContext.getEntityHoldersByKey().entrySet());
            }
        }
    }
}

