/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.campaign;

import java.util.Date;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.campaign.Iteration;
import org.squashtest.tm.domain.campaign.IterationStatus;
import org.squashtest.tm.service.annotation.CheckBlockingMilestone;
import org.squashtest.tm.service.annotation.Id;
import org.squashtest.tm.service.campaign.CustomIterationModificationService;

@Transactional
public interface IterationModificationService
extends CustomIterationModificationService {
    public static final String WRITE_ITERATION_OR_ADMIN = "hasPermission(#arg0, 'org.squashtest.tm.domain.campaign.Iteration', 'WRITE')  or hasRole('ROLE_ADMIN')";

    @PreAuthorize(value="hasPermission(#arg0, 'org.squashtest.tm.domain.campaign.Iteration', 'WRITE')  or hasRole('ROLE_ADMIN')")
    @CheckBlockingMilestone(entityType=Iteration.class)
    public void changeDescription(@Id long var1, String var3);

    @PreAuthorize(value="hasPermission(#arg0, 'org.squashtest.tm.domain.campaign.Iteration', 'WRITE')  or hasRole('ROLE_ADMIN')")
    @CheckBlockingMilestone(entityType=Iteration.class)
    public void changeReference(@Id long var1, String var3);

    @PreAuthorize(value="hasPermission(#arg0, 'org.squashtest.tm.domain.campaign.Iteration', 'WRITE')  or hasRole('ROLE_ADMIN')")
    @CheckBlockingMilestone(entityType=Iteration.class)
    public void changeStatus(@Id long var1, IterationStatus var3);

    @PreAuthorize(value="hasPermission(#arg0, 'org.squashtest.tm.domain.campaign.Iteration', 'WRITE')  or hasRole('ROLE_ADMIN')")
    @CheckBlockingMilestone(entityType=Iteration.class)
    public void changeScheduledStartDate(@Id long var1, Date var3);

    @PreAuthorize(value="hasPermission(#arg0, 'org.squashtest.tm.domain.campaign.Iteration', 'WRITE')  or hasRole('ROLE_ADMIN')")
    @CheckBlockingMilestone(entityType=Iteration.class)
    public void changeScheduledEndDate(@Id long var1, Date var3);

    @PreAuthorize(value="hasPermission(#arg0, 'org.squashtest.tm.domain.campaign.Iteration', 'WRITE')  or hasRole('ROLE_ADMIN')")
    @CheckBlockingMilestone(entityType=Iteration.class)
    public void changeActualStartDate(@Id long var1, Date var3);

    @PreAuthorize(value="hasPermission(#arg0, 'org.squashtest.tm.domain.campaign.Iteration', 'WRITE')  or hasRole('ROLE_ADMIN')")
    @CheckBlockingMilestone(entityType=Iteration.class)
    public void changeActualEndDate(@Id long var1, Date var3);

    @PreAuthorize(value="hasPermission(#arg0, 'org.squashtest.tm.domain.campaign.Iteration', 'WRITE')  or hasRole('ROLE_ADMIN')")
    @CheckBlockingMilestone(entityType=Iteration.class)
    public void changeActualStartAuto(@Id long var1, boolean var3);

    @PreAuthorize(value="hasPermission(#arg0, 'org.squashtest.tm.domain.campaign.Iteration', 'WRITE')  or hasRole('ROLE_ADMIN')")
    @CheckBlockingMilestone(entityType=Iteration.class)
    public void changeActualEndAuto(@Id long var1, boolean var3);
}

