/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service;

import jakarta.annotation.PostConstruct;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.exception.user.InfrastructureAdminException;
import org.squashtest.tm.service.user.InfrastructureAdminService;
import org.squashtest.tm.service.user.UserAdministrationService;

@Service
public class InfrastructureAdminManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(InfrastructureAdminManager.class);
    private final UserAdministrationService userAdministrationService;
    private final InfrastructureAdminService infrastructureAdminService;
    @Value(value="${squash.cloud-mode-enabled:false}")
    private boolean needsInfrastructureAdmin;

    public InfrastructureAdminManager(UserAdministrationService userAdministrationService, InfrastructureAdminService infrastructureAdminService) {
        this.userAdministrationService = userAdministrationService;
        this.infrastructureAdminService = infrastructureAdminService;
    }

    @PostConstruct
    public void checkAndManageInfrastructureAdmin() {
        if (this.needsInfrastructureAdmin) {
            LOGGER.debug("SquashTM is running in cloud mode. Will check if infrastructure administrator {} exists.", new Object[]{"squash-cloud-admin"});
            if (this.infrastructureAdminExists()) {
                return;
            }
            LOGGER.debug("Infrastructure administrator {} does not exist. Creating user.", new Object[]{"squash-cloud-admin"});
            this.infrastructureAdminService.createInfrastructureAdminAndToken();
        } else {
            LOGGER.debug("This instance does not need any infrastructure administrator. Deleting all.", new Object[0]);
            this.userAdministrationService.deleteAllInfrastructureAdminMembers();
            this.deleteTokenFileIfExists();
        }
    }

    private boolean infrastructureAdminExists() {
        String infrastructureAdminGroupQualifiedName = this.userAdministrationService.findUserGroupQualifiedName("squash-cloud-admin");
        if (infrastructureAdminGroupQualifiedName == null) {
            return false;
        }
        if ("squashtest.authz.group.tm.InfrastructureAdmin".equals(infrastructureAdminGroupQualifiedName)) {
            LOGGER.debug("Infrastructure administrator {} already exists.", new Object[]{"squash-cloud-admin"});
            this.deleteTokenFileIfExists();
            return true;
        }
        throw new InfrastructureAdminException("User already exists but is not an infrastructure administrator.");
    }

    private void deleteTokenFileIfExists() {
        Path filePath = Paths.get(this.infrastructureAdminService.getTokenFilePath(), new String[0]);
        if (Files.exists(filePath, new LinkOption[0])) {
            try {
                Files.deleteIfExists(filePath);
            }
            catch (IOException e) {
                LOGGER.warn("Failed to delete token file.", (Throwable)e);
            }
        }
    }
}

