/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.testautomation.supervision;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.squashtest.tm.core.foundation.lang.MathsUtils;
import org.squashtest.tm.domain.campaign.testplan.TestPlanItem;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.domain.testautomation.AutomatedExecutionExtender;
import org.squashtest.tm.domain.testautomation.AutomatedSuite;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.service.testautomation.model.AutomatedSuiteWithSquashAutomAutomatedITPIs;
import org.squashtest.tm.service.testautomation.supervision.model.AutomatedSuiteOverview;
import org.squashtest.tm.service.testautomation.supervision.model.ExecutionsOverview;
import org.squashtest.tm.service.testautomation.supervision.model.SquashAutomExecutionView;
import org.squashtest.tm.service.testautomation.supervision.model.TfExecutionView;

public final class AutomatedExecutionViewUtils {
    private AutomatedExecutionViewUtils() {
    }

    public static AutomatedSuiteOverview buildFirstAutomatedSuiteOverview(AutomatedSuiteWithSquashAutomAutomatedITPIs suite) {
        List executions = suite.getSuite().getExecutionExtenders();
        List<AutomatedExecutionExtender> tfExecutions = executions.stream().filter(exec -> Objects.nonNull(exec.getAutomatedTest())).toList();
        ExecutionsOverview<TfExecutionView> tfOverview = AutomatedExecutionViewUtils.generateTfOverview(tfExecutions);
        List<TestPlanItem> items = suite.getSquashAutomAutomatedItems();
        ExecutionsOverview<SquashAutomExecutionView> automOverview = AutomatedExecutionViewUtils.generateSquashAutomOverviewFromItpis(items);
        return new AutomatedSuiteOverview(suite.getSuite().getUuid(), tfOverview.progression(), tfOverview.executionViews(), automOverview.progression(), automOverview.executionViews(), suite.getSuite().getId());
    }

    public static AutomatedSuiteOverview buildAutomatedSuiteOverview(AutomatedSuite suite) {
        List executions = suite.getExecutionExtenders();
        List<AutomatedExecutionExtender> tfExecutions = executions.stream().filter(exec -> Objects.nonNull(exec.getAutomatedTest())).toList();
        ExecutionsOverview<TfExecutionView> tfOverview = AutomatedExecutionViewUtils.generateTfOverview(tfExecutions);
        List<AutomatedExecutionExtender> automExecutions = executions.stream().filter(exec -> Objects.isNull(exec.getAutomatedTest())).toList();
        ExecutionsOverview<SquashAutomExecutionView> automOverview = AutomatedExecutionViewUtils.generateSquashAutomOverview(automExecutions);
        return new AutomatedSuiteOverview(suite.getUuid(), tfOverview.progression(), tfOverview.executionViews(), automOverview.progression(), automOverview.executionViews(), suite.getId());
    }

    private static ExecutionsOverview<TfExecutionView> generateTfOverview(Collection<AutomatedExecutionExtender> execExtenders) {
        ArrayList<TfExecutionView> executionsViews = new ArrayList<TfExecutionView>(execExtenders.size());
        int totalExecutions = execExtenders.size();
        int totalTerminated = 0;
        for (AutomatedExecutionExtender execExtender : execExtenders) {
            Execution execution = execExtender.getExecution();
            if (execution.getExecutionStatus().isTerminatedStatus()) {
                ++totalTerminated;
            }
            TfExecutionView execView = AutomatedExecutionViewUtils.convertExecExtenderToTfExecutionView(execExtender);
            executionsViews.add(execView);
        }
        int progression = AutomatedExecutionViewUtils.percentProgression(totalTerminated, totalExecutions);
        return new ExecutionsOverview<TfExecutionView>(progression, executionsViews);
    }

    private static ExecutionsOverview<SquashAutomExecutionView> generateSquashAutomOverview(Collection<AutomatedExecutionExtender> execExtenders) {
        ArrayList<SquashAutomExecutionView> executionsViews = new ArrayList<SquashAutomExecutionView>(execExtenders.size());
        int totalTerminated = 0;
        for (AutomatedExecutionExtender execExtender : execExtenders) {
            Execution execution = execExtender.getExecution();
            if (execution.getExecutionStatus().isTerminatedStatus()) {
                ++totalTerminated;
            }
            SquashAutomExecutionView execView = AutomatedExecutionViewUtils.convertExecExtenderToSquashAutomExecutionView(execExtender);
            executionsViews.add(execView);
        }
        return new ExecutionsOverview<SquashAutomExecutionView>(totalTerminated, executionsViews);
    }

    private static ExecutionsOverview<SquashAutomExecutionView> generateSquashAutomOverviewFromItpis(Collection<TestPlanItem> iterationTestPlanItems) {
        ArrayList<SquashAutomExecutionView> executionViews = new ArrayList<SquashAutomExecutionView>(iterationTestPlanItems.size());
        int totalTerminated = 0;
        for (TestPlanItem itpi : iterationTestPlanItems) {
            if (itpi.getExecutionStatus().isTerminatedStatus()) {
                ++totalTerminated;
            }
            SquashAutomExecutionView execView = AutomatedExecutionViewUtils.convertItpiToSquashAutomExecutionView(itpi);
            executionViews.add(execView);
        }
        executionViews.sort(Comparator.comparing(SquashAutomExecutionView::itemOrder, Comparator.nullsFirst(Comparator.naturalOrder())));
        return new ExecutionsOverview<SquashAutomExecutionView>(totalTerminated, executionViews);
    }

    private static int percentProgression(int totalTerminated, int totalExec) {
        if (totalExec == 0) {
            return 100;
        }
        return MathsUtils.percent((long)totalTerminated, (long)totalExec);
    }

    public static TfExecutionView convertExecExtenderToTfExecutionView(AutomatedExecutionExtender autoExec) {
        return new TfExecutionView(autoExec.getExecution().getId(), autoExec.getExecution().getName(), autoExec.getExecution().getExecutionStatus(), autoExec.getNodeName(), autoExec.getAutomatedProject().getLabel());
    }

    public static SquashAutomExecutionView convertExecExtenderToSquashAutomExecutionView(AutomatedExecutionExtender autoExec) {
        Execution execution = autoExec.getExecution();
        return new SquashAutomExecutionView(execution.getTestPlanItem().getId(), execution.getName(), execution.getDatasetLabel(), execution.getExecutionStatus(), execution.getReferencedTestCase().getProject().getTestAutomationServer().getName());
    }

    public static SquashAutomExecutionView convertItpiToSquashAutomExecutionView(TestPlanItem itpi) {
        TestCase referencedTestCase = itpi.getReferencedTestCase();
        return new SquashAutomExecutionView(itpi.getId(), referencedTestCase.getName(), Objects.nonNull(itpi.getReferencedDataset()) ? itpi.getReferencedDataset().getName() : null, ExecutionStatus.READY, referencedTestCase.getProject().getTestAutomationServer().getName(), itpi.getOrder());
    }
}

