/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.statistics.campaign;

import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import org.squashtest.tm.domain.planning.StandardWorkloadCalendar;

public final class ScheduledIteration {
    public static final String SCHED_ITER_NO_ITERATIONS_I18N = "dashboard.campaigns.progression.errors.nodata";
    public static final String SCHED_ITER_MISSING_DATES_I18N = "dashboard.campaigns.progression.errors.nulldates";
    public static final String SCHED_ITER_OVERLAP_DATES_I18N = "dashboard.campaigns.progression.errors.overlap";
    public static final String LONE_ITERATION_MISSING_DATES_I18N = "dashboard.iteration.progression.errors.nulldates";
    private long id;
    private String name;
    private long testplanCount;
    private Date scheduledStart;
    private Date scheduledEnd;
    private Collection<Object[]> cumulativeTestsByDate = new LinkedList<Object[]>();

    public ScheduledIteration() {
    }

    public ScheduledIteration(long id, String name, long testplanCount, Date scheduledStart, Date scheduledEnd) {
        this.id = id;
        this.name = name;
        this.testplanCount = testplanCount;
        this.scheduledStart = scheduledStart;
        this.scheduledEnd = scheduledEnd;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public long getTestplanCount() {
        return this.testplanCount;
    }

    public void setTestplanCount(long testplanCount) {
        this.testplanCount = testplanCount;
    }

    public Date getScheduledStart() {
        return this.scheduledStart;
    }

    public void setScheduledStart(Date scheduledStart) {
        this.scheduledStart = scheduledStart;
    }

    public Date getScheduledEnd() {
        return this.scheduledEnd;
    }

    public void setScheduledEnd(Date scheduledEnd) {
        this.scheduledEnd = scheduledEnd;
    }

    public Collection<Object[]> getCumulativeTestsByDate() {
        return this.cumulativeTestsByDate;
    }

    public void addCumulativeTestByDate(Object[] testByDate) {
        this.cumulativeTestsByDate.add(testByDate);
    }

    public void computeCumulativeTestByDate(float initialCumulativeTests) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this.scheduledStart);
        StandardWorkloadCalendar workloadCalendar = new StandardWorkloadCalendar();
        float workload = workloadCalendar.getWorkload(this.scheduledStart, this.scheduledEnd);
        float incrementPerDay = (float)this.testplanCount / workload;
        Date curDate = this.scheduledStart;
        float cumulativeTests = initialCumulativeTests;
        do {
            this.cumulativeTestsByDate.add(new Object[]{curDate, Float.valueOf(cumulativeTests += workloadCalendar.getWorkload(curDate) * incrementPerDay)});
            calendar.add(6, 1);
        } while (!(curDate = calendar.getTime()).after(this.scheduledEnd));
    }

    public static void checkIterationDatesIntegrity(ScheduledIteration iteration) {
        Date start = iteration.scheduledStart;
        Date end = iteration.scheduledEnd;
        if (start == null || end == null) {
            throw new IllegalArgumentException(SCHED_ITER_MISSING_DATES_I18N);
        }
    }

    public static void checkIterationDatesAreSet(ScheduledIteration iteration) {
        Date start = iteration.scheduledStart;
        Date end = iteration.scheduledEnd;
        if (start == null || end == null) {
            throw new IllegalArgumentException(LONE_ITERATION_MISSING_DATES_I18N);
        }
    }

    public static void checkIterationsDatesIntegrity(Collection<ScheduledIteration> iterations) {
        Date prevEnd = null;
        if (iterations.isEmpty()) {
            throw new IllegalArgumentException(SCHED_ITER_NO_ITERATIONS_I18N);
        }
        for (ScheduledIteration iter : iterations) {
            Date start = iter.scheduledStart;
            Date end = iter.scheduledEnd;
            if (start == null || end == null) {
                throw new IllegalArgumentException(SCHED_ITER_MISSING_DATES_I18N);
            }
            if (end.before(start)) {
                throw new IllegalArgumentException(SCHED_ITER_OVERLAP_DATES_I18N);
            }
            if (prevEnd != null && !start.after(prevEnd)) {
                throw new IllegalArgumentException(SCHED_ITER_OVERLAP_DATES_I18N);
            }
            prevEnd = end;
        }
    }
}

