/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.testautomation.resultimport;

import jakarta.inject.Inject;
import org.apache.commons.io.FilenameUtils;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.stereotype.Service;
import org.squashtest.tm.event.ConfigUpdateEvent;
import org.squashtest.tm.service.configuration.ConfigurationService;
import org.squashtest.tm.service.testautomation.resultimport.AttachmentContentVerificationService;

@Service
public class AttachmentContentVerificationServiceImpl
implements AttachmentContentVerificationService,
ApplicationListener<ApplicationEvent> {
    private String[] allowedExtensionsForExecutions;
    private String[] allowedExtensionsForAutomatedSuites;
    private Long maxUploadSizeInBytes;
    private ConfigurationService config;

    @Inject
    public AttachmentContentVerificationServiceImpl(ConfigurationService config) {
        this.config = config;
    }

    private void updateConfig() {
        String whiteListKey = "uploadfilter.fileExtensions.whitelist";
        String whiteList = this.config.findConfiguration(whiteListKey);
        this.allowedExtensionsForExecutions = whiteList.split(",");
        String whiteListKeyForAutomatedSuiteImport = "uploadfilter.fileExtensions.resultImport.whitelist";
        String whiteListForAutomatedSuiteImport = this.config.findConfiguration(whiteListKeyForAutomatedSuiteImport);
        this.allowedExtensionsForAutomatedSuites = whiteListForAutomatedSuiteImport.split(",");
        String uploadSizeLimit = this.config.findConfiguration("uploadfilter.upload.sizeLimitInBytes");
        this.maxUploadSizeInBytes = Long.parseLong(uploadSizeLimit);
    }

    @Override
    public boolean isTypeAllowedForExecutionImport(String filename) {
        String fileType = FilenameUtils.getExtension((String)filename);
        String[] stringArray = this.allowedExtensionsForExecutions;
        int n = this.allowedExtensionsForExecutions.length;
        int n2 = 0;
        while (n2 < n) {
            String type = stringArray[n2];
            if (type.trim().equalsIgnoreCase(fileType)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public boolean isTypeAllowedForAutomatedSuiteImport(String filename) {
        String fileType = FilenameUtils.getExtension((String)filename);
        String[] stringArray = this.allowedExtensionsForAutomatedSuites;
        int n = this.allowedExtensionsForAutomatedSuites.length;
        int n2 = 0;
        while (n2 < n) {
            String type = stringArray[n2];
            if (type.trim().equalsIgnoreCase(fileType)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public boolean isSizeAllowed(String content) {
        if (content == null || content.isBlank()) {
            return true;
        }
        long size = content.getBytes().length;
        return size <= this.maxUploadSizeInBytes;
    }

    @Override
    public Long getMaxUploadSizeInBytes() {
        return this.maxUploadSizeInBytes;
    }

    @Override
    public String[] getAllowedExtensionsForExecutions() {
        return this.allowedExtensionsForExecutions;
    }

    @Override
    public String[] getAllowedExtensionsForAutomatedSuites() {
        return this.allowedExtensionsForAutomatedSuites;
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ConfigUpdateEvent || event instanceof ContextRefreshedEvent) {
            this.updateConfig();
        }
    }
}

