/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.testautomation.model.messages;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opentestfactory.messages.Status;
import org.squashtest.tm.service.internal.testautomation.model.messages.Metadata;
import org.squashtest.tm.service.internal.testautomation.model.messages.WorkflowData;

public class WorkflowsStatus
extends Status<Map<String, WorkflowData>> {
    private static final String ITEMS_KEY = "items";
    private static final String ORIGINATING_PROJECTS_KEY = "squashtest.org/originating-projects";

    public WorkflowsStatus(String apiVersion) {
        super(apiVersion);
    }

    public List<WorkflowData> getProjectWorkflows(String projectId) {
        Map map;
        Map details = this.getDetails();
        Map map2 = map = Objects.isNull(details) ? null : (Map)details.get(ITEMS_KEY);
        if (Objects.nonNull(map)) {
            return map.values().stream().filter(workflow -> this.isProjectIdPresentInWorkflow(projectId, workflow.metadata())).toList();
        }
        return Collections.emptyList();
    }

    private boolean isProjectIdPresentInWorkflow(String projectId, Metadata metadata) {
        if (metadata.annotations() != null && metadata.annotations().containsKey(ORIGINATING_PROJECTS_KEY)) {
            List<Object> projectIds = metadata.annotations().get(ORIGINATING_PROJECTS_KEY);
            return projectIds.contains(projectId);
        }
        return false;
    }
}

