/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.security;

import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.Select;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.acls.domain.PermissionFactory;
import org.springframework.security.acls.model.Permission;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.api.security.acls.Permissions;
import org.squashtest.tm.aspect.validation.NotNullValidatorAspect;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.testcase.TestCaseLibrary;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.dto.AccessPermission;
import org.squashtest.tm.service.internal.security.AffirmativeBasedCompositePermissionEvaluator;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.service.security.SecurityCheckableObject;
import org.squashtest.tm.service.security.UserContextService;

@Service(value="squashtest.core.security.PermissionEvaluationService")
@Transactional(readOnly=true)
public class AclPermissionEvaluationService
implements PermissionEvaluationService {
    private static final String ACCESS_IS_DENIED = "Access is denied";
    private final UserContextService userContextService;
    private final AffirmativeBasedCompositePermissionEvaluator permissionEvaluator;
    private final PermissionFactory permissionFactory;
    private final DSLContext dslContext;

    public AclPermissionEvaluationService(UserContextService userContextService, @Lazy AffirmativeBasedCompositePermissionEvaluator permissionEvaluator, PermissionFactory permissionFactory, DSLContext dslContext) {
        this.userContextService = userContextService;
        this.permissionEvaluator = permissionEvaluator;
        this.permissionFactory = permissionFactory;
        this.dslContext = dslContext;
    }

    private boolean hasRoleOrPermissionOnObject(String role, Permission permission, Object object) {
        if (this.userContextService.hasRole(role)) {
            return true;
        }
        return this.permissionEvaluator.hasPermission(this.userContextService.getAuthentication(), object, permission);
    }

    @Override
    public boolean hasRoleOrPermissionOnObject(String role, String permissionName, Object object) {
        return this.hasRoleOrPermissionOnObject(role, this.permissionFactory.buildFromName(permissionName), object);
    }

    @Override
    public boolean hasPermissionOnObject(String permission, Object entity) {
        return this.permissionEvaluator.hasPermission(this.userContextService.getAuthentication(), entity, this.permissionFactory.buildFromName(permission));
    }

    @Override
    public void checkPermission(SecurityCheckableObject ... checkableObjects) {
        if (this.userContextService.hasRole("ROLE_ADMIN")) {
            return;
        }
        SecurityCheckableObject[] securityCheckableObjectArray = checkableObjects;
        int n = checkableObjects.length;
        int n2 = 0;
        while (n2 < n) {
            SecurityCheckableObject object = securityCheckableObjectArray[n2];
            if (!this.hasPermissionOnObject(object.getPermission(), object.getObject())) {
                throw new AccessDeniedException(ACCESS_IS_DENIED);
            }
            ++n2;
        }
    }

    @Override
    public void checkPermission(List<Long> ids, String permission, String entityClassName) {
        if (this.userContextService.hasRole("ROLE_ADMIN")) {
            return;
        }
        for (Long entityId : ids) {
            if (this.hasPermissionOnObject(permission, entityId, entityClassName)) continue;
            throw new AccessDeniedException(ACCESS_IS_DENIED);
        }
    }

    @Override
    public void checkPermission(Collection<?> toCheck, String permission) {
        if (this.userContextService.hasRole("ROLE_ADMIN")) {
            return;
        }
        for (Object o : toCheck) {
            if (this.hasPermissionOnObject(permission, o)) continue;
            throw new AccessDeniedException(ACCESS_IS_DENIED);
        }
    }

    @Override
    public void checkAtLeastOneProjectManagementPermissionOrAdmin() {
        if (this.userContextService.hasRole("ROLE_ADMIN") || this.userContextService.hasRole("ROLE_INFRASTRUCTURE_ADMIN")) {
            return;
        }
        List<Long> partyIds = this.fetchPartyIdsFromLogin(this.userContextService.getUsername());
        this.checkAtLeastOneProjectManagementPermissionOrAdmin(partyIds);
    }

    @Override
    public void checkAtLeastOneProjectImportPermissionOrAdmin() {
        if (!this.userContextService.hasRole("ROLE_ADMIN")) {
            List<Long> partyIds = this.fetchPartyIdsFromLogin(this.userContextService.getUsername());
            this.checkHasAtLeastOneManagementPermission(partyIds, Permissions.IMPORT);
        }
    }

    @Override
    public void checkAtLeastOneProjectManagementPermissionOrAdmin(List<Long> partyIds) {
        if (!this.userContextService.hasRole("ROLE_ADMIN")) {
            this.checkHasAtLeastOneManagementPermission(partyIds, Permissions.MANAGE_PROJECT);
        }
    }

    @Override
    public void checkAtLeastOneMilestoneManagementPermissionOrAdmin() {
        if (!this.userContextService.hasRole("ROLE_ADMIN")) {
            List<Long> partyIds = this.fetchPartyIdsFromLogin(this.userContextService.getUsername());
            this.checkAtLeastOneMilestoneManagementPermissionOrAdmin(partyIds);
        }
    }

    @Override
    public void checkAtLeastOneMilestoneManagementPermissionOrAdmin(List<Long> partyIds) {
        if (!this.userContextService.hasRole("ROLE_ADMIN")) {
            this.checkHasAtLeastOneManagementPermission(partyIds, Permissions.MANAGE_MILESTONE);
        }
    }

    @Override
    public void checkAtLeastOneClearanceManagementPermissionOrAdmin() {
        if (!this.userContextService.hasRole("ROLE_ADMIN")) {
            List<Long> partyIds = this.fetchPartyIdsFromLogin(this.userContextService.getUsername());
            this.checkAtLeastOneClearanceManagementPermissionOrAdmin(partyIds);
        }
    }

    @Override
    public void checkAtLeastOneClearanceManagementPermissionOrAdmin(List<Long> partyIds) {
        if (!this.userContextService.hasRole("ROLE_ADMIN")) {
            this.checkHasAtLeastOneManagementPermission(partyIds, Permissions.MANAGE_PROJECT_CLEARANCE);
        }
    }

    @Override
    public boolean hasAtLeastOneTestCaseCreationPermissionOrAdmin(Long partyId) {
        if (this.userContextService.hasRole("ROLE_ADMIN")) {
            return true;
        }
        return this.hasAtLeastOneTestCaseCreationPermission(partyId);
    }

    @Override
    public Set<AccessPermission> findAccessPermissions() {
        List<Long> partyIds = this.fetchPartyIdsFromLogin(this.userContextService.getUsername());
        return this.findAccessPermissions(partyIds);
    }

    @Override
    public Set<AccessPermission> findAccessPermissions(List<Long> partyIds) {
        Set accessPermissionMasks = Arrays.stream(AccessPermission.values()).map(accessPermission -> accessPermission.getPermissionWithMask().getMask()).collect(Collectors.toUnmodifiableSet());
        Map result = this.dslContext.select((SelectField)Tables.ACL_GROUP_PERMISSION.ACL_GROUP_ID, (SelectField)Tables.ACL_GROUP_PERMISSION.PERMISSION_MASK).from((TableLike)Tables.ACL_GROUP_PERMISSION).join((TableLike)Tables.ACL_RESPONSIBILITY_SCOPE_ENTRY).on(Tables.ACL_RESPONSIBILITY_SCOPE_ENTRY.ACL_GROUP_ID.eq((Field)Tables.ACL_GROUP_PERMISSION.ACL_GROUP_ID)).where(Tables.ACL_RESPONSIBILITY_SCOPE_ENTRY.PARTY_ID.in(partyIds)).and(Tables.ACL_GROUP_PERMISSION.PERMISSION_MASK.in(accessPermissionMasks)).groupBy(new GroupField[]{Tables.ACL_GROUP_PERMISSION.ACL_GROUP_ID, Tables.ACL_GROUP_PERMISSION.PERMISSION_MASK}).fetchGroups((Field)Tables.ACL_GROUP_PERMISSION.ACL_GROUP_ID, (Field)Tables.ACL_GROUP_PERMISSION.PERMISSION_MASK);
        if (result.isEmpty()) {
            return Collections.emptySet();
        }
        boolean isOnlyAutomationProgrammer = result.values().stream().allMatch(list -> list.contains(Permissions.WRITE_AS_AUTOMATION.getMask()) && !list.contains(Permissions.WRITE_AS_FUNCTIONAL.getMask()));
        if (isOnlyAutomationProgrammer) {
            return Collections.singleton(AccessPermission.WRITE_AS_AUTOMATION);
        }
        return result.values().stream().flatMap(Collection::stream).map(AccessPermission::findByMask).collect(Collectors.toSet());
    }

    @Override
    public boolean hasRoleOrPermissionOnObject(String role, String permissionName, Long entityId, String entityClassName) {
        if (this.userContextService.hasRole(role)) {
            return true;
        }
        return this.hasPermissionOnObject(permissionName, entityId, entityClassName);
    }

    @Override
    public boolean hasRoleOrPermissionOnObject(String[] roles, String permissionName, Long entityId, String entityClassName) {
        String[] stringArray = roles;
        int n = roles.length;
        int n2 = 0;
        while (n2 < n) {
            String role = stringArray[n2];
            if (this.userContextService.hasRole(role)) {
                return true;
            }
            ++n2;
        }
        return this.hasPermissionOnObject(permissionName, entityId, entityClassName);
    }

    @Override
    public boolean canRead(Object object) {
        return this.hasRoleOrPermissionOnObject("ROLE_ADMIN", "READ", object);
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS)
    public boolean hasRole(String role) {
        return this.userContextService.hasRole(role);
    }

    @Override
    public boolean hasMoreThanRead(Object object) {
        boolean hasMore = false;
        if (this.userContextService.hasRole("ROLE_ADMIN")) {
            hasMore = true;
        } else {
            Authentication authentication = this.userContextService.getAuthentication();
            Set permissions = Permissions.getAllPermissionNames();
            hasMore = this.findPermission(permissions, object, authentication);
        }
        return hasMore;
    }

    boolean findPermission(Set<String> allPermissions, Object object, Authentication authentication) {
        for (String permission : allPermissions) {
            try {
                if (Permissions.READ.name().equals(permission) || !this.permissionEvaluator.hasPermission(authentication, object, permission)) continue;
                return true;
            }
            catch (IllegalArgumentException iaexecption) {
                List<String> knownMessages = Arrays.asList("Unknown permission 'RESERVED_ON'", "Unknown permission 'RESERVED_OFF'", "Unknown permission 'THIRTY_TWO_RESERVED_OFF'");
                if (knownMessages.contains(iaexecption.getMessage())) continue;
                throw iaexecption;
            }
        }
        return false;
    }

    @Override
    public boolean hasPermissionOnObject(String permissionName, Long entityId, String entityClassName) {
        Authentication authentication = this.userContextService.getAuthentication();
        Permission permission = this.permissionFactory.buildFromName(permissionName);
        return this.permissionEvaluator.hasPermission(authentication, entityId, entityClassName, permission);
    }

    @Override
    public Map<String, Boolean> hasRoleOrPermissionsOnObject(String role, String[] permissions, Object entity) {
        boolean hasRole = this.userContextService.hasRole(role);
        HashMap<String, Boolean> permByName = new HashMap<String, Boolean>(permissions.length);
        String[] stringArray = permissions;
        int n = permissions.length;
        int n2 = 0;
        while (n2 < n) {
            String perm = stringArray[n2];
            permByName.put(perm, hasRole || this.hasPermissionOnObject(perm, entity));
            ++n2;
        }
        return permByName;
    }

    @Override
    public Collection<String> permissionsOn(@NotNull String className, long id) {
        String string = className;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289((Object)string);
        ArrayList<String> perms = new ArrayList<String>();
        Set permissions = Permissions.getAllPermissionNames();
        if (this.userContextService.hasRole("ROLE_ADMIN")) {
            return permissions;
        }
        for (String right : permissions) {
            if (!this.hasPermissionOnObject(right, id, className)) continue;
            perms.add(right);
        }
        return perms;
    }

    private void checkHasAtLeastOneManagementPermission(List<Long> partyIds, Permissions permission) {
        boolean hasManagementPermission = this.dslContext.fetchExists((Select)this.dslContext.select((SelectField)Tables.ACL_RESPONSIBILITY_SCOPE_ENTRY.ID).from((TableLike)Tables.ACL_RESPONSIBILITY_SCOPE_ENTRY).join((TableLike)Tables.ACL_GROUP_PERMISSION).on(Tables.ACL_RESPONSIBILITY_SCOPE_ENTRY.ACL_GROUP_ID.eq((Field)Tables.ACL_GROUP_PERMISSION.ACL_GROUP_ID)).join((TableLike)Tables.ACL_CLASS).on(Tables.ACL_GROUP_PERMISSION.CLASS_ID.eq((Field)Tables.ACL_CLASS.ID)).where(Tables.ACL_RESPONSIBILITY_SCOPE_ENTRY.PARTY_ID.in(partyIds)).and(Tables.ACL_GROUP_PERMISSION.PERMISSION_MASK.eq((Object)permission.getMask())).and(Tables.ACL_CLASS.CLASSNAME.eq((Object)Project.class.getName())));
        if (!hasManagementPermission) {
            throw new AccessDeniedException("Only users with management rights can perform this action");
        }
    }

    private boolean hasAtLeastOneTestCaseCreationPermission(Long partyId) {
        return this.dslContext.fetchExists((Select)this.dslContext.select((SelectField)Tables.ACL_RESPONSIBILITY_SCOPE_ENTRY.ID).from((TableLike)Tables.ACL_RESPONSIBILITY_SCOPE_ENTRY).join((TableLike)Tables.ACL_GROUP_PERMISSION).on(Tables.ACL_RESPONSIBILITY_SCOPE_ENTRY.ACL_GROUP_ID.eq((Field)Tables.ACL_GROUP_PERMISSION.ACL_GROUP_ID)).join((TableLike)Tables.ACL_CLASS).on(Tables.ACL_GROUP_PERMISSION.CLASS_ID.eq((Field)Tables.ACL_CLASS.ID)).where(Tables.ACL_RESPONSIBILITY_SCOPE_ENTRY.PARTY_ID.eq((Object)partyId)).and(Tables.ACL_GROUP_PERMISSION.PERMISSION_MASK.eq((Object)Permissions.CREATE.getMask())).and(Tables.ACL_CLASS.CLASSNAME.eq((Object)TestCaseLibrary.class.getName())));
    }

    private List<Long> fetchPartyIdsFromLogin(String login) {
        return this.dslContext.select((SelectField)Tables.CORE_USER.PARTY_ID).from((TableLike)Tables.CORE_USER).where(Tables.CORE_USER.LOGIN.eq((Object)login)).union((Select)this.dslContext.select((SelectField)Tables.CORE_TEAM_MEMBER.TEAM_ID).from((TableLike)Tables.CORE_TEAM_MEMBER).join((TableLike)Tables.CORE_USER).on(Tables.CORE_TEAM_MEMBER.USER_ID.eq((Field)Tables.CORE_USER.PARTY_ID)).where(Tables.CORE_USER.LOGIN.eq((Object)login))).fetchInto(Long.class);
    }
}

