/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.display.impl.collectors;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.springframework.stereotype.Component;
import org.squashtest.tm.domain.NodeReference;
import org.squashtest.tm.domain.NodeType;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.display.grid.DataRow;
import org.squashtest.tm.service.internal.repository.display.CustomFieldValueDisplayDao;
import org.squashtest.tm.service.internal.repository.display.MilestoneDisplayDao;
import org.squashtest.tm.service.internal.repository.display.TreeNodeCollector;
import org.squashtest.tm.service.internal.repository.display.impl.collectors.AbstractTreeNodeCollector;
import org.squashtest.tm.service.milestone.ActiveMilestoneHolder;

@Component
public class TestSuiteCollector
extends AbstractTreeNodeCollector
implements TreeNodeCollector {
    public TestSuiteCollector(DSLContext dsl, CustomFieldValueDisplayDao customFieldValueDisplayDao, ActiveMilestoneHolder activeMilestoneHolder, MilestoneDisplayDao milestoneDisplayDao) {
        super(dsl, customFieldValueDisplayDao, activeMilestoneHolder, milestoneDisplayDao);
    }

    @Override
    protected Map<Long, DataRow> doCollect(List<Long> ids) {
        Map<Long, DataRow> testSuites = this.collectTestSuites(ids);
        this.appendMilestonesInheritedFromCampaign(testSuites);
        return testSuites;
    }

    private Map<Long, DataRow> collectTestSuites(List<Long> ids) {
        return this.dsl.select((SelectField)Tables.TEST_SUITE.ID, (SelectField)Tables.TEST_SUITE.NAME, (SelectField)Tables.TEST_SUITE.EXECUTION_STATUS, (SelectField)Tables.CAMPAIGN_LIBRARY_NODE.PROJECT_ID.as("projectId"), (SelectField)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID.as("CAMPAIGN_ID")).from((TableLike)Tables.TEST_SUITE).leftJoin((TableLike)Tables.ITERATION_TEST_SUITE).on(Tables.TEST_SUITE.ID.eq((Field)Tables.ITERATION_TEST_SUITE.TEST_SUITE_ID)).leftJoin((TableLike)Tables.CAMPAIGN_ITERATION).on(Tables.ITERATION_TEST_SUITE.ITERATION_ID.eq((Field)Tables.CAMPAIGN_ITERATION.ITERATION_ID)).leftJoin((TableLike)Tables.CAMPAIGN_LIBRARY_NODE).on(Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID.eq((Field)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID)).where(Tables.TEST_SUITE.ID.in(ids)).fetch().stream().collect(Collectors.toMap(tuple -> (Long)tuple.get((Field)Tables.TEST_SUITE.ID), tuple -> {
            DataRow dataRow = new DataRow();
            dataRow.setId(new NodeReference(NodeType.TEST_SUITE, (Long)tuple.get((Field)Tables.TEST_SUITE.ID)).toNodeId());
            dataRow.setProjectId((Long)tuple.get("projectId", Long.class));
            dataRow.setData(tuple.intoMap());
            return dataRow;
        }));
    }

    @Override
    public NodeType getHandledEntityType() {
        return NodeType.TEST_SUITE;
    }
}

