/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.display.impl;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.OrderField;
import org.jooq.Record3;
import org.jooq.Select;
import org.jooq.SelectField;
import org.jooq.SelectFieldOrAsterisk;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.domain.aiserver.AiProvider;
import org.squashtest.tm.domain.artificialintelligence.AiUsageName;
import org.squashtest.tm.domain.milestone.Milestone;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.jooq.domain.tables.Requirement;
import org.squashtest.tm.service.internal.display.dto.aiserver.AiServerRequiredOptions;
import org.squashtest.tm.service.internal.display.dto.requirement.AbstractRequirementVersionDto;
import org.squashtest.tm.service.internal.display.dto.requirement.DetailedStepViewRequirementVersionDto;
import org.squashtest.tm.service.internal.display.dto.requirement.HighLevelRequirementVersionDto;
import org.squashtest.tm.service.internal.display.dto.requirement.RequirementVersionDto;
import org.squashtest.tm.service.internal.repository.display.RequirementVersionDisplayDao;
import org.squashtest.tm.service.internal.utils.JSONUtils;
import org.squashtest.tm.service.milestone.ActiveMilestoneHolder;
import org.squashtest.tm.service.plugin.ConfigurablePluginManager;

@Repository
public class RequirementVersionDisplayDaoImpl
implements RequirementVersionDisplayDao {
    private static final String HAS_EXTENDER = "HAS_EXTENDER";
    private static final String SERVER_NAME = "SERVER_NAME";
    private static final String REMOTE_SYNCHRONISATION_KIND = "REMOTE_SYNCHRONISATION_KIND";
    private static final String AI_SERVER_ID = "AI_SERVER_ID";
    private static final String AI_SERVER_PROVIDER = "AI_SERVER_PROVIDER";
    private static final String CAN_USE_AI_FEATURE = "CAN_USE_AI_FEATURE";
    private final DSLContext dsl;
    private final ActiveMilestoneHolder activeMilestoneHolder;
    private final ConfigurablePluginManager configurablePluginManager;

    public RequirementVersionDisplayDaoImpl(DSLContext dsl, ActiveMilestoneHolder activeMilestoneHolder, @Lazy ConfigurablePluginManager configurablePluginManager) {
        this.dsl = dsl;
        this.activeMilestoneHolder = activeMilestoneHolder;
        this.configurablePluginManager = configurablePluginManager;
    }

    @Override
    public Map<Long, Long> findCurrentRequirementVersions(List<Long> requirementIds) {
        Optional<Milestone> activeMilestoneId = this.activeMilestoneHolder.getActiveMilestone();
        if (activeMilestoneId.isPresent()) {
            return this.findRequirementVersionIdsInMilestoneMode(requirementIds, activeMilestoneId.get().getId());
        }
        return this.findRequirementVersionIdsWithoutMilestone(requirementIds);
    }

    @Override
    public Long findCurrentRequirementVersions(Long requirementId) {
        Map<Long, Long> currentRequirementVersions = this.findCurrentRequirementVersions(Collections.singletonList(requirementId));
        return currentRequirementVersions.get(requirementId);
    }

    @Override
    public List<String> retrieveFullNameByRequirementLibraryNodeIds(List<Long> requirementLibraryNodeIds, List<Long> projectIds) {
        Table<Record3<String, String, Long>> reqReferenceAndNameTable = this.getReqReferenceWithNameAndIdTable(requirementLibraryNodeIds);
        Field reference = reqReferenceAndNameTable.field("REQUIREMENT_VERSION_REFERENCE", String.class);
        Field name = reqReferenceAndNameTable.field("RESOURCE_NAME", String.class);
        Field nodeId = reqReferenceAndNameTable.field("REQUIREMENT_LIBRARY_NODE_ID", Long.class);
        Field fullName = DSL.when((Condition)Objects.requireNonNull(reference).eq((Object)""), (Field)name).otherwise(DSL.concat((Field[])new Field[]{reference, DSL.val((String)" - "), name}));
        return this.dsl.select((SelectField)fullName).from(reqReferenceAndNameTable).join((TableLike)Tables.REQUIREMENT_LIBRARY_NODE).on(Objects.requireNonNull(nodeId).eq((Field)Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID)).where(Tables.REQUIREMENT_LIBRARY_NODE.PROJECT_ID.in(projectIds)).orderBy((OrderField)fullName).fetch(fullName);
    }

    private Table<Record3<String, String, Long>> getReqReferenceWithNameAndIdTable(List<Long> requirementLibraryNodeIds) {
        return this.dsl.select((SelectField)DSL.when((Condition)Tables.REQUIREMENT_VERSION.REFERENCE.isNull(), (Object)"").otherwise((Field)Tables.REQUIREMENT_VERSION.REFERENCE).as("REQUIREMENT_VERSION_REFERENCE"), (SelectField)Tables.RESOURCE.NAME.as("RESOURCE_NAME"), (SelectField)Tables.REQUIREMENT_VERSION.REQUIREMENT_ID.as("REQUIREMENT_LIBRARY_NODE_ID")).from((TableLike)Tables.RESOURCE).join((TableLike)Tables.REQUIREMENT_VERSION).on(Tables.RESOURCE.RES_ID.eq((Field)Tables.REQUIREMENT_VERSION.RES_ID)).where(Tables.REQUIREMENT_VERSION.REQUIREMENT_ID.in(requirementLibraryNodeIds)).union((Select)this.dsl.select((SelectField)DSL.val((String)"").as("REQUIREMENT_VERSION_REFERENCE"), (SelectField)Tables.RESOURCE.NAME.as("RESOURCE_NAME"), (SelectField)Tables.REQUIREMENT_FOLDER.RLN_ID.as("REQUIREMENT_LIBRARY_NODE_ID")).from((TableLike)Tables.RESOURCE).join((TableLike)Tables.REQUIREMENT_FOLDER).on(Tables.RESOURCE.RES_ID.eq((Field)Tables.REQUIREMENT_FOLDER.RES_ID)).where(Tables.REQUIREMENT_FOLDER.RLN_ID.in(requirementLibraryNodeIds))).asTable();
    }

    @Override
    public RequirementVersionDto findRequirementVersion(Long currentVersionId) {
        RequirementVersionDto requirementVersion = this.findBaseRequirementVersion(currentVersionId, RequirementVersionDto.class);
        this.setReadOnlyFieldsIfReqIsSynchronized(requirementVersion);
        this.appendLinkedHighLevelRequirement(requirementVersion);
        return requirementVersion;
    }

    @Override
    public HighLevelRequirementVersionDto findHighLevelRequirementVersion(Long currentVersionId) {
        HighLevelRequirementVersionDto baseRequirementVersion = this.findBaseRequirementVersion(currentVersionId, HighLevelRequirementVersionDto.class);
        this.setReadOnlyFieldsIfReqIsSynchronized(baseRequirementVersion);
        return baseRequirementVersion;
    }

    private void setReadOnlyFieldsIfReqIsSynchronized(AbstractRequirementVersionDto requirementVersion) {
        if (!requirementVersion.isHasExtender()) {
            return;
        }
        String attributeMappingsJson = this.configurablePluginManager.getAttributeMappingsOrPluginDefault(requirementVersion.getProjectId(), requirementVersion.getRemoteSynchronisationKind());
        if (Objects.nonNull(attributeMappingsJson)) {
            List<String> readonlyFields = this.fetchReadonlyFields(attributeMappingsJson);
            requirementVersion.setReadonlyFields(readonlyFields);
        }
    }

    private List<String> fetchReadonlyFields(String attributeMappingsJson) {
        Iterator<JsonNode> attributeMappingNodes = JSONUtils.getElementsFromJsonArray(attributeMappingsJson);
        if (!attributeMappingNodes.hasNext()) {
            return Collections.emptyList();
        }
        ArrayList<String> readonlyFields = new ArrayList<String>();
        attributeMappingNodes.forEachRemaining(attributeMapping -> {
            boolean bl = readonlyFields.add(attributeMapping.get("squashField").asText());
        });
        return readonlyFields;
    }

    private void appendLinkedHighLevelRequirement(RequirementVersionDto requirementVersion) {
        RequirementVersionDto.LinkedHighLevelRequirementDto linkedHighLevelRequirement = this.findLinkedHighLevelRequirement(requirementVersion.getRequirementId());
        requirementVersion.setLinkedHighLevelRequirement(linkedHighLevelRequirement);
    }

    @Override
    public RequirementVersionDto.LinkedHighLevelRequirementDto findLinkedHighLevelRequirement(Long requirementId) {
        Requirement lowLevelRequirement = Tables.REQUIREMENT.as("LOW_LEVEL_REQUIREMENT");
        Requirement highLevelRequirement = Tables.REQUIREMENT.as("HIGH_LEVEL_REQUIREMENT");
        return (RequirementVersionDto.LinkedHighLevelRequirementDto)this.dsl.select((SelectField)highLevelRequirement.RLN_ID.as("REQUIREMENT_ID"), (SelectField)Tables.RESOURCE.RES_ID.as("REQUIREMENT_VERSION_ID"), (SelectField)Tables.RESOURCE.NAME, (SelectField)Tables.REQUIREMENT_VERSION.REFERENCE, (SelectField)Tables.PROJECT.NAME.as("PROJECT_NAME")).from((TableLike)lowLevelRequirement).innerJoin((TableLike)highLevelRequirement).on(highLevelRequirement.RLN_ID.eq((Field)lowLevelRequirement.HIGH_LEVEL_REQUIREMENT_ID)).innerJoin((TableLike)Tables.RESOURCE).on(Tables.RESOURCE.RES_ID.eq((Field)highLevelRequirement.CURRENT_VERSION_ID)).innerJoin((TableLike)Tables.REQUIREMENT_VERSION).on(Tables.REQUIREMENT_VERSION.RES_ID.eq((Field)highLevelRequirement.CURRENT_VERSION_ID)).innerJoin((TableLike)Tables.REQUIREMENT_LIBRARY_NODE).on(Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID.eq((Field)highLevelRequirement.RLN_ID)).innerJoin((TableLike)Tables.PROJECT).on(Tables.REQUIREMENT_LIBRARY_NODE.PROJECT_ID.eq((Field)Tables.PROJECT.PROJECT_ID)).where(lowLevelRequirement.RLN_ID.eq((Object)requirementId)).fetchOneInto(RequirementVersionDto.LinkedHighLevelRequirementDto.class);
    }

    private <T extends AbstractRequirementVersionDto> T findBaseRequirementVersion(Long currentVersionId, Class<T> baseClass) {
        return (T)((AbstractRequirementVersionDto)this.dsl.select(new SelectFieldOrAsterisk[]{Tables.REQUIREMENT_VERSION.RES_ID.as("ID"), Tables.REQUIREMENT_VERSION.REFERENCE, Tables.REQUIREMENT_VERSION.REQUIREMENT_ID, Tables.REQUIREMENT_VERSION.VERSION_NUMBER, Tables.REQUIREMENT_VERSION.CATEGORY, Tables.REQUIREMENT_VERSION.CRITICALITY, Tables.REQUIREMENT_VERSION.REQUIREMENT_STATUS.as("STATUS"), Tables.RESOURCE.NAME, Tables.RESOURCE.ATTACHMENT_LIST_ID, Tables.RESOURCE.CREATED_BY, Tables.RESOURCE.CREATED_ON, Tables.RESOURCE.LAST_MODIFIED_BY, Tables.RESOURCE.LAST_MODIFIED_ON, Tables.RESOURCE.DESCRIPTION, Tables.REQUIREMENT_LIBRARY_NODE.PROJECT_ID, Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_REQ_ID, Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_REQ_URL, Tables.REMOTE_SYNCHRONISATION.SYNC_STATUS, Tables.REMOTE_SYNCHRONISATION.SERVER_ID, Tables.THIRD_PARTY_SERVER.NAME.as(SERVER_NAME), Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_REQ_PERIMETER_STATUS, Tables.BUGTRACKER.KIND.as("BUGTRACKER_KIND"), Tables.AI_SERVER.SERVER_ID.as(AI_SERVER_ID), Tables.AI_SERVER.PROVIDER.as(AI_SERVER_PROVIDER), this.buildCanUseAiFeatureField().as(CAN_USE_AI_FEATURE), DSL.field((Condition)Tables.REQUIREMENT_SYNC_EXTENDER.REQ_SYNC_ID.isNotNull()).as(HAS_EXTENDER), DSL.when((Condition)Tables.REMOTE_SYNCHRONISATION.KIND.isNull().and(DSL.field((Condition)Tables.REQUIREMENT_SYNC_EXTENDER.REQ_SYNC_ID.isNotNull())).and(Tables.BUGTRACKER.KIND.contains((Object)"redmine")), (Object)"squash.tm.plugin.redminereq").otherwise((Field)Tables.REMOTE_SYNCHRONISATION.KIND).as(REMOTE_SYNCHRONISATION_KIND)}).from((TableLike)Tables.REQUIREMENT_VERSION).innerJoin((TableLike)Tables.RESOURCE).using(new Field[]{Tables.REQUIREMENT_VERSION.RES_ID}).innerJoin((TableLike)Tables.REQUIREMENT_LIBRARY_NODE).on(Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID.eq((Field)Tables.REQUIREMENT_VERSION.REQUIREMENT_ID)).innerJoin((TableLike)Tables.PROJECT).on(Tables.PROJECT.PROJECT_ID.eq((Field)Tables.REQUIREMENT_LIBRARY_NODE.PROJECT_ID)).leftJoin((TableLike)Tables.REQUIREMENT_SYNC_EXTENDER).on(Tables.REQUIREMENT_VERSION.REQUIREMENT_ID.eq((Field)Tables.REQUIREMENT_SYNC_EXTENDER.REQUIREMENT_ID)).leftJoin((TableLike)Tables.REMOTE_SYNCHRONISATION).on(Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_SYNCHRONISATION_ID.eq((Field)Tables.REMOTE_SYNCHRONISATION.REMOTE_SYNCHRONISATION_ID)).leftJoin((TableLike)Tables.THIRD_PARTY_SERVER).on(Tables.REMOTE_SYNCHRONISATION.SERVER_ID.eq((Field)Tables.THIRD_PARTY_SERVER.SERVER_ID)).leftJoin((TableLike)Tables.BUGTRACKER).on(Tables.REQUIREMENT_SYNC_EXTENDER.SERVER_ID.eq((Field)Tables.BUGTRACKER.BUGTRACKER_ID)).innerJoin((TableLike)Tables.AI_USAGE).on(Tables.AI_USAGE.USAGE.eq((Object)AiUsageName.CLASSIC_TEST_CASE_GENERATION.name())).leftJoin((TableLike)Tables.PROJECT_AI_CONFIGURATION).on(Tables.PROJECT_AI_CONFIGURATION.PROJECT_ID.eq((Field)Tables.PROJECT.PROJECT_ID).and(Tables.PROJECT_AI_CONFIGURATION.AI_USAGE_ID.eq((Field)Tables.AI_USAGE.AI_USAGE_ID))).leftJoin((TableLike)Tables.AI_SERVER).on(DSL.coalesce((Field)Tables.PROJECT.AI_SERVER_ID, (Field[])new Field[]{Tables.PROJECT_AI_CONFIGURATION.AI_SERVER_ID}).eq((Field)Tables.AI_SERVER.SERVER_ID)).where(Tables.REQUIREMENT_VERSION.RES_ID.eq((Object)currentVersionId)).fetchOneInto(baseClass));
    }

    private Field<Boolean> buildCanUseAiFeatureField() {
        return DSL.field((SelectField)DSL.when((Condition)Tables.AI_SERVER.PROVIDER.eq((Object)AiProvider.NONE.name()), (Field)RequirementVersionDisplayDaoImpl.canUseNoneProvider()).when(Tables.AI_SERVER.PROVIDER.eq((Object)AiProvider.CUSTOM.name()), (Field)RequirementVersionDisplayDaoImpl.canUseCustomAIServer().and(RequirementVersionDisplayDaoImpl.checkRequiredProjectAiConfiguration())).when(Tables.AI_SERVER.PROVIDER.eq((Object)AiProvider.GOOGLE_VERTEX_AI.name()), (Field)RequirementVersionDisplayDaoImpl.canUseGoogleVertexAi().and(RequirementVersionDisplayDaoImpl.checkRequiredProjectAiConfiguration())).otherwise((Field)RequirementVersionDisplayDaoImpl.canUseStandardProvider().and(RequirementVersionDisplayDaoImpl.checkRequiredProjectAiConfiguration())));
    }

    private static Condition canUseNoneProvider() {
        return Tables.AI_SERVER.PAYLOAD_TEMPLATE.isNotNull().and(Tables.AI_SERVER.JSON_PATH.isNotNull());
    }

    private static Condition canUseCustomAIServer() {
        return Tables.AI_SERVER.OPTIONS.contains((Object)AiServerRequiredOptions.PAYLOAD_TEMPLATE.label).and(Tables.AI_SERVER.OPTIONS.contains((Object)AiServerRequiredOptions.GENERATED_TEXT_JSON_PATH.label));
    }

    private static Condition canUseStandardProvider() {
        return Tables.AI_SERVER.MODEL_NAME.isNotNull().and(Tables.AI_SERVER.MODEL_NAME.ne((Object)""));
    }

    private static Condition canUseGoogleVertexAi() {
        return Tables.AI_SERVER.MODEL_NAME.isNotNull().and(Tables.AI_SERVER.MODEL_NAME.isNotNull()).and(Tables.AI_SERVER.MODEL_NAME.ne((Object)"")).and(Tables.AI_SERVER.OPTIONS.contains((Object)AiServerRequiredOptions.PROJECT_ID.label)).and(Tables.AI_SERVER.OPTIONS.contains((Object)AiServerRequiredOptions.REGION.label));
    }

    private static Condition checkRequiredProjectAiConfiguration() {
        return Tables.PROJECT_AI_CONFIGURATION.AI_SERVER_ID.isNotNull().and(Tables.PROJECT_AI_CONFIGURATION.PROMPT_SET_ID.isNotNull());
    }

    @Override
    public DetailedStepViewRequirementVersionDto findById(Long requirementVersionId) {
        return (DetailedStepViewRequirementVersionDto)this.dsl.select((SelectField)Tables.REQUIREMENT_VERSION.CATEGORY, (SelectField)Tables.REQUIREMENT_VERSION.CRITICALITY, (SelectField)Tables.REQUIREMENT_VERSION.REQUIREMENT_STATUS.as("STATUS"), (SelectField)Tables.REQUIREMENT_VERSION.VERSION_NUMBER, (SelectField)Tables.RESOURCE.DESCRIPTION).from((TableLike)Tables.REQUIREMENT_VERSION).innerJoin((TableLike)Tables.RESOURCE).using(new Field[]{Tables.REQUIREMENT_VERSION.RES_ID}).where(Tables.REQUIREMENT_VERSION.RES_ID.eq((Object)requirementVersionId)).fetchOneInto(DetailedStepViewRequirementVersionDto.class);
    }

    private Map<Long, Long> findRequirementVersionIdsWithoutMilestone(List<Long> requirementIds) {
        return this.findCurrentVersionByRequirement(requirementIds);
    }

    private Map<Long, Long> findCurrentVersionByRequirement(List<Long> requirementIds) {
        return this.dsl.select((SelectField)Tables.REQUIREMENT.RLN_ID, (SelectField)Tables.REQUIREMENT.CURRENT_VERSION_ID).from((TableLike)Tables.REQUIREMENT).where(Tables.REQUIREMENT.RLN_ID.in(requirementIds)).fetchMap((Field)Tables.REQUIREMENT.RLN_ID, (Field)Tables.REQUIREMENT.CURRENT_VERSION_ID);
    }

    private Map<Long, Long> findRequirementVersionIdsInMilestoneMode(List<Long> requirementIds, Long activeMilestoneId) {
        Map<Long, Long> requirementToCurrentVersionIds = this.findCurrentVersionByRequirement(requirementIds);
        Map milestoneRequirementVersionIds = this.dsl.select((SelectField)Tables.REQUIREMENT_VERSION.REQUIREMENT_ID, (SelectField)Tables.REQUIREMENT_VERSION.RES_ID).from((TableLike)Tables.REQUIREMENT_VERSION).innerJoin((TableLike)Tables.MILESTONE_REQ_VERSION).on(Tables.REQUIREMENT_VERSION.RES_ID.eq((Field)Tables.MILESTONE_REQ_VERSION.REQ_VERSION_ID)).where(Tables.REQUIREMENT_VERSION.REQUIREMENT_ID.in(requirementIds)).and(Tables.MILESTONE_REQ_VERSION.MILESTONE_ID.eq((Object)activeMilestoneId)).fetchMap((Field)Tables.REQUIREMENT_VERSION.REQUIREMENT_ID, (Field)Tables.REQUIREMENT_VERSION.RES_ID);
        return requirementIds.stream().collect(Collectors.toMap(Function.identity(), requirementId -> Optional.ofNullable(milestoneRequirementVersionIds.getOrDefault(requirementId, requirementToCurrentVersionIds.getOrDefault(requirementId, null))).orElseThrow(() -> new IllegalArgumentException("No version found for requirement " + String.valueOf(requirementId)))));
    }
}

