/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.report;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.service.report.ReportTemplateManagerService;

@Service
public class ReportTemplateManagerServiceImpl
implements ReportTemplateManagerService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReportTemplateManagerServiceImpl.class);
    public static final String DOCX_FILE_EXTENSION = "docx";

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public boolean addATemplateToServer(String filePath, String folderPath, MultipartFile uploadedFile) {
        String fileExtension = FilenameUtils.getExtension((String)uploadedFile.getOriginalFilename());
        if (!DOCX_FILE_EXTENSION.equals(fileExtension)) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("Uploaded file does not have a valid template file extension: %s", fileExtension), new Object[0]);
            }
            return false;
        }
        try {
            if (Files.notExists(Paths.get(folderPath, new String[0]), new LinkOption[0])) {
                this.checkPathAndCreateMissingFolders(folderPath);
            }
            uploadedFile.transferTo(Paths.get(filePath, new String[0]));
            return true;
        }
        catch (IOException e) {
            LOGGER.debug("An error occurred while adding report template file", (Throwable)e);
            return false;
        }
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void deleteTemplateFromServer(String filePath) {
        try {
            if (Files.exists(Paths.get(filePath, new String[0]), new LinkOption[0])) {
                FileUtils.delete((File)new File(filePath));
            }
        }
        catch (IOException e) {
            LOGGER.debug("An error occurred while deleting report template file", (Throwable)e);
        }
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public boolean doesTemplateExistOnServer(String filePath) {
        return new File(filePath).exists();
    }

    private void checkPathAndCreateMissingFolders(String folderPath) throws IOException {
        String[] pathParts = folderPath.split("/");
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < pathParts.length && builder.toString().compareTo(folderPath) != 0) {
            builder.append(pathParts[i]);
            Path tempDirectoryPath = Paths.get(builder.toString(), new String[0]);
            if (Files.notExists(tempDirectoryPath, new LinkOption[0])) {
                Files.createDirectory(tempDirectoryPath, new FileAttribute[0]);
            }
            ++i;
            builder.append("/");
        }
    }
}

