/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.promptset;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.artificialintelligence.AiUsage;
import org.squashtest.tm.domain.artificialintelligence.AiUsageName;
import org.squashtest.tm.domain.promptset.PromptSet;
import org.squashtest.tm.exception.NameAlreadyInUseException;
import org.squashtest.tm.service.internal.repository.AiUsageDao;
import org.squashtest.tm.service.internal.repository.ProjectAiConfigurationDao;
import org.squashtest.tm.service.internal.repository.PromptDao;
import org.squashtest.tm.service.internal.repository.PromptSetDao;
import org.squashtest.tm.service.promptset.PromptSetManagerService;

@Transactional
@Service
public class PromptSetManagerServiceImpl
implements PromptSetManagerService {
    private final PromptSetDao promptSetDao;
    private final PromptDao promptDao;
    private final AiUsageDao aiUsageDao;
    private final ProjectAiConfigurationDao projectAiConfigurationDao;

    public PromptSetManagerServiceImpl(PromptSetDao promptSetDao, PromptDao promptDao, AiUsageDao aiUsageDao, ProjectAiConfigurationDao projectAiConfigurationDao) {
        this.promptSetDao = promptSetDao;
        this.promptDao = promptDao;
        this.aiUsageDao = aiUsageDao;
        this.projectAiConfigurationDao = projectAiConfigurationDao;
    }

    @Override
    public PromptSet findById(long promptSetId) {
        return (PromptSet)this.promptSetDao.getReferenceById(promptSetId);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void changeName(long promptSetId, String newName) {
        PromptSet promptSet = this.findById(promptSetId);
        if (StringUtils.equals((CharSequence)promptSet.getName(), (CharSequence)newName)) {
            return;
        }
        this.checkNameAvailability(newName);
        promptSet.setName(newName);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void changeDescription(long promptSetId, String newDescription) {
        PromptSet promptSet = this.findById(promptSetId);
        promptSet.setDescription(newDescription);
    }

    @Override
    public void changeAiUsage(long promptSetId, String aiUsage) {
        Long aiUsageId = this.aiUsageDao.findAiUsageIdByUsage(AiUsageName.valueOf((String)aiUsage));
        if (aiUsageId == null) {
            throw new IllegalArgumentException("Unknown artificial intelligence usage: " + aiUsage);
        }
        AiUsage usage = (AiUsage)this.aiUsageDao.getReferenceById(aiUsageId);
        PromptSet promptSet = this.findById(promptSetId);
        promptSet.setAiUsage(usage);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void persist(PromptSet promptSet) {
        this.checkNameAvailability(promptSet.getName());
        this.promptSetDao.save(promptSet);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void delete(List<Long> promptSetIds) {
        this.removeFromProjectAiConfigurations(promptSetIds);
        this.deletePromptsFromPromptSets(promptSetIds);
        this.promptSetDao.deleteAllByIdInBatch(promptSetIds);
    }

    private void removeFromProjectAiConfigurations(List<Long> promptSetIds) {
        this.projectAiConfigurationDao.removePromptSetsFromProjectAiConfigurations(promptSetIds);
    }

    private void deletePromptsFromPromptSets(List<Long> promptSetIds) {
        List promptSets = this.promptSetDao.findAllById(promptSetIds);
        for (PromptSet promptSet : promptSets) {
            this.promptDao.deleteAllInBatch(promptSet.getPrompts());
        }
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public PromptSet createPromptSet(String name, String description, String aiUsage) {
        PromptSet promptSet = new PromptSet();
        promptSet.setName(name);
        promptSet.setDescription(description);
        Long aiUsageId = this.aiUsageDao.findAiUsageIdByUsage(AiUsageName.valueOf((String)aiUsage));
        if (aiUsageId == null) {
            throw new IllegalArgumentException("Unknown artificial intelligence usage: " + aiUsage);
        }
        AiUsage usage = (AiUsage)this.aiUsageDao.getReferenceById(aiUsageId);
        promptSet.setAiUsage(usage);
        this.persist(promptSet);
        return promptSet;
    }

    private void checkNameAvailability(String name) {
        if (this.promptSetDao.findByName(name) != null) {
            throw new NameAlreadyInUseException("PromptSet", name, "name");
        }
    }
}

