/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.promptset;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.promptset.Prompt;
import org.squashtest.tm.domain.promptset.PromptSet;
import org.squashtest.tm.exception.NameAlreadyInUseException;
import org.squashtest.tm.service.internal.artificialintelligence.server.custom.MessageRound;
import org.squashtest.tm.service.internal.artificialintelligence.server.custom.RequestPayloadGenerator;
import org.squashtest.tm.service.internal.repository.PromptDao;
import org.squashtest.tm.service.internal.repository.PromptSetDao;
import org.squashtest.tm.service.promptset.PromptManagerService;

@Transactional
@Service
public class PromptManagerServiceImpl
implements PromptManagerService {
    private static final String SYSTEM_PROMPT_TEMPLATE = "systemPromptTemplate";
    private static final String USER_PROMPT_TEMPLATE = "userPromptTemplate";
    private final PromptDao promptDao;
    private final PromptSetDao promptSetDao;

    public PromptManagerServiceImpl(PromptDao promptDao, PromptSetDao promptSetDao) {
        this.promptDao = promptDao;
        this.promptSetDao = promptSetDao;
    }

    @Override
    public Prompt findById(long promptId) {
        return (Prompt)this.promptDao.getReferenceById(promptId);
    }

    @Override
    public void changeName(long promptId, String newName) {
        Prompt prompt = this.findById(promptId);
        if (StringUtils.equals((CharSequence)prompt.getName(), (CharSequence)newName)) {
            return;
        }
        this.checkNameAvailability(newName, prompt.getPromptSet().getId());
        prompt.setName(newName);
    }

    @Override
    public void changeSystemPromptTemplate(long promptId, String systemPromptTemplate) {
        this.checkIfIsValidHandleBar(systemPromptTemplate, SYSTEM_PROMPT_TEMPLATE);
        Prompt prompt = this.findById(promptId);
        prompt.setSystemPromptTemplate(systemPromptTemplate);
    }

    @Override
    public void changeUserPromptTemplate(long promptId, String userPromptTemplate) {
        this.checkIfIsValidHandleBar(userPromptTemplate, USER_PROMPT_TEMPLATE);
        Prompt prompt = this.findById(promptId);
        prompt.setUserPromptTemplate(userPromptTemplate);
    }

    private void checkIfIsValidHandleBar(String promptTemplate, String fieldName) {
        RequestPayloadGenerator.generate(promptTemplate, fieldName, new ArrayList<MessageRound>(), "");
    }

    @Override
    public void addPrompt(long promptSetId, Prompt prompt) {
        PromptSet promptSet = (PromptSet)this.promptSetDao.getReferenceById(promptSetId);
        this.checkNameAvailability(prompt.getName(), promptSet.getId());
        this.checkIfIsValidHandleBar(prompt.getSystemPromptTemplate(), SYSTEM_PROMPT_TEMPLATE);
        this.checkIfIsValidHandleBar(prompt.getUserPromptTemplate(), USER_PROMPT_TEMPLATE);
        prompt.setPromptSet(promptSet);
        this.promptDao.save(prompt);
        promptSet.addPrompt(prompt);
    }

    @Override
    public void deletePrompts(List<Long> promptIds) {
        this.promptDao.deleteAllByIdInBatch(promptIds);
    }

    private void checkNameAvailability(String name, Long promptSetId) {
        if (this.promptDao.findByNameAndPromptSetId(name, promptSetId) != null) {
            throw new NameAlreadyInUseException("Prompt", name, "name");
        }
    }
}

