/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.project;

import jakarta.inject.Inject;
import jakarta.persistence.EntityNotFoundException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.springframework.data.domain.Sort;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.acls.domain.ObjectIdentityImpl;
import org.springframework.security.acls.model.ObjectIdentity;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.core.foundation.collection.Filtering;
import org.squashtest.tm.core.foundation.collection.PagedCollectionHolder;
import org.squashtest.tm.core.foundation.collection.Paging;
import org.squashtest.tm.core.foundation.collection.PagingAndSorting;
import org.squashtest.tm.core.foundation.collection.PagingBackedPagedCollectionHolder;
import org.squashtest.tm.core.foundation.collection.Sorting;
import org.squashtest.tm.domain.acl.AclGroup;
import org.squashtest.tm.domain.actionword.ActionWordLibrary;
import org.squashtest.tm.domain.campaign.CampaignLibrary;
import org.squashtest.tm.domain.customreport.CustomReportLibrary;
import org.squashtest.tm.domain.project.GenericProject;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.project.ProjectPermission;
import org.squashtest.tm.domain.project.ProjectTemplate;
import org.squashtest.tm.domain.project.ProjectVisitor;
import org.squashtest.tm.domain.requirement.RequirementLibrary;
import org.squashtest.tm.domain.testcase.TestCaseLibrary;
import org.squashtest.tm.domain.tf.automationrequest.AutomationRequestLibrary;
import org.squashtest.tm.domain.users.Party;
import org.squashtest.tm.domain.users.PartyProjectPermissionsBean;
import org.squashtest.tm.domain.users.User;
import org.squashtest.tm.service.annotation.SpringDaoMetaAnnotationAspect;
import org.squashtest.tm.service.internal.project.ProjectsPermissionManagementServiceImpl$AjcClosure1;
import org.squashtest.tm.service.internal.repository.GenericProjectDao;
import org.squashtest.tm.service.internal.repository.PartyDao;
import org.squashtest.tm.service.internal.repository.ProfileDao;
import org.squashtest.tm.service.internal.repository.UserDao;
import org.squashtest.tm.service.license.LicenseHelperService;
import org.squashtest.tm.service.project.ProjectsPermissionManagementService;
import org.squashtest.tm.service.security.acls.model.ObjectAclService;

@Service(value="squashtest.tm.service.ProjectsPermissionManagementService")
@Transactional
public class ProjectsPermissionManagementServiceImpl
implements ProjectsPermissionManagementService {
    private static final String NAMESPACE = "squashtest.acl.group.tm";
    private static final List<String> PROJECT_CLASS_NAMES;
    @Inject
    private ObjectAclService aclService;
    @Inject
    private GenericProjectDao genericProjectFinder;
    @Inject
    private UserDao userDao;
    @Inject
    private PartyDao partyDao;
    @Inject
    private LicenseHelperService licenseHelperService;
    @Inject
    private ProfileDao profileDao;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    static {
        ProjectsPermissionManagementServiceImpl.ajc$preClinit();
        PROJECT_CLASS_NAMES = new ArrayList<String>(Arrays.asList("org.squashtest.tm.domain.project.Project", "org.squashtest.tm.domain.project.ProjectTemplate"));
    }

    @Override
    @Transactional(readOnly=true)
    public List<AclGroup> findAllPossiblePermission() {
        return this.aclService.findAllPermissionGroupsByNamespace(NAMESPACE);
    }

    @Override
    public void deleteUserProjectOldPermission(String userLogin, long projectId) {
        ObjectIdentity entityRef = this.createProjectIdentity(projectId);
        User user = this.userDao.findUserByLogin(userLogin);
        this.aclService.removeAllResponsibilities(user.getId(), entityRef);
        GenericProject project = (GenericProject)this.genericProjectFinder.getReferenceById(projectId);
        ObjectIdentity rlibraryRef = this.createRequirementLibraryIdentity(project);
        this.aclService.removeAllResponsibilities(user.getId(), rlibraryRef);
        ObjectIdentity tclibraryRef = this.createTestCaseLibraryIdentity(project);
        this.aclService.removeAllResponsibilities(user.getId(), tclibraryRef);
        ObjectIdentity clibraryRef = this.createCampaignLibraryIdentity(project);
        this.aclService.removeAllResponsibilities(user.getId(), clibraryRef);
        ObjectIdentity crlibraryRef = this.createCustomReportLibraryIdentity(project);
        this.aclService.removeAllResponsibilities(user.getId(), crlibraryRef);
        ObjectIdentity arlibraryRef = this.createAutomationRequestLibraryIdentity(project);
        this.aclService.removeAllResponsibilities(user.getId(), arlibraryRef);
    }

    private ObjectIdentity createProjectIdentity(long projectId) {
        GenericProject project = (GenericProject)this.genericProjectFinder.getReferenceById(projectId);
        final Class[] projectType = new Class[1];
        project.accept(new ProjectVisitor(){

            public void visit(ProjectTemplate projectTemplate) {
                projectType[0] = ProjectTemplate.class;
            }

            public void visit(Project project) {
                projectType[0] = Project.class;
            }
        });
        return new ObjectIdentityImpl(projectType[0], (Serializable)Long.valueOf(projectId));
    }

    private ObjectIdentity createCampaignLibraryIdentity(GenericProject project) {
        return new ObjectIdentityImpl(CampaignLibrary.class, (Serializable)project.getCampaignLibrary().getId());
    }

    private ObjectIdentity createTestCaseLibraryIdentity(GenericProject project) {
        return new ObjectIdentityImpl(TestCaseLibrary.class, (Serializable)project.getTestCaseLibrary().getId());
    }

    private ObjectIdentity createRequirementLibraryIdentity(GenericProject project) {
        return new ObjectIdentityImpl(RequirementLibrary.class, (Serializable)project.getRequirementLibrary().getId());
    }

    private ObjectIdentity createCustomReportLibraryIdentity(GenericProject project) {
        return new ObjectIdentityImpl(CustomReportLibrary.class, (Serializable)project.getCustomReportLibrary().getId());
    }

    private ObjectIdentity createAutomationRequestLibraryIdentity(GenericProject project) {
        return new ObjectIdentityImpl(AutomationRequestLibrary.class, (Serializable)project.getAutomationRequestLibrary().getId());
    }

    private ObjectIdentity createActionWordLibraryIdentity(GenericProject project) {
        return new ObjectIdentityImpl(ActionWordLibrary.class, (Serializable)project.getActionWordLibrary().getId());
    }

    @Override
    @Transactional(readOnly=true)
    public List<ProjectPermission> findProjectPermissionByParty(long partyId) {
        ArrayList<ProjectPermission> newResult = new ArrayList<ProjectPermission>();
        List<Object[]> result = this.aclService.retrieveClassAclGroupFromPartyId(partyId, PROJECT_CLASS_NAMES);
        for (Object[] objects : result) {
            GenericProject project = (GenericProject)this.genericProjectFinder.getReferenceById((Long)objects[0]);
            newResult.add(new ProjectPermission(project, (AclGroup)objects[1]));
        }
        return newResult;
    }

    @Override
    @Transactional(readOnly=true)
    public List<GenericProject> findProjectWithPermissionByParty(long partyId) {
        ArrayList<GenericProject> newResult = new ArrayList<GenericProject>();
        List<Object[]> result = this.aclService.retrieveClassAclGroupFromPartyId(partyId, PROJECT_CLASS_NAMES);
        for (Object[] objects : result) {
            GenericProject project = (GenericProject)this.genericProjectFinder.getReferenceById((Long)objects[0]);
            newResult.add(project);
        }
        return newResult;
    }

    @Override
    @Transactional(readOnly=true)
    public List<ProjectPermission> findProjectPermissionByUserLogin(String userLogin) {
        ArrayList<ProjectPermission> newResult = new ArrayList<ProjectPermission>();
        Map result = this.aclService.retrieveClassAclGroupFromUserLogin(userLogin, PROJECT_CLASS_NAMES).stream().collect(Collectors.groupingBy(objects -> (Long)objects[0], Collectors.mapping(objects -> (AclGroup)objects[1], Collectors.toList())));
        this.genericProjectFinder.findAllById(result.keySet()).forEach(project -> ((List)result.get(project.getId())).forEach(aclGroup -> {
            boolean bl = newResult.add(new ProjectPermission(project, aclGroup));
        }));
        return newResult;
    }

    @Override
    @Transactional(readOnly=true)
    public PagedCollectionHolder<List<ProjectPermission>> findProjectPermissionByParty(long partyId, PagingAndSorting sorting, Filtering filtering) {
        ArrayList<ProjectPermission> newResult = new ArrayList<ProjectPermission>();
        List<Object[]> result = this.aclService.retrieveClassAclGroupFromPartyId(partyId, PROJECT_CLASS_NAMES, (Sorting)sorting, filtering);
        int total = result.size();
        for (Object[] objects : result) {
            GenericProject project = (GenericProject)this.genericProjectFinder.getReferenceById((Long)objects[0]);
            newResult.add(new ProjectPermission(project, (AclGroup)objects[1]));
        }
        return new PagingBackedPagedCollectionHolder((Paging)sorting, (long)total, newResult);
    }

    @Override
    @Transactional(readOnly=true)
    public List<GenericProject> findProjectWithoutPermissionByParty(long partyId) {
        List<Long> idList = this.aclService.findObjectWithoutPermissionByPartyId(partyId, PROJECT_CLASS_NAMES);
        if (idList == null || idList.isEmpty()) {
            return Collections.emptyList();
        }
        return this.genericProjectFinder.findAllById(idList);
    }

    @Override
    @Transactional(readOnly=true)
    public List<GenericProject> findProjectWithoutPermissionByParty(long partyId, Sort sorting) {
        List<Long> idList = this.aclService.findObjectWithoutPermissionByPartyId(partyId, PROJECT_CLASS_NAMES);
        if (idList == null || idList.isEmpty()) {
            return Collections.emptyList();
        }
        Sort sort = sorting;
        List<Long> list = idList;
        GenericProjectDao genericProjectDao = this.genericProjectFinder;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)genericProjectDao, list, (Object)sort);
        Object[] objectArray = new Object[]{this, genericProjectDao, list, sort, joinPoint};
        ProjectsPermissionManagementServiceImpl$AjcClosure1 projectsPermissionManagementServiceImpl$AjcClosure1 = new ProjectsPermissionManagementServiceImpl$AjcClosure1(objectArray);
        return (List)SpringDaoMetaAnnotationAspect.aspectOf().guardAgainstEmptyness(projectsPermissionManagementServiceImpl$AjcClosure1.linkClosureAndJoinPoint(4112));
    }

    @Override
    public void addNewPermissionToProject(long partyId, long projectId, String permission) {
        String groupQualifiedName = this.userDao.findUserGroupQualifiedName(partyId);
        if ("squashtest.authz.group.tm.InfrastructureAdmin".equals(groupQualifiedName)) {
            throw new AccessDeniedException("Access denied.");
        }
        Long profileId = this.profileDao.findByQualifiedName(permission);
        if (Objects.isNull(profileId)) {
            throw new EntityNotFoundException(String.format("%s %S %S", "The profile", permission, "does not exist."));
        }
        this.addNewPermissionToProject(partyId, projectId, (long)profileId);
    }

    @Override
    public void addNewPermissionToProject(long partyId, long projectId, long profileId) {
        this.licenseHelperService.assertLicenseAllowsToAddOrActivateUser();
        ObjectIdentity projectRef = this.createProjectIdentity(projectId);
        Party party = (Party)this.partyDao.getReferenceById(partyId);
        this.aclService.addNewResponsibility(party.getId(), projectRef, profileId);
        GenericProject project = (GenericProject)this.genericProjectFinder.getReferenceById(projectId);
        ObjectIdentity rlibraryRef = this.createRequirementLibraryIdentity(project);
        this.aclService.addNewResponsibility(party.getId(), rlibraryRef, profileId);
        ObjectIdentity tclibraryRef = this.createTestCaseLibraryIdentity(project);
        this.aclService.addNewResponsibility(party.getId(), tclibraryRef, profileId);
        ObjectIdentity clibraryRef = this.createCampaignLibraryIdentity(project);
        this.aclService.addNewResponsibility(party.getId(), clibraryRef, profileId);
        ObjectIdentity crlibraryRef = this.createCustomReportLibraryIdentity(project);
        this.aclService.addNewResponsibility(party.getId(), crlibraryRef, profileId);
        ObjectIdentity arlibraryRef = this.createAutomationRequestLibraryIdentity(project);
        this.aclService.addNewResponsibility(party.getId(), arlibraryRef, profileId);
        ObjectIdentity awlibraryRef = this.createActionWordLibraryIdentity(project);
        this.aclService.addNewResponsibility(party.getId(), awlibraryRef, profileId);
    }

    @Override
    public void addNewPermissionToProject(long userId, List<Long> projectIds, String permission) {
        projectIds.forEach(projectId -> this.addNewPermissionToProject(userId, (long)projectId, permission));
    }

    @Override
    public void addNewPermissionToProject(long userId, List<Long> projectIds, long profileId) {
        String groupQualifiedName = this.userDao.findUserGroupQualifiedName(userId);
        if ("squashtest.authz.group.tm.InfrastructureAdmin".equals(groupQualifiedName)) {
            throw new AccessDeniedException("Access denied.");
        }
        projectIds.forEach(projectId -> this.addNewPermissionToProject(userId, (long)projectId, profileId));
    }

    @Override
    public void removeProjectPermission(long partyId, long projectId) {
        ObjectIdentity projectRef = this.createProjectIdentity(projectId);
        this.aclService.removeAllResponsibilities(partyId, projectRef);
        GenericProject project = (GenericProject)this.genericProjectFinder.getReferenceById(projectId);
        ObjectIdentity rlibraryRef = this.createRequirementLibraryIdentity(project);
        this.aclService.removeAllResponsibilities(partyId, rlibraryRef);
        ObjectIdentity tclibraryRef = this.createTestCaseLibraryIdentity(project);
        this.aclService.removeAllResponsibilities(partyId, tclibraryRef);
        ObjectIdentity clibraryRef = this.createCampaignLibraryIdentity(project);
        this.aclService.removeAllResponsibilities(partyId, clibraryRef);
        ObjectIdentity crlibraryRef = this.createCustomReportLibraryIdentity(project);
        this.aclService.removeAllResponsibilities(partyId, crlibraryRef);
        ObjectIdentity arlibraryRef = this.createAutomationRequestLibraryIdentity(project);
        this.aclService.removeAllResponsibilities(partyId, arlibraryRef);
        ObjectIdentity awlibraryRef = this.createActionWordLibraryIdentity(project);
        this.aclService.removeAllResponsibilities(partyId, awlibraryRef);
    }

    @Override
    public void removeProjectPermission(long userId, List<Long> projectIds) {
        projectIds.forEach(projectId -> this.removeProjectPermission(userId, (long)projectId));
    }

    @Override
    public void removeProjectPermissionForAllProjects(long partyId) {
        this.aclService.removeAllResponsibilities(partyId);
    }

    @Override
    @Transactional(readOnly=true)
    public List<PartyProjectPermissionsBean> findPartyPermissionsBeanByProject(long projectId) {
        Class projectClass = this.genericProjectFinder.isProjectTemplate(projectId) ? ProjectTemplate.class : Project.class;
        return this.findPartyPermissionBeanByProjectOfGivenType(projectId, projectClass);
    }

    @Override
    @Transactional(readOnly=true)
    public PagedCollectionHolder<List<PartyProjectPermissionsBean>> findPartyPermissionsBeanByProject(PagingAndSorting sorting, Filtering filtering, long projectId) {
        Class projectClass = this.genericProjectFinder.isProjectTemplate(projectId) ? ProjectTemplate.class : Project.class;
        return this.findPartyPermissionBeanByProjectOfGivenType(projectId, projectClass, sorting, filtering);
    }

    @Override
    @Transactional(readOnly=true)
    public List<Party> findPartyWithoutPermissionByProject(long projectId) {
        List<Long> idList = this.aclService.findPartiesWithoutPermissionByObject(projectId, PROJECT_CLASS_NAMES);
        return this.partyDao.findAllById(idList);
    }

    private List<PartyProjectPermissionsBean> findPartyPermissionsBeanByProjectTemplate(long genericProjectId, Class<?> genericClass) {
        return this.findPartyPermissionBeanByProjectOfGivenType(genericProjectId, genericClass);
    }

    private List<PartyProjectPermissionsBean> findPartyPermissionBeanByProjectOfGivenType(long genericProjectId, Class<?> projectType) {
        ArrayList<PartyProjectPermissionsBean> newResult = new ArrayList<PartyProjectPermissionsBean>();
        List<Object[]> result = this.aclService.retrievePartyAndAclGroupNameFromIdentityAndClass(genericProjectId, projectType);
        for (Object[] objects : result) {
            Party party = (Party)this.partyDao.getReferenceById((Long)objects[0]);
            newResult.add(new PartyProjectPermissionsBean(party, (AclGroup)objects[1]));
        }
        return newResult;
    }

    private PagedCollectionHolder<List<PartyProjectPermissionsBean>> findPartyPermissionBeanByProjectOfGivenType(long projectId, Class<?> projectType, PagingAndSorting sorting, Filtering filtering) {
        List<Object[]> result = this.aclService.retrievePartyAndAclGroupNameFromIdentityAndClass(projectId, projectType, (Sorting)sorting, filtering);
        int total = result.size();
        int startIndex = sorting.getFirstItemIndex();
        int lastIndex = Math.min(startIndex + sorting.getPageSize(), total);
        result = result.subList(startIndex, lastIndex);
        ArrayList<PartyProjectPermissionsBean> newResult = new ArrayList<PartyProjectPermissionsBean>(result.size());
        for (Object[] objects : result) {
            Party party = (Party)this.partyDao.getReferenceById((Long)objects[0]);
            newResult.add(new PartyProjectPermissionsBean(party, (AclGroup)objects[1]));
        }
        return new PagingBackedPagedCollectionHolder((Paging)sorting, (long)total, newResult);
    }

    @Override
    public void copyAssignedUsersFromProjectToTemplate(ProjectTemplate template, long projectId) {
        List<PartyProjectPermissionsBean> projectPartyPermissions = this.findPartyPermissionsBeanByProjectTemplate(projectId, Project.class);
        this.addPermissionsToProject(projectPartyPermissions, (GenericProject)template);
    }

    @Override
    public void copyAssignedUsers(GenericProject target, GenericProject source) {
        long sourceId = source.getId();
        this.copyAssignedUsers(target, sourceId);
    }

    @Override
    public void removeAllPermissionsFromProject(long projectId) {
        ObjectIdentityImpl projectRef = new ObjectIdentityImpl(Project.class, (Serializable)Long.valueOf(projectId));
        this.aclService.removeAllResponsibilities((ObjectIdentity)projectRef);
    }

    @Override
    public void removeAllPermissionsFromObject(Class<?> clazz, long id) {
        ObjectIdentityImpl ref = new ObjectIdentityImpl(clazz, (Serializable)Long.valueOf(id));
        this.aclService.removeAllResponsibilities((ObjectIdentity)ref);
    }

    @Override
    public boolean isInPermissionGroup(String userLogin, Long projectId, String permissionGroup) {
        User user = this.userDao.findUserByLogin(userLogin);
        return this.isInPermissionGroup(user.getId(), projectId, permissionGroup);
    }

    @Override
    @Transactional(readOnly=true)
    public boolean isInPermissionGroup(long partyId, Long projectId, String permissionGroup) {
        boolean isInGroup = false;
        List<PartyProjectPermissionsBean> permissions = this.findPartyPermissionsBeanByProject(projectId);
        for (PartyProjectPermissionsBean permission : permissions) {
            if (permission.getParty().getId() != partyId || !permission.getPermissionGroup().getQualifiedName().equals(permissionGroup)) continue;
            isInGroup = true;
        }
        return isInGroup;
    }

    private void copyAssignedUsers(GenericProject targetProject, long sourceId) {
        List<PartyProjectPermissionsBean> templatePartyPermissions = this.findPartyPermissionsBeanByProject(sourceId);
        this.addPermissionsToProject(templatePartyPermissions, targetProject);
    }

    private void addPermissionsToProject(List<PartyProjectPermissionsBean> partyPermissions, GenericProject genericProject) {
        for (PartyProjectPermissionsBean partyPermission : partyPermissions) {
            long userId = partyPermission.getParty().getId();
            String groupQualifiedName = this.userDao.findUserGroupQualifiedName(userId);
            if ("squashtest.authz.group.tm.InfrastructureAdmin".equals(groupQualifiedName)) {
                throw new AccessDeniedException("Access denied.");
            }
            long projectId = genericProject.getId();
            long profileId = partyPermission.getPermissionGroup().getId();
            this.addNewPermissionToProject(userId, projectId, profileId);
        }
    }

    static final /* synthetic */ List findAllByIdIn_aroundBody0(ProjectsPermissionManagementServiceImpl projectsPermissionManagementServiceImpl, GenericProjectDao genericProjectDao, List list, Sort sort, JoinPoint joinPoint) {
        return genericProjectDao.findAllByIdIn(list, sort);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ProjectsPermissionManagementServiceImpl.java", ProjectsPermissionManagementServiceImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("41000401", "findAllByIdIn", "org.squashtest.tm.service.internal.repository.GenericProjectDao", "java.util.List:org.springframework.data.domain.Sort", "idList:sorting", "", "java.util.List"), 253);
    }
}

