/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.pivot.projectimporter.pivotimporter;

import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.zip.ZipFile;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Service;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.campaign.CampaignLibrary;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.domain.customfield.CustomFieldBinding;
import org.squashtest.tm.domain.infolist.InfoList;
import org.squashtest.tm.domain.infolist.InfoListProjectBindingType;
import org.squashtest.tm.domain.milestone.Milestone;
import org.squashtest.tm.domain.project.GenericProject;
import org.squashtest.tm.domain.projectimporter.PivotFormatImport;
import org.squashtest.tm.domain.requirement.RequirementLibrary;
import org.squashtest.tm.domain.testcase.TestCaseLibrary;
import org.squashtest.tm.exception.pivot.projectimporter.pivotimporter.CouldNotBindEntityDuringImportException;
import org.squashtest.tm.exception.pivot.projectimporter.pivotimporter.CouldNotImportFileException;
import org.squashtest.tm.service.customfield.CustomFieldBindingFinderService;
import org.squashtest.tm.service.customfield.CustomFieldBindingModificationService;
import org.squashtest.tm.service.feature.FeatureManager;
import org.squashtest.tm.service.infolist.InfoListBindingManagerService;
import org.squashtest.tm.service.internal.dto.pivotdefinition.LibraryPivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.ProjectPivot;
import org.squashtest.tm.service.internal.dto.projectimporter.AttachmentPivotHolder;
import org.squashtest.tm.service.internal.dto.projectimporter.ImportWarningEntry;
import org.squashtest.tm.service.internal.dto.projectimporter.JsonImportFile;
import org.squashtest.tm.service.internal.dto.projectimporter.PivotImportMetadata;
import org.squashtest.tm.service.internal.dto.projectimporter.ProjectIdsReferences;
import org.squashtest.tm.service.internal.pivot.projectimporter.pivotimporter.AbstractPivotImport;
import org.squashtest.tm.service.internal.pivot.projectimporter.pivotimporter.PivotImportStrategy;
import org.squashtest.tm.service.internal.repository.GenericProjectDao;
import org.squashtest.tm.service.internal.repository.InfoListDao;
import org.squashtest.tm.service.internal.repository.MilestoneDao;
import org.squashtest.tm.service.internal.utils.HTMLCleanupUtils;
import org.squashtest.tm.service.milestone.MilestoneBindingManagerService;
import org.squashtest.tm.service.pivot.projectimporter.pivotimporter.AttachmentPivotImportService;
import org.squashtest.tm.service.pivot.projectimporter.pivotimporter.ProjectPivotImporterService;

@Service
public class ProjectPivotImporterServiceImpl
extends AbstractPivotImport
implements ProjectPivotImporterService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProjectPivotImporterServiceImpl.class);
    private final AttachmentPivotImportService attachmentPivotImportService;
    private final CustomFieldBindingFinderService customFieldBindingFinderService;
    private final CustomFieldBindingModificationService customFieldBindingModificationService;
    private final InfoListBindingManagerService infoListBindingManagerService;
    private final InfoListDao infoListDao;
    private final FeatureManager featureManager;
    private final MilestoneDao milestoneDao;
    private final MilestoneBindingManagerService milestoneBindingManagerService;
    private final GenericProjectDao genericProjectDao;
    private final MessageSource messageSource;
    @PersistenceContext
    private EntityManager entityManager;

    public ProjectPivotImporterServiceImpl(AttachmentPivotImportService attachmentPivotImportService, CustomFieldBindingFinderService customFieldBindingFinderService, CustomFieldBindingModificationService customFieldBindingModificationService, InfoListBindingManagerService infoListBindingManagerService, InfoListDao infoListDao, FeatureManager featureManager, MilestoneDao milestoneDao, MilestoneBindingManagerService milestoneBindingManagerService, GenericProjectDao genericProjectDao, MessageSource messageSource) {
        super(LOGGER);
        this.attachmentPivotImportService = attachmentPivotImportService;
        this.customFieldBindingFinderService = customFieldBindingFinderService;
        this.customFieldBindingModificationService = customFieldBindingModificationService;
        this.infoListBindingManagerService = infoListBindingManagerService;
        this.infoListDao = infoListDao;
        this.featureManager = featureManager;
        this.milestoneDao = milestoneDao;
        this.milestoneBindingManagerService = milestoneBindingManagerService;
        this.genericProjectDao = genericProjectDao;
        this.messageSource = messageSource;
    }

    @Override
    public <I extends InputStream> ProjectPivot getProjectPivotFromZis(I is) {
        ArrayList projectPivots = new ArrayList();
        this.parseEntities(is, JsonImportFile.PROJECTS, JsonImportFile.PROJECTS.getJsonFieldKind(), ProjectPivot.class, projectPivots::add);
        if (projectPivots.size() != 1) {
            throw new CouldNotImportFileException("\"%s\" should contain exactly one project definition, but found %s".formatted(JsonImportFile.PROJECTS.getFileName(), projectPivots.size()));
        }
        return (ProjectPivot)projectPivots.getFirst();
    }

    @Override
    public void importProjectInformationFromZipArchive(ZipFile zipFile, ProjectIdsReferences projectIdsReferences, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) {
        PivotImportStrategy<ProjectPivot> projectPivotImporterStrategy = this.getProjectPivotImporterStrategy(projectIdsReferences, pivotImportMetadata, pivotFormatImport);
        this.importEntitiesFromZipArchive(zipFile, JsonImportFile.PROJECTS, pivotFormatImport, pivotImportMetadata, "projects", "project", projectPivotImporterStrategy);
    }

    private PivotImportStrategy<ProjectPivot> getProjectPivotImporterStrategy(final ProjectIdsReferences projectIdsReferences, final PivotImportMetadata pivotImportMetadata, final PivotFormatImport pivotFormatImport) {
        return new PivotImportStrategy<ProjectPivot>(){

            @Override
            public Class<ProjectPivot> getPivotClazz() {
                return ProjectPivot.class;
            }

            @Override
            public void create(List<ProjectPivot> entities) {
                ProjectPivotImporterServiceImpl.this.updateProject(entities, projectIdsReferences, pivotImportMetadata, pivotFormatImport);
            }
        };
    }

    private void updateProject(List<ProjectPivot> entities, ProjectIdsReferences projectIdsReferences, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) {
        if (entities.size() != 1) {
            throw new CouldNotImportFileException("\"%s\" should contain exactly one project definition, but found %s".formatted(JsonImportFile.PROJECTS.getFileName(), entities.size()));
        }
        GenericProject genericProject = this.genericProjectDao.getGenericProjectWithInfoListById(projectIdsReferences.getId());
        ProjectPivot projectPivot = entities.getFirst();
        this.checkProjectName(projectPivot, genericProject, pivotImportMetadata);
        this.checkProjectLabel(projectPivot, genericProject, pivotImportMetadata);
        this.updateDescription(projectPivot, genericProject, pivotImportMetadata);
        if (pivotImportMetadata.getPivotOptions().isImportInfoList()) {
            this.updateInfoListBinding(projectPivot, genericProject, pivotFormatImport, pivotImportMetadata);
        }
        this.updateCustomFieldBinding(projectPivot, genericProject, pivotFormatImport, pivotImportMetadata);
        this.handleAttachmentRichText(projectPivot, genericProject, pivotFormatImport, pivotImportMetadata);
        this.handleMilestoneBinding(projectPivot, genericProject, pivotFormatImport, pivotImportMetadata);
        this.entityManager.flush();
        this.entityManager.clear();
    }

    private void checkProjectName(ProjectPivot projectPivot, GenericProject project, PivotImportMetadata pivotImportMetadata) {
        if (!Objects.equals(projectPivot.getName(), project.getName())) {
            pivotImportMetadata.addImportWarningEntry(ImportWarningEntry.projectNameChanged(projectPivot.getName(), project.getName()));
        }
    }

    private void checkProjectLabel(ProjectPivot projectPivot, GenericProject project, PivotImportMetadata pivotImportMetadata) {
        if (StringUtils.isBlank((CharSequence)project.getLabel())) {
            Optional.ofNullable(projectPivot.getLabel()).ifPresent(arg_0 -> ((GenericProject)project).setLabel(arg_0));
            return;
        }
        if (!Objects.equals(projectPivot.getLabel(), project.getLabel())) {
            pivotImportMetadata.addImportWarningEntry(ImportWarningEntry.projectLabelChanged(projectPivot.getLabel(), project.getLabel()));
        }
    }

    private void updateDescription(ProjectPivot projectPivot, GenericProject project, PivotImportMetadata pivotImportMetadata) {
        if (Objects.equals(projectPivot.getDescription(), project.getDescription()) || StringUtils.isBlank((CharSequence)projectPivot.getDescription())) {
            return;
        }
        String newDescription = this.mergeDescription(project.getDescription(), projectPivot.getDescription(), pivotImportMetadata.getLocale());
        project.setDescription(newDescription);
    }

    private String mergeDescription(String projectDescription, String pivotDescription, Locale locale) {
        Document document = Jsoup.parse((String)"");
        Element body = document.body();
        Document projectDocument = this.cleanDescription(projectDescription);
        Document pivotDocument = this.cleanDescription(pivotDescription);
        this.addTimestamp(body, locale);
        this.addContentSection(body, pivotDocument);
        if (!projectDocument.body().text().isBlank()) {
            this.addSeparator(body);
            this.addContentSection(body, projectDocument);
        }
        return document.body().html();
    }

    private void addSeparator(Element body) {
        body.appendElement("p").text("\u2014\u2014\u2014\u2014\u2014\u2014\u2014 || \u2014\u2014\u2014\u2014\u2014\u2014\u2014");
    }

    private void addTimestamp(Element body, Locale locale) {
        String label = this.messageSource.getMessage("project.description.import.timestamp.label", null, locale);
        String dateFormatPattern = "en".equals(locale.getLanguage()) ? "MM/dd/yyyy HH:mm" : "dd/MM/yyyy HH:mm";
        String formattedDate = new SimpleDateFormat(dateFormatPattern).format(new Date());
        body.appendElement("p").text("%s : %s".formatted(label, formattedDate));
    }

    private void addContentSection(Element body, Document htmlContent) {
        htmlContent.body().children().forEach(element2 -> {
            Element element3 = body.appendChild((Node)element2.clone());
        });
    }

    private Document cleanDescription(String description) {
        Node node;
        String cleanDescription = HTMLCleanupUtils.cleanHtml(description);
        Document document = Jsoup.parse((String)cleanDescription);
        List childNodes = document.body().childNodes();
        if (childNodes.size() == 1 && (node = (Node)childNodes.getFirst()) instanceof TextNode) {
            TextNode textNode = (TextNode)node;
            String text = textNode.text();
            document.body().empty();
            document.body().appendElement("p").text(text);
        }
        return document;
    }

    private void updateInfoListBinding(ProjectPivot projectPivot, GenericProject project, PivotFormatImport pivotFormatImport, PivotImportMetadata pivotImportMetadata) {
        Map<InfoListProjectBindingType, InfoList> systemInfoListByBindingType = this.infoListDao.findAllInfoListSystem().stream().collect(Collectors.toMap(infoList -> InfoListProjectBindingType.fromSystemInfoListCode((String)infoList.getCode()), infoList -> infoList));
        projectPivot.getBoundInfoLists().forEach((bindingType, infoListPivotId) -> {
            Long infoListId;
            if (pivotImportMetadata.getInfoListIdsMap().containsKey(infoListPivotId)) {
                infoListId = pivotImportMetadata.getInfoListIdsMap().get(infoListPivotId);
            } else if (systemInfoListByBindingType.containsKey(bindingType)) {
                infoListId = ((InfoList)systemInfoListByBindingType.get(bindingType)).getId();
            } else {
                throw new CouldNotBindEntityDuringImportException("Import Id: %s - Project id: %s - Could not find info list with pivot ID %s for binding type %s".formatted(pivotFormatImport.getId(), project.getId(), infoListPivotId, bindingType));
            }
            if (!this.getCurrentBindingInfoListId((InfoListProjectBindingType)bindingType, project).equals(infoListId)) {
                this.addInfoListBinding((InfoListProjectBindingType)bindingType, infoListId, project.getId(), pivotFormatImport);
            }
        });
    }

    private void addInfoListBinding(InfoListProjectBindingType bindingType, Long infoListId, Long projectId, PivotFormatImport pivotFormatImport) {
        try {
            switch (bindingType) {
                case REQUIREMENT_CATEGORY: {
                    this.infoListBindingManagerService.bindListToProjectReqCategory(infoListId, projectId);
                    break;
                }
                case TEST_CASE_NATURE: {
                    this.infoListBindingManagerService.bindListToProjectTcNature(infoListId, projectId);
                    break;
                }
                case TEST_CASE_TYPE: {
                    this.infoListBindingManagerService.bindListToProjectTcType(infoListId, projectId);
                }
            }
        }
        catch (Exception e) {
            String message = String.format("Import Id: %s - Project id: %s - Failed to add info list binding \"%s\"", pivotFormatImport.getId(), projectId, bindingType);
            LOGGER.error(message, new Object[0]);
            throw new CouldNotBindEntityDuringImportException(message, (Throwable)e);
        }
    }

    private Long getCurrentBindingInfoListId(InfoListProjectBindingType bindingType, GenericProject project) {
        return switch (bindingType) {
            case InfoListProjectBindingType.REQUIREMENT_CATEGORY -> project.getRequirementCategories().getId();
            case InfoListProjectBindingType.TEST_CASE_NATURE -> project.getTestCaseNatures().getId();
            case InfoListProjectBindingType.TEST_CASE_TYPE -> project.getTestCaseTypes().getId();
            default -> throw new MatchException(null, null);
        };
    }

    private void updateCustomFieldBinding(ProjectPivot projectPivot, GenericProject project, PivotFormatImport pivotFormatImport, PivotImportMetadata pivotImportMetadata) {
        List<CustomFieldBinding> existingBindings = this.customFieldBindingFinderService.findCustomFieldsForGenericProject(project.getId());
        projectPivot.getBoundCufs().forEach((cufPivotId, boundEntities) -> {
            if (!pivotImportMetadata.getCustomFieldIdsMap().containsKey(cufPivotId)) {
                throw new CouldNotBindEntityDuringImportException("Import Id: %s - Project id: %s - Custom field with pivot ID %s not found in the import.".formatted(pivotFormatImport.getId(), project.getId(), cufPivotId));
            }
            Long customFieldId = pivotImportMetadata.getCustomFieldIdsMap().get(cufPivotId).id();
            boundEntities.forEach(boundEntity -> this.addCustomFieldBinding(customFieldId, (BindableEntity)boundEntity, existingBindings, project, pivotFormatImport));
        });
    }

    private void addCustomFieldBinding(Long customFieldId, BindableEntity boundEntity, List<CustomFieldBinding> existingBindings, GenericProject project, PivotFormatImport pivotFormatImport) {
        try {
            if (this.isCustomFieldBindingExists(existingBindings, customFieldId, boundEntity)) {
                LOGGER.info("Import Id: {} - Project id: {} - Custom field binding already exists for entity {}", new Object[]{pivotFormatImport.getId(), project.getId(), boundEntity});
            } else {
                this.customFieldBindingModificationService.addNewCustomFieldBindingUnsecured(project.getId(), boundEntity, customFieldId);
            }
        }
        catch (Exception e) {
            String message = String.format("Import Id: %s - Project id: %s - Failed to add custom field binding for entity %s", pivotFormatImport.getId(), project.getId(), boundEntity);
            LOGGER.error(message, new Object[0]);
            throw new CouldNotBindEntityDuringImportException(message, (Throwable)e);
        }
    }

    private boolean isCustomFieldBindingExists(List<CustomFieldBinding> existingBindings, Long customFieldId, BindableEntity boundEntity) {
        return existingBindings.stream().anyMatch(binding -> binding.getCustomField().getId().equals(customFieldId) && binding.getBoundEntity().equals((Object)boundEntity));
    }

    private void handleAttachmentRichText(ProjectPivot projectPivot, GenericProject project, PivotFormatImport pivotFormatImport, PivotImportMetadata pivotImportMetadata) {
        Map<Long, Long> attachmentsConversion = this.attachmentPivotImportService.addAttachmentsToEntity(new AttachmentPivotHolder<GenericProject, ProjectPivot>(projectPivot, project), pivotImportMetadata, pivotFormatImport);
        String description = project.getDescription();
        project.setDescription(this.attachmentPivotImportService.updateRichText(description, project.getAttachmentList(), attachmentsConversion, pivotImportMetadata));
        this.attachmentPivotImportService.addAttachmentsToEntity(new AttachmentPivotHolder<RequirementLibrary, LibraryPivot>(projectPivot.getRequirementLibrary(), project.getRequirementLibrary()), pivotImportMetadata, pivotFormatImport);
        this.attachmentPivotImportService.addAttachmentsToEntity(new AttachmentPivotHolder<TestCaseLibrary, LibraryPivot>(projectPivot.getTestCaseLibrary(), project.getTestCaseLibrary()), pivotImportMetadata, pivotFormatImport);
        this.attachmentPivotImportService.addAttachmentsToEntity(new AttachmentPivotHolder<CampaignLibrary, LibraryPivot>(projectPivot.getCampaignLibrary(), project.getCampaignLibrary()), pivotImportMetadata, pivotFormatImport);
    }

    private void handleMilestoneBinding(ProjectPivot projectPivot, GenericProject project, PivotFormatImport pivotFormatImport, PivotImportMetadata pivotImportMetadata) {
        if (!this.featureManager.isEnabled(FeatureManager.Feature.MILESTONE)) {
            return;
        }
        List milestones = this.milestoneDao.findAllById(this.getMilestoneIdsFromProjectPivot(projectPivot, project, pivotFormatImport, pivotImportMetadata));
        List<Milestone> existingMilestones = this.milestoneBindingManagerService.getAllBindedMilestoneForProject(project.getId());
        milestones.forEach(milestone -> this.addMilestoneBinding((Milestone)milestone, existingMilestones, project, pivotFormatImport));
    }

    private List<Long> getMilestoneIdsFromProjectPivot(ProjectPivot projectPivot, GenericProject project, PivotFormatImport pivotFormatImport, PivotImportMetadata pivotImportMetadata) {
        return projectPivot.getMilestones().stream().map(milestonePivotId -> {
            if (pivotImportMetadata.getMilestoneIdsMap().containsKey(milestonePivotId)) {
                return pivotImportMetadata.getMilestoneIdsMap().get(milestonePivotId);
            }
            throw new CouldNotBindEntityDuringImportException("Import Id: %s - Project id: %s - Milestone with pivot ID %s not found in the import.".formatted(pivotFormatImport.getId(), project.getId(), milestonePivotId));
        }).filter(Objects::nonNull).toList();
    }

    private void addMilestoneBinding(Milestone milestone, List<Milestone> existingMilestones, GenericProject project, PivotFormatImport pivotFormatImport) {
        try {
            if (this.isMilestoneBindingExists(existingMilestones, milestone.getId())) {
                LOGGER.info("Import Id: {} - Project id: {} - Milestone binding with id {} already exists", new Object[]{pivotFormatImport.getId(), project.getId(), milestone.getId()});
            } else {
                this.milestoneBindingManagerService.bindMilestonesToProject(Collections.singletonList(milestone), project, false);
            }
        }
        catch (Exception e) {
            String message = String.format("Import Id: %s - Project id: %s - Failed to add milestone binding with id %s", pivotFormatImport.getId(), project.getId(), milestone.getId());
            LOGGER.error(message, new Object[0]);
            throw new CouldNotBindEntityDuringImportException(message, (Throwable)e);
        }
    }

    private boolean isMilestoneBindingExists(List<Milestone> existingMilestones, Long milestoneId) {
        return existingMilestones.stream().anyMatch(binding -> binding.getId().equals(milestoneId));
    }
}

