/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.pivot.converters;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jooq.Field;
import org.jooq.Record;
import org.springframework.stereotype.Service;
import org.squashtest.tm.domain.attachment.Attachment;
import org.squashtest.tm.domain.attachment.AttachmentEntity;
import org.squashtest.tm.domain.attachment.AttachmentHolder;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.domain.customfield.CustomField;
import org.squashtest.tm.domain.customfield.RawValue;
import org.squashtest.tm.domain.infolist.InfoList;
import org.squashtest.tm.domain.infolist.InfoListItem;
import org.squashtest.tm.domain.infolist.InfoListProjectBindingType;
import org.squashtest.tm.domain.infolist.UserListItem;
import org.squashtest.tm.domain.milestone.Milestone;
import org.squashtest.tm.domain.milestone.MilestoneRange;
import org.squashtest.tm.domain.milestone.MilestoneStatus;
import org.squashtest.tm.domain.requirement.RequirementVersionLinkType;
import org.squashtest.tm.exception.pivot.projectexporter.ExportPivotException;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.attachment.AttachmentRepository;
import org.squashtest.tm.service.internal.dto.CustomFieldFormModel;
import org.squashtest.tm.service.internal.dto.pivotdefinition.AttachmentPivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.CustomFieldPivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.CustomFieldValuePivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.InfoListItemPivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.InfoListPivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.LibraryPivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.MilestonePivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.PivotBoundEntity;
import org.squashtest.tm.service.internal.dto.pivotdefinition.ProjectPivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.RequirementLinkTypePivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.ServersPivot;
import org.squashtest.tm.service.internal.dto.projectimporter.PivotImportMetadata;
import org.squashtest.tm.service.internal.dto.projectimporter.SquashCustomFieldInfo;
import org.squashtest.tm.service.pivot.converters.AdminPivotConverterService;
import org.squashtest.tm.service.pivot.projectexporter.dao.CustomFieldPivotDao;
import org.squashtest.tm.service.pivot.projectimporter.pivotimporter.AttachmentPivotImportService;

@Service
public class AdminPivotConverterServiceImpl
implements AdminPivotConverterService {
    private final AttachmentPivotImportService attachmentPivotImportService;
    private final AttachmentRepository attachmentRepository;

    public AdminPivotConverterServiceImpl(AttachmentPivotImportService attachmentPivotImportService, AttachmentRepository attachmentRepository) {
        this.attachmentPivotImportService = attachmentPivotImportService;
        this.attachmentRepository = attachmentRepository;
    }

    @Override
    public CustomField pivotToCustomField(CustomFieldPivot customFieldPivot) {
        CustomFieldFormModel cufFormModel = new CustomFieldFormModel();
        cufFormModel.setInputType(customFieldPivot.getInputType());
        cufFormModel.setName(customFieldPivot.getName());
        cufFormModel.setLabel(customFieldPivot.getLabel());
        cufFormModel.setCode(customFieldPivot.getCode());
        cufFormModel.setDefaultValue(Objects.requireNonNullElse(customFieldPivot.getDefaultValue(), ""));
        cufFormModel.setOptional(customFieldPivot.isOptional());
        cufFormModel.setOptions(AdminPivotConverterServiceImpl.convertCufOptionsToListOfArrays(customFieldPivot.getOptions()));
        return cufFormModel.getCustomField();
    }

    @Override
    public <E extends AttachmentHolder, P extends PivotBoundEntity> Map<Long, RawValue> pivotToCustomFieldValues(P entityPivot, E entity, Map<Long, Long> attachmentsConversion, PivotImportMetadata pivotImportMetadata) {
        HashMap<Long, RawValue> customFieldsValues = new HashMap<Long, RawValue>();
        entityPivot.getCustomFields().forEach(customFieldValuePivot -> {
            SquashCustomFieldInfo customFieldInfo = pivotImportMetadata.getCustomFieldIdsMap().get(customFieldValuePivot.getCustomFieldId());
            String value = customFieldValuePivot.getValue();
            switch (customFieldInfo.inputType()) {
                case TAG: {
                    ArrayList tagValues = Objects.nonNull(value) ? Arrays.stream(value.split("\\|")).toList() : new ArrayList();
                    customFieldsValues.put(customFieldInfo.id(), new RawValue(tagValues));
                    break;
                }
                case RICH_TEXT: {
                    String updatedRichText = this.attachmentPivotImportService.updateRichText(value, entity.getAttachmentList(), attachmentsConversion, pivotImportMetadata);
                    customFieldsValues.put(customFieldInfo.id(), new RawValue(updatedRichText));
                    break;
                }
                default: {
                    customFieldsValues.put(customFieldInfo.id(), new RawValue(value));
                }
            }
        });
        return customFieldsValues;
    }

    private static String[][] convertCufOptionsToListOfArrays(List<CustomFieldPivot.Option> options) {
        String[][] result = new String[options.size()][3];
        int i = 0;
        while (i < options.size()) {
            CustomFieldPivot.Option option = options.get(i);
            result[i][0] = option.getName();
            result[i][1] = option.getCode();
            result[i][2] = option.getColor();
            ++i;
        }
        return result;
    }

    @Override
    public CustomFieldValuePivot customFieldValueRecordToCustomFieldValuePivot(Record record) {
        CustomFieldValuePivot customFieldValuePivot = new CustomFieldValuePivot();
        customFieldValuePivot.setPivotId((Long)record.get(CustomFieldPivotDao.CFV_TABLE_CF_VALUE_ID));
        customFieldValuePivot.setCustomFieldId((Long)record.get(CustomFieldPivotDao.CFV_TABLE_CF_ID));
        customFieldValuePivot.setValue((String)record.get(CustomFieldPivotDao.CFV_TABLE_CF_VALUE));
        customFieldValuePivot.setBindableEntity(BindableEntity.valueOf((String)((String)record.get(CustomFieldPivotDao.CFV_TABLE_BOUND_ENTITY_TYPE))));
        customFieldValuePivot.setBindableId((Long)record.get(CustomFieldPivotDao.CFV_TABLE_BOUND_ENTITY_ID));
        return customFieldValuePivot;
    }

    @Override
    public InfoList pivotToInfoList(InfoListPivot infoListPivot) {
        InfoList infoList = new InfoList();
        Optional.ofNullable(infoListPivot.getLabel()).ifPresent(arg_0 -> ((InfoList)infoList).setLabel(arg_0));
        infoList.setCode(infoListPivot.getCode());
        infoList.setDescription(infoListPivot.getDescription());
        infoList.setCreatedBy(infoListPivot.getCreatedBy());
        infoList.setCreatedOn(infoListPivot.getCreatedOn());
        infoListPivot.getInfoListItems().forEach(infoListItemPivot -> {
            UserListItem infoListItem = new UserListItem();
            Optional.ofNullable(infoListItemPivot.getLabel()).ifPresent(arg_0 -> ((InfoListItem)infoListItem).setLabel(arg_0));
            Optional.ofNullable(infoListItemPivot.getCode()).ifPresent(arg_0 -> ((InfoListItem)infoListItem).setCode(arg_0));
            infoListItem.setColour(infoListItemPivot.getColor());
            Optional.ofNullable(infoListItemPivot.getIconName()).ifPresent(arg_0 -> ((InfoListItem)infoListItem).setIconName(arg_0));
            infoListItem.setDefault(infoListItemPivot.isDefaultValue());
            infoList.addItem((InfoListItem)infoListItem);
        });
        return infoList;
    }

    @Override
    public Milestone pivotToMilestone(MilestonePivot milestonePivot, PivotImportMetadata pivotImportMetadata) {
        Milestone milestone = new Milestone();
        milestone.setLabel(milestonePivot.getLabel());
        milestone.setDescription(milestonePivot.getDescription());
        milestone.setStatus(milestonePivot.getStatus());
        milestone.setEndDate(milestonePivot.getDueDate());
        if (Objects.nonNull(milestonePivot.getRange()) && MilestoneRange.GLOBAL.equals((Object)milestonePivot.getRange())) {
            if (pivotImportMetadata.isAdmin()) {
                milestone.setRange(MilestoneRange.GLOBAL);
            } else {
                milestone.setRange(MilestoneRange.RESTRICTED);
            }
        } else {
            milestone.setRange(MilestoneRange.RESTRICTED);
        }
        return milestone;
    }

    @Override
    public RequirementVersionLinkType pivotToRequirementVersionLinkType(RequirementLinkTypePivot requirementLinkTypePivot) {
        RequirementVersionLinkType requirementVersionLinkType = new RequirementVersionLinkType();
        requirementVersionLinkType.setRole1(requirementLinkTypePivot.getRole1());
        requirementVersionLinkType.setRole2(requirementLinkTypePivot.getRole2());
        requirementVersionLinkType.setRole1Code(requirementLinkTypePivot.getRoleCode1());
        requirementVersionLinkType.setRole2Code(requirementLinkTypePivot.getRoleCode2());
        return requirementVersionLinkType;
    }

    @Override
    public AttachmentPivot attachmentToPivotAttachment(Attachment attachment, Long oldAttachmentId, Long oldContentId) {
        AttachmentPivot attachmentPivot = new AttachmentPivot();
        attachmentPivot.setPivotId(oldAttachmentId);
        attachmentPivot.setOriginalFileName(attachment.getName());
        attachmentPivot.setContentId(oldContentId);
        attachmentPivot.setAddedOn(attachment.getAddedOn());
        attachmentPivot.setLastModifiedOn(attachment.getLastModifiedOn());
        return attachmentPivot;
    }

    @Override
    public InfoListPivot recordToInfoListPivot(Record record) {
        InfoListPivot infoListPivot = new InfoListPivot();
        infoListPivot.setPivotId((Long)record.get((Field)Tables.INFO_LIST.INFO_LIST_ID));
        infoListPivot.setLabel((String)record.get((Field)Tables.INFO_LIST.LABEL));
        infoListPivot.setDescription((String)record.get((Field)Tables.INFO_LIST.DESCRIPTION));
        infoListPivot.setCode((String)record.get((Field)Tables.INFO_LIST.CODE));
        infoListPivot.setCreatedBy((String)record.get((Field)Tables.INFO_LIST.CREATED_BY));
        infoListPivot.setCreatedOn((Date)record.get((Field)Tables.INFO_LIST.CREATED_ON));
        infoListPivot.setLastModifiedBy((String)record.get((Field)Tables.INFO_LIST.LAST_MODIFIED_BY));
        infoListPivot.setLastModifiedOn((Date)record.get((Field)Tables.INFO_LIST.LAST_MODIFIED_ON));
        return infoListPivot;
    }

    @Override
    public InfoListItemPivot recordToInfoListItemPivot(Record record) {
        InfoListItemPivot infoListItemPivot = new InfoListItemPivot();
        infoListItemPivot.setPivotId((Long)record.get((Field)Tables.INFO_LIST_ITEM.ITEM_ID));
        infoListItemPivot.setLabel((String)record.get((Field)Tables.INFO_LIST_ITEM.LABEL));
        infoListItemPivot.setCode((String)record.get((Field)Tables.INFO_LIST_ITEM.CODE));
        infoListItemPivot.setColor((String)record.get((Field)Tables.INFO_LIST_ITEM.COLOUR));
        infoListItemPivot.setIconName((String)record.get((Field)Tables.INFO_LIST_ITEM.ICON_NAME));
        infoListItemPivot.setDefaultValue((Boolean)record.get((Field)Tables.INFO_LIST_ITEM.IS_DEFAULT));
        return infoListItemPivot;
    }

    @Override
    public AttachmentPivot recordToAttachmentPivot(Record record, Field<Long> holderIdField) {
        return this.recordToAttachmentPivot(record, holderIdField, null);
    }

    @Override
    public AttachmentPivot recordToAttachmentPivot(Record record, Field<Long> holderIdField, Field<String> holderTypeField) {
        AttachmentPivot attachmentPivot = new AttachmentPivot();
        attachmentPivot.setPivotId((Long)record.get((Field)Tables.ATTACHMENT.ATTACHMENT_ID));
        attachmentPivot.setOriginalFileName((String)record.get((Field)Tables.ATTACHMENT.NAME));
        attachmentPivot.setZipImportFileName((Long)record.get((Field)Tables.ATTACHMENT.ATTACHMENT_ID), (String)record.get((Field)Tables.ATTACHMENT.TYPE));
        attachmentPivot.setContentId((Long)record.get((Field)Tables.ATTACHMENT_CONTENT.ATTACHMENT_CONTENT_ID));
        try {
            attachmentPivot.setContent(this.attachmentRepository.getContentBytes(record));
        }
        catch (IOException e) {
            throw new ExportPivotException("An error occurred while reading the content of attachment '%s' with ID '%s'".formatted(record.get((Field)Tables.ATTACHMENT.NAME), record.get((Field)Tables.ATTACHMENT.ATTACHMENT_ID)), (Throwable)e);
        }
        attachmentPivot.setAddedOn((Date)record.get((Field)Tables.ATTACHMENT.ADDED_ON));
        attachmentPivot.setLastModifiedOn((Date)record.get((Field)Tables.ATTACHMENT.LAST_MODIFIED_ON));
        attachmentPivot.setHolderId((Long)record.get(holderIdField));
        if (holderTypeField != null) {
            attachmentPivot.setAttachmentEntity(AttachmentEntity.valueOf((String)((String)record.get(holderTypeField))));
        }
        return attachmentPivot;
    }

    @Override
    public ProjectPivot recordToProjectPivot(Record record) {
        ProjectPivot projectPivot = new ProjectPivot();
        projectPivot.setPivotId((Long)record.get((Field)Tables.PROJECT.PROJECT_ID));
        projectPivot.setName((String)record.get((Field)Tables.PROJECT.NAME));
        projectPivot.setLabel((String)record.get((Field)Tables.PROJECT.LABEL));
        projectPivot.setDescription((String)record.get((Field)Tables.PROJECT.DESCRIPTION));
        projectPivot.setCreatedBy((String)record.get((Field)Tables.PROJECT.CREATED_BY));
        projectPivot.setCreatedOn((Date)record.get((Field)Tables.PROJECT.CREATED_ON));
        projectPivot.setLastModifiedBy((String)record.get((Field)Tables.PROJECT.LAST_MODIFIED_BY));
        projectPivot.setLastModifiedOn((Date)record.get((Field)Tables.PROJECT.LAST_MODIFIED_ON));
        projectPivot.setRequirementLibrary(this.recordToLibrary(record, (Field<Long>)Tables.PROJECT.RL_ID));
        projectPivot.setTestCaseLibrary(this.recordToLibrary(record, (Field<Long>)Tables.PROJECT.TCL_ID));
        projectPivot.setCampaignLibrary(this.recordToLibrary(record, (Field<Long>)Tables.PROJECT.CL_ID));
        this.addBoundInfoList(record, projectPivot);
        return projectPivot;
    }

    private LibraryPivot recordToLibrary(Record record, Field<Long> libraryIdField) {
        LibraryPivot libraryPivot = new LibraryPivot();
        libraryPivot.setPivotId((Long)record.get(libraryIdField));
        return libraryPivot;
    }

    private void addBoundInfoList(Record record, ProjectPivot projectPivot) {
        projectPivot.addBoundInfoList(InfoListProjectBindingType.REQUIREMENT_CATEGORY, (Long)record.get((Field)Tables.PROJECT.REQ_CATEGORIES_LIST));
        projectPivot.addBoundInfoList(InfoListProjectBindingType.TEST_CASE_NATURE, (Long)record.get((Field)Tables.PROJECT.TC_NATURES_LIST));
        projectPivot.addBoundInfoList(InfoListProjectBindingType.TEST_CASE_TYPE, (Long)record.get((Field)Tables.PROJECT.TC_TYPES_LIST));
    }

    @Override
    public void appendCustomFieldBinding(Record record, ProjectPivot projectPivot) {
        BindableEntity boundEntity = BindableEntity.valueOf((String)((String)record.get((Field)Tables.CUSTOM_FIELD_BINDING.BOUND_ENTITY)));
        projectPivot.addBoundCuf((Long)record.get((Field)Tables.CUSTOM_FIELD_BINDING.CF_ID), boundEntity);
    }

    @Override
    public void appendMilestoneBinding(Record record, ProjectPivot projectPivot) {
        Long milestoneId = (Long)record.get((Field)Tables.MILESTONE.MILESTONE_ID);
        if (milestoneId != null) {
            projectPivot.addMilestone(milestoneId);
        }
    }

    @Override
    public void appendBugtrackerBinding(Record record, ProjectPivot projectPivot) {
        Long bugtrackerId = (Long)record.get((Field)Tables.PROJECT.BUGTRACKER_ID);
        if (bugtrackerId != null) {
            projectPivot.setBugtracker(bugtrackerId);
            projectPivot.addBugtrackerProjectNames((String)record.get((Field)Tables.BUGTRACKER_PROJECT.BUGTRACKER_PROJECT_NAME));
        }
    }

    @Override
    public MilestonePivot recordToMilestonePivot(Record record) {
        MilestonePivot milestonePivot = new MilestonePivot();
        milestonePivot.setPivotId((Long)record.get((Field)Tables.MILESTONE.MILESTONE_ID));
        milestonePivot.setLabel((String)record.get((Field)Tables.MILESTONE.LABEL));
        milestonePivot.setDescription((String)record.get((Field)Tables.MILESTONE.DESCRIPTION));
        milestonePivot.setDueDate((Date)record.get((Field)Tables.MILESTONE.END_DATE));
        milestonePivot.setStatus(MilestoneStatus.valueOf((String)((String)record.get((Field)Tables.MILESTONE.STATUS))));
        milestonePivot.setRange(MilestoneRange.valueOf((String)((String)record.get((Field)Tables.MILESTONE.M_RANGE))));
        milestonePivot.setCreatedBy((String)record.get((Field)Tables.MILESTONE.CREATED_BY));
        milestonePivot.setCreatedOn((Date)record.get((Field)Tables.MILESTONE.CREATED_ON));
        milestonePivot.setLastModifiedBy((String)record.get((Field)Tables.MILESTONE.LAST_MODIFIED_BY));
        milestonePivot.setLastModifiedOn((Date)record.get((Field)Tables.MILESTONE.LAST_MODIFIED_ON));
        return milestonePivot;
    }

    @Override
    public MilestonePivot recordToBindingMilestonePivot(Record record, Field<Long> holderId, Field<Long> milestoneIdField) {
        MilestonePivot milestonePivot = new MilestonePivot();
        milestonePivot.setPivotId((Long)record.get(milestoneIdField));
        milestonePivot.setBindableId((Long)record.get(holderId));
        return milestonePivot;
    }

    @Override
    public RequirementLinkTypePivot recordToRequirementLinkTypePivot(Record record) {
        RequirementLinkTypePivot requirementLinkTypePivot = new RequirementLinkTypePivot();
        requirementLinkTypePivot.setPivotId((Long)record.get((Field)Tables.REQUIREMENT_VERSION_LINK_TYPE.TYPE_ID));
        requirementLinkTypePivot.setRole1((String)record.get((Field)Tables.REQUIREMENT_VERSION_LINK_TYPE.ROLE_1));
        requirementLinkTypePivot.setRole2((String)record.get((Field)Tables.REQUIREMENT_VERSION_LINK_TYPE.ROLE_2));
        requirementLinkTypePivot.setRoleCode1((String)record.get((Field)Tables.REQUIREMENT_VERSION_LINK_TYPE.ROLE_1_CODE));
        requirementLinkTypePivot.setRoleCode2((String)record.get((Field)Tables.REQUIREMENT_VERSION_LINK_TYPE.ROLE_2_CODE));
        return requirementLinkTypePivot;
    }

    @Override
    public ServersPivot recordToServerPivot(Record record) {
        ServersPivot serversPivot = new ServersPivot();
        serversPivot.setPivotId((Long)record.get((Field)Tables.THIRD_PARTY_SERVER.SERVER_ID));
        serversPivot.setKind((String)record.get((Field)Tables.BUGTRACKER.KIND));
        serversPivot.setName((String)record.get((Field)Tables.THIRD_PARTY_SERVER.NAME));
        serversPivot.setUrl((String)record.get((Field)Tables.THIRD_PARTY_SERVER.URL));
        return serversPivot;
    }
}

