/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.dto.projectimporter;

import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.service.internal.dto.projectimporter.JsonImportFile;

public record ImportWarningEntry(JsonImportFile importFile, String message) {
    public static ImportWarningEntry projectNameChanged(String projectPivotName, String projectName) {
        String message = "The imported project has a name \"%s\" in the file \"%s\", but the current project has a different name: \"%s\". The project name cannot be changed.".formatted(projectPivotName, JsonImportFile.PROJECTS.getFileName(), projectName);
        return new ImportWarningEntry(JsonImportFile.PROJECTS, message);
    }

    public static ImportWarningEntry projectLabelChanged(String projectPivotLabel, String projectLabel) {
        String message = "The imported project has a label \"%s\" in the file \"%s\", but the current project has a different label: \"%s\". The project label cannot be changed.".formatted(projectPivotLabel, JsonImportFile.PROJECTS.getFileName(), projectLabel);
        return new ImportWarningEntry(JsonImportFile.PROJECTS, message);
    }

    public static ImportWarningEntry attachmentError(EntityType entityType, String attachmentName, JsonImportFile jsonImportFile, String exMessage) {
        String message = "An error occurred while adding attachment \"%s\" for entity type %s : %s".formatted(attachmentName, entityType, exMessage);
        return new ImportWarningEntry(jsonImportFile, message);
    }

    public static ImportWarningEntry attachmentNotFound(EntityType entityType, String attachmentName, JsonImportFile jsonImportFile) {
        String message = "Attachment \"%s\" for entity type %s was not found in the import archive".formatted(attachmentName, entityType);
        return new ImportWarningEntry(jsonImportFile, message);
    }

    public static ImportWarningEntry requirementMilestoneAlreadyBound(String milestoneName, String requirementName) {
        String message = "The requirement version \"%s\" is already bound to a milestone named \"%s\". Two versions of a same requirement cannot be associated with a same milestone.".formatted(requirementName, milestoneName);
        return new ImportWarningEntry(JsonImportFile.REQUIREMENTS, message);
    }

    public static ImportWarningEntry requirementLinkTypeCodeAlreadyUsed(String pivotId, String code) {
        String message = "The requirement link type with pivot id \"%s\" has a code \"%s\" that is already used by another requirement link type.".formatted(pivotId, code);
        return new ImportWarningEntry(JsonImportFile.REQUIREMENT_LINK_TYPES, message);
    }

    public static ImportWarningEntry requirementLinkTypeCodeDuplication(String pivotId) {
        String message = "The requirement link type with pivot id \"%s\" has the same role1 code and role2 code.".formatted(pivotId);
        return new ImportWarningEntry(JsonImportFile.REQUIREMENT_LINK_TYPES, message);
    }

    public static ImportWarningEntry requirementLinkDuplication(String pivotId) {
        String message = "The requirement version with id \"%s\" is a link to itself.".formatted(pivotId);
        return new ImportWarningEntry(JsonImportFile.REQUIREMENTS, message);
    }
}

