/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.campaign.export;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.jooq.CommonTableExpression;
import org.jooq.Field;
import org.jooq.Name;
import org.jooq.OrderField;
import org.jooq.Record;
import org.jooq.ResultQuery;
import org.jooq.Select;
import org.jooq.SelectField;
import org.jooq.SelectFieldOrAsterisk;
import org.jooq.SelectOrderByStep;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.squashtest.tm.aspect.validation.CleanHtmlAspect;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.campaign.export.CampaignExportCSVModel;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.campaign.export.AbstractCampaignExportCSVModel;
import org.squashtest.tm.service.internal.campaign.export.CampaignExportCSVFullModelImpl$DataIterator$AjcClosure1;
import org.squashtest.tm.service.internal.campaign.export.CellImpl;
import org.squashtest.tm.service.internal.campaign.export.RowImpl;
import org.squashtest.tm.service.internal.dto.CustomFieldDto;
import org.squashtest.tm.service.internal.dto.CustomFieldValueDto;
import org.squashtest.tm.service.internal.dto.ExecutionDto;
import org.squashtest.tm.service.internal.dto.ExecutionStepDto;
import org.squashtest.tm.service.internal.dto.ITPIDto;
import org.squashtest.tm.service.internal.dto.IterationDto;
import org.squashtest.tm.service.internal.dto.NumericCufHelper;
import org.squashtest.tm.service.internal.dto.TestCaseDto;
import org.squashtest.tm.service.internal.dto.TestStepDto;

@Component
@Scope(value="prototype")
public class CampaignExportCSVFullModelImpl
extends AbstractCampaignExportCSVModel {
    private static final Logger LOGGER = LoggerFactory.getLogger(CampaignExportCSVModel.class);
    private static final String UNCHECKED = "unchecked";
    private static final String TS_VERIFYING_STEP = "ts_verifying_step";
    private static final String ES_VERIFYING_STEP = "es_verifying_step";
    public static final String TS_RVC = "ts_rvc";
    public static final String TC_RVC = "tc_rvc";
    public static final String ES_RVC = "es_rvc";
    public static final String EXEC_ISSUE = "exec_issue";
    public static final String ES_ISSUE = "es_issue";
    public static final String INFO_LIST_1 = "info_list_1";
    public static final String INFO_LIST_2 = "info_list_2";
    public static final String TCS = "tcs";
    public static final String CTP = "ctp";
    private int nbRows;

    @Override
    void initIterationsAndCustomFields() {
        LOGGER.info("campaign full export : processing model", new Object[0]);
        Iterator<Record> iterator = this.getIterationJooqQueryIterator();
        ArrayList<Long> allTestCaseIds = new ArrayList<Long>();
        ArrayList<Long> allExecutionIds = new ArrayList<Long>();
        this.populateCampaignDto(iterator, allTestCaseIds, allExecutionIds);
        Set<Long> allIterationIds = this.campaignDto.getIterationMap().keySet();
        List<Long> allExecutionStepIds = this.collectLatestExecutionStepId(this.campaignDto.getIterationMap().values());
        this.nbRows = allExecutionStepIds.size();
        this.populateCampCUFModelAndCampCUFValues();
        this.populateCUFModelAndCufValues("ITERATION", this.iterCUFModel, this.iterCUFValues, allIterationIds);
        this.populateCUFModelAndCufValues("TEST_CASE", this.tcCUFModel, this.tcCUFValues, allTestCaseIds);
        this.populateCUFModelAndCufValues("EXECUTION", this.execCUFModel, this.execCUFValues, allExecutionIds);
        this.populateCUFModelAndCufValues("EXECUTION_STEP", this.esCUFModel, this.esCUFValues, allExecutionStepIds);
        this.nbColumns = 35 + this.campCUFModel.size() + this.iterCUFModel.size() + this.tcCUFModel.size() + this.execCUFModel.size() + this.esCUFModel.size();
        LOGGER.info("campaign full export : model processed", new Object[0]);
    }

    @Override
    Iterator<Record> getIterationJooqQueryIterator() {
        CommonTableExpression cte = DSL.name((String)"cte").fields(new String[]{"ITERATION_ID", "ITERATION_NAME", "campaignId", "SCHEDULED_END_DATE", "SCHEDULED_START_DATE", "ACTUAL_END_DATE", "ACTUAL_START_DATE", "TEST_PLAN_ITEM_ID", "ITPI_EXECUTION_STATUS", "LOGIN", "LAST_EXECUTED_ON", "ITPI_EXECUTION_ID", "NAME", "LABEL", "TCLN_ID", "IMPORTANCE", "REFERENCE", "TC_NATURE", "TC_TYPE", "TC_STATUS", "REQUIREMENT_VERSION_COVERAGE_ID", "TEST_CASE_NAME", "PROJECT_ID", "TC_PROJECT", "ISSUE_ID", "TEST_SUITE_NAME", "TC_MILESTONE_LABEL", "STEP_ORDER", "STEP_ID", "CALLED_TEST_CASE_ID", "EXECUTION_ID", "EXECUTION_MODE", "EXECUTION_STATUS", "EXECUTION_STEP_ID", "EXECUTION_STEP_STATUS", "LAST_EXECUTED_BY", "EXECUTION_LAST_EXECUTED_ON", "COMMENT", "EXECUTION_STEP_ORDER", "TEST_STEP_ID", ES_ISSUE, "ES_REQUIREMENT_VERSION_COVERAGE_ID"}).as(this.getRecursiveIterationSteps());
        return this.dsl.withRecursive(new CommonTableExpression[]{cte}).selectDistinct(new SelectFieldOrAsterisk[0]).from((TableLike)cte).where(DSL.field((String)"STEP_ID", Long.class).eq(DSL.field((String)"TEST_STEP_ID", Long.class)).or(DSL.field((String)"TEST_STEP_ID", Long.class).isNull())).orderBy((OrderField)DSL.field((String)"ITERATION_ID", Long.class), (OrderField)DSL.field((String)"TEST_PLAN_ITEM_ID", Long.class), (OrderField)DSL.field((String)"EXECUTION_ID", Long.class), (OrderField)DSL.field((String)"EXECUTION_STEP_ORDER", Long.class)).fetch().iterator();
    }

    private SelectOrderByStep<Record> getRecursiveIterationSteps() {
        return this.dsl.selectDistinct(new SelectFieldOrAsterisk[]{AbstractCampaignExportCSVModel.ITERATION_ID, AbstractCampaignExportCSVModel.ITERATION_NAME, Tables.CAMPAIGN.CLN_ID, AbstractCampaignExportCSVModel.ITERATION_SCHEDULED_END_DATE, AbstractCampaignExportCSVModel.ITERATION_SCHEDULED_START_DATE, AbstractCampaignExportCSVModel.ITERATION_ACTUAL_END_DATE, AbstractCampaignExportCSVModel.ITERATION_ACTUAL_START_DATE, Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID, Tables.TEST_PLAN_ITEM.EXECUTION_STATUS, AbstractCampaignExportCSVModel.USER_LOGIN, Tables.TEST_PLAN_ITEM.LAST_EXECUTED_ON, Tables.EXECUTION.EXECUTION_ID, AbstractCampaignExportCSVModel.DATASET_NAME, AbstractCampaignExportCSVModel.IT_MILESTONE.LABEL, AbstractCampaignExportCSVModel.TC_ID, AbstractCampaignExportCSVModel.TC_IMPORTANCE, AbstractCampaignExportCSVModel.TC_REFERENCE, AbstractCampaignExportCSVModel.TC_NATURE, AbstractCampaignExportCSVModel.TC_TYPE, AbstractCampaignExportCSVModel.TC_STATUS, AbstractCampaignExportCSVModel.TC_REQUIREMENT_VERIFIED, AbstractCampaignExportCSVModel.TC_NAME, AbstractCampaignExportCSVModel.PROJECT_ID, AbstractCampaignExportCSVModel.PROJECT_NAME, AbstractCampaignExportCSVModel.ITPI_ISSUE, AbstractCampaignExportCSVModel.TSu_NAME, AbstractCampaignExportCSVModel.TC_MILESTONE.LABEL, AbstractCampaignExportCSVModel.TS_ORDER, AbstractCampaignExportCSVModel.TS_ID, AbstractCampaignExportCSVModel.CTS_CALLED_TS, AbstractCampaignExportCSVModel.EXECUTION_ID, AbstractCampaignExportCSVModel.EXECUTION_MODE, AbstractCampaignExportCSVModel.EXECUTION_STATUS, AbstractCampaignExportCSVModel.EXECUTION_STEP_ID, AbstractCampaignExportCSVModel.EXECUTION_STEP_STATUS, AbstractCampaignExportCSVModel.ES_LAST_EXECUTED_BY, AbstractCampaignExportCSVModel.ES_LAST_EXECUTED_ON, AbstractCampaignExportCSVModel.ES_COMMENT, AbstractCampaignExportCSVModel.ES_ORDER, AbstractCampaignExportCSVModel.ES_TS_ID, AbstractCampaignExportCSVModel.ES_ISSUE, AbstractCampaignExportCSVModel.ES_REQUIREMENT_VERIFIED}).from((TableLike)Tables.ITERATION).innerJoin((TableLike)Tables.CAMPAIGN_ITERATION).on(AbstractCampaignExportCSVModel.ITERATION_ID.eq((Field)Tables.CAMPAIGN_ITERATION.ITERATION_ID)).innerJoin((TableLike)Tables.CAMPAIGN).on(Tables.CAMPAIGN.CLN_ID.eq((Field)Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID)).innerJoin((TableLike)Tables.TEST_PLAN_ITEM).on(Tables.TEST_PLAN_ITEM.TEST_PLAN_ID.eq((Field)Tables.ITERATION.TEST_PLAN_ID)).leftJoin((TableLike)Tables.TEST_CASE).on(AbstractCampaignExportCSVModel.TC_ID.eq((Field)Tables.TEST_PLAN_ITEM.TCLN_ID)).leftJoin((TableLike)Tables.TEST_CASE_STEPS).on(Tables.TEST_CASE_STEPS.TEST_CASE_ID.eq(AbstractCampaignExportCSVModel.TC_ID)).leftJoin((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.eq(AbstractCampaignExportCSVModel.TC_ID)).leftJoin((TableLike)Tables.CALL_TEST_STEP).on(Tables.CALL_TEST_STEP.TEST_STEP_ID.eq(AbstractCampaignExportCSVModel.TS_ID)).leftJoin((TableLike)Tables.ACTION_TEST_STEP).on(Tables.ACTION_TEST_STEP.TEST_STEP_ID.eq(AbstractCampaignExportCSVModel.TS_ID)).leftJoin((TableLike)Tables.KEYWORD_TEST_STEP).on(Tables.KEYWORD_TEST_STEP.TEST_STEP_ID.eq(AbstractCampaignExportCSVModel.TS_ID)).leftJoin((TableLike)Tables.VERIFYING_STEPS.as(TS_VERIFYING_STEP)).on(Tables.VERIFYING_STEPS.as((String)TS_VERIFYING_STEP).TEST_STEP_ID.eq((Field)Tables.ACTION_TEST_STEP.TEST_STEP_ID)).leftJoin((TableLike)Tables.EXECUTION).on(Tables.EXECUTION.TEST_PLAN_ITEM_ID.eq((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID)).leftJoin((TableLike)Tables.EXECUTION_EXECUTION_STEPS).on(Tables.EXECUTION_EXECUTION_STEPS.EXECUTION_ID.eq((Field)Tables.EXECUTION.EXECUTION_ID)).leftJoin((TableLike)Tables.EXECUTION_STEP).on(Tables.EXECUTION_STEP.EXECUTION_STEP_ID.eq((Field)Tables.EXECUTION_EXECUTION_STEPS.EXECUTION_STEP_ID)).leftJoin((TableLike)Tables.REQUIREMENT_VERSION_COVERAGE.as(TS_RVC)).on(AbstractCampaignExportCSVModel.TS_REQUIREMENT_VERIFIED.eq((Field)Tables.VERIFYING_STEPS.as((String)TS_VERIFYING_STEP).REQUIREMENT_VERSION_COVERAGE_ID)).innerJoin((TableLike)Tables.PROJECT).on(AbstractCampaignExportCSVModel.PROJECT_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID)).leftJoin((TableLike)Tables.REQUIREMENT_VERSION_COVERAGE.as(TC_RVC)).on(Tables.REQUIREMENT_VERSION_COVERAGE.as((String)TC_RVC).VERIFYING_TEST_CASE_ID.eq(AbstractCampaignExportCSVModel.TC_ID)).leftJoin((TableLike)Tables.DATASET).on(Tables.DATASET.DATASET_ID.eq((Field)Tables.TEST_PLAN_ITEM.DATASET_ID)).leftJoin((TableLike)Tables.EXECUTION_ISSUES_CLOSURE.as(EXEC_ISSUE)).on(Tables.EXECUTION_ISSUES_CLOSURE.as((String)EXEC_ISSUE).EXECUTION_ID.eq((Field)Tables.EXECUTION.EXECUTION_ID)).leftJoin((TableLike)Tables.ISSUE.as(ES_ISSUE)).on(Tables.ISSUE.as((String)ES_ISSUE).ISSUE_LIST_ID.eq((Field)Tables.EXECUTION_STEP.ISSUE_LIST_ID)).leftJoin((TableLike)Tables.VERIFYING_STEPS.as(ES_VERIFYING_STEP)).on(Tables.VERIFYING_STEPS.as((String)ES_VERIFYING_STEP).TEST_STEP_ID.eq((Field)Tables.EXECUTION_STEP.TEST_STEP_ID)).leftJoin((TableLike)Tables.REQUIREMENT_VERSION_COVERAGE.as(ES_RVC)).on(AbstractCampaignExportCSVModel.ES_REQUIREMENT_VERIFIED.eq((Field)Tables.VERIFYING_STEPS.as((String)ES_VERIFYING_STEP).REQUIREMENT_VERSION_COVERAGE_ID)).leftJoin((TableLike)Tables.TEST_SUITE_TEST_PLAN_ITEM).on(Tables.TEST_SUITE_TEST_PLAN_ITEM.TPI_ID.eq(AbstractCampaignExportCSVModel.ITPI_ID)).leftJoin((TableLike)Tables.TEST_SUITE).on(Tables.TEST_SUITE.ID.eq((Field)Tables.TEST_SUITE_TEST_PLAN_ITEM.SUITE_ID)).leftJoin((TableLike)Tables.MILESTONE_TEST_CASE).on(Tables.MILESTONE_TEST_CASE.TEST_CASE_ID.eq(AbstractCampaignExportCSVModel.TC_ID)).leftJoin((TableLike)AbstractCampaignExportCSVModel.TC_MILESTONE).on(AbstractCampaignExportCSVModel.TC_MILESTONE.MILESTONE_ID.eq((Field)Tables.MILESTONE_TEST_CASE.MILESTONE_ID)).leftJoin((TableLike)Tables.MILESTONE_CAMPAIGN).on(Tables.MILESTONE_CAMPAIGN.CAMPAIGN_ID.eq((Field)Tables.CAMPAIGN.CLN_ID)).leftJoin((TableLike)AbstractCampaignExportCSVModel.IT_MILESTONE).on(AbstractCampaignExportCSVModel.IT_MILESTONE.MILESTONE_ID.eq((Field)Tables.MILESTONE_CAMPAIGN.MILESTONE_ID)).leftJoin((TableLike)Tables.CORE_USER).on(Tables.CORE_USER.PARTY_ID.eq((Field)Tables.TEST_PLAN_ITEM.ASSIGNEE_ID)).leftJoin((TableLike)Tables.INFO_LIST_ITEM.as(INFO_LIST_1)).on(Tables.INFO_LIST_ITEM.as((String)INFO_LIST_1).ITEM_ID.eq((Field)Tables.TEST_CASE.TC_TYPE)).leftJoin((TableLike)Tables.INFO_LIST_ITEM.as(INFO_LIST_2)).on(Tables.INFO_LIST_ITEM.as((String)INFO_LIST_2).ITEM_ID.eq((Field)Tables.TEST_CASE.TC_NATURE)).where(Tables.CAMPAIGN.CLN_ID.eq((Object)this.campaign.getId())).union((Select)DSL.select((SelectFieldOrAsterisk[])new SelectFieldOrAsterisk[]{DSL.field((Name)DSL.name((String[])new String[]{"cte", "ITERATION_ID"}), Long.class), DSL.field((Name)DSL.name((String[])new String[]{"cte", "ITERATION_NAME"}), String.class), DSL.field((Name)DSL.name((String[])new String[]{"cte", "campaignId"}), String.class), DSL.field((Name)DSL.name((String[])new String[]{"cte", "SCHEDULED_END_DATE"}), Date.class), DSL.field((Name)DSL.name((String[])new String[]{"cte", "SCHEDULED_START_DATE"}), Date.class), DSL.field((Name)DSL.name((String[])new String[]{"cte", "ACTUAL_END_DATE"}), Date.class), DSL.field((Name)DSL.name((String[])new String[]{"cte", "ACTUAL_START_DATE"}), Date.class), DSL.field((Name)DSL.name((String[])new String[]{"cte", "TEST_PLAN_ITEM_ID"}), Long.class), DSL.field((Name)DSL.name((String[])new String[]{"cte", "ITPI_EXECUTION_STATUS"}), String.class), DSL.field((Name)DSL.name((String[])new String[]{"cte", "LOGIN"}), String.class), DSL.field((Name)DSL.name((String[])new String[]{"cte", "LAST_EXECUTED_ON"}), Date.class), DSL.field((Name)DSL.name((String[])new String[]{"cte", "ITPI_EXECUTION_ID"}), Long.class), DSL.field((Name)DSL.name((String[])new String[]{"cte", "NAME"}), String.class), DSL.field((Name)DSL.name((String[])new String[]{"cte", "LABEL"}), String.class), DSL.field((Name)DSL.name((String[])new String[]{"cte", "TCLN_ID"}), Long.class), DSL.field((Name)DSL.name((String[])new String[]{"cte", "IMPORTANCE"}), String.class), DSL.field((Name)DSL.name((String[])new String[]{"cte", "REFERENCE"}), String.class), DSL.field((Name)DSL.name((String[])new String[]{"cte", "TC_NATURE"}), String.class), DSL.field((Name)DSL.name((String[])new String[]{"cte", "TC_TYPE"}), String.class), DSL.field((Name)DSL.name((String[])new String[]{"cte", "TC_STATUS"}), String.class), DSL.field((Name)DSL.name((String[])new String[]{"cte", "REQUIREMENT_VERSION_COVERAGE_ID"}), Long.class), DSL.field((Name)DSL.name((String[])new String[]{"cte", "TEST_CASE_NAME"}), String.class), DSL.field((Name)DSL.name((String[])new String[]{"cte", "PROJECT_ID"}), Long.class), DSL.field((Name)DSL.name((String[])new String[]{"cte", "TC_PROJECT"}), String.class), DSL.field((Name)DSL.name((String[])new String[]{"cte", "ISSUE_ID"}), Long.class), DSL.field((Name)DSL.name((String[])new String[]{"cte", "TEST_SUITE_NAME"}), String.class), DSL.field((Name)DSL.name((String[])new String[]{"cte", "TC_MILESTONE_LABEL"}), String.class), DSL.field((Name)DSL.name((String[])new String[]{TCS, "STEP_ORDER"}), Long.class), DSL.field((Name)DSL.name((String[])new String[]{TCS, "STEP_ID"}), Long.class), DSL.field((Name)DSL.name((String[])new String[]{CTP, "CALLED_TEST_CASE_ID"}), Long.class), DSL.field((Name)DSL.name((String[])new String[]{"cte", "EXECUTION_ID"}), Long.class), DSL.field((Name)DSL.name((String[])new String[]{"cte", "EXECUTION_MODE"}), String.class), DSL.field((Name)DSL.name((String[])new String[]{"cte", "EXECUTION_STATUS"}), String.class), DSL.field((Name)DSL.name((String[])new String[]{"cte", "EXECUTION_STEP_ID"}), Long.class), DSL.field((Name)DSL.name((String[])new String[]{"cte", "EXECUTION_STEP_STATUS"}), String.class), DSL.field((Name)DSL.name((String[])new String[]{"cte", "LAST_EXECUTED_BY"}), String.class), DSL.field((Name)DSL.name((String[])new String[]{"cte", "EXECUTION_LAST_EXECUTED_ON"}), Date.class), DSL.field((Name)DSL.name((String[])new String[]{"cte", "COMMENT"}), String.class), DSL.field((Name)DSL.name((String[])new String[]{"cte", "EXECUTION_STEP_ORDER"}), Long.class), DSL.field((Name)DSL.name((String[])new String[]{"cte", "TEST_STEP_ID"}), Long.class), DSL.field((Name)DSL.name((String[])new String[]{"cte", ES_ISSUE}), Long.class), DSL.field((Name)DSL.name((String[])new String[]{"cte", "ES_REQUIREMENT_VERSION_COVERAGE_ID"}), Long.class)}).from(DSL.name((String)"cte")).join((TableLike)Tables.CALL_TEST_STEP.as(CTP)).on(DSL.field((Name)DSL.name((String[])new String[]{"cte", "STEP_ID"})).eq(DSL.field((Name)DSL.name((String[])new String[]{CTP, "TEST_STEP_ID"})))).join((TableLike)Tables.TEST_CASE_STEPS.as(TCS)).on(DSL.field((Name)DSL.name((String[])new String[]{CTP, "CALLED_TEST_CASE_ID"})).eq(DSL.field((Name)DSL.name((String[])new String[]{TCS, "TEST_CASE_ID"})))));
    }

    private void populateCampaignDto(Iterator<Record> iterator, List<Long> allTestCaseIds, List<Long> allExecutionIds) {
        IterationDto currentIteration = new IterationDto();
        ITPIDto currentItpi = new ITPIDto();
        TestCaseDto currentTestCase = new TestCaseDto();
        TestStepDto currentTestStep = new TestStepDto();
        ExecutionDto currentExecution = new ExecutionDto();
        ExecutionStepDto currentExecutionStep = new ExecutionStepDto();
        while (iterator.hasNext()) {
            Record r = iterator.next();
            currentIteration = this.populateIterationInCampaignDto(r, currentIteration);
            CampaignExportCSVFullModelImpl.populateIterationMilestoneForCampaignDto(r, currentIteration);
            if (currentIteration.getTestPlan((Long)r.get(AbstractCampaignExportCSVModel.ITPI_ID)) == null) {
                ITPIDto newItpi = this.createNewItpiDto(r);
                TestCaseDto newTestCase = this.createNewTestCaseDto(r);
                allTestCaseIds.add((Long)r.get(AbstractCampaignExportCSVModel.TC_ID));
                newItpi.setTestCase(newTestCase);
                currentIteration.addTestPlan(newItpi);
                currentItpi = currentIteration.getTestPlan((Long)r.get(AbstractCampaignExportCSVModel.ITPI_ID));
                currentTestCase = currentItpi.getTestCase();
                currentTestStep = this.populateTestCaseWithCreatedTestStep(r, currentTestCase, currentTestStep);
                currentExecution = this.populateExecutionOrCreateNewOne(allExecutionIds, r, currentItpi, currentExecution);
                currentExecutionStep = this.getExecutionStepFromCurrentExecution(r, currentExecutionStep, currentExecution);
                continue;
            }
            this.populateItpi(r, currentItpi);
            this.populateTestCase(r, currentTestCase);
            currentTestStep = this.populateExistingTestStepOrCreateNewOne(currentTestStep, r, currentTestCase);
            if (r.get(AbstractCampaignExportCSVModel.EXECUTION_ID) == null) continue;
            if (!currentExecution.getId().equals(r.get(AbstractCampaignExportCSVModel.EXECUTION_ID))) {
                ExecutionDto newExecution = this.createNewExecutionDto(r);
                currentItpi.addExecution(newExecution);
                currentExecution = currentItpi.getExecution((Long)r.get(AbstractCampaignExportCSVModel.EXECUTION_ID));
                allExecutionIds.add((Long)r.get(AbstractCampaignExportCSVModel.EXECUTION_ID));
            } else if (r.get(AbstractCampaignExportCSVModel.EXECUTION_STEP_ID) != null) {
                currentExecutionStep = this.populateExecutionStepOrCreateNewOne(currentExecutionStep, r, currentExecution);
            }
            CampaignExportCSVFullModelImpl.addIssueForExecution(r, currentExecution);
        }
    }

    private ExecutionStepDto populateExecutionStepOrCreateNewOne(ExecutionStepDto currentExecutionStep, Record r, ExecutionDto currentExecution) {
        if (!currentExecutionStep.getId().equals(r.get(AbstractCampaignExportCSVModel.EXECUTION_STEP_ID))) {
            ExecutionStepDto newES = this.createExecutionStepDto(r);
            currentExecution.addStep(newES);
            currentExecutionStep = currentExecution.getStep((Long)r.get(AbstractCampaignExportCSVModel.EXECUTION_STEP_ID));
        } else {
            this.populateExecutionStepDto(r, currentExecutionStep);
        }
        return currentExecutionStep;
    }

    private TestStepDto populateTestCaseWithCreatedTestStep(Record r, TestCaseDto currentTestCase, TestStepDto currentTestStep) {
        if (r.get(AbstractCampaignExportCSVModel.TS_ID) != null) {
            TestStepDto step = this.createTestStepDto(r);
            currentTestCase.addStep(step);
            currentTestStep = currentTestCase.getStep((Long)r.get(AbstractCampaignExportCSVModel.TS_ID));
        }
        return currentTestStep;
    }

    private TestStepDto populateExistingTestStepOrCreateNewOne(TestStepDto currentTestStep, Record r, TestCaseDto currentTestCase) {
        if (currentTestStep.getId().equals(r.get(AbstractCampaignExportCSVModel.TS_ID)) && r.get(AbstractCampaignExportCSVModel.TS_REQUIREMENT_VERIFIED) != null) {
            currentTestStep.addRequirement((Long)r.get(AbstractCampaignExportCSVModel.TS_REQUIREMENT_VERIFIED));
        } else if (r.get(AbstractCampaignExportCSVModel.TS_ID) != null) {
            TestStepDto step = this.createTestStepDto(r);
            currentTestCase.addStep(step);
            currentTestStep = currentTestCase.getStep((Long)r.get(AbstractCampaignExportCSVModel.TS_ID));
        }
        return currentTestStep;
    }

    private ExecutionDto populateExecutionOrCreateNewOne(List<Long> allExecutionIds, Record r, ITPIDto currentItpi, ExecutionDto currentExecution) {
        if (r.get(AbstractCampaignExportCSVModel.EXECUTION_ID) != null) {
            ExecutionDto execution = currentItpi.getExecution((Long)r.get(AbstractCampaignExportCSVModel.EXECUTION_ID));
            if (execution == null) {
                execution = this.createNewExecutionDto(r);
            }
            CampaignExportCSVFullModelImpl.addIssueForExecution(r, execution);
            currentItpi.addExecution(execution);
            currentExecution = currentItpi.getExecution((Long)r.get(AbstractCampaignExportCSVModel.EXECUTION_ID));
            allExecutionIds.add((Long)r.get(AbstractCampaignExportCSVModel.EXECUTION_ID));
        }
        return currentExecution;
    }

    private ExecutionStepDto getExecutionStepFromCurrentExecution(Record r, ExecutionStepDto currentExecutionStep, ExecutionDto currentExecution) {
        if (r.get(AbstractCampaignExportCSVModel.EXECUTION_ID) != null && r.get(AbstractCampaignExportCSVModel.EXECUTION_STEP_ID) != null) {
            currentExecutionStep = currentExecution.getStep((Long)r.get(AbstractCampaignExportCSVModel.EXECUTION_STEP_ID));
        }
        return currentExecutionStep;
    }

    private ExecutionStepDto createExecutionStepDto(Record r) {
        ExecutionStepDto es = new ExecutionStepDto((Long)r.get(AbstractCampaignExportCSVModel.EXECUTION_STEP_ID), (String)r.get(AbstractCampaignExportCSVModel.EXECUTION_STEP_STATUS), (Integer)r.get(AbstractCampaignExportCSVModel.ES_ORDER), (Long)r.get(AbstractCampaignExportCSVModel.ES_TS_ID));
        if (r.get(AbstractCampaignExportCSVModel.ES_COMMENT) != null) {
            es.setComment((String)r.get(AbstractCampaignExportCSVModel.ES_COMMENT));
        }
        if (r.get(AbstractCampaignExportCSVModel.ES_LAST_EXECUTED_BY) != null) {
            es.setLastExecutedBy((String)r.get(AbstractCampaignExportCSVModel.ES_LAST_EXECUTED_BY));
        }
        es.setLastExecutedOn((Date)r.get(AbstractCampaignExportCSVModel.ES_LAST_EXECUTED_ON));
        this.populateExecutionStepDto(r, es);
        return es;
    }

    private TestStepDto createTestStepDto(Record r) {
        TestStepDto step = new TestStepDto((Long)r.get(AbstractCampaignExportCSVModel.TS_ID), (Integer)r.get(AbstractCampaignExportCSVModel.TS_ORDER));
        if (r.get(AbstractCampaignExportCSVModel.CTS_CALLED_TS) != null) {
            step.setCalledTestCaseId((Long)r.get(AbstractCampaignExportCSVModel.CTS_CALLED_TS));
        } else if (r.get(AbstractCampaignExportCSVModel.TS_REQUIREMENT_VERIFIED) != null) {
            step.addRequirement((Long)r.get(AbstractCampaignExportCSVModel.TS_REQUIREMENT_VERIFIED));
        }
        return step;
    }

    @Override
    protected void populateItpi(Record r, ITPIDto itpi) {
        if (r.get(AbstractCampaignExportCSVModel.TSu_NAME.as("TEST_SUITE_NAME")) != null) {
            itpi.getTestSuiteSet().add((String)r.get(AbstractCampaignExportCSVModel.TSu_NAME.as("TEST_SUITE_NAME")));
        }
    }

    private void populateExecutionStepDto(Record r, ExecutionStepDto executionStepDto) {
        if (r.get(AbstractCampaignExportCSVModel.ES_REQUIREMENT_VERIFIED) != null) {
            executionStepDto.addRequirement((Long)r.get(AbstractCampaignExportCSVModel.ES_REQUIREMENT_VERIFIED));
        }
        if (r.get(ES_ISSUE) != null) {
            executionStepDto.addIssue((Long)r.get(AbstractCampaignExportCSVModel.ES_ISSUE));
        }
    }

    private TestCaseDto createNewTestCaseDto(Record r) {
        TestCaseDto newTestCase = new TestCaseDto((Long)r.get(AbstractCampaignExportCSVModel.TC_ID), (String)r.get(AbstractCampaignExportCSVModel.TC_REFERENCE), (String)r.get(AbstractCampaignExportCSVModel.TC_NAME.as("TEST_CASE_NAME")), (String)r.get(AbstractCampaignExportCSVModel.TC_IMPORTANCE), (String)r.get(AbstractCampaignExportCSVModel.TC_NATURE.as("TC_NATURE")), (String)r.get(AbstractCampaignExportCSVModel.TC_TYPE.as("TC_TYPE")), (String)r.get(AbstractCampaignExportCSVModel.TC_STATUS), (Long)r.get(AbstractCampaignExportCSVModel.PROJECT_ID), (String)r.get(AbstractCampaignExportCSVModel.PROJECT_NAME.as("TC_PROJECT")));
        this.populateTestCase(r, newTestCase);
        return newTestCase;
    }

    private ExecutionDto createNewExecutionDto(Record r) {
        boolean automated = "AUTOMATED".equals(r.get(AbstractCampaignExportCSVModel.EXECUTION_MODE));
        ExecutionDto newExecution = new ExecutionDto((Long)r.get(AbstractCampaignExportCSVModel.EXECUTION_ID), (String)r.get(AbstractCampaignExportCSVModel.EXECUTION_STATUS), automated);
        if (r.get(AbstractCampaignExportCSVModel.EXECUTION_STEP_ID) != null) {
            ExecutionStepDto executionStepDto = this.createExecutionStepDto(r);
            newExecution.addStep(executionStepDto);
        }
        return newExecution;
    }

    private List<Long> collectLatestExecutionStepId(Collection<IterationDto> iterations) {
        ArrayList<Long> execStepIds = new ArrayList<Long>();
        for (IterationDto iteration : iterations) {
            for (ITPIDto item : iteration.getTestPlanList()) {
                if (item.isTestCaseDeleted() || item.getLatestExecution() == null) continue;
                execStepIds.addAll(item.getLatestExecution().getSteps().keySet());
            }
        }
        return execStepIds;
    }

    public CampaignExportCSVModel.Row getHeader() {
        ArrayList<CellImpl> headerCells = new ArrayList<CellImpl>(this.nbColumns);
        headerCells.add(new CellImpl("CPG_SCHEDULED_START_ON"));
        headerCells.add(new CellImpl("CPG_SCHEDULED_END_ON"));
        headerCells.add(new CellImpl("CPG_ACTUAL_START_ON"));
        headerCells.add(new CellImpl("CPG_ACTUAL_END_ON"));
        headerCells.add(new CellImpl("IT_ID"));
        headerCells.add(new CellImpl("IT_NUM"));
        headerCells.add(new CellImpl("IT_NAME"));
        if (this.milestonesEnabled) {
            headerCells.add(new CellImpl("IT_MILESTONE"));
        }
        headerCells.add(new CellImpl("IT_SCHEDULED_START_ON"));
        headerCells.add(new CellImpl("IT_SCHEDULED_END_ON"));
        headerCells.add(new CellImpl("IT_ACTUAL_START_ON"));
        headerCells.add(new CellImpl("IT_ACTUAL_END_ON"));
        headerCells.add(new CellImpl("TC_ID"));
        headerCells.add(new CellImpl("TC_NAME"));
        headerCells.add(new CellImpl("TC_PROJECT_ID"));
        headerCells.add(new CellImpl("TC_PROJECT"));
        if (this.milestonesEnabled) {
            headerCells.add(new CellImpl("TC_MILESTONE"));
        }
        headerCells.add(new CellImpl("TC_WEIGHT"));
        headerCells.add(new CellImpl("TEST_SUITE"));
        headerCells.add(new CellImpl("#_EXECUTIONS"));
        headerCells.add(new CellImpl("#_REQUIREMENTS"));
        headerCells.add(new CellImpl("#_ISSUES"));
        headerCells.add(new CellImpl("DATASET"));
        headerCells.add(new CellImpl("EXEC_STATUS"));
        headerCells.add(new CellImpl("EXEC_LOGIN"));
        headerCells.add(new CellImpl("EXECUTION_DATE"));
        headerCells.add(new CellImpl("TC_REF"));
        headerCells.add(new CellImpl("TC_NATURE"));
        headerCells.add(new CellImpl("TC_TYPE"));
        headerCells.add(new CellImpl("TC_STATUS"));
        headerCells.add(new CellImpl("STEP_ID"));
        headerCells.add(new CellImpl("STEP_NUM"));
        headerCells.add(new CellImpl("STEP_#_REQ"));
        headerCells.add(new CellImpl("EXEC_STEP_STATUS"));
        headerCells.add(new CellImpl("EXEC_STEP_DATE"));
        headerCells.add(new CellImpl("EXEC_STEP_USER"));
        headerCells.add(new CellImpl("EXEC_STEP_#_ISSUES"));
        headerCells.add(new CellImpl("EXEC_STEP_COMMENT"));
        for (CustomFieldDto cufModel : this.campCUFModel) {
            headerCells.add(new CellImpl("CPG_CUF_" + cufModel.getCode()));
        }
        for (CustomFieldDto cufModel : this.iterCUFModel) {
            headerCells.add(new CellImpl("IT_CUF_" + cufModel.getCode()));
        }
        for (CustomFieldDto cufModel : this.tcCUFModel) {
            headerCells.add(new CellImpl("TC_CUF_" + cufModel.getCode()));
        }
        for (CustomFieldDto cufModel : this.execCUFModel) {
            headerCells.add(new CellImpl("HEADER_EXEC_CUF_" + cufModel.getCode()));
        }
        for (CustomFieldDto cufModel : this.esCUFModel) {
            headerCells.add(new CellImpl("STEP_CUF_" + cufModel.getCode()));
        }
        return new RowImpl(headerCells, this.separator);
    }

    public Iterator<CampaignExportCSVModel.Row> dataIterator() {
        return new DataIterator();
    }

    private class DataIterator
    implements Iterator<CampaignExportCSVModel.Row> {
        private static final String N_A = "n/a";
        private IterationDto iteration = null;
        private ITPIDto itp = null;
        private ExecutionDto exec = null;
        private ExecutionStepDto execStep = null;
        private TestStepDto testStep = null;
        private int iterIndex = -1;
        private int itpIndex = -1;
        private int stepIndex = -1;
        private int testStepIndex = -1;
        private boolean globalHasNext = true;
        private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        private List<CellImpl> cachedItpcellFixed = new ArrayList<CellImpl>(17);
        private List<CellImpl> cachedItpcellCuf;
        private boolean cachedItpcellReady;
        private int logcount;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

        public DataIterator() {
            this.cachedItpcellCuf = new ArrayList<CellImpl>(CampaignExportCSVFullModelImpl.this.iterCUFModel.size());
            this.cachedItpcellReady = false;
            this.logcount = 0;
            this.moveToNextStep();
        }

        @Override
        public CampaignExportCSVModel.Row next() {
            ArrayList<CellImpl> dataCells = new ArrayList<CellImpl>(CampaignExportCSVFullModelImpl.this.nbColumns);
            this.populateCampaignFixedRowData(dataCells);
            this.populateIterationFixedRowData(dataCells);
            this.populateTestCaseFixedRowData(dataCells);
            this.populateTestStepFixedRowData(dataCells);
            this.populateCampaignCUFRowData(dataCells);
            this.populateIterationCUFRowData(dataCells);
            this.populateTestCaseCUFRowData(dataCells);
            this.populateExecutionCUFRowData(dataCells);
            this.populateExecutionStepCUFRowData(dataCells);
            this.moveToNextStep();
            ++this.logcount;
            if (this.logcount % 99 == 0) {
                LOGGER.info("Campaign full export: processed {} lines out of {} (maximum estimate)", new Object[]{this.logcount + 1, CampaignExportCSVFullModelImpl.this.nbRows + 1});
            }
            return new RowImpl(dataCells, CampaignExportCSVFullModelImpl.this.separator);
        }

        private void populateExecutionCUFRowData(List<CellImpl> dataCells) {
            ExecutionDto exe = this.exec;
            if (exe != null) {
                Collection execValues = (Collection)CampaignExportCSVFullModelImpl.this.execCUFValues.get((Object)this.exec.getId());
                for (CustomFieldDto model : CampaignExportCSVFullModelImpl.this.execCUFModel) {
                    String strValue = this.getValue(execValues, model);
                    dataCells.add(new CellImpl(strValue));
                }
            }
        }

        private void populateExecutionStepCUFRowData(List<CellImpl> dataCells) {
            ExecutionStepDto eStep = this.execStep;
            if (eStep != null) {
                Collection esValues = (Collection)CampaignExportCSVFullModelImpl.this.esCUFValues.get((Object)this.execStep.getId());
                for (CustomFieldDto model : CampaignExportCSVFullModelImpl.this.esCUFModel) {
                    String strValue = this.getValue(esValues, model);
                    dataCells.add(new CellImpl(strValue));
                }
            }
        }

        private void populateTestCaseCUFRowData(List<CellImpl> dataCells) {
            if (this.cachedItpcellReady) {
                dataCells.addAll(this.cachedItpcellCuf);
            } else {
                TestCaseDto testCase = this.itp.getTestCase();
                Collection tcValues = (Collection)CampaignExportCSVFullModelImpl.this.tcCUFValues.get((Object)testCase.getId());
                for (CustomFieldDto model : CampaignExportCSVFullModelImpl.this.tcCUFModel) {
                    String strValue = this.getValue(tcValues, model);
                    CellImpl cell = new CellImpl(strValue);
                    dataCells.add(cell);
                    this.cachedItpcellCuf.add(cell);
                }
                this.cachedItpcellReady = true;
            }
        }

        private void populateIterationCUFRowData(List<CellImpl> dataCells) {
            Collection iValues = (Collection)CampaignExportCSVFullModelImpl.this.iterCUFValues.get((Object)this.iteration.getId());
            for (CustomFieldDto model : CampaignExportCSVFullModelImpl.this.iterCUFModel) {
                String strValue = this.getValue(iValues, model);
                dataCells.add(new CellImpl(strValue));
            }
        }

        private void populateCampaignCUFRowData(List<CellImpl> dataCells) {
            for (CustomFieldDto model : CampaignExportCSVFullModelImpl.this.campCUFModel) {
                String strValue = this.getCampaignCufValue((CustomFieldValueDto)CampaignExportCSVFullModelImpl.this.campCUFValues.get(model.getId()), model);
                dataCells.add(new CellImpl(strValue));
            }
        }

        private void populateTestStepFixedRowData(List<CellImpl> dataCells) {
            if (this.execStep == null && this.testStep != null) {
                dataCells.add(new CellImpl(N_A));
                dataCells.add(new CellImpl(String.valueOf(this.testStepIndex + 1)));
                dataCells.add(new CellImpl(this.formatStepRequirements()));
                dataCells.add(new CellImpl(N_A));
                dataCells.add(new CellImpl(N_A));
                dataCells.add(new CellImpl(N_A));
                dataCells.add(new CellImpl(N_A));
                dataCells.add(new CellImpl(N_A));
            } else if (this.execStep != null) {
                dataCells.add(new CellImpl(Long.toString(this.execStep.getId())));
                dataCells.add(new CellImpl(String.valueOf(this.stepIndex + 1)));
                dataCells.add(new CellImpl(this.formatStepRequirements()));
                dataCells.add(new CellImpl(this.execStep.getStatus()));
                dataCells.add(new CellImpl(this.formatDate(this.execStep.getLastExecutedOn())));
                dataCells.add(new CellImpl(this.execStep.getLastExecutedBy()));
                dataCells.add(new CellImpl(Integer.toString(this.execStep.getIssueSet().size())));
                ExecutionStepDto executionStepDto = this.execStep;
                JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)executionStepDto);
                Object[] objectArray = new Object[]{this, executionStepDto, joinPoint};
                CampaignExportCSVFullModelImpl$DataIterator$AjcClosure1 campaignExportCSVFullModelImpl$DataIterator$AjcClosure1 = new CampaignExportCSVFullModelImpl$DataIterator$AjcClosure1(objectArray);
                dataCells.add(new CellImpl(this.formatLongText((String)CleanHtmlAspect.aspectOf().aroundCleanHtmlMethodExecution(campaignExportCSVFullModelImpl$DataIterator$AjcClosure1.linkClosureAndJoinPoint(4112)))));
            } else {
                dataCells.add(new CellImpl(N_A));
                dataCells.add(new CellImpl(N_A));
                dataCells.add(new CellImpl(N_A));
                dataCells.add(new CellImpl(N_A));
                dataCells.add(new CellImpl(N_A));
                dataCells.add(new CellImpl(N_A));
                dataCells.add(new CellImpl(N_A));
                dataCells.add(new CellImpl(N_A));
            }
        }

        private String formatLongText(String text) {
            return text == null ? "" : text.trim();
        }

        private void populateTestCaseFixedRowData(List<CellImpl> dataCells) {
            if (this.cachedItpcellReady) {
                dataCells.addAll(this.cachedItpcellFixed);
            } else {
                TestCaseDto testCase = this.itp.getTestCase();
                ExecutionDto execution = this.itp.getLatestExecution();
                int issueNumber = execution != null ? execution.getIssueSet().size() : 0;
                this.cachedItpcellFixed.add(new CellImpl(testCase.getId().toString()));
                this.cachedItpcellFixed.add(new CellImpl(testCase.getName()));
                this.cachedItpcellFixed.add(new CellImpl(testCase.getProjectId().toString()));
                this.cachedItpcellFixed.add(new CellImpl(testCase.getProjectName()));
                if (CampaignExportCSVFullModelImpl.this.milestonesEnabled) {
                    this.cachedItpcellFixed.add(new CellImpl(this.formatMilestone(testCase.getMilestoneSet())));
                }
                this.cachedItpcellFixed.add(new CellImpl(testCase.getImportance()));
                this.cachedItpcellFixed.add(new CellImpl(this.itp.getTestSuiteNames()));
                this.cachedItpcellFixed.add(new CellImpl(Integer.toString(this.itp.getExecutionMap().size())));
                this.cachedItpcellFixed.add(new CellImpl(Integer.toString(testCase.getRequirementSet().size())));
                this.cachedItpcellFixed.add(new CellImpl(Integer.toString(issueNumber)));
                this.cachedItpcellFixed.add(new CellImpl(this.itp.getDataset()));
                this.cachedItpcellFixed.add(new CellImpl(this.itp.getStatus()));
                this.cachedItpcellFixed.add(new CellImpl(this.itp.getUserName()));
                this.cachedItpcellFixed.add(new CellImpl(this.formatDate(this.itp.getLastExecutedOn())));
                this.cachedItpcellFixed.add(new CellImpl(testCase.getReference()));
                this.cachedItpcellFixed.add(new CellImpl(testCase.getNature()));
                this.cachedItpcellFixed.add(new CellImpl(testCase.getType()));
                this.cachedItpcellFixed.add(new CellImpl(testCase.getStatus()));
                dataCells.addAll(this.cachedItpcellFixed);
            }
        }

        private void populateIterationFixedRowData(List<CellImpl> dataCells) {
            dataCells.add(new CellImpl(this.iteration.getId().toString()));
            dataCells.add(new CellImpl(String.valueOf(this.iterIndex + 1)));
            dataCells.add(new CellImpl(this.iteration.getName()));
            if (CampaignExportCSVFullModelImpl.this.milestonesEnabled) {
                dataCells.add(new CellImpl(this.formatMilestone(this.iteration.getMilestoneSet())));
            }
            dataCells.add(new CellImpl(this.formatDate(this.iteration.getScheduledStartDate())));
            dataCells.add(new CellImpl(this.formatDate(this.iteration.getScheduledEndDate())));
            dataCells.add(new CellImpl(this.formatDate(this.iteration.getActualStartDate())));
            dataCells.add(new CellImpl(this.formatDate(this.iteration.getActualEndDate())));
        }

        private void populateCampaignFixedRowData(List<CellImpl> dataCells) {
            dataCells.add(new CellImpl(this.formatDate(CampaignExportCSVFullModelImpl.this.campaign.getScheduledStartDate())));
            dataCells.add(new CellImpl(this.formatDate(CampaignExportCSVFullModelImpl.this.campaign.getScheduledEndDate())));
            dataCells.add(new CellImpl(this.formatDate(CampaignExportCSVFullModelImpl.this.campaign.getActualStartDate())));
            dataCells.add(new CellImpl(this.formatDate(CampaignExportCSVFullModelImpl.this.campaign.getActualEndDate())));
        }

        private String formatMilestone(Set<String> milestones) {
            StringBuilder sb = new StringBuilder();
            for (String m : milestones) {
                sb.append(m);
                sb.append("|");
            }
            sb.setLength(Math.max(sb.length() - 1, 0));
            return sb.toString();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private String getCampaignCufValue(CustomFieldValueDto customFieldValueDto, CustomFieldDto model) {
            if (customFieldValueDto != null && customFieldValueDto.getValue() != null) {
                if ("NUMERIC".equals(model.getInputType())) {
                    return NumericCufHelper.formatOutputNumericCufValue(customFieldValueDto.getValue());
                }
                return customFieldValueDto.getValue();
            }
            return "";
        }

        private String getValue(Collection<CustomFieldValueDto> values, CustomFieldDto model) {
            if (values != null) {
                return this.formatOutputValue(model, values);
            }
            return "--";
        }

        private String formatOutputValue(CustomFieldDto model, Collection<CustomFieldValueDto> values) {
            for (CustomFieldValueDto value : values) {
                Long customFieldId = value.getCufId();
                if (customFieldId != model.getId()) continue;
                if ("NUMERIC".equals(model.getInputType())) {
                    return NumericCufHelper.formatOutputNumericCufValue(value.getValue());
                }
                return value.getValue();
            }
            return "";
        }

        private String formatDate(Date date) {
            return date == null ? "" : this.dateFormat.format(date);
        }

        private String formatStepRequirements() {
            String res = this.execStep != null ? Integer.toString(this.execStep.getRequirementSet().size()) : (this.testStep != null ? Integer.toString(this.testStep.getRequirementSet().size()) : "?");
            return res;
        }

        @Override
        public boolean hasNext() {
            return this.globalHasNext;
        }

        private void moveToNextStep() {
            boolean foundNextStep;
            do {
                if (this.execStep != null || this.testStep != null) continue;
                boolean nextTCSucc = this.moveToNextTestCase();
                if (!nextTCSucc) {
                    this.globalHasNext = false;
                    return;
                }
                this.resetCachedItpcell();
                this.resetStepIndex();
                this.resetTestStepIndex();
            } while (!(foundNextStep = this.itp.getLatestExecution() != null ? this.findNextSuitableStepFromLatestExecution() : this.findNextSuitableStepFromTestCaseSteps()));
        }

        private boolean findNextSuitableStepFromLatestExecution() {
            boolean foundNextStep = false;
            this.exec = this.itp.getLatestExecution();
            List<ExecutionStepDto> steps = this.exec.getSteps().values().stream().sorted(Comparator.comparingInt(ExecutionStepDto::getStepOrder)).toList();
            int stepsSize = steps.size();
            ++this.stepIndex;
            if (this.stepIndex < stepsSize) {
                this.execStep = steps.get(this.stepIndex);
                this.testStep = null;
                foundNextStep = true;
            } else if (stepsSize == 0) {
                this.execStep = null;
                this.testStep = null;
                foundNextStep = true;
            } else {
                this.execStep = null;
                this.testStep = null;
            }
            return foundNextStep;
        }

        private boolean findNextSuitableStepFromTestCaseSteps() {
            boolean foundNextStep = false;
            this.exec = null;
            TestCaseDto testCase = this.itp.getTestCase();
            List<TestStepDto> testSteps = this.getActionTestStepList(testCase);
            int actionTestStepSize = testSteps.size();
            ++this.testStepIndex;
            if (this.testStepIndex < actionTestStepSize) {
                this.testStep = testSteps.get(this.testStepIndex);
                foundNextStep = true;
            } else if (actionTestStepSize == 0) {
                this.testStep = null;
                foundNextStep = true;
            } else {
                this.testStep = null;
            }
            this.execStep = null;
            return foundNextStep;
        }

        private List<TestStepDto> getActionTestStepList(TestCaseDto testCase) {
            ArrayList<TestStepDto> result = new ArrayList<TestStepDto>();
            Iterator<Record> tcSteps = this.getTestCaseStepsJooqQueryIterator(testCase.getId());
            while (tcSteps.hasNext()) {
                TestStepDto stepDto = CampaignExportCSVFullModelImpl.this.createTestStepDto(tcSteps.next());
                result.add(stepDto);
            }
            return result;
        }

        Iterator<Record> getTestCaseStepsJooqQueryIterator(Long testCaseId) {
            CommonTableExpression cte = DSL.name((String)"cte").fields("TCLN_ID", "STEP_ORDER", "STEP_ID", "CALLED_TEST_CASE_ID", "REQUIREMENT_VERSION_COVERAGE_ID").as((ResultQuery)CampaignExportCSVFullModelImpl.this.dsl.select(AbstractCampaignExportCSVModel.TC_ID, AbstractCampaignExportCSVModel.TS_ORDER, AbstractCampaignExportCSVModel.TS_ID, AbstractCampaignExportCSVModel.CTS_CALLED_TS, AbstractCampaignExportCSVModel.TS_REQUIREMENT_VERIFIED).from((TableLike)Tables.TEST_CASE).leftJoin((TableLike)Tables.TEST_CASE_STEPS).on(Tables.TEST_CASE_STEPS.TEST_CASE_ID.eq(AbstractCampaignExportCSVModel.TC_ID)).leftJoin((TableLike)Tables.CALL_TEST_STEP).on(Tables.CALL_TEST_STEP.TEST_STEP_ID.eq(AbstractCampaignExportCSVModel.TS_ID)).leftJoin((TableLike)Tables.ACTION_TEST_STEP).on(Tables.ACTION_TEST_STEP.TEST_STEP_ID.eq(AbstractCampaignExportCSVModel.TS_ID)).leftJoin((TableLike)Tables.VERIFYING_STEPS.as(CampaignExportCSVFullModelImpl.TS_VERIFYING_STEP)).on(Tables.VERIFYING_STEPS.as((String)CampaignExportCSVFullModelImpl.TS_VERIFYING_STEP).TEST_STEP_ID.eq((Field)Tables.ACTION_TEST_STEP.TEST_STEP_ID)).leftJoin((TableLike)Tables.REQUIREMENT_VERSION_COVERAGE.as(CampaignExportCSVFullModelImpl.TS_RVC)).on(AbstractCampaignExportCSVModel.TS_REQUIREMENT_VERIFIED.eq((Field)Tables.VERIFYING_STEPS.as((String)CampaignExportCSVFullModelImpl.TS_VERIFYING_STEP).REQUIREMENT_VERSION_COVERAGE_ID)).where(AbstractCampaignExportCSVModel.TC_ID.eq((Object)testCaseId)).unionAll((Select)DSL.select((SelectField)DSL.field((Name)DSL.name((String[])new String[]{"cte", "TCLN_ID"}), Long.class), (SelectField)DSL.field((Name)DSL.name((String[])new String[]{CampaignExportCSVFullModelImpl.TCS, "STEP_ORDER"}), Integer.class), (SelectField)DSL.field((Name)DSL.name((String[])new String[]{CampaignExportCSVFullModelImpl.TCS, "STEP_ID"}), Long.class), (SelectField)DSL.field((Name)DSL.name((String[])new String[]{CampaignExportCSVFullModelImpl.CTP, "CALLED_TEST_CASE_ID"}), Long.class), (SelectField)DSL.field((Name)DSL.name((String[])new String[]{"cte", "REQUIREMENT_VERSION_COVERAGE_ID"}), Long.class)).from(DSL.name((String)"cte")).join((TableLike)Tables.CALL_TEST_STEP.as(CampaignExportCSVFullModelImpl.CTP)).on(DSL.field((Name)DSL.name((String[])new String[]{"cte", "STEP_ID"})).eq(DSL.field((Name)DSL.name((String[])new String[]{CampaignExportCSVFullModelImpl.CTP, "TEST_STEP_ID"})))).join((TableLike)Tables.TEST_CASE_STEPS.as(CampaignExportCSVFullModelImpl.TCS)).on(DSL.field((Name)DSL.name((String[])new String[]{CampaignExportCSVFullModelImpl.CTP, "CALLED_TEST_CASE_ID"})).eq(DSL.field((Name)DSL.name((String[])new String[]{CampaignExportCSVFullModelImpl.TCS, "TEST_CASE_ID"}))))));
            return CampaignExportCSVFullModelImpl.this.dsl.withRecursive(new CommonTableExpression[]{cte}).select(new SelectFieldOrAsterisk[0]).from((TableLike)cte).leftJoin((TableLike)Tables.CALL_TEST_STEP).on(Tables.CALL_TEST_STEP.TEST_STEP_ID.eq(cte.field("STEP_ID", Long.class))).where(Tables.CALL_TEST_STEP.TEST_STEP_ID.eq((Object)testCaseId).isNull()).orderBy((OrderField)DSL.field((String)"STEP_ORDER")).fetch().iterator();
        }

        private boolean moveToNextTestCase() {
            boolean foundNextTC;
            do {
                if (this.itp == null) {
                    boolean nextIterSucc = this.moveToNextIteration();
                    if (!nextIterSucc) {
                        return false;
                    }
                    this.resetTCIndex();
                }
                List<ITPIDto> items = this.iteration.getTestPlanList();
                int itemSize = items.size();
                ++this.itpIndex;
                if (this.itpIndex >= itemSize) {
                    this.itp = null;
                    foundNextTC = false;
                    continue;
                }
                if (items.get(this.itpIndex).isTestCaseDeleted()) {
                    foundNextTC = false;
                    continue;
                }
                this.itp = items.get(this.itpIndex);
                foundNextTC = true;
            } while (!foundNextTC);
            return foundNextTC;
        }

        private boolean moveToNextIteration() {
            boolean foundIter = false;
            ++this.iterIndex;
            List<IterationDto> iterations = CampaignExportCSVFullModelImpl.this.campaignDto.getIterationList();
            int iterSize = iterations.size();
            if (this.iterIndex < iterSize) {
                this.iteration = iterations.get(this.iterIndex);
                foundIter = true;
            }
            return foundIter;
        }

        private void resetStepIndex() {
            this.stepIndex = -1;
        }

        private void resetTestStepIndex() {
            this.testStepIndex = -1;
        }

        private void resetTCIndex() {
            this.itpIndex = -1;
        }

        private void resetCachedItpcell() {
            this.cachedItpcellFixed.clear();
            this.cachedItpcellCuf.clear();
            this.cachedItpcellReady = false;
        }

        static {
            DataIterator.ajc$preClinit();
        }

        static final /* synthetic */ String getComment_aroundBody0(DataIterator dataIterator, ExecutionStepDto executionStepDto, JoinPoint joinPoint) {
            return executionStepDto.getComment();
        }

        private static /* synthetic */ void ajc$preClinit() {
            Factory factory = new Factory("CampaignExportCSVFullModelImpl.java", DataIterator.class);
            ajc$tjp_0 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("1", "getComment", "org.squashtest.tm.service.internal.dto.ExecutionStepDto", "", "", "", "java.lang.String"), 925);
        }
    }
}

