/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.campaign;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jooq.DSLContext;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.api.security.acls.Permissions;
import org.squashtest.tm.core.foundation.exception.ActionException;
import org.squashtest.tm.core.foundation.lang.Wrapped;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.campaign.TestPlanOwner;
import org.squashtest.tm.domain.campaign.testplan.TestPlanItem;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.domain.script.GherkinParser;
import org.squashtest.tm.domain.testcase.ExploratoryTestCase;
import org.squashtest.tm.domain.testcase.KeywordTestCase;
import org.squashtest.tm.domain.testcase.ScriptedTestCase;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestCaseVisitor;
import org.squashtest.tm.exception.execution.ExecutionHasNoStepsException;
import org.squashtest.tm.exception.execution.TestPlanItemNotExecutableException;
import org.squashtest.tm.exception.execution.TestPlanTerminatedOrNoStepsException;
import org.squashtest.tm.security.UserContextHolder;
import org.squashtest.tm.service.campaign.ExecutionCreationService;
import org.squashtest.tm.service.campaign.TestPlanExecutionProcessingService;
import org.squashtest.tm.service.internal.campaign.CampaignNodeDeletionHandler;
import org.squashtest.tm.service.internal.display.dto.execution.TestPlanResume;
import org.squashtest.tm.service.internal.display.grid.GridFilterValue;
import org.squashtest.tm.service.internal.display.grid.GridRequest;
import org.squashtest.tm.service.internal.display.grid.GridResponse;
import org.squashtest.tm.service.internal.repository.TestPlanItemDao;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.service.security.SecurityCheckableObject;

public abstract class AbstractTestPlanExecutionProcessingService<E extends TestPlanOwner, T extends TestPlanResume>
implements TestPlanExecutionProcessingService<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractTestPlanExecutionProcessingService.class);
    private static final String EXECUTION_CREATION_FAILED_MSG = "Failed to create execution for test plan item {}";
    private final CampaignNodeDeletionHandler campaignDeletionHandler;
    protected final TestPlanItemDao testPlanItemDao;
    protected final PermissionEvaluationService permissionEvaluationService;
    private final ExecutionCreationService executionCreationService;
    protected final DSLContext dslContext;

    AbstractTestPlanExecutionProcessingService(CampaignNodeDeletionHandler campaignDeletionHandler, PermissionEvaluationService permissionEvaluationService, TestPlanItemDao testPlanItemDao, DSLContext dslContext, ExecutionCreationService executionCreationService) {
        this.campaignDeletionHandler = campaignDeletionHandler;
        this.permissionEvaluationService = permissionEvaluationService;
        this.testPlanItemDao = testPlanItemDao;
        this.dslContext = dslContext;
        this.executionCreationService = executionCreationService;
    }

    protected void deleteAllExecutions(long testPlanOwnerId) {
        E testPlanOwner = this.getTestPlanOwner(testPlanOwnerId);
        String testerLogin = this.findUserLoginIfTester(testPlanOwner);
        this.deleteAllExecutions(testPlanOwner, testerLogin);
    }

    private void deleteAllExecutions(E testPlanOwner, String testerLogin) {
        List items = testPlanOwner.getTestPlanItems();
        if (!items.isEmpty()) {
            this.deleteAllExecutionsOfTestPlan(items, testerLogin);
        }
    }

    private void deleteAllExecutionsOfTestPlan(List<TestPlanItem> items, String testerLogin) {
        for (TestPlanItem item : items) {
            Set executions;
            if (testerLogin != null && (item.getAssignee() == null || !item.getAssignee().getLogin().equals(testerLogin)) || (executions = item.getExecutions()).isEmpty()) continue;
            this.campaignDeletionHandler.deleteExecutions(executions.stream().toList());
        }
    }

    @Override
    public T startResumeNextExecution(long testPlanOwnerId, long testPlanItemId, boolean deletePrevious) {
        E testPlanOwner = this.getTestPlanOwner(testPlanOwnerId);
        if (deletePrevious) {
            String testerLogin = this.findUserLoginIfTester(testPlanOwner);
            TestPlanItem item = testPlanOwner.findNextExecutableTestPlanItem(testPlanItemId, testerLogin);
            Execution execution = this.findUnexecutedOrCreateExecution(item);
            while (execution == null || execution.getSteps().isEmpty()) {
                item = testPlanOwner.findNextExecutableTestPlanItem(item.getId().longValue(), testerLogin);
                execution = this.findUnexecutedOrCreateExecution(item);
            }
            boolean hasNextTestCase = this.hasNextTestCase(testPlanOwner, testerLogin, execution);
            return this.createNewTestPlanResume(testPlanOwnerId, execution, hasNextTestCase);
        }
        List testPlanItems = testPlanOwner.getTestPlanItems();
        TestPlanItem item = this.getTestPlanItem(testPlanItemId);
        TestPlanItem nextTestPlanItem = this.findNextTestPlanItem(item, testPlanItems);
        Execution execution = this.createExecutionForTestPlanItem(nextTestPlanItem);
        while (execution == null || execution.getSteps().isEmpty()) {
            nextTestPlanItem = this.findNextTestPlanItem(nextTestPlanItem, testPlanItems);
            execution = this.createExecutionForTestPlanItem(nextTestPlanItem);
        }
        boolean hasNext = this.findNextTestPlanItem(nextTestPlanItem, testPlanItems) != null;
        return this.createNewTestPlanResume(testPlanOwnerId, execution, hasNext);
    }

    private TestPlanItem findNextTestPlanItem(TestPlanItem currentItem, List<TestPlanItem> items) {
        if (items == null || items.isEmpty() || currentItem == null) {
            return null;
        }
        int i = 0;
        while (i < items.size()) {
            if (items.get(i).equals(currentItem)) {
                return i + 1 < items.size() ? items.get(i + 1) : null;
            }
            ++i;
        }
        return null;
    }

    private TestPlanItem getTestPlanItem(long testPlanItemId) {
        return this.testPlanItemDao.findById(testPlanItemId).orElse(null);
    }

    private Execution startResumeNextExecutionOfFilteredTestPlan(long testPlanOwnerId, long testPlanItemId, List<TestPlanItem> partialTestPlan, boolean deletePrevious) {
        if (deletePrevious) {
            E transientTestPlanOwner = this.createTransientTestPlanOwnerWithFilteredTestPlan(testPlanOwnerId, partialTestPlan);
            String testerLogin = this.findUserLoginIfTester(testPlanOwnerId, transientTestPlanOwner.getClass().getName());
            TestPlanItem item = transientTestPlanOwner.findNextExecutableTestPlanItem(testPlanItemId, testerLogin);
            Execution execution = this.findUnexecutedOrCreateExecution(item);
            while (execution == null || execution.getSteps().isEmpty()) {
                item = transientTestPlanOwner.findNextExecutableTestPlanItem(item.getId().longValue());
                execution = this.findUnexecutedOrCreateExecution(item);
            }
            return execution;
        }
        TestPlanItem item = this.getTestPlanItem(testPlanItemId);
        TestPlanItem nextTestPlanItem = this.findNextTestPlanItem(item, partialTestPlan);
        Execution execution = this.createExecutionForTestPlanItem(nextTestPlanItem);
        while (execution == null || execution.getSteps().isEmpty()) {
            nextTestPlanItem = this.findNextTestPlanItem(nextTestPlanItem, partialTestPlan);
            execution = this.createExecutionForTestPlanItem(nextTestPlanItem);
        }
        return execution;
    }

    private boolean partialTestPlanIdsHasNextTestCase(long testPlanOwnerId, Execution execution, List<TestPlanItem> partialTestPlan) {
        boolean hasNextTestCase = false;
        if (Objects.nonNull(execution)) {
            hasNextTestCase = this.partialTestPlanIdsHaveMoreExecutableItems(testPlanOwnerId, execution.getTestPlanItem().getId(), partialTestPlan);
        }
        return hasNextTestCase;
    }

    private boolean partialTestPlanHasNextTestCase(long testPlanOwnerId, Execution execution, List<TestPlanItem> partialTestPlan) {
        if (execution == null) {
            return false;
        }
        return this.partialTestPlanHasMoreExecutableItems(testPlanOwnerId, execution.getTestPlanItem().getId(), partialTestPlan);
    }

    protected boolean hasNextTestCase(E testPlanOwner, String testerLogin, Execution execution) {
        if (execution == null) {
            return false;
        }
        Long testPlanItemId = execution.getTestPlanItem().getId();
        return !this.isLastExecutableTestPlanItem(testPlanOwner, testPlanItemId, testerLogin);
    }

    protected T commonStartResume(long testPlanOwnerId) {
        if (this.hasDeletedTestCaseInTestPlan(testPlanOwnerId)) {
            throw this.getTestPlanHasDeletedTestCaseException();
        }
        E testPlanOwner = this.getTestPlanOwner(testPlanOwnerId);
        String testerLogin = this.findUserLoginIfTester(testPlanOwner);
        return this.startResume(testPlanOwner, testPlanOwnerId, testerLogin);
    }

    private T startResume(E testPlanOwner, long testPlanOwnerId, String testerLogin) {
        Execution execution;
        try {
            TestPlanItem item = testPlanOwner.findFirstExecutableTestPlanItem(testerLogin);
            execution = this.findUnexecutedOrCreateExecution(item);
            if (execution == null || execution.getSteps().isEmpty()) {
                execution = this.startResumeNextExecution(testPlanOwner, testerLogin, item.getId());
            }
        }
        catch (TestPlanItemNotExecutableException e) {
            throw new TestPlanTerminatedOrNoStepsException((Exception)((Object)e));
        }
        boolean hasNextTestCase = this.hasNextTestCase(testPlanOwner, testerLogin, execution);
        return this.createNewTestPlanResume(testPlanOwnerId, execution, hasNextTestCase);
    }

    private Execution startResumeNextExecution(E testPlanOwner, String testerLogin, long testPlanItemId) {
        TestPlanItem item = testPlanOwner.findNextExecutableTestPlanItem(testPlanItemId, testerLogin);
        Execution execution = this.findUnexecutedOrCreateExecution(item);
        while (execution == null || execution.getSteps().isEmpty()) {
            item = testPlanOwner.findNextExecutableTestPlanItem(item.getId().longValue());
            execution = this.findUnexecutedOrCreateExecution(item);
        }
        return execution;
    }

    private Execution startResumePartialTestPlan(long testPlanOwnerId, List<TestPlanItem> partialTestPlan) {
        String testerLogin;
        E transientTestPlanOwner = this.createTransientTestPlanOwnerWithFilteredTestPlan(testPlanOwnerId, partialTestPlan);
        TestPlanItem item = transientTestPlanOwner.findFirstExecutableTestPlanItem(testerLogin = this.findUserLoginIfTester(testPlanOwnerId, transientTestPlanOwner.getClass().getName()));
        Execution execution = this.findUnexecutedOrCreateExecution(item);
        if (execution == null || execution.getSteps().isEmpty()) {
            this.startResumeNextExecution(testPlanOwnerId, item.getId(), true);
        }
        return execution;
    }

    private Execution checkValidityThenResumeFilteredTestPlan(long iterationId, List<TestPlanItem> partialTestPlan) {
        boolean hasDeletedTestCaseInFilteredSelection = this.hasDeletedTestCaseInFilteredSelection(partialTestPlan);
        if (!hasDeletedTestCaseInFilteredSelection) {
            try {
                return this.startResumePartialTestPlan(iterationId, partialTestPlan);
            }
            catch (ExecutionHasNoStepsException | TestPlanItemNotExecutableException ex) {
                throw new TestPlanTerminatedOrNoStepsException((Exception)ex);
            }
        }
        throw this.getTestPlanHasDeletedTestCaseException();
    }

    abstract ActionException getTestPlanHasDeletedTestCaseException();

    abstract List<TestPlanItem> getFilteredTestPlan(long var1, List<GridFilterValue> var3);

    protected GridRequest prepareNonPaginatedGridRequest(List<GridFilterValue> filters) {
        GridRequest gridRequest = new GridRequest();
        gridRequest.setFilterValues(filters);
        return gridRequest.toNonPaginatedRequest();
    }

    protected List<Long> extractItemIdsFromGridResponse(GridResponse gridResponse) {
        return gridResponse.getDataRows().stream().map(row -> Long.valueOf(row.getId())).toList();
    }

    protected List<Long> extractItemIdsFromPartialTestPlan(List<TestPlanItem> partialTestPlan) {
        return partialTestPlan.stream().map(TestPlanItem::getId).toList();
    }

    @Override
    public T relaunch(long testPlanOwnerId, boolean deletePrevious) {
        if (this.hasDeletedTestCaseInTestPlan(testPlanOwnerId)) {
            throw this.getTestPlanHasDeletedTestCaseException();
        }
        try {
            E testPlanOwner = this.getTestPlanOwner(testPlanOwnerId);
            String testerLogin = this.findUserLoginIfTester(testPlanOwner);
            if (deletePrevious) {
                this.deleteAllExecutions(testPlanOwner, testerLogin);
                return this.startResume(testPlanOwner, testPlanOwnerId, testerLogin);
            }
            return this.relaunchWithoutDeletion(testPlanOwnerId, testerLogin);
        }
        catch (ExecutionHasNoStepsException | TestPlanItemNotExecutableException e) {
            throw new TestPlanTerminatedOrNoStepsException((Exception)e);
        }
    }

    @Override
    @Transactional
    public TestPlanResume relaunchFilteredTestPlan(long testPlanOwnerId, List<GridFilterValue> filters, boolean deletePrevious) {
        Execution execution;
        E testPlanOwner = this.getTestPlanOwner(testPlanOwnerId);
        this.checkExecutePermission(testPlanOwner);
        List<TestPlanItem> partialTestPlan = this.getFilteredTestPlan(testPlanOwnerId, filters);
        if (deletePrevious) {
            execution = this.checkValidityThenRelaunchFilteredTestPlan(testPlanOwnerId, partialTestPlan);
        } else {
            String testerLogin = this.findUserLoginIfTester(testPlanOwner);
            execution = this.relaunchFilteredTestPlanWithoutDeletion(partialTestPlan, testerLogin);
        }
        boolean hasNextTestCase = deletePrevious ? this.partialTestPlanHasNextTestCase(testPlanOwnerId, execution, partialTestPlan) : execution != null && this.findNextTestPlanItem(execution.getTestPlanItem(), partialTestPlan) != null;
        return this.createNewTestPlanResume(testPlanOwnerId, execution, hasNextTestCase, this.extractItemIdsFromPartialTestPlan(partialTestPlan));
    }

    public T relaunchWithoutDeletion(long testPlanOwnerId, String testerLogin) {
        E testPlanOwner = this.getTestPlanOwner(testPlanOwnerId);
        this.checkExecutePermission(testPlanOwner);
        TestPlanItem item = (TestPlanItem)testPlanOwner.getTestPlanItems().getFirst();
        if (testerLogin != null && !item.isAssignedToUser(testerLogin)) {
            return null;
        }
        try {
            Execution execution = this.createExecutionForTestPlanItem(item);
            TestPlanItem nextTestPlanItem = item;
            while (execution == null || execution.getSteps().isEmpty()) {
                nextTestPlanItem = this.findNextTestPlanItem(nextTestPlanItem, testPlanOwner.getTestPlanItems());
                execution = this.createExecutionForTestPlanItem(nextTestPlanItem);
            }
            boolean hasNext = this.findNextTestPlanItem(nextTestPlanItem, testPlanOwner.getTestPlanItems()) != null;
            return this.createNewTestPlanResume(testPlanOwnerId, execution, hasNext);
        }
        catch (ExecutionHasNoStepsException | TestPlanItemNotExecutableException e) {
            LOGGER.warn(EXECUTION_CREATION_FAILED_MSG, new Object[]{item.getId(), e});
            return null;
        }
    }

    private Execution relaunchFilteredTestPlanWithoutDeletion(List<TestPlanItem> partialTestPlan, String testerLogin) {
        if (this.hasDeletedTestCaseInFilteredSelection(partialTestPlan)) {
            throw this.getTestPlanHasDeletedTestCaseException();
        }
        if (partialTestPlan.isEmpty()) {
            return null;
        }
        TestPlanItem item = partialTestPlan.getFirst();
        if (testerLogin != null && !item.isAssignedToUser(testerLogin)) {
            return null;
        }
        try {
            Execution execution = this.createExecutionForTestPlanItem(item);
            TestPlanItem nextTestPlanItem = item;
            while (execution == null || execution.getSteps().isEmpty()) {
                nextTestPlanItem = this.findNextTestPlanItem(nextTestPlanItem, partialTestPlan);
                execution = this.createExecutionForTestPlanItem(nextTestPlanItem);
            }
            return execution;
        }
        catch (ExecutionHasNoStepsException | TestPlanItemNotExecutableException e) {
            LOGGER.warn(EXECUTION_CREATION_FAILED_MSG, new Object[]{item.getId(), e});
            return null;
        }
    }

    private Execution checkValidityThenRelaunchFilteredTestPlan(long testPlanOwnerId, List<TestPlanItem> partialTestPlan) {
        boolean hasDeletedTestCaseInFilteredSelection = this.hasDeletedTestCaseInFilteredSelection(partialTestPlan);
        if (!hasDeletedTestCaseInFilteredSelection) {
            try {
                return this.startRelaunchPartialTestPlan(testPlanOwnerId, partialTestPlan);
            }
            catch (ExecutionHasNoStepsException | TestPlanItemNotExecutableException ex) {
                throw new TestPlanTerminatedOrNoStepsException((Exception)ex);
            }
        }
        throw this.getTestPlanHasDeletedTestCaseException();
    }

    private Execution startRelaunchPartialTestPlan(long testPlanOwnerId, List<TestPlanItem> partialTestPlan) {
        this.deleteAllExecutionsOfPartialTestPlan(partialTestPlan, testPlanOwnerId);
        return this.startResumePartialTestPlan(testPlanOwnerId, partialTestPlan);
    }

    private void deleteAllExecutionsOfPartialTestPlan(List<TestPlanItem> partialTestPlan, long testPlanOwnerId) {
        E testPlanOwner = this.getTestPlanOwner(testPlanOwnerId);
        this.checkExecutePermission(testPlanOwner);
        String testerLogin = this.findUserLoginIfTester(testPlanOwner);
        this.deleteAllExecutionsOfTestPlan(partialTestPlan, testerLogin);
    }

    private boolean partialTestPlanIdsHaveMoreExecutableItems(long testPlanOwnerId, Long testPlanItemId, List<TestPlanItem> partialTestPlan) {
        E transientTestPlanOwner = this.createTransientTestPlanOwnerWithFilteredTestPlan(testPlanOwnerId, partialTestPlan);
        String testerLogin = this.findUserLoginIfTester(testPlanOwnerId, transientTestPlanOwner.getClass().getName());
        return !this.isLastExecutableTestPlanItem(transientTestPlanOwner, testPlanItemId, testerLogin);
    }

    private boolean partialTestPlanHasMoreExecutableItems(long testPlanOwnerId, Long testPlanItemId, List<TestPlanItem> partialTestPlan) {
        E transientTestPlanOwner = this.createTransientTestPlanOwnerWithFilteredTestPlan(testPlanOwnerId, partialTestPlan);
        String testerLogin = this.findUserLoginIfTester(testPlanOwnerId, transientTestPlanOwner.getClass().getName());
        return !this.isLastExecutableTestPlanItem(transientTestPlanOwner, testPlanItemId, testerLogin);
    }

    protected abstract E getTestPlanOwner(long var1);

    abstract E createTransientTestPlanOwnerWithFilteredTestPlan(long var1, List<TestPlanItem> var3);

    private boolean isLastExecutableTestPlanItem(E testPlanOwner, long testPlanItemId, String testerLogin) {
        List testPlans = testPlanOwner.getTestPlanItems();
        int i = testPlans.size() - 1;
        while (i >= 0) {
            TestPlanItem item = (TestPlanItem)testPlans.get(i);
            if (!item.isTestCaseDeleted()) {
                TestCase testCase = item.getReferencedTestCase();
                if (item.isExecutable() && this.testCaseHasSteps(testCase) && (testerLogin == null || item.isAssignedToUser(testerLogin))) {
                    return testPlanItemId == item.getId();
                }
            }
            --i;
        }
        return false;
    }

    private boolean testCaseHasSteps(final TestCase testCase) {
        final Wrapped hasSteps = new Wrapped();
        TestCaseVisitor visitor = new TestCaseVisitor(){

            public void visit(TestCase testCase2) {
                hasSteps.setValue((Object)(testCase2.getSteps() != null && !testCase2.getSteps().isEmpty() ? 1 : 0));
            }

            public void visit(KeywordTestCase keywordTestCase) {
                hasSteps.setValue((Object)(testCase.getSteps() != null && !testCase.getSteps().isEmpty() ? 1 : 0));
            }

            public void visit(ScriptedTestCase scriptedTestCase) {
                hasSteps.setValue((Object)(scriptedTestCase.getScript() != null && !scriptedTestCase.getScript().isEmpty() && AbstractTestPlanExecutionProcessingService.this.hasScenarios(scriptedTestCase) ? 1 : 0));
            }

            public void visit(ExploratoryTestCase exploratoryTestCase) {
                hasSteps.setValue((Object)false);
            }
        };
        testCase.accept(visitor);
        return (Boolean)hasSteps.getValue();
    }

    private boolean hasScenarios(ScriptedTestCase scriptedTestCase) {
        return GherkinParser.hasScenarios((String)scriptedTestCase.getScript());
    }

    private void checkExecutePermission(Object domainObject) {
        this.permissionEvaluationService.checkPermission(new SecurityCheckableObject(domainObject, Permissions.EXECUTE.name()));
    }

    private String findUserLoginIfTester(long domainObjectId, String domainObjectClass) {
        if (!this.permissionEvaluationService.hasRoleOrPermissionOnObject("ROLE_ADMIN", Permissions.READ_UNASSIGNED.name(), (Long)domainObjectId, domainObjectClass)) {
            return UserContextHolder.getUsername();
        }
        return null;
    }

    private String findUserLoginIfTester(Object domainObject) {
        if (!this.permissionEvaluationService.hasRoleOrPermissionOnObject("ROLE_ADMIN", Permissions.READ_UNASSIGNED.name(), domainObject)) {
            return UserContextHolder.getUsername();
        }
        return null;
    }

    private Execution findUnexecutedOrCreateExecution(TestPlanItem testPlanItem) {
        if (!testPlanItem.isExecutable()) {
            return null;
        }
        Execution execution = testPlanItem.getLatestExecution();
        if (execution != null) {
            return execution;
        }
        try {
            return this.executionCreationService.createManualExecution(testPlanItem.getId(), null);
        }
        catch (ExecutionHasNoStepsException | TestPlanItemNotExecutableException e) {
            LOGGER.warn(EXECUTION_CREATION_FAILED_MSG, new Object[]{testPlanItem.getId(), e});
            return null;
        }
    }

    private Execution createExecutionForTestPlanItem(TestPlanItem testPlanItem) {
        if (testPlanItem == null) {
            return null;
        }
        TestCase testCase = testPlanItem.getReferencedTestCase();
        if (testCase == null || !this.testCaseHasSteps(testCase)) {
            return null;
        }
        try {
            return this.executionCreationService.createManualExecution(testPlanItem.getId(), null);
        }
        catch (ExecutionHasNoStepsException | TestPlanItemNotExecutableException e) {
            LOGGER.warn(EXECUTION_CREATION_FAILED_MSG, new Object[]{testPlanItem.getId(), e});
            return null;
        }
    }

    protected boolean hasDeletedTestCaseInFilteredSelection(List<TestPlanItem> partialTestPlan) {
        return partialTestPlan.stream().anyMatch(item -> Objects.isNull(item.getReferencedTestCase()));
    }

    @Override
    public TestPlanResume resumeWithFilteredTestPlan(long testPlanOwnerId, List<GridFilterValue> filters) {
        E testPlanOwner = this.getTestPlanOwner(testPlanOwnerId);
        this.checkExecutePermission(testPlanOwner);
        List<TestPlanItem> partialTestPlan = this.getFilteredTestPlan(testPlanOwnerId, filters);
        Execution execution = this.checkValidityThenResumeFilteredTestPlan(testPlanOwnerId, partialTestPlan);
        boolean hasNextTestCase = this.partialTestPlanHasNextTestCase(testPlanOwnerId, execution, partialTestPlan);
        return this.createNewTestPlanResume(testPlanOwnerId, execution, hasNextTestCase, this.extractItemIdsFromPartialTestPlan(partialTestPlan));
    }

    protected abstract TestPlanResume createNewTestPlanResume(long var1, Execution var3, boolean var4, List<Long> var5);

    protected abstract T createNewTestPlanResume(long var1, Execution var3, boolean var4);

    @Override
    public TestPlanResume resumeNextExecutionOfFilteredTestPlan(long testPlanOwnerId, long testPlanItemId, List<Long> partialTestPlanItemIds, boolean deletePrevious) {
        E testPlanOwner = this.getTestPlanOwner(testPlanOwnerId);
        this.checkExecutePermission(testPlanOwner);
        List partialTestPlan = this.testPlanItemDao.findAllById(partialTestPlanItemIds);
        Execution execution = this.startResumeNextExecutionOfFilteredTestPlan(testPlanOwnerId, testPlanItemId, partialTestPlan, deletePrevious);
        boolean hasNextTestCase = deletePrevious ? this.partialTestPlanIdsHasNextTestCase(testPlanOwnerId, execution, partialTestPlan) : this.findNextTestPlanItem(execution.getTestPlanItem(), partialTestPlan) != null;
        return this.createNewTestPlanResume(testPlanOwnerId, execution, hasNextTestCase, partialTestPlanItemIds);
    }
}

