/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.attachment;

import jakarta.inject.Inject;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.jooq.Field;
import org.jooq.Record;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.attachment.Attachment;
import org.squashtest.tm.domain.attachment.AttachmentContent;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.attachment.RawAttachment;
import org.squashtest.tm.service.internal.attachment.AttachmentRepository;
import org.squashtest.tm.service.internal.attachment.AttachmentRepositoryVisitor;
import org.squashtest.tm.service.internal.attachment.AttachmentStorageModeConfigurer;
import org.squashtest.tm.service.internal.repository.AttachmentDao;

@Component(value="fileSystemAttachmentRepository")
@ConditionalOnProperty(name={"squashtm.feature.file.repository"}, havingValue="true")
@Transactional
public class FileSystemAttachmentRepository
implements AttachmentRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileSystemAttachmentRepository.class);
    @PersistenceContext
    private EntityManager entityManager;
    @Inject
    private AttachmentDao attachmentDao;
    @Inject
    private AttachmentStorageModeConfigurer storageConfigurer;

    @Override
    public AttachmentContent createContent(RawAttachment rawAttachment, long attachmentListId) throws IOException {
        AttachmentContent content = new AttachmentContent();
        this.entityManager.persist((Object)content);
        this.entityManager.flush();
        Object path = this.findFolderPath(attachmentListId);
        path = (String)path + String.valueOf(content.getId());
        InputStream stream = rawAttachment.getStream();
        FileUtils.copyInputStreamToFile((InputStream)stream, (File)new File((String)path));
        return content;
    }

    @Override
    public InputStream getContentStream(Long attachmentId) throws FileNotFoundException {
        String path = this.getAttachmentPath(attachmentId);
        return new FileInputStream(path);
    }

    @Override
    public byte[] getContentBytes(Long attachmentId) throws IOException {
        String path = this.getAttachmentPath(attachmentId);
        return Files.readAllBytes(Paths.get(path, new String[0]));
    }

    @Override
    public byte[] getContentBytes(Record attachmentRecord) throws IOException {
        String path = this.getAttachmentPath((Long)attachmentRecord.get((Field)Tables.ATTACHMENT.ATTACHMENT_LIST_ID), (Long)attachmentRecord.get((Field)Tables.ATTACHMENT.ATTACHMENT_ID), (String)attachmentRecord.get((Field)Tables.ATTACHMENT.NAME), (Long)attachmentRecord.get((Field)Tables.ATTACHMENT_CONTENT.ATTACHMENT_CONTENT_ID));
        Path attachmentPath = Paths.get(path, new String[0]);
        if (Files.exists(attachmentPath, new LinkOption[0])) {
            return Files.readAllBytes(attachmentPath);
        }
        return new byte[0];
    }

    @Override
    public void removeContent(long attachmentId) throws IOException {
        String path = this.getAttachmentPath(attachmentId);
        Files.delete(Paths.get(path, new String[0]));
    }

    @Override
    public void copyContent(Attachment copy) {
        Long sourceId = copy.getAttachmentToCopyId();
        String sourcePath = this.getAttachmentPath(sourceId);
        String copyPath = this.getAttachmentPath(copy.getId());
        try {
            FileUtils.copyFile((File)new File(sourcePath), (File)new File(copyPath));
        }
        catch (IOException e) {
            LOGGER.error("Unable to copy {} to {}", new Object[]{sourcePath, copyPath});
            throw new RuntimeException(e);
        }
    }

    @Override
    public void deleteContent(List<Long> attachmentListIds) {
        for (Long attachmentListId : attachmentListIds) {
            String folderPath = this.findFolderPath(attachmentListId);
            File folder = new File(folderPath);
            if (!folder.exists()) continue;
            try {
                FileUtils.cleanDirectory((File)folder);
                Files.deleteIfExists(Paths.get(folderPath, new String[0]));
            }
            catch (IOException e) {
                LOGGER.error("Unable to delete {}", new Object[]{folderPath});
                throw new RuntimeException(e);
            }
        }
    }

    private String getAttachmentPath(Long attachmentId) {
        Attachment attachment = (Attachment)this.attachmentDao.getReferenceById(attachmentId);
        Long attachmentListId = attachment.getAttachmentList().getId();
        Long contentId = attachment.getContent().getId();
        return this.getAttachmentPath(attachmentListId, attachmentId, attachment.getName(), contentId);
    }

    private String getAttachmentPath(Long attachmentListId, Long attachmentId, String attachmentName, Long contentId) {
        String folderPath = this.findFolderPath(attachmentListId);
        if (contentId == null) {
            throw new IllegalArgumentException("Content id is null. Not able to generate path for content of attachment '%s' with id '%s'".formatted(attachmentName, attachmentId));
        }
        return folderPath + String.valueOf(contentId);
    }

    private String findFolderPath(long attachmentListId) {
        String id = String.valueOf(attachmentListId);
        String paddedId = StringUtils.leftPad((String)id, (int)12, (String)"0");
        ArrayList<String> parts = new ArrayList<String>();
        parts.add(paddedId.substring(0, 3));
        parts.add(paddedId.substring(3, 6));
        parts.add(paddedId.substring(6, 9));
        parts.add(paddedId.substring(9, 12));
        Object path = StringUtils.join(parts, (String)"/");
        path = this.storageConfigurer.getRepoPath() + (String)path;
        return StringUtils.appendIfMissing((String)path, (CharSequence)"/", (CharSequence[])new CharSequence[0]);
    }

    @Override
    public void removeContent(long attachmentListId, long attachmentContentId) {
        String folderPath = this.findFolderPath(attachmentListId);
        try {
            Files.delete(Paths.get(folderPath + attachmentContentId, new String[0]));
        }
        catch (IOException e) {
            LOGGER.error("Failed to delete attachment {} from list {} stored in path {}", new Object[]{attachmentContentId, attachmentListId, folderPath, e});
        }
    }

    @Override
    public void accept(AttachmentRepositoryVisitor visitor) {
        visitor.visit(this);
    }
}

