/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.attachment;

import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.env.AbstractEnvironment;
import org.springframework.stereotype.Component;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.service.internal.attachment.AttachmentStorageMode;

@Component
public class AttachmentStorageModeConfigurer {
    private static final Logger LOGGER = LoggerFactory.getLogger(AttachmentStorageModeConfigurer.class);
    @Inject
    private AbstractEnvironment environment;
    private AttachmentStorageMode attachmentStorageMode = AttachmentStorageMode.DATABASE;
    private String repoPath;

    @PostConstruct
    public void init() {
        boolean isFileRepo = (Boolean)this.environment.getProperty("squashtm.feature.file.repository", Boolean.class, (Object)Boolean.FALSE);
        if (isFileRepo) {
            this.attachmentStorageMode = AttachmentStorageMode.FILE_REPOSITORY;
            LOGGER.info("The property 'squashtm.feature.file.repository' is set to true. Attachments will be stored in file system.", new Object[0]);
            this.repoPath = this.environment.getRequiredProperty("squash.path.file.repository");
            this.repoPath = StringUtils.appendIfMissing((String)this.repoPath, (CharSequence)"/", (CharSequence[])new CharSequence[0]);
            LOGGER.info("File repository path is configure as : {}", new Object[]{this.repoPath});
        } else {
            LOGGER.info("squashtm.feature.file.repository is set to false or not indicated. Attachments will be stored in database.", new Object[0]);
        }
    }

    public AttachmentStorageMode getAttachmentStorageMode() {
        return this.attachmentStorageMode;
    }

    public String getRepoPath() {
        return this.repoPath;
    }
}

