/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.attachment;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.codec.binary.Base64;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.api.utils.AttachmentImageHelper;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.service.internal.attachment.AttachmentManagerServiceImpl;
import org.squashtest.tm.service.internal.attachment.AttachmentRepository;

@Service(value="squash.api.AttachmentImageHelper")
@Transactional
public class AttachmentImageHelperImpl
implements AttachmentImageHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(AttachmentManagerServiceImpl.class);
    private final AttachmentRepository attachmentRepository;

    public AttachmentImageHelperImpl(AttachmentRepository attachmentRepository) {
        this.attachmentRepository = attachmentRepository;
    }

    public String getImageBase64String(Long attachmentId) {
        InputStream is = null;
        String str = "";
        try {
            is = this.attachmentRepository.getContentStream(attachmentId);
            byte[] bit = is.readAllBytes();
            is.read(bit, 0, bit.length);
            is.close();
            str = Base64.encodeBase64String((byte[])bit);
        }
        catch (IOException ex) {
            LOGGER.error("Error: could not retrieve stream content for base64 image", (Throwable)ex);
        }
        return str;
    }
}

