/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.artificialintelligence.server;

import com.fasterxml.jackson.databind.ObjectMapper;
import dev.langchain4j.service.Result;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.aiserver.AiProvider;
import org.squashtest.tm.domain.aiserver.AiServer;
import org.squashtest.tm.domain.servers.AuthenticationPolicy;
import org.squashtest.tm.domain.servers.AuthenticationProtocol;
import org.squashtest.tm.domain.servers.ThirdPartyServer;
import org.squashtest.tm.exception.NameAlreadyInUseException;
import org.squashtest.tm.exception.artificialintelligence.server.CouldNotUpdateAiServerConfigurationException;
import org.squashtest.tm.exception.artificialintelligence.server.MalformedJsonPathException;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.annotation.IsUltimateLicenseAvailable;
import org.squashtest.tm.service.artificialintelligence.AiChatClientProvider;
import org.squashtest.tm.service.artificialintelligence.server.AiServerManagerService;
import org.squashtest.tm.service.internal.artificialintelligence.AiChatClient;
import org.squashtest.tm.service.internal.display.dto.aiserver.AbstractAiServerConfiguration;
import org.squashtest.tm.service.internal.display.dto.aiserver.AiServerConfiguration;
import org.squashtest.tm.service.internal.display.dto.aiserver.AiServerDto;
import org.squashtest.tm.service.internal.display.dto.aiserver.CustomAiServerConfiguration;
import org.squashtest.tm.service.internal.repository.AiServerDao;
import org.squashtest.tm.service.internal.repository.AiTestCaseGenerationDao;
import org.squashtest.tm.service.jsonpathextractor.JsonPathExtractor;
import org.squashtest.tm.service.project.CustomGenericProjectManager;
import org.squashtest.tm.service.servers.StoredCredentialsManager;
import org.squashtest.tm.service.user.UserAccountService;

@Service
@Transactional
public class AiServerManagerServiceImpl
implements AiServerManagerService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AiServerManagerServiceImpl.class);
    private final AiServerDao aiServerDao;
    private final DSLContext dsl;
    private final CustomGenericProjectManager customGenericProjectManager;
    private final UserAccountService userAccountService;
    private final JsonPathExtractor jsonPathExtractor;
    private final StoredCredentialsManager credentialsManager;
    private final AiTestCaseGenerationDao aiTestCaseGenerationDao;
    private final AiChatClientProvider aiChatClientProvider;

    public AiServerManagerServiceImpl(AiServerDao aiServerDao, DSLContext dsl, CustomGenericProjectManager customGenericProjectManager, UserAccountService userAccountService, JsonPathExtractor jsonPathExtractor, StoredCredentialsManager credentialsManager, AiTestCaseGenerationDao aiTestCaseGenerationDao, AiChatClientProvider aiChatClientProvider) {
        this.aiServerDao = aiServerDao;
        this.dsl = dsl;
        this.customGenericProjectManager = customGenericProjectManager;
        this.userAccountService = userAccountService;
        this.jsonPathExtractor = jsonPathExtractor;
        this.credentialsManager = credentialsManager;
        this.aiTestCaseGenerationDao = aiTestCaseGenerationDao;
        this.aiChatClientProvider = aiChatClientProvider;
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void persist(AiServer server) {
        String serverName = server.getName();
        if (this.nameInUse(serverName)) {
            throw new NameAlreadyInUseException(AiServer.class.getSimpleName(), serverName);
        }
        server.setAuthenticationPolicy(AuthenticationPolicy.APP_LEVEL);
        server.setAuthenticationProtocol(AuthenticationProtocol.TOKEN_AUTH);
        this.aiServerDao.save(server);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @IsUltimateLicenseAvailable
    public void deleteAiServers(List<Long> aiServerIds) {
        List allServers = this.aiServerDao.findAllById(aiServerIds);
        List<Long> legacyServerIds = allServers.stream().filter(aiServer -> aiServer.getProvider() == AiProvider.NONE).map(ThirdPartyServer::getId).toList();
        List<Long> newAiServerIds = allServers.stream().filter(aiServer -> aiServer.getProvider() != AiProvider.NONE).map(ThirdPartyServer::getId).toList();
        this.customGenericProjectManager.unbindLegacyAiServers(legacyServerIds);
        this.customGenericProjectManager.unbindAiServersFromProjectAiConfigurations(newAiServerIds);
        this.aiServerDao.deleteAllById(aiServerIds);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void updateName(long aiServerId, String name) {
        if (this.nameInUse(name)) {
            throw new NameAlreadyInUseException(AiServer.class.getSimpleName(), name);
        }
        AiServer server = (AiServer)this.aiServerDao.getReferenceById(aiServerId);
        server.setName(name);
    }

    @Override
    @IsUltimateLicenseAvailable
    public boolean nameInUse(String serverName) {
        Long id = (Long)this.dsl.select((SelectField)Tables.THIRD_PARTY_SERVER.SERVER_ID).from((TableLike)Tables.THIRD_PARTY_SERVER).join((TableLike)Tables.AI_SERVER).on(Tables.THIRD_PARTY_SERVER.SERVER_ID.eq((Field)Tables.AI_SERVER.SERVER_ID)).where(Tables.THIRD_PARTY_SERVER.NAME.eq((Object)serverName)).fetchOneInto(Long.class);
        return id != null;
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @IsUltimateLicenseAvailable
    public void updateDescription(long aiServerId, String description) {
        AiServer server = (AiServer)this.aiServerDao.getReferenceById(aiServerId);
        server.setDescription(description);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @IsUltimateLicenseAvailable
    public void updateUrl(long aiServerId, String url) {
        AiServer server = (AiServer)this.aiServerDao.getReferenceById(aiServerId);
        server.setUrl(url);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @IsUltimateLicenseAvailable
    public void updatePayloadTemplate(long aiServerId, String payload) {
        AiServer server = (AiServer)this.aiServerDao.getReferenceById(aiServerId);
        if (payload.isEmpty()) {
            server.setPayloadTemplate(null);
        } else {
            server.setPayloadTemplate(payload);
        }
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @IsUltimateLicenseAvailable
    public void forceAuditAfterCredentialsUpdate(long aiServerId) {
        AiServer server = (AiServer)this.aiServerDao.getReferenceById(aiServerId);
        server.setLastModifiedOn(new Date());
        server.setLastModifiedBy(this.userAccountService.findCurrentUserDto().getUsername());
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @IsUltimateLicenseAvailable
    public void updateJsonPath(long aiServerId, String jsonPath) {
        if (this.jsonPathExtractor.isPathValid(jsonPath) || jsonPath.isEmpty()) {
            AiServer server = (AiServer)this.aiServerDao.getReferenceById(aiServerId);
            if (jsonPath.isEmpty()) {
                server.setJsonPath(null);
            } else {
                server.setJsonPath(jsonPath);
            }
        } else {
            throw new MalformedJsonPathException();
        }
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @IsUltimateLicenseAvailable
    public void updateProviderWithDefaultUrlAndResetConfig(long aiServerId, AiProvider provider, String defaultUrl) {
        AiServer server = (AiServer)this.aiServerDao.getReferenceById(aiServerId);
        server.setProvider(provider);
        server.setUrl(defaultUrl);
        server.setOptions(null);
        server.setModelName(null);
        this.credentialsManager.deleteAppLevelCredentials(aiServerId);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @IsUltimateLicenseAvailable
    public void updateModelName(long aiServerId, String modelName) {
        AiServer server = (AiServer)this.aiServerDao.getReferenceById(aiServerId);
        server.setModelName(modelName.trim());
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @IsUltimateLicenseAvailable
    public void updateTemperature(long aiServerId, Double temperature) {
        AiServer server = (AiServer)this.aiServerDao.getReferenceById(aiServerId);
        AiServerConfiguration conf = AiServerConfiguration.getDeserializedConfiguration(server.getOptions(), server.getName(), AiServerConfiguration.class);
        conf.setTemperature(temperature);
        AiServerManagerServiceImpl.updateServerOptionsWithConf(server, conf);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @IsUltimateLicenseAvailable
    public void updateTopP(long aiServerId, Double topP) {
        AiServer server = (AiServer)this.aiServerDao.getReferenceById(aiServerId);
        AiServerConfiguration conf = AiServerConfiguration.getDeserializedConfiguration(server.getOptions(), server.getName(), AiServerConfiguration.class);
        conf.setTopP(topP);
        AiServerManagerServiceImpl.updateServerOptionsWithConf(server, conf);
    }

    @Override
    public void updateProjectId(long aiServerId, String projectId) {
        AiServer server = (AiServer)this.aiServerDao.getReferenceById(aiServerId);
        AiServerConfiguration conf = AiServerConfiguration.getDeserializedConfiguration(server.getOptions(), server.getName(), AiServerConfiguration.class);
        conf.setProjectId(projectId);
        AiServerManagerServiceImpl.updateServerOptionsWithConf(server, conf);
    }

    @Override
    public void updateRegion(long aiServerId, String region) {
        AiServer server = (AiServer)this.aiServerDao.getReferenceById(aiServerId);
        AiServerConfiguration conf = AiServerConfiguration.getDeserializedConfiguration(server.getOptions(), server.getName(), AiServerConfiguration.class);
        conf.setRegion(region);
        AiServerManagerServiceImpl.updateServerOptionsWithConf(server, conf);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @IsUltimateLicenseAvailable
    public void updateRandomSeed(long aiServerId, Integer randomSeed) {
        AiServer server = (AiServer)this.aiServerDao.getReferenceById(aiServerId);
        AiServerConfiguration conf = AiServerConfiguration.getDeserializedConfiguration(server.getOptions(), server.getName(), AiServerConfiguration.class);
        conf.setRandomSeed(randomSeed);
        AiServerManagerServiceImpl.updateServerOptionsWithConf(server, conf);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @IsUltimateLicenseAvailable
    public void updateSeed(long aiServerId, Integer seed) {
        AiServer server = (AiServer)this.aiServerDao.getReferenceById(aiServerId);
        AiServerConfiguration conf = AiServerConfiguration.getDeserializedConfiguration(server.getOptions(), server.getName(), AiServerConfiguration.class);
        conf.setSeed(seed);
        AiServerManagerServiceImpl.updateServerOptionsWithConf(server, conf);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @IsUltimateLicenseAvailable
    public void updateMaxTokens(long aiServerId, Integer maxTokens) {
        AiServer server = (AiServer)this.aiServerDao.getReferenceById(aiServerId);
        AiServerConfiguration conf = AiServerConfiguration.getDeserializedConfiguration(server.getOptions(), server.getName(), AiServerConfiguration.class);
        conf.setMaxTokens(maxTokens);
        AiServerManagerServiceImpl.updateServerOptionsWithConf(server, conf);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @IsUltimateLicenseAvailable
    public void updateMaxCompletionTokens(long aiServerId, Integer maxCompletionTokens) {
        AiServer server = (AiServer)this.aiServerDao.getReferenceById(aiServerId);
        AiServerConfiguration conf = AiServerConfiguration.getDeserializedConfiguration(server.getOptions(), server.getName(), AiServerConfiguration.class);
        conf.setMaxCompletionTokens(maxCompletionTokens);
        AiServerManagerServiceImpl.updateServerOptionsWithConf(server, conf);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @IsUltimateLicenseAvailable
    public void updateMaxOutputTokens(long aiServerId, Integer maxOutputTokens) {
        AiServer server = (AiServer)this.aiServerDao.getReferenceById(aiServerId);
        AiServerConfiguration conf = AiServerConfiguration.getDeserializedConfiguration(server.getOptions(), server.getName(), AiServerConfiguration.class);
        conf.setMaxOutputTokens(maxOutputTokens);
        AiServerManagerServiceImpl.updateServerOptionsWithConf(server, conf);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @IsUltimateLicenseAvailable
    public void updateReasoningEffort(long aiServerId, String reasoningEffort) {
        AiServer server = (AiServer)this.aiServerDao.getReferenceById(aiServerId);
        AiServerConfiguration conf = AiServerConfiguration.getDeserializedConfiguration(server.getOptions(), server.getName(), AiServerConfiguration.class);
        conf.setReasoningEffort(reasoningEffort);
        AiServerManagerServiceImpl.updateServerOptionsWithConf(server, conf);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @IsUltimateLicenseAvailable
    public void updateOrganizationId(long aiServerId, String organizationId) {
        AiServer server = (AiServer)this.aiServerDao.getReferenceById(aiServerId);
        AiServerConfiguration conf = AiServerConfiguration.getDeserializedConfiguration(server.getOptions(), server.getName(), AiServerConfiguration.class);
        conf.setOrganizationId(organizationId);
        AiServerManagerServiceImpl.updateServerOptionsWithConf(server, conf);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @IsUltimateLicenseAvailable
    public void updateApiVersion(long aiServerId, String apiVersion) {
        AiServer server = (AiServer)this.aiServerDao.getReferenceById(aiServerId);
        AiServerConfiguration conf = AiServerConfiguration.getDeserializedConfiguration(server.getOptions(), server.getName(), AiServerConfiguration.class);
        conf.setApiVersion(apiVersion);
        AiServerManagerServiceImpl.updateServerOptionsWithConf(server, conf);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @IsUltimateLicenseAvailable
    public void updateThinkingType(long aiServerId, String thinkingType) {
        AiServer server = (AiServer)this.aiServerDao.getReferenceById(aiServerId);
        AiServerConfiguration conf = AiServerConfiguration.getDeserializedConfiguration(server.getOptions(), server.getName(), AiServerConfiguration.class);
        conf.setThinkingType(thinkingType);
        AiServerManagerServiceImpl.updateServerOptionsWithConf(server, conf);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @IsUltimateLicenseAvailable
    public void updateThinkingBudgetTokens(long aiServerId, Integer thinkingBudgetTokens) {
        AiServer server = (AiServer)this.aiServerDao.getReferenceById(aiServerId);
        AiServerConfiguration conf = AiServerConfiguration.getDeserializedConfiguration(server.getOptions(), server.getName(), AiServerConfiguration.class);
        conf.setThinkingBudgetTokens(thinkingBudgetTokens);
        AiServerManagerServiceImpl.updateServerOptionsWithConf(server, conf);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @IsUltimateLicenseAvailable
    public void updateHttpHeaderName(long aiServerId, String httpHeaderName, int headerNumber) {
        AiServer server = (AiServer)this.aiServerDao.getReferenceById(aiServerId);
        CustomAiServerConfiguration conf = AiServerConfiguration.getDeserializedConfiguration(server.getOptions(), server.getName(), CustomAiServerConfiguration.class);
        switch (headerNumber) {
            case 1: {
                conf.setHttpHeaderName1(httpHeaderName);
                break;
            }
            case 2: {
                conf.setHttpHeaderName2(httpHeaderName);
                break;
            }
            case 3: {
                conf.setHttpHeaderName3(httpHeaderName);
                break;
            }
            case 4: {
                conf.setHttpHeaderName4(httpHeaderName);
                break;
            }
            case 5: {
                conf.setHttpHeaderName5(httpHeaderName);
                break;
            }
            default: {
                throw new IllegalArgumentException("Header number must be between 1 and 5");
            }
        }
        AiServerManagerServiceImpl.updateServerOptionsWithConf(server, conf);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @IsUltimateLicenseAvailable
    public void updateHttpHeaderValueTemplate(long aiServerId, String httpHeaderValueTemplate, int headerNumber) {
        AiServer server = (AiServer)this.aiServerDao.getReferenceById(aiServerId);
        CustomAiServerConfiguration conf = AiServerConfiguration.getDeserializedConfiguration(server.getOptions(), server.getName(), CustomAiServerConfiguration.class);
        switch (headerNumber) {
            case 1: {
                conf.setHttpHeaderValueTemplate1(httpHeaderValueTemplate);
                break;
            }
            case 2: {
                conf.setHttpHeaderValueTemplate2(httpHeaderValueTemplate);
                break;
            }
            case 3: {
                conf.setHttpHeaderValueTemplate3(httpHeaderValueTemplate);
                break;
            }
            case 4: {
                conf.setHttpHeaderValueTemplate4(httpHeaderValueTemplate);
                break;
            }
            case 5: {
                conf.setHttpHeaderValueTemplate5(httpHeaderValueTemplate);
                break;
            }
            default: {
                throw new IllegalArgumentException("Header number must be between 1 and 5");
            }
        }
        AiServerManagerServiceImpl.updateServerOptionsWithConf(server, conf);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @IsUltimateLicenseAvailable
    public void updateCustomAiServerPayloadTemplate(long aiServerId, String payloadTemplate) {
        AiServer server = (AiServer)this.aiServerDao.getReferenceById(aiServerId);
        CustomAiServerConfiguration conf = AiServerConfiguration.getDeserializedConfiguration(server.getOptions(), server.getName(), CustomAiServerConfiguration.class);
        conf.setPayloadTemplate(payloadTemplate);
        AiServerManagerServiceImpl.updateServerOptionsWithConf(server, conf);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @IsUltimateLicenseAvailable
    public void updateGeneratedTextJsonPath(long aiServerId, String generatedTextJsonPath) {
        if (!StringUtils.isBlank((CharSequence)generatedTextJsonPath) && !this.jsonPathExtractor.isPathValid(generatedTextJsonPath)) {
            throw new MalformedJsonPathException();
        }
        AiServer server = (AiServer)this.aiServerDao.getReferenceById(aiServerId);
        CustomAiServerConfiguration conf = AiServerConfiguration.getDeserializedConfiguration(server.getOptions(), server.getName(), CustomAiServerConfiguration.class);
        conf.setGeneratedTextJsonPath(generatedTextJsonPath);
        AiServerManagerServiceImpl.updateServerOptionsWithConf(server, conf);
    }

    private static void updateServerOptionsWithConf(AiServer server, AbstractAiServerConfiguration conf) {
        try {
            server.setOptions(new ObjectMapper().writeValueAsString((Object)conf));
        }
        catch (IOException e) {
            LOGGER.error("Could not update configuration options for AI server {}", new Object[]{server.getName(), e});
            throw new CouldNotUpdateAiServerConfigurationException();
        }
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @IsUltimateLicenseAvailable
    public String testAiServerConfiguration(long serverId, String systemPrompt, String userPrompt) {
        AiServerDto aiServerDto = this.aiTestCaseGenerationDao.findAiServerDtoByAiServerId(serverId);
        AiChatClient aiChatClient = this.aiChatClientProvider.createAiChatClient(aiServerDto, systemPrompt);
        LOGGER.info("Testing AI Server configuration by sending system prompt and user prompt", new Object[0]);
        Result<String> response = aiChatClient.doChat(userPrompt);
        return (String)response.content();
    }
}

