/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.testautomation.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.squashtest.tm.domain.testautomation.AutomatedTest;
import org.squashtest.tm.domain.testautomation.TestAutomationProject;

public class TestAutomationProjectContent {
    private final TestAutomationProject project;
    private final List<AutomatedTest> tests;
    private Exception knownProblem = null;
    private boolean orderGuaranteed;

    public TestAutomationProjectContent(TestAutomationProject project) {
        this.project = project;
        this.tests = new ArrayList<AutomatedTest>();
    }

    public TestAutomationProjectContent(TestAutomationProject project, Exception knownProblem) {
        this.project = project;
        this.tests = new ArrayList<AutomatedTest>();
        this.knownProblem = knownProblem;
    }

    public TestAutomationProjectContent(TestAutomationProject project, Collection<AutomatedTest> tests) {
        this(project);
        this.appendTests(tests);
    }

    public TestAutomationProjectContent(TestAutomationProject project, Collection<AutomatedTest> tests, boolean orderGuaranteed) {
        this(project, tests);
        this.orderGuaranteed = orderGuaranteed;
    }

    public TestAutomationProject getProject() {
        return this.project;
    }

    public List<AutomatedTest> getTests() {
        return Collections.unmodifiableList(this.tests);
    }

    public Exception getKnownProblem() {
        return this.knownProblem;
    }

    public boolean hadKnownProblems() {
        return this.knownProblem != null;
    }

    public void setKnownProblem(Exception knownProblem) {
        this.knownProblem = knownProblem;
    }

    public boolean isOrderGuaranteed() {
        return this.orderGuaranteed;
    }

    public void setOrderGuaranteed(boolean orderGuaranteed) {
        this.orderGuaranteed = orderGuaranteed;
    }

    public void appendTest(AutomatedTest test) {
        this.doAppendTest(test);
    }

    private void doAppendTest(AutomatedTest test) {
        this.tests.add(test);
    }

    public final void appendTests(Collection<AutomatedTest> tests) {
        for (AutomatedTest test : tests) {
            this.doAppendTest(test);
        }
    }

    public final void mergeContent(TestAutomationProjectContent otherContent) {
        if (this.project != otherContent.getProject()) {
            throw new IllegalArgumentException("attempted to merge automated tests from project '" + this.project.getLabel() + "' with project '" + otherContent.getProject().getLabel() + "' !");
        }
        Set myTestPaths = this.getTests().stream().map(AutomatedTest::getName).collect(Collectors.toSet());
        otherContent.getTests().forEach(otherTest -> {
            if (!myTestPaths.contains(otherTest.getName())) {
                this.doAppendTest((AutomatedTest)otherTest);
            }
        });
    }
}

