/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.statistics.requirement;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.Map;

public class RequirementVersionBundleStat {
    Map<Long, SimpleRequirementStats> requirementStats = new HashMap<Long, SimpleRequirementStats>();

    public Map<Long, SimpleRequirementStats> getRequirementStats() {
        return this.requirementStats;
    }

    private SimpleRequirementStats getSimpleStats(Long reqId) {
        SimpleRequirementStats rates;
        if (this.requirementStats.containsKey(reqId)) {
            rates = this.requirementStats.get(reqId);
        } else {
            rates = new SimpleRequirementStats(reqId);
            this.requirementStats.put(reqId, rates);
        }
        return rates;
    }

    public void computeRate(Long reqId, String key, Integer countAll, Integer countMatching) {
        SimpleRequirementStats stats = this.getSimpleStats(reqId);
        double rate = this.calculateRate(countAll, countMatching);
        stats.setRate(key, rate, countAll, countMatching);
    }

    private double calculateRate(Integer countAll, Integer countMatching) {
        double rate = 0.0;
        if (countAll != null && countAll != 0 && countMatching != null) {
            rate = countMatching.doubleValue() / countAll.doubleValue();
        }
        rate = this.makeProperRoundedRate(rate);
        return rate;
    }

    private double makeProperRoundedRate(double rate) {
        BigDecimal bigDecimal = BigDecimal.valueOf(rate *= 100.0).setScale(2, RoundingMode.HALF_UP);
        rate = bigDecimal.doubleValue();
        return rate;
    }

    public static class SimpleRequirementStats {
        public static final String REDACTION_RATE_KEY = "REDACTION_RATE";
        public static final String VERIFICATION_RATE_KEY = "VERIFICATION_RATE";
        public static final String VALIDATION_RATE_KEY = "VALIDATION_RATE";
        private final Long reqId;
        private final Map<String, StatisticData> rates = new HashMap<String, StatisticData>();

        public SimpleRequirementStats(Long reqId) {
            this.reqId = reqId;
        }

        public void setRate(String key, Double rate, Integer countAll, Integer countMatching) {
            switch (key) {
                case "REDACTION_RATE": 
                case "VERIFICATION_RATE": 
                case "VALIDATION_RATE": {
                    this.rates.put(key, new StatisticData(countMatching, countAll, rate));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Programmatic error : Unknown key : " + key);
                }
            }
        }

        public Long getReqId() {
            return this.reqId;
        }

        public Double getRedactionRate() {
            return this.getRate(REDACTION_RATE_KEY);
        }

        public Integer getAllTestCaseCount() {
            return this.getCount(REDACTION_RATE_KEY);
        }

        public Integer getRedactedTestCase() {
            return this.getMatching(REDACTION_RATE_KEY);
        }

        public Integer getVerifiedTestCase() {
            return this.getMatching(VERIFICATION_RATE_KEY);
        }

        public Integer getPlannedTestCase() {
            return this.getCount(VERIFICATION_RATE_KEY);
        }

        public Integer getValidatedTestCase() {
            return this.getMatching(VALIDATION_RATE_KEY);
        }

        public Integer getExecutedTestCase() {
            return this.getCount(VALIDATION_RATE_KEY);
        }

        private Double getRate(String rateKey) {
            if (this.rates.containsKey(rateKey)) {
                return this.rates.get(rateKey).getRate();
            }
            throw this.throwNoDataExeception(rateKey);
        }

        private Integer getCount(String rateKey) {
            if (this.rates.containsKey(rateKey)) {
                return this.rates.get(rateKey).getCountAll();
            }
            throw this.throwNoDataExeception(rateKey);
        }

        private Integer getMatching(String rateKey) {
            if (this.rates.containsKey(rateKey)) {
                return this.rates.get(rateKey).getMatchingCount();
            }
            throw this.throwNoDataExeception(rateKey);
        }

        public Double getVerificationRate() {
            return this.getRate(VERIFICATION_RATE_KEY);
        }

        public Double getValidationRate() {
            return this.getRate(VALIDATION_RATE_KEY);
        }

        private IllegalArgumentException throwNoDataExeception(String rateKey) {
            return new IllegalArgumentException("You must initialize statistic bundle before get rates... no value for key " + rateKey + " in statistic map.");
        }
    }

    public static class StatisticData {
        private Integer matchingCount;
        private Integer countAll;
        private Double rate;

        StatisticData(Integer matchingCount, Integer countAll, Double rate) {
            this.matchingCount = matchingCount;
            this.countAll = countAll;
            this.rate = rate;
        }

        public Integer getMatchingCount() {
            if (this.matchingCount == null) {
                return 0;
            }
            return this.matchingCount;
        }

        public Integer getCountAll() {
            if (this.countAll == null) {
                return 0;
            }
            return this.countAll;
        }

        public Double getRate() {
            return this.rate;
        }
    }
}

