/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.testautomation.resultimport;

import com.google.common.collect.Lists;
import jakarta.persistence.EntityManager;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.attachment.AttachmentHolder;
import org.squashtest.tm.domain.campaign.testplan.TestPlanItem;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.domain.customfield.CustomFieldValue;
import org.squashtest.tm.domain.customfield.RawValue;
import org.squashtest.tm.domain.denormalizedfield.DenormalizedFieldHolder;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.domain.execution.ExecutionStep;
import org.squashtest.tm.domain.project.GenericProject;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.testautomation.AutomatedExecutionExtender;
import org.squashtest.tm.domain.testautomation.AutomatedSuite;
import org.squashtest.tm.domain.testautomation.AutomatedTestTechnology;
import org.squashtest.tm.domain.testcase.CreateExecutionFromTestCaseVisitor;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestCaseVisitor;
import org.squashtest.tm.exception.execution.TestPlanItemNotExecutableException;
import org.squashtest.tm.service.attachment.AttachmentManagerService;
import org.squashtest.tm.service.attachment.UploadedData;
import org.squashtest.tm.service.campaign.AutomatedExecutionCreationService;
import org.squashtest.tm.service.internal.customfield.PrivateCustomFieldValueService;
import org.squashtest.tm.service.internal.denormalizedfield.PrivateDenormalizedFieldValueService;
import org.squashtest.tm.service.internal.dto.resultimport.AttachmentDto;
import org.squashtest.tm.service.internal.dto.resultimport.CustomFieldDto;
import org.squashtest.tm.service.internal.dto.resultimport.ImportTestPlanItemDto;
import org.squashtest.tm.service.internal.dto.resultimport.PartialErrorDto;
import org.squashtest.tm.service.internal.dto.resultimport.TestDto;
import org.squashtest.tm.service.internal.repository.ExecutionDao;
import org.squashtest.tm.service.internal.repository.IterationTestPlanDao;
import org.squashtest.tm.service.internal.repository.hibernate.utils.HibernateConfig;
import org.squashtest.tm.service.internal.testautomation.resultimport.AttachmentImportHelper;
import org.squashtest.tm.service.internal.testautomation.resultimport.CustomFieldImportVerificationServiceImpl;
import org.squashtest.tm.service.testautomation.resultimport.AutomatedExecutionImportService;
import org.squashtest.tm.service.testautomation.resultimport.CustomFieldImportVerificationService;
import org.squashtest.tm.service.testautomation.resultimport.FailureDetailImportService;
import org.squashtest.tm.service.testautomation.resultimport.TestStepImportService;

@Service
@Transactional
public class AutomatedExecutionImportServiceImpl
implements AutomatedExecutionImportService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AutomatedExecutionImportServiceImpl.class);
    private final ExecutionDao executionDao;
    private final IterationTestPlanDao iterationTestPlanDao;
    private final EntityManager entityManager;
    private final AutomatedExecutionCreationService automatedExecutionCreationService;
    private final AttachmentManagerService attachmentManagerService;
    private final PrivateCustomFieldValueService customFieldValuesService;
    private final PrivateDenormalizedFieldValueService denormalizedFieldValueService;
    private final CustomFieldImportVerificationService customFieldImportVerificationService;
    private final AttachmentImportHelper attachmentImportHelper;
    private final TestStepImportService testStepImportService;
    private final FailureDetailImportService failureDetailsImportService;

    public AutomatedExecutionImportServiceImpl(ExecutionDao executionDao, IterationTestPlanDao iterationTestPlanDao, EntityManager entityManager, AutomatedExecutionCreationService automatedExecutionCreationService, AttachmentManagerService attachmentManagerService, PrivateCustomFieldValueService customFieldValuesService, PrivateDenormalizedFieldValueService denormalizedFieldValueService, CustomFieldImportVerificationServiceImpl customFieldImportVerificationService, AttachmentImportHelper attachmentImportHelper, TestStepImportService testStepImportService, FailureDetailImportService failureDetailsImportService) {
        this.executionDao = executionDao;
        this.iterationTestPlanDao = iterationTestPlanDao;
        this.entityManager = entityManager;
        this.automatedExecutionCreationService = automatedExecutionCreationService;
        this.attachmentManagerService = attachmentManagerService;
        this.customFieldValuesService = customFieldValuesService;
        this.denormalizedFieldValueService = denormalizedFieldValueService;
        this.customFieldImportVerificationService = customFieldImportVerificationService;
        this.attachmentImportHelper = attachmentImportHelper;
        this.testStepImportService = testStepImportService;
        this.failureDetailsImportService = failureDetailsImportService;
    }

    @Override
    public void importAutomatedExecutions(AutomatedSuite automatedSuite, List<ImportTestPlanItemDto> testPlanItems, Project project, PartialErrorDto partialErrors) {
        HibernateConfig.enableBatch(this.entityManager, 20);
        Lists.partition(testPlanItems, (int)20).forEach(batch -> {
            List<Long> testPlanItemIds = batch.stream().map(ImportTestPlanItemDto::getId).toList();
            List<TestPlanItem> testPlanItemsFromDb = this.iterationTestPlanDao.fetchForAutomatedExecutionImport(testPlanItemIds);
            HashMap<TestDto, TestPlanItem> testPlanItemMap = new HashMap<TestDto, TestPlanItem>();
            Map<Long, TestPlanItem> testPlanItemIdMap = testPlanItemsFromDb.stream().collect(Collectors.toMap(TestPlanItem::getId, tpi -> tpi));
            for (ImportTestPlanItemDto item : batch) {
                TestPlanItem testPlanItem = testPlanItemIdMap.get(item.getId());
                testPlanItemMap.put(item.getTestDto(), testPlanItem);
            }
            Map<Execution, TestDto> createdExecutionMap = this.processTestPlanItemBatch(automatedSuite, testPlanItemMap, partialErrors);
            this.failureDetailsImportService.addFailureDetails(createdExecutionMap, partialErrors);
            this.initializeCustomFields(createdExecutionMap.keySet(), project);
            this.populateCustomFields(createdExecutionMap, partialErrors);
            this.entityManager.flush();
            this.entityManager.clear();
        });
        this.automatedExecutionCreationService.updateIteration(automatedSuite);
    }

    private Map<Execution, TestDto> processTestPlanItemBatch(AutomatedSuite automatedSuite, Map<TestDto, TestPlanItem> testPlanItemMap, PartialErrorDto partialErrors) {
        HashMap<Execution, TestDto> createdExecutions = new HashMap<Execution, TestDto>();
        List<Long> testPlanItemIds = testPlanItemMap.values().stream().map(TestPlanItem::getId).toList();
        Map<Long, Integer> nextPositionItem = this.iterationTestPlanDao.getNextExecutionOrders(testPlanItemIds);
        for (Map.Entry<TestDto, TestPlanItem> entry : testPlanItemMap.entrySet()) {
            Integer position = nextPositionItem.get(entry.getValue().getId());
            createdExecutions.put(this.importAutomatedExecution(automatedSuite, entry.getKey(), entry.getValue(), position, partialErrors), entry.getKey());
        }
        this.entityManager.flush();
        return createdExecutions;
    }

    private Execution importAutomatedExecution(AutomatedSuite automatedSuite, TestDto testDto, TestPlanItem item, Integer position, PartialErrorDto partialErrors) {
        if (item.isTestCaseDeleted()) {
            throw new TestPlanItemNotExecutableException("Cannot import the execution: the referenced test case %s has been deleted.".formatted(item.getReferencedTestCase().getAutomatedTestReference()));
        }
        CreateExecutionFromTestCaseVisitor createExecutionVisitor = new CreateExecutionFromTestCaseVisitor(item.getReferencedDataset());
        item.getReferencedTestCase().accept((TestCaseVisitor)createExecutionVisitor);
        Execution execution = createExecutionVisitor.getCreatedExecution();
        execution.setOrder(position);
        execution.setUnsafeExecutionStatus(ExecutionStatus.fromString((String)testDto.getStatus()));
        item.addNewExecution(execution);
        AutomatedExecutionExtender extender = new AutomatedExecutionExtender();
        extender.setExecution(execution);
        extender.setAutomatedSuite(automatedSuite);
        execution.setAutomatedExecutionExtender(extender);
        TestCase referencedTestCase = execution.getReferencedTestCase();
        extender.setAutomatedTest(referencedTestCase.getAutomatedTest());
        AutomatedTestTechnology automatedTestTechnology = referencedTestCase.getAutomatedTestTechnology();
        if (automatedTestTechnology != null) {
            extender.setTestTechnology(automatedTestTechnology.getName());
        } else {
            extender.setTestTechnology(null);
        }
        if (testDto.getDuration() != null) {
            extender.setDuration(testDto.getDuration());
        }
        String automatedTestRef = testDto.getReference();
        String datasetName = testDto.getDatasetName();
        String fullTestIdentifier = "'%s' %s".formatted(automatedTestRef, StringUtils.isNotBlank((CharSequence)datasetName) ? "with dataset '%s'".formatted(datasetName) : "with an empty dataset");
        boolean isNumberOfStepsValid = this.testStepImportService.isNumberOfStepsValid(execution, testDto, fullTestIdentifier, partialErrors);
        if (isNumberOfStepsValid) {
            this.testStepImportService.addTestStepsToExecution(fullTestIdentifier, execution, testDto.getTestSteps(), partialErrors);
        }
        Execution persistedExecution = (Execution)this.executionDao.save(execution);
        this.testStepImportService.addAttachmentsToExecutionSteps(testDto, partialErrors, isNumberOfStepsValid, fullTestIdentifier, referencedTestCase, execution);
        this.addAttachmentsToExecution(testDto, persistedExecution, partialErrors, automatedTestRef, fullTestIdentifier);
        this.attachmentManagerService.copyContentsOnExternalRepository((AttachmentHolder)persistedExecution);
        for (ExecutionStep executionStep : persistedExecution.getSteps()) {
            this.attachmentManagerService.copyContentsOnExternalRepository((AttachmentHolder)executionStep);
        }
        return execution;
    }

    private void addAttachmentsToExecution(TestDto testDto, Execution execution, PartialErrorDto partialErrors, String automatedTestRef, String fullTestIdentifier) {
        List<AttachmentDto> attachments = testDto.getAttachments();
        if (attachments != null) {
            this.attachmentImportHelper.deduplicateAttachmentNames(attachments);
            for (AttachmentDto attachmentDto : attachments) {
                this.addAttachmentToExecution(execution, attachmentDto, partialErrors, automatedTestRef, fullTestIdentifier);
            }
        }
    }

    private void addAttachmentToExecution(Execution execution, AttachmentDto attachmentDto, PartialErrorDto partialErrors, String automatedTestRef, String fullTestIdentifier) {
        TestCase referencedTestCase = execution.getReferencedTestCase();
        Long testCaseId = referencedTestCase.getId();
        if (this.attachmentImportHelper.isValidExecutionAttachment(testCaseId, automatedTestRef, fullTestIdentifier, partialErrors, attachmentDto)) {
            UploadedData uploadedData;
            try {
                uploadedData = this.attachmentImportHelper.decodeBase64AttachmentContent(attachmentDto);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                partialErrors.addNewTestError(testCaseId, automatedTestRef, "Content of attachment '%s' for test %s is not a valid Base64 string.".formatted(attachmentDto.getName(), fullTestIdentifier));
                return;
            }
            try {
                this.attachmentManagerService.importAttachmentWithoutPermissionCheck(execution, uploadedData);
            }
            catch (IOException e) {
                partialErrors.addNewTestError(testCaseId, automatedTestRef, "Failed to add attachment %s to test %s.".formatted(attachmentDto.getName(), fullTestIdentifier));
                LOGGER.error("Failed to add attachment {} to execution {}", new Object[]{attachmentDto.getName(), execution.getId(), e});
            }
        }
    }

    public void initializeCustomFields(Set<Execution> createdExecutions, Project project) {
        this.createCustomFieldsForExecutionAndExecutionSteps(createdExecutions, project);
        this.createDenormalizedFieldsForExecutionAndExecutionSteps(createdExecutions);
    }

    private void createCustomFieldsForExecutionAndExecutionSteps(Set<Execution> executions, Project project) {
        this.customFieldValuesService.createAllCustomFieldValues(executions, (GenericProject)project);
        Set steps = executions.stream().flatMap(exec -> exec.getSteps().stream()).collect(Collectors.toSet());
        this.customFieldValuesService.createAllCustomFieldValues(steps, (GenericProject)project);
    }

    private void createDenormalizedFieldsForExecutionAndExecutionSteps(Set<Execution> executions) {
        Map<Long, List<DenormalizedFieldHolder>> map = executions.stream().map(DenormalizedFieldHolder.class::cast).collect(Collectors.groupingBy(holder -> ((Execution)holder).getReferencedTestCase().getId()));
        this.denormalizedFieldValueService.createBatchDenormalizedFieldValues(map, BindableEntity.TEST_CASE);
        this.denormalizedFieldValueService.createAllDenormalizedFieldValuesForSteps(executions);
    }

    private void populateCustomFields(Map<Execution, TestDto> createdExecutionMap, PartialErrorDto partialErrors) {
        HashMap<Execution, Map<Long, RawValue>> executionToCustomFieldsMap = new HashMap<Execution, Map<Long, RawValue>>();
        List<CustomFieldValue> allCustomFieldValues = this.customFieldValuesService.findAllCustomFieldValues(createdExecutionMap.keySet());
        Map<Long, List<CustomFieldValue>> executionCustomFieldsMap = allCustomFieldValues.stream().collect(Collectors.groupingBy(CustomFieldValue::getBoundEntityId));
        for (Map.Entry<Execution, TestDto> entry : createdExecutionMap.entrySet()) {
            Map<Long, RawValue> customFieldsToSet;
            Execution execution = entry.getKey();
            TestDto testDto = entry.getValue();
            if (testDto.getCustomFields() == null || testDto.getCustomFields().isEmpty() || (customFieldsToSet = this.populateCustomFields(execution, executionCustomFieldsMap.get(execution.getId()), testDto.getCustomFields(), partialErrors)).isEmpty()) continue;
            executionToCustomFieldsMap.put(execution, customFieldsToSet);
        }
        if (!executionToCustomFieldsMap.isEmpty()) {
            this.customFieldValuesService.initBatchCustomFieldValues(executionToCustomFieldsMap);
        }
    }

    private Map<Long, RawValue> populateCustomFields(Execution execution, List<CustomFieldValue> executionCustomFields, List<CustomFieldDto> customFields, PartialErrorDto partialErrors) {
        HashMap<Long, RawValue> customFieldsToSet = new HashMap<Long, RawValue>();
        Map<String, CustomFieldValue> customFieldValueMap = executionCustomFields.stream().collect(Collectors.toMap(value -> value.getCustomField().getCode(), value -> value));
        this.customFieldImportVerificationService.checkForDuplicates(execution, customFields, partialErrors);
        for (CustomFieldDto customField : customFields) {
            CustomFieldValue customFieldValue = customFieldValueMap.get(customField.getCode());
            if (customFieldValue != null) {
                RawValue rawValue = this.customFieldImportVerificationService.parseCustomFieldDtoValue(customField, execution, customFieldValue, partialErrors);
                if (rawValue == null || !this.customFieldImportVerificationService.validateCustomFieldImport(execution, customFieldValue.getCustomField(), rawValue, partialErrors)) continue;
                customFieldsToSet.put(customFieldValue.getCustomField().getId(), rawValue);
                continue;
            }
            partialErrors.addNewTestError(execution.getReferencedTestCase().getId(), execution.getReferencedTestCase().getAutomatedTestReference(), "Custom field %s not found for test case %s.".formatted(customField.getCode(), execution.getReferencedTestCase().getAutomatedTestReference()));
        }
        if (customFieldsToSet.isEmpty()) {
            return Collections.emptyMap();
        }
        return customFieldsToSet;
    }
}

