/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.testautomation.assistance.candidate;

import java.util.List;
import org.springframework.stereotype.Service;
import org.squashtest.tm.api.security.acls.Permissions;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.service.internal.repository.TestAutomationCandidateDao;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.service.testautomation.assistance.candidate.TestCandidatePermissionEvaluationService;

@Service
public class TestCandidatePermissionEvaluationServiceImpl
implements TestCandidatePermissionEvaluationService {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestCandidatePermissionEvaluationServiceImpl.class);
    private final PermissionEvaluationService permissionEvaluationService;
    private final TestAutomationCandidateDao testAutomationCandidateDao;

    public TestCandidatePermissionEvaluationServiceImpl(PermissionEvaluationService permissionEvaluationService, TestAutomationCandidateDao testAutomationCandidateDao) {
        this.permissionEvaluationService = permissionEvaluationService;
        this.testAutomationCandidateDao = testAutomationCandidateDao;
    }

    @Override
    public boolean hasPermissionOnProjects(List<Long> projectIds) {
        if (this.permissionEvaluationService.hasRole("ROLE_ADMIN")) {
            return true;
        }
        return this.testAutomationCandidateDao.findOneTestCaseIdPerProject(projectIds).values().stream().allMatch(this::hasPermissionOnTestCase);
    }

    @Override
    public boolean hasPermissionsOnTestCases(List<Long> testCaseIds) {
        if (this.permissionEvaluationService.hasRole("ROLE_ADMIN")) {
            return true;
        }
        for (Long testCaseId : testCaseIds) {
            boolean hasAutomationPermission = this.permissionEvaluationService.hasRoleOrPermissionOnObject("ROLE_ADMIN", Permissions.WRITE_AS_AUTOMATION.name(), testCaseId, TestCase.class.getName());
            boolean hasWritePermission = this.permissionEvaluationService.hasRoleOrPermissionOnObject("ROLE_ADMIN", Permissions.WRITE.name(), testCaseId, TestCase.class.getName());
            if (hasWritePermission || hasAutomationPermission) continue;
            LOGGER.debug("Permission denied on test case ID: {}", new Object[]{testCaseId});
            return false;
        }
        return true;
    }

    @Override
    public boolean hasPermissionOnTestCase(Long testCaseId) {
        boolean hasWritePermission = this.permissionEvaluationService.hasRoleOrPermissionOnObject("ROLE_ADMIN", Permissions.WRITE.name(), testCaseId, TestCase.class.getName());
        boolean hasAutomationPermission = this.permissionEvaluationService.hasRoleOrPermissionOnObject("ROLE_ADMIN", Permissions.WRITE_AS_AUTOMATION.name(), testCaseId, TestCase.class.getName());
        return hasWritePermission || hasAutomationPermission;
    }
}

