/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.testautomation;

import java.util.Collection;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.testautomation.AutomatedTest;
import org.squashtest.tm.domain.testautomation.TestAutomationProject;
import org.squashtest.tm.domain.testautomation.TestAutomationServer;
import org.squashtest.tm.service.internal.testautomation.TestAutomationConnectorRegistry;
import org.squashtest.tm.service.internal.testautomation.TestAutomationConnectorTask;
import org.squashtest.tm.service.testautomation.model.TestAutomationProjectContent;
import org.squashtest.tm.service.testautomation.spi.TestAutomationConnector;

public class FetchTestListTask
implements TestAutomationConnectorTask<TestAutomationProjectContent> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestAutomationConnector.class);
    private TestAutomationConnectorRegistry connectorRegistry;
    private TestAutomationProject project;
    private String username;

    public FetchTestListTask(TestAutomationConnectorRegistry connectorRegistry, TestAutomationProject project, String username) {
        this.connectorRegistry = connectorRegistry;
        this.project = project;
        this.username = username;
    }

    @Override
    public TestAutomationProjectContent call() throws Exception {
        TestAutomationServer server = this.project.getServer();
        TestAutomationConnector connector = this.connectorRegistry.getConnectorForKind(server.getKind());
        Collection<AutomatedTest> allTests = connector.listTestsInProject(this.project, this.username);
        boolean orderGuaranteed = connector.testListIsOrderGuaranteed(allTests);
        return new TestAutomationProjectContent(this.project, allTests, orderGuaranteed);
    }

    @Override
    public TestAutomationProjectContent buildFailedResult(Exception thrownException) {
        LOGGER.error("The task 'fetch test list' failed for project '{}' on server '{}'", new Object[]{this.project.getLabel(), this.project.getServer().getUrl(), thrownException});
        return new TestAutomationProjectContent(this.project, thrownException);
    }
}

