/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.security;

import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.authentication.dao.DaoAuthenticationProvider;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.squashtest.tm.api.security.authentication.AuthenticationProviderFeatures;
import org.squashtest.tm.api.security.authentication.FeaturesAwareAuthentication;
import org.squashtest.tm.service.internal.security.InternalAuthenticationProviderFeatures;

public class SquashDaoAuthenticationProvider
extends DaoAuthenticationProvider {
    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        Authentication auth = super.authenticate(authentication);
        return new FeatureAwareDaoAuthenticationToken((UsernamePasswordAuthenticationToken)auth);
    }

    public static final class FeatureAwareDaoAuthenticationToken
    extends UsernamePasswordAuthenticationToken
    implements FeaturesAwareAuthentication {
        private static final long serialVersionUID = 1L;

        private FeatureAwareDaoAuthenticationToken(UsernamePasswordAuthenticationToken token) {
            super(token.getPrincipal(), token.getCredentials(), token.getAuthorities());
        }

        public AuthenticationProviderFeatures getFeatures() {
            return InternalAuthenticationProviderFeatures.INSTANCE;
        }
    }
}

