/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.hibernate;

import jakarta.annotation.Nullable;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jooq.CommonTableExpression;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Name;
import org.jooq.OrderField;
import org.jooq.Record1;
import org.jooq.ResultQuery;
import org.jooq.Select;
import org.jooq.SelectField;
import org.jooq.SelectSeekStep1;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.jooq.impl.SQLDataType;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.core.foundation.lang.PathUtils;
import org.squashtest.tm.domain.requirement.RequirementLibraryNode;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.jooq.domain.tables.Resource;
import org.squashtest.tm.jooq.domain.tables.RlnRelationship;
import org.squashtest.tm.service.internal.repository.RequirementLibraryNodeDao;
import org.squashtest.tm.service.internal.repository.hibernate.HibernateEntityDao;

@Repository(value="squashtest.tm.repository.RequirementLibraryNodeDao")
public class HibernateRequirementLibraryNodeDao
extends HibernateEntityDao<RequirementLibraryNode>
implements RequirementLibraryNodeDao {
    private static final String ID = "ID";
    private static final String PATH = "PATH";
    private static final String POSITION = "POSITION";
    private static final String PATH_CTE = "pathCte";
    @Inject
    DSLContext dslContext;

    @Override
    public List<String> getParentsName(long entityId) {
        return this.entityManager.createNativeQuery("select rs.name from RESOURCE rs join REQUIREMENT_FOLDER rf on rs.res_id = rf.res_id join REQUIREMENT_LIBRARY_NODE rln on rf.rln_id = rln.rln_id inner join RLN_RELATIONSHIP_CLOSURE clos on clos.ancestor_id = rln.rln_id where clos.descendant_id = :nodeId order by clos.depth desc").setParameter("nodeId", (Object)entityId).getResultList();
    }

    @Override
    public List<Long> getParentsIds(long entityId) {
        return this.entityManager.createNativeQuery("select rln.rln_id from REQUIREMENT_LIBRARY_NODE rln inner join RLN_RELATIONSHIP_CLOSURE clos on clos.ancestor_id = rln.rln_id where clos.descendant_id = :nodeId order by clos.depth desc").setParameter("nodeId", (Object)entityId).getResultList();
    }

    @Override
    public List<Long> findNodeIdsByPath(List<String> paths) {
        ArrayList<Long> result = new ArrayList<Long>();
        String fullPath = paths.get(paths.size() - 1);
        String projectName = PathUtils.extractUnescapedProjectName((String)fullPath);
        List<String> splits = Arrays.asList(PathUtils.splitPath((String)fullPath));
        List effectiveSplits = PathUtils.unescapeSlashes(splits);
        if (effectiveSplits.size() < 2) {
            return Collections.singletonList(null);
        }
        if (effectiveSplits.size() == 2) {
            String rootName = (String)effectiveSplits.get(1);
            return Collections.singletonList(this.getRootNodeId(rootName, projectName));
        }
        List<String> pathsWithoutProject = this.getPathsWithoutProject(paths);
        List<Child> children = this.getChildren(pathsWithoutProject.get(pathsWithoutProject.size() - 1), projectName);
        for (String rlnPath : pathsWithoutProject) {
            result.add(children.stream().filter(c -> c.path().equals(rlnPath)).findFirst().map(Child::id).orElse(null));
        }
        return result;
    }

    @Override
    public Long findNodeIdByPath(String path) {
        String projectName = PathUtils.extractUnescapedProjectName((String)path);
        List<String> splits = Arrays.asList(PathUtils.splitPath((String)path));
        List effectiveSplits = PathUtils.unescapeSlashes(splits);
        if (effectiveSplits.size() < 2) {
            return null;
        }
        if (effectiveSplits.size() == 2) {
            String rootName = (String)effectiveSplits.get(1);
            return this.getRootNodeId(rootName, projectName);
        }
        String rlnPath = PathUtils.getPathWithoutProject((List)effectiveSplits);
        List<Child> children = this.getChildren(rlnPath, projectName);
        if (children.isEmpty()) {
            return null;
        }
        return children.stream().filter(c -> c.path().equals(rlnPath)).findFirst().map(Child::id).orElse(null);
    }

    private List<String> getPathsWithoutProject(List<String> paths) {
        ArrayList<String> result = new ArrayList<String>();
        for (String path : paths.subList(1, paths.size())) {
            List<String> splits = Arrays.asList(PathUtils.splitPath((String)path));
            List effectiveSplits = PathUtils.unescapeSlashes(splits);
            result.add(PathUtils.getPathWithoutProject((List)effectiveSplits));
        }
        return result;
    }

    private List<Child> getChildren(String path, String projectName) {
        CommonTableExpression cte = DSL.name((String)PATH_CTE).fields(ID, PATH, POSITION).as((ResultQuery)this.dslContext.select((SelectField)Tables.RLN_RESOURCE.RLN_ID, (SelectField)Tables.RESOURCE.NAME.cast(SQLDataType.VARCHAR((int)10000)), (SelectField)Tables.REQUIREMENT_LIBRARY_CONTENT.CONTENT_ORDER).from((TableLike)Tables.PROJECT).join((TableLike)Tables.REQUIREMENT_LIBRARY_CONTENT).on(Tables.PROJECT.RL_ID.eq((Field)Tables.REQUIREMENT_LIBRARY_CONTENT.LIBRARY_ID)).join((TableLike)Tables.RLN_RESOURCE).on(Tables.REQUIREMENT_LIBRARY_CONTENT.CONTENT_ID.eq((Field)Tables.RLN_RESOURCE.RLN_ID)).join((TableLike)Tables.RESOURCE).on(Tables.RLN_RESOURCE.RES_ID.eq((Field)Tables.RESOURCE.RES_ID)).where(Tables.PROJECT.NAME.eq((Object)projectName)).union((Select)DSL.select((SelectField)Tables.RLN_RELATIONSHIP.DESCENDANT_ID, (SelectField)DSL.field((Name)DSL.name((String[])new String[]{PATH_CTE, PATH})).concat(new String[]{"/"}).concat(new Field[]{Tables.RESOURCE.NAME}).cast(SQLDataType.VARCHAR((int)10000)), (SelectField)Tables.RLN_RELATIONSHIP.CONTENT_ORDER).from(DSL.name((String)PATH_CTE)).join((TableLike)Tables.RLN_RELATIONSHIP).on(DSL.field((Name)DSL.name((String[])new String[]{PATH_CTE, ID})).eq((Object)Tables.RLN_RELATIONSHIP.ANCESTOR_ID)).join((TableLike)Tables.RLN_RESOURCE).on(Tables.RLN_RELATIONSHIP.DESCENDANT_ID.eq((Field)Tables.RLN_RESOURCE.RLN_ID)).join((TableLike)Tables.RESOURCE).on(Tables.RLN_RESOURCE.RES_ID.eq((Field)Tables.RESOURCE.RES_ID)).where((Condition)DSL.val((String)path).like(DSL.concat((Field[])new Field[]{DSL.field((Name)DSL.name((String[])new String[]{PATH_CTE, PATH})), DSL.val((String)"/"), Tables.RESOURCE.NAME, DSL.val((String)"%")})))));
        return this.dslContext.withRecursive(new CommonTableExpression[]{cte}).selectFrom((TableLike)cte).orderBy((OrderField)cte.field(POSITION)).fetchInto(Child.class);
    }

    @Nullable
    private Long getRootNodeId(String rootName, String projectName) {
        return (Long)this.selectRootNodes(rootName, projectName).limit((Number)1).fetchOneInto(Long.class);
    }

    private SelectSeekStep1<Record1<Long>, Integer> selectRootNodes(String rootName, String projectName) {
        return this.dslContext.select((SelectField)Tables.REQUIREMENT_LIBRARY_CONTENT.CONTENT_ID).from((TableLike)Tables.PROJECT).innerJoin((TableLike)Tables.REQUIREMENT_LIBRARY_CONTENT).on(Tables.PROJECT.RL_ID.eq((Field)Tables.REQUIREMENT_LIBRARY_CONTENT.LIBRARY_ID)).innerJoin((TableLike)Tables.RLN_RESOURCE).on(Tables.REQUIREMENT_LIBRARY_CONTENT.CONTENT_ID.eq((Field)Tables.RLN_RESOURCE.RLN_ID)).innerJoin((TableLike)Tables.RESOURCE).on(Tables.RLN_RESOURCE.RES_ID.eq((Field)Tables.RESOURCE.RES_ID)).where(Tables.PROJECT.NAME.eq((Object)projectName).and(Tables.RESOURCE.NAME.eq((Object)rootName))).orderBy((OrderField)Tables.REQUIREMENT_LIBRARY_CONTENT.CONTENT_ORDER.asc());
    }

    @Override
    public Map<Long, List<String>> findContentNames(Collection<Long> folderIds) {
        return this.dslContext.select((SelectField)RlnRelationship.RLN_RELATIONSHIP.ANCESTOR_ID, (SelectField)Resource.RESOURCE.NAME).from((TableLike)RlnRelationship.RLN_RELATIONSHIP).innerJoin((TableLike)Tables.RLN_RESOURCE).on(RlnRelationship.RLN_RELATIONSHIP.DESCENDANT_ID.eq((Field)Tables.RLN_RESOURCE.RLN_ID)).innerJoin((TableLike)Resource.RESOURCE).on(Tables.RLN_RESOURCE.RES_ID.eq((Field)Resource.RESOURCE.RES_ID)).where(RlnRelationship.RLN_RELATIONSHIP.ANCESTOR_ID.in(folderIds)).fetchGroups((Field)RlnRelationship.RLN_RELATIONSHIP.ANCESTOR_ID, (Field)Resource.RESOURCE.NAME);
    }

    @Override
    public Map<Long, List<Long>> findRequirementContentIds(List<Long> requirementIds) {
        if (requirementIds.isEmpty()) {
            return Collections.emptyMap();
        }
        return this.dslContext.select((SelectField)Tables.RLN_RELATIONSHIP.ANCESTOR_ID, (SelectField)Tables.RLN_RELATIONSHIP.DESCENDANT_ID).from((TableLike)Tables.RLN_RELATIONSHIP).where(Tables.RLN_RELATIONSHIP.ANCESTOR_ID.in(requirementIds)).fetchGroups((Field)Tables.RLN_RELATIONSHIP.ANCESTOR_ID, (Field)Tables.RLN_RELATIONSHIP.DESCENDANT_ID);
    }

    private record Child(Long id, String path, Integer position) {
    }
}

