/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.hibernate;

import java.util.Objects;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.display.dto.aiserver.AiServerDto;
import org.squashtest.tm.service.internal.repository.AiTestCaseGenerationDao;

@Repository
public class AiTestCaseGenerationDaoImpl
implements AiTestCaseGenerationDao {
    private final DSLContext dslContext;

    public AiTestCaseGenerationDaoImpl(DSLContext dslContext) {
        this.dslContext = dslContext;
    }

    @Override
    public Long findTargetTestCaseLibraryId(Long projectId) {
        return (Long)this.dslContext.select((SelectField)Tables.TEST_CASE_LIBRARY.TCL_ID).from((TableLike)Tables.TEST_CASE_LIBRARY).innerJoin((TableLike)Tables.PROJECT).on(Tables.TEST_CASE_LIBRARY.TCL_ID.eq((Field)Tables.PROJECT.TCL_ID)).where(Tables.PROJECT.PROJECT_ID.eq((Object)projectId)).fetchOneInto(Long.class);
    }

    @Override
    public AiServerDto findAiServerDtoByAiServerId(Long aiServerId) {
        AiServerDto aiServerDto = (AiServerDto)this.dslContext.select((SelectField)Tables.THIRD_PARTY_SERVER.URL.as("URL"), (SelectField)Tables.AI_SERVER.PAYLOAD_TEMPLATE.as("PAYLOAD_TEMPLATE"), (SelectField)Tables.AI_SERVER.SERVER_ID.as("ID"), (SelectField)Tables.AI_SERVER.JSON_PATH, (SelectField)Tables.AI_SERVER.PROVIDER, (SelectField)Tables.AI_SERVER.MODEL_NAME, (SelectField)Tables.AI_SERVER.OPTIONS).from((TableLike)Tables.THIRD_PARTY_SERVER).innerJoin((TableLike)Tables.AI_SERVER).on(Tables.THIRD_PARTY_SERVER.SERVER_ID.eq((Field)Tables.AI_SERVER.SERVER_ID)).where(Tables.THIRD_PARTY_SERVER.SERVER_ID.eq((Object)aiServerId)).fetchOneInto(AiServerDto.class);
        if (Objects.nonNull(aiServerDto)) {
            aiServerDto.initializeConfiguration();
        }
        return aiServerDto;
    }

    @Override
    public AiServerDto findAiServerDtoByProjectId(long projectId) {
        AiServerDto aiServerDto = (AiServerDto)this.dslContext.select((SelectField)Tables.THIRD_PARTY_SERVER.URL.as("URL"), (SelectField)Tables.AI_SERVER.PAYLOAD_TEMPLATE.as("PAYLOAD_TEMPLATE"), (SelectField)Tables.AI_SERVER.SERVER_ID.as("ID"), (SelectField)Tables.AI_SERVER.JSON_PATH, (SelectField)Tables.AI_SERVER.PROVIDER, (SelectField)Tables.AI_SERVER.MODEL_NAME, (SelectField)Tables.AI_SERVER.OPTIONS).from((TableLike)Tables.THIRD_PARTY_SERVER).innerJoin((TableLike)Tables.AI_SERVER).on(Tables.AI_SERVER.SERVER_ID.eq((Field)Tables.THIRD_PARTY_SERVER.SERVER_ID)).innerJoin((TableLike)Tables.PROJECT).on(Tables.PROJECT.AI_SERVER_ID.eq((Field)Tables.AI_SERVER.SERVER_ID)).where(Tables.PROJECT.PROJECT_ID.eq((Object)projectId)).fetchOneInto(AiServerDto.class);
        if (Objects.nonNull(aiServerDto)) {
            aiServerDto.initializeConfiguration();
        }
        return aiServerDto;
    }
}

