/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.data.domain.Pageable;
import org.squashtest.tm.domain.EntityReference;
import org.squashtest.tm.domain.query.ColumnType;
import org.squashtest.tm.domain.query.NaturalJoinStyle;
import org.squashtest.tm.domain.query.QueryAggregationColumn;
import org.squashtest.tm.domain.query.QueryColumnPrototype;
import org.squashtest.tm.domain.query.QueryColumnPrototypeInstance;
import org.squashtest.tm.domain.query.QueryFilterColumn;
import org.squashtest.tm.domain.query.QueryModel;
import org.squashtest.tm.domain.query.QueryOrderingColumn;
import org.squashtest.tm.domain.query.QueryProjectionColumn;
import org.squashtest.tm.domain.query.QueryStrategy;
import org.squashtest.tm.domain.query.SpecializedEntityType;
import org.squashtest.tm.service.internal.query.InternalEntityType;
import org.squashtest.tm.service.internal.query.QueryProfile;
import org.squashtest.tm.service.query.ConfiguredQuery;

class InternalQueryModel {
    private ConfiguredQuery parent;
    private Set<InternalEntityType> targetEntities;
    private InternalEntityType rootEntity;
    private QueryProfile queryProfile = QueryProfile.REGULAR_QUERY;
    private AbstractPerProfileColumnExposer columnExposer = new RegularQueryColumnExposer(new QueryModel());

    InternalQueryModel() {
    }

    InternalQueryModel(ConfiguredQuery parent) {
        this.parent = parent;
        this.assignColumnExposer();
    }

    static InternalQueryModel createFor(QueryModel queryModel) {
        ConfiguredQuery confQuery = new ConfiguredQuery(queryModel);
        return new InternalQueryModel(confQuery);
    }

    static InternalQueryModel createFor(QueryColumnPrototypeInstance columnInstance) {
        QueryColumnPrototype proto = columnInstance.getColumn();
        if (proto.getColumnType() != ColumnType.CALCULATED) {
            throw new RuntimeException("Attempted to create a subquery for a column that has no subquery");
        }
        ConfiguredQuery configured = new ConfiguredQuery(proto.getSubQuery());
        SpecializedEntityType specType = columnInstance.getSpecializedType();
        InternalEntityType internalType = InternalEntityType.fromSpecializedType(specType);
        return new InternalQueryModel(configured).withRootEntity(internalType);
    }

    InternalQueryModel withRootEntity(InternalEntityType rootEntity) {
        this.rootEntity = rootEntity;
        return this;
    }

    InternalQueryModel withProfile(QueryProfile profile) {
        this.queryProfile = profile;
        this.assignColumnExposer();
        return this;
    }

    List<QueryProjectionColumn> getProjectionColumns() {
        return this.columnExposer.getProjections();
    }

    List<QueryAggregationColumn> getAggregationColumns() {
        return this.columnExposer.getAggregations();
    }

    List<QueryFilterColumn> getFilterColumns() {
        return this.columnExposer.getFilters();
    }

    List<QueryOrderingColumn> getOrderingColumns() {
        return this.columnExposer.getOrdering();
    }

    NaturalJoinStyle getJoinStyle() {
        return this.parent.getQueryModel().getJoinStyle();
    }

    QueryStrategy getStrategy() {
        return this.parent.getQueryModel().getStrategy();
    }

    Collection<EntityReference> getScope() {
        return this.parent.getScope();
    }

    InternalEntityType getRootEntity() {
        this.assignRootEntityIfUnspecified();
        return this.rootEntity;
    }

    Set<InternalEntityType> getTargetEntities() {
        this.computeTargetEntitiesIfUnspecified();
        return this.targetEntities;
    }

    Pageable getPaging() {
        return this.parent.getPaging();
    }

    QueryProfile getQueryProfile() {
        return this.queryProfile;
    }

    Collection<? extends QueryColumnPrototypeInstance> getInlinedColumns() {
        return this.findSubqueriesForStrategy(QueryStrategy.INLINED);
    }

    Collection<? extends QueryColumnPrototypeInstance> getSubqueryColumns() {
        return this.findSubqueriesForStrategy(QueryStrategy.SUBQUERY);
    }

    private void assignRootEntityIfUnspecified() {
        if (this.rootEntity == null) {
            InternalEntityType firstType;
            QueryColumnPrototypeInstance firstProto = this.collectAllColumns().get(0);
            SpecializedEntityType firstSpecialType = firstProto.getSpecializedType();
            this.rootEntity = firstType = InternalEntityType.fromSpecializedType(firstSpecialType);
        }
    }

    protected final void computeTargetEntitiesIfUnspecified() {
        if (this.targetEntities == null || this.targetEntities.isEmpty()) {
            LinkedHashSet<InternalEntityType> allTypes = new LinkedHashSet<InternalEntityType>();
            this.assignRootEntityIfUnspecified();
            allTypes.add(this.rootEntity);
            List<QueryColumnPrototypeInstance> allColumns = this.collectAllColumns();
            Set colTypes = allColumns.stream().map(col -> col.getSpecializedType()).map(InternalEntityType::fromSpecializedType).collect(Collectors.toSet());
            allTypes.addAll(colTypes);
            this.targetEntities = allTypes;
        }
    }

    private void assignColumnExposer() {
        switch (this.queryProfile) {
            case REGULAR_QUERY: {
                this.columnExposer = new RegularQueryColumnExposer(this.parent.getQueryModel());
                break;
            }
            case SUBSELECT_QUERY: {
                this.columnExposer = new SubselectQueryColumnExposer(this.parent.getQueryModel());
                break;
            }
            case SUBWHERE_QUERY: {
                this.columnExposer = new SubwehreQueryColumnExposer(this.parent.getQueryModel());
                break;
            }
            default: {
                throw new RuntimeException("unsupported QueryProfile : " + String.valueOf((Object)this.queryProfile));
            }
        }
    }

    private Collection<QueryColumnPrototypeInstance> findSubqueriesForStrategy(QueryStrategy strategy) {
        return this.collectAllColumns().stream().filter(col -> {
            QueryColumnPrototype proto = col.getColumn();
            return proto.getColumnType() == ColumnType.CALCULATED && proto.getSubQuery().getStrategy() == strategy;
        }).toList();
    }

    List<QueryColumnPrototypeInstance> collectAllColumns() {
        QueryModel query = this.parent.getQueryModel();
        ArrayList<QueryColumnPrototypeInstance> allColumns = new ArrayList<QueryColumnPrototypeInstance>();
        allColumns.addAll(query.getAggregationColumns());
        allColumns.addAll(query.getProjectionColumns());
        allColumns.addAll(query.getOrderingColumns());
        allColumns.addAll(query.getFilterColumns());
        return allColumns;
    }

    private static abstract class AbstractPerProfileColumnExposer {
        protected List<QueryProjectionColumn> projections;
        protected List<QueryAggregationColumn> aggregations;
        protected List<QueryFilterColumn> filters;
        protected List<QueryOrderingColumn> ordering;

        private AbstractPerProfileColumnExposer() {
        }

        public List<QueryProjectionColumn> getProjections() {
            return this.projections;
        }

        public List<QueryAggregationColumn> getAggregations() {
            return this.aggregations;
        }

        public List<QueryFilterColumn> getFilters() {
            return this.filters;
        }

        public List<QueryOrderingColumn> getOrdering() {
            return this.ordering;
        }
    }

    private static final class RegularQueryColumnExposer
    extends AbstractPerProfileColumnExposer {
        RegularQueryColumnExposer(QueryModel model) {
            this.projections = new ArrayList(model.getProjectionColumns());
            this.aggregations = new ArrayList(model.getAggregationColumns());
            this.filters = new ArrayList(model.getFilterColumns());
            this.ordering = new ArrayList(model.getOrderingColumns());
        }
    }

    private static final class SubselectQueryColumnExposer
    extends AbstractPerProfileColumnExposer {
        SubselectQueryColumnExposer(QueryModel model) {
            this.projections = new ArrayList(model.getProjectionColumns());
            this.filters = new ArrayList(model.getFilterColumns());
            this.aggregations = Collections.emptyList();
            this.ordering = Collections.emptyList();
        }
    }

    private static final class SubwehreQueryColumnExposer
    extends AbstractPerProfileColumnExposer {
        SubwehreQueryColumnExposer(QueryModel model) {
            this.projections = new ArrayList(model.getProjectionColumns());
            this.filters = new ArrayList(model.getFilterColumns());
            this.aggregations = new ArrayList(model.getAggregationColumns());
            this.ordering = Collections.emptyList();
        }
    }
}

