/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.pivot.projectexporter.dao;

import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.ResultQuery;
import org.jooq.Select;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.dto.pivotdefinition.AbstractPivotObject;
import org.squashtest.tm.service.internal.dto.pivotdefinition.AttachmentPivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.MilestonePivot;
import org.squashtest.tm.service.internal.jooq.SubElementRecordProcessor;
import org.squashtest.tm.service.internal.pivot.projectexporter.dao.AbstractPivotDao;
import org.squashtest.tm.service.internal.pivot.projectexporter.dao.EntityBindingField;
import org.squashtest.tm.service.pivot.converters.AdminPivotConverterService;
import org.squashtest.tm.service.pivot.projectexporter.dao.MilestonePivotDao;

@Repository
public class MilestonePivotDaoImpl
extends AbstractPivotDao<MilestonePivot>
implements MilestonePivotDao {
    MilestonePivotDaoImpl(DSLContext dsl, AdminPivotConverterService adminPivotConverterService) {
        super(dsl, adminPivotConverterService);
    }

    @Override
    public boolean hasMilestoneBindingByProjectId(Long projectId) {
        return this.dsl.fetchExists((Select)this.dsl.selectOne().from((TableLike)Tables.MILESTONE_BINDING).where(Tables.MILESTONE_BINDING.PROJECT_ID.eq((Object)projectId)));
    }

    private ResultQuery<? extends Record> getMilestoneQueryByProjectId(Long projectId) {
        return this.dsl.select((SelectField)Tables.MILESTONE.MILESTONE_ID, (SelectField)Tables.MILESTONE.LABEL, (SelectField)Tables.MILESTONE.DESCRIPTION, (SelectField)Tables.MILESTONE.END_DATE, (SelectField)Tables.MILESTONE.STATUS, (SelectField)Tables.MILESTONE.M_RANGE, (SelectField)Tables.MILESTONE.CREATED_BY, (SelectField)Tables.MILESTONE.CREATED_ON, (SelectField)Tables.MILESTONE.LAST_MODIFIED_BY, (SelectField)Tables.MILESTONE.LAST_MODIFIED_ON).from((TableLike)Tables.MILESTONE_BINDING).join((TableLike)Tables.MILESTONE).on(Tables.MILESTONE.MILESTONE_ID.eq((Field)Tables.MILESTONE_BINDING.MILESTONE_ID)).where(Tables.MILESTONE_BINDING.PROJECT_ID.eq((Object)projectId));
    }

    @Override
    public void getMilestoneByProjectId(Long projectId, Consumer<MilestonePivot> consumer) {
        ResultQuery<? extends Record> milestoneQuery = this.getMilestoneQueryByProjectId(projectId);
        this.convertRecordAndWritingPivot(milestoneQuery, projectId, EntityBindingField.MILESTONE, consumer, attachmentPivot -> {});
    }

    @Override
    protected MilestonePivot getNewPivotObject(Record record, Long projectId, EntityBindingField entityBindingField) {
        return this.adminPivotConverterService.recordToMilestonePivot(record);
    }

    @Override
    protected void fillPivotObject(MilestonePivot pivotObject, Record record) {
    }

    @Override
    protected List<SubElementRecordProcessor<? extends AbstractPivotObject>> getSubElementRecordProcessors(Long projectId, EntityBindingField entityBindingField) {
        return List.of();
    }

    @Override
    protected void appendSubElementsToPivotObject(MilestonePivot pivotObject, Map<Class<? extends AbstractPivotObject>, List<? extends AbstractPivotObject>> subElementsByClazz, Consumer<AttachmentPivot> writingAttachmentConsumer) {
    }
}

