/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.pivot.converters;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.jooq.Field;
import org.jooq.Record;
import org.springframework.stereotype.Service;
import org.squashtest.tm.aspect.validation.CleanHtmlAspect;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.bdd.Keyword;
import org.squashtest.tm.domain.infolist.InfoListItem;
import org.squashtest.tm.domain.infolist.ListItemReference;
import org.squashtest.tm.domain.testcase.ActionTestStep;
import org.squashtest.tm.domain.testcase.Dataset;
import org.squashtest.tm.domain.testcase.DatasetParamValue;
import org.squashtest.tm.domain.testcase.ExploratoryTestCase;
import org.squashtest.tm.domain.testcase.KeywordTestCase;
import org.squashtest.tm.domain.testcase.Parameter;
import org.squashtest.tm.domain.testcase.ParameterAssignationMode;
import org.squashtest.tm.domain.testcase.ScriptedTestCase;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestCaseImportance;
import org.squashtest.tm.domain.testcase.TestCaseKind;
import org.squashtest.tm.domain.testcase.TestCaseStatus;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.dto.pivotdefinition.testcaseworkspace.TestCasePivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.testcaseworkspace.testcasepart.ActionStepPivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.testcaseworkspace.testcasepart.CalledTestCasesPivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.testcaseworkspace.testcasepart.DatasetParamPivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.testcaseworkspace.testcasepart.DatasetPivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.testcaseworkspace.testcasepart.KeywordPivot;
import org.squashtest.tm.service.internal.dto.projectimporter.PivotImportMetadata;
import org.squashtest.tm.service.internal.pivot.converters.TestCasePivotConverterServiceImpl$AjcClosure1;
import org.squashtest.tm.service.internal.pivot.converters.TestCasePivotConverterServiceImpl$AjcClosure11;
import org.squashtest.tm.service.internal.pivot.converters.TestCasePivotConverterServiceImpl$AjcClosure13;
import org.squashtest.tm.service.internal.pivot.converters.TestCasePivotConverterServiceImpl$AjcClosure15;
import org.squashtest.tm.service.internal.pivot.converters.TestCasePivotConverterServiceImpl$AjcClosure17;
import org.squashtest.tm.service.internal.pivot.converters.TestCasePivotConverterServiceImpl$AjcClosure19;
import org.squashtest.tm.service.internal.pivot.converters.TestCasePivotConverterServiceImpl$AjcClosure21;
import org.squashtest.tm.service.internal.pivot.converters.TestCasePivotConverterServiceImpl$AjcClosure3;
import org.squashtest.tm.service.internal.pivot.converters.TestCasePivotConverterServiceImpl$AjcClosure5;
import org.squashtest.tm.service.internal.pivot.converters.TestCasePivotConverterServiceImpl$AjcClosure7;
import org.squashtest.tm.service.internal.pivot.converters.TestCasePivotConverterServiceImpl$AjcClosure9;
import org.squashtest.tm.service.pivot.converters.TestCasePivotConverterService;
import org.squashtest.tm.service.pivot.projectexporter.dao.TestCasePivotDao;
import org.squashtest.tm.service.testcase.ParameterFinder;

@Service
public class TestCasePivotConverterServiceImpl
implements TestCasePivotConverterService {
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;

    @Override
    public TestCase pivotToTestCase(TestCasePivot testCasePivot, PivotImportMetadata pivotImportMetadata) {
        TestCase testCase = switch (testCasePivot.getTestCaseKind()) {
            case TestCaseKind.STANDARD -> this.toStandardTestCase(testCasePivot);
            case TestCaseKind.KEYWORD -> this.toKeywordTestCase(testCasePivot);
            case TestCaseKind.GHERKIN -> this.toGherkinTestCase(testCasePivot);
            case TestCaseKind.EXPLORATORY -> this.toExploratoryTestCase(testCasePivot);
            default -> throw new MatchException(null, null);
        };
        this.addCommonPartTestCase(testCasePivot, testCase, pivotImportMetadata);
        return testCase;
    }

    private void addCommonPartTestCase(TestCasePivot testCasePivot, TestCase testCase, PivotImportMetadata pivotImportMetadata) {
        TestCasePivot testCasePivot2 = testCasePivot;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)testCasePivot2);
        Object[] objectArray = new Object[]{this, testCasePivot2, joinPoint};
        TestCasePivotConverterServiceImpl$AjcClosure1 testCasePivotConverterServiceImpl$AjcClosure1 = new TestCasePivotConverterServiceImpl$AjcClosure1(objectArray);
        testCase.setDescription((String)CleanHtmlAspect.aspectOf().aroundCleanHtmlMethodExecution(testCasePivotConverterServiceImpl$AjcClosure1.linkClosureAndJoinPoint(4112)));
        Optional.ofNullable(testCasePivot.getReference()).ifPresent(arg_0 -> ((TestCase)testCase).setReference(arg_0));
        Optional.ofNullable(testCasePivot.getImportance()).ifPresent(arg_0 -> ((TestCase)testCase).setImportance(arg_0));
        Optional.ofNullable(testCasePivot.getStatus()).ifPresent(arg_0 -> ((TestCase)testCase).setStatus(arg_0));
        testCase.setCreatedBy(testCasePivot.getCreatedBy());
        testCase.setCreatedOn(testCasePivot.getCreatedOn());
        if (Objects.nonNull(testCasePivot.getNatureCode()) && pivotImportMetadata.getPivotOptions().isImportInfoList()) {
            testCase.setNature((InfoListItem)new ListItemReference(testCasePivot.getNatureCode()));
        }
        if (Objects.nonNull(testCasePivot.getTypeCode()) && pivotImportMetadata.getPivotOptions().isImportInfoList()) {
            testCase.setType((InfoListItem)new ListItemReference(testCasePivot.getTypeCode()));
        }
    }

    private TestCase toStandardTestCase(TestCasePivot testCasePivot) {
        TestCase testCase = new TestCase();
        testCase.setName(testCasePivot.getName());
        TestCasePivot testCasePivot2 = testCasePivot;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)testCasePivot2);
        Object[] objectArray = new Object[]{this, testCasePivot2, joinPoint};
        TestCasePivotConverterServiceImpl$AjcClosure3 testCasePivotConverterServiceImpl$AjcClosure3 = new TestCasePivotConverterServiceImpl$AjcClosure3(objectArray);
        if (Objects.nonNull((String)CleanHtmlAspect.aspectOf().aroundCleanHtmlMethodExecution(testCasePivotConverterServiceImpl$AjcClosure3.linkClosureAndJoinPoint(4112)))) {
            TestCasePivot testCasePivot3 = testCasePivot;
            JoinPoint joinPoint2 = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)testCasePivot3);
            Object[] objectArray2 = new Object[]{this, testCasePivot3, joinPoint2};
            TestCasePivotConverterServiceImpl$AjcClosure5 testCasePivotConverterServiceImpl$AjcClosure5 = new TestCasePivotConverterServiceImpl$AjcClosure5(objectArray2);
            testCase.setPrerequisite((String)CleanHtmlAspect.aspectOf().aroundCleanHtmlMethodExecution(testCasePivotConverterServiceImpl$AjcClosure5.linkClosureAndJoinPoint(4112)));
        }
        return testCase;
    }

    private KeywordTestCase toKeywordTestCase(TestCasePivot testCasePivot) {
        KeywordTestCase testCase = new KeywordTestCase();
        testCase.setName(testCasePivot.getName());
        return testCase;
    }

    private ScriptedTestCase toGherkinTestCase(TestCasePivot testCasePivot) {
        ScriptedTestCase testCase = new ScriptedTestCase(testCasePivot.getName());
        if (Objects.nonNull(testCasePivot.getScript())) {
            testCase.setScript(testCasePivot.getScript());
        }
        return testCase;
    }

    private TestCase toExploratoryTestCase(TestCasePivot testCasePivot) {
        ExploratoryTestCase testCase = new ExploratoryTestCase();
        testCase.setName(testCasePivot.getName());
        TestCasePivot testCasePivot2 = testCasePivot;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)testCasePivot2);
        Object[] objectArray = new Object[]{this, testCasePivot2, joinPoint};
        TestCasePivotConverterServiceImpl$AjcClosure7 testCasePivotConverterServiceImpl$AjcClosure7 = new TestCasePivotConverterServiceImpl$AjcClosure7(objectArray);
        if (Objects.nonNull((String)CleanHtmlAspect.aspectOf().aroundCleanHtmlMethodExecution(testCasePivotConverterServiceImpl$AjcClosure7.linkClosureAndJoinPoint(4112)))) {
            TestCasePivot testCasePivot3 = testCasePivot;
            JoinPoint joinPoint2 = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)testCasePivot3);
            Object[] objectArray2 = new Object[]{this, testCasePivot3, joinPoint2};
            TestCasePivotConverterServiceImpl$AjcClosure9 testCasePivotConverterServiceImpl$AjcClosure9 = new TestCasePivotConverterServiceImpl$AjcClosure9(objectArray2);
            testCase.setCharter((String)CleanHtmlAspect.aspectOf().aroundCleanHtmlMethodExecution(testCasePivotConverterServiceImpl$AjcClosure9.linkClosureAndJoinPoint(4112)));
        }
        testCase.setSessionDuration(testCasePivot.getSessionDuration());
        return testCase;
    }

    @Override
    public Parameter pivotToDatasetParameter(DatasetParamPivot datasetParamPivot) {
        Parameter parameter = new Parameter();
        parameter.setName(datasetParamPivot.getName());
        DatasetParamPivot datasetParamPivot2 = datasetParamPivot;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)datasetParamPivot2);
        Object[] objectArray = new Object[]{this, datasetParamPivot2, joinPoint};
        TestCasePivotConverterServiceImpl$AjcClosure11 testCasePivotConverterServiceImpl$AjcClosure11 = new TestCasePivotConverterServiceImpl$AjcClosure11(objectArray);
        if (Objects.nonNull((String)CleanHtmlAspect.aspectOf().aroundCleanHtmlMethodExecution(testCasePivotConverterServiceImpl$AjcClosure11.linkClosureAndJoinPoint(4112)))) {
            DatasetParamPivot datasetParamPivot3 = datasetParamPivot;
            JoinPoint joinPoint2 = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)datasetParamPivot3);
            Object[] objectArray2 = new Object[]{this, datasetParamPivot3, joinPoint2};
            TestCasePivotConverterServiceImpl$AjcClosure13 testCasePivotConverterServiceImpl$AjcClosure13 = new TestCasePivotConverterServiceImpl$AjcClosure13(objectArray2);
            parameter.setDescription((String)CleanHtmlAspect.aspectOf().aroundCleanHtmlMethodExecution(testCasePivotConverterServiceImpl$AjcClosure13.linkClosureAndJoinPoint(4112)));
        }
        return parameter;
    }

    @Override
    public Dataset pivotToDataset(DatasetPivot datasetPivot, ParameterFinder parameterFinder, Map<String, Long> datasetParamIdsMap) {
        Dataset dataset = new Dataset();
        dataset.setName(datasetPivot.getName());
        List<Long> squashParamIds = datasetPivot.getParamValues().stream().map(value -> (Long)datasetParamIdsMap.get(value.getId())).toList();
        List<Parameter> parameters = parameterFinder.findByIds(squashParamIds);
        for (DatasetPivot.ParamValue value2 : datasetPivot.getParamValues()) {
            Long squashParamId = datasetParamIdsMap.get(value2.getId());
            Parameter parameter = parameters.stream().filter(p -> p.getId().equals(squashParamId)).findFirst().orElseThrow();
            new DatasetParamValue(parameter, dataset, value2.getValue());
        }
        return dataset;
    }

    @Override
    public ActionTestStep pivotToActionTestStep(ActionStepPivot actionStepPivot) {
        ActionTestStep actionTestStep = new ActionTestStep();
        ActionStepPivot actionStepPivot2 = actionStepPivot;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)actionStepPivot2);
        Object[] objectArray = new Object[]{this, actionStepPivot2, joinPoint};
        TestCasePivotConverterServiceImpl$AjcClosure15 testCasePivotConverterServiceImpl$AjcClosure15 = new TestCasePivotConverterServiceImpl$AjcClosure15(objectArray);
        if (Objects.nonNull((String)CleanHtmlAspect.aspectOf().aroundCleanHtmlMethodExecution(testCasePivotConverterServiceImpl$AjcClosure15.linkClosureAndJoinPoint(4112)))) {
            ActionStepPivot actionStepPivot3 = actionStepPivot;
            JoinPoint joinPoint2 = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)actionStepPivot3);
            Object[] objectArray2 = new Object[]{this, actionStepPivot3, joinPoint2};
            TestCasePivotConverterServiceImpl$AjcClosure17 testCasePivotConverterServiceImpl$AjcClosure17 = new TestCasePivotConverterServiceImpl$AjcClosure17(objectArray2);
            actionTestStep.setAction((String)CleanHtmlAspect.aspectOf().aroundCleanHtmlMethodExecution(testCasePivotConverterServiceImpl$AjcClosure17.linkClosureAndJoinPoint(4112)));
        }
        ActionStepPivot actionStepPivot4 = actionStepPivot;
        JoinPoint joinPoint3 = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)actionStepPivot4);
        Object[] objectArray3 = new Object[]{this, actionStepPivot4, joinPoint3};
        TestCasePivotConverterServiceImpl$AjcClosure19 testCasePivotConverterServiceImpl$AjcClosure19 = new TestCasePivotConverterServiceImpl$AjcClosure19(objectArray3);
        if (Objects.nonNull((String)CleanHtmlAspect.aspectOf().aroundCleanHtmlMethodExecution(testCasePivotConverterServiceImpl$AjcClosure19.linkClosureAndJoinPoint(4112)))) {
            ActionStepPivot actionStepPivot5 = actionStepPivot;
            JoinPoint joinPoint4 = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)actionStepPivot5);
            Object[] objectArray4 = new Object[]{this, actionStepPivot5, joinPoint4};
            TestCasePivotConverterServiceImpl$AjcClosure21 testCasePivotConverterServiceImpl$AjcClosure21 = new TestCasePivotConverterServiceImpl$AjcClosure21(objectArray4);
            actionTestStep.setExpectedResult((String)CleanHtmlAspect.aspectOf().aroundCleanHtmlMethodExecution(testCasePivotConverterServiceImpl$AjcClosure21.linkClosureAndJoinPoint(4112)));
        }
        return actionTestStep;
    }

    @Override
    public TestCasePivot testCaseRecordToTestCasePivot(Record record, Long projectId) {
        return switch (TestCaseKind.valueOf((String)((String)record.get(TestCasePivotDao.TC_KIND)))) {
            case TestCaseKind.STANDARD -> this.standardTestCaseRecordToTestCasePivot(record, projectId);
            case TestCaseKind.GHERKIN -> this.gherkinTestCaseRecordToTestCasePivot(record, projectId);
            case TestCaseKind.KEYWORD -> this.commonTestCaseRecordToTestCasePivot(record, TestCaseKind.KEYWORD, projectId);
            case TestCaseKind.EXPLORATORY -> this.exploratoryTestCaseRecordToTestCasePivot(record, projectId);
            default -> throw new MatchException(null, null);
        };
    }

    private TestCasePivot commonTestCaseRecordToTestCasePivot(Record record, TestCaseKind testCaseKind, Long projectId) {
        TestCasePivot testCasePivot = new TestCasePivot();
        testCasePivot.setTestCaseKind(testCaseKind);
        testCasePivot.setPivotId((Long)record.get((Field)Tables.TEST_CASE.TCLN_ID));
        testCasePivot.setName((String)record.get((Field)Tables.TEST_CASE_LIBRARY_NODE.NAME));
        testCasePivot.setDescription((String)record.get((Field)Tables.TEST_CASE_LIBRARY_NODE.DESCRIPTION));
        testCasePivot.setReference((String)record.get((Field)Tables.TEST_CASE.REFERENCE));
        testCasePivot.setStatus(TestCaseStatus.valueOf((String)((String)record.get((Field)Tables.TEST_CASE.TC_STATUS))));
        testCasePivot.setImportance(TestCaseImportance.valueOf((String)((String)record.get((Field)Tables.TEST_CASE.IMPORTANCE))));
        testCasePivot.getVerifiedRequirementVersions().addAll(this.getVerifiedRequirementVersionIds((String)record.get(TestCasePivotDao.TEST_CASE_COVERAGE_REQ_VERSION_IDS)));
        if (projectId.equals(record.get((Field)Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID))) {
            testCasePivot.setNatureCode((String)record.get(TestCasePivotDao.TC_NATURE));
            testCasePivot.setTypeCode((String)record.get(TestCasePivotDao.TC_TYPE));
            Long parentId = (Long)record.get((Field)Tables.TCLN_RELATIONSHIP.ANCESTOR_ID);
            if (Objects.isNull(parentId)) {
                testCasePivot.setParentType(EntityType.TEST_CASE_LIBRARY);
            } else {
                testCasePivot.setParentType(EntityType.TEST_CASE_FOLDER);
                testCasePivot.setParentId(parentId, "F");
            }
        } else {
            testCasePivot.setParentType(EntityType.TEST_CASE_FOLDER);
            testCasePivot.setParentIdGenerated((Long)record.get((Field)Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID), "F");
        }
        testCasePivot.setCreatedBy((String)record.get((Field)Tables.TEST_CASE_LIBRARY_NODE.CREATED_BY));
        testCasePivot.setCreatedOn((Date)record.get((Field)Tables.TEST_CASE_LIBRARY_NODE.CREATED_ON));
        testCasePivot.setLastModifiedBy((String)record.get((Field)Tables.TEST_CASE_LIBRARY_NODE.LAST_MODIFIED_BY));
        testCasePivot.setLastModifiedOn((Date)record.get((Field)Tables.TEST_CASE_LIBRARY_NODE.LAST_MODIFIED_ON));
        return testCasePivot;
    }

    private TestCasePivot gherkinTestCaseRecordToTestCasePivot(Record record, Long projectId) {
        TestCasePivot testCasePivot = this.commonTestCaseRecordToTestCasePivot(record, TestCaseKind.GHERKIN, projectId);
        testCasePivot.setScript((String)record.get((Field)Tables.SCRIPTED_TEST_CASE.SCRIPT));
        return testCasePivot;
    }

    private TestCasePivot exploratoryTestCaseRecordToTestCasePivot(Record record, Long projectId) {
        TestCasePivot testCasePivot = this.commonTestCaseRecordToTestCasePivot(record, TestCaseKind.EXPLORATORY, projectId);
        testCasePivot.setCharter((String)record.get((Field)Tables.EXPLORATORY_TEST_CASE.CHARTER));
        testCasePivot.setSessionDuration((Integer)record.get((Field)Tables.EXPLORATORY_TEST_CASE.SESSION_DURATION));
        return testCasePivot;
    }

    private TestCasePivot standardTestCaseRecordToTestCasePivot(Record record, Long projectId) {
        TestCasePivot testCasePivot = this.commonTestCaseRecordToTestCasePivot(record, TestCaseKind.STANDARD, projectId);
        testCasePivot.setPrerequisite((String)record.get((Field)Tables.TEST_CASE.PREREQUISITE));
        return testCasePivot;
    }

    @Override
    public KeywordPivot keywordStepRecordToKeywordPivot(Record record) {
        KeywordPivot keywordPivot = new KeywordPivot();
        keywordPivot.setPivotId((Long)record.get((Field)Tables.TEST_CASE_STEPS.STEP_ID));
        keywordPivot.setKeyword(Keyword.valueOf((String)((String)record.get((Field)Tables.KEYWORD_TEST_STEP.KEYWORD))));
        keywordPivot.setDocString((String)record.get((Field)Tables.KEYWORD_TEST_STEP.DOCSTRING));
        keywordPivot.setComment((String)record.get((Field)Tables.KEYWORD_TEST_STEP.COMMENT));
        keywordPivot.setDataTable((String)record.get((Field)Tables.KEYWORD_TEST_STEP.DATATABLE));
        keywordPivot.setActionWord((String)record.get(TestCasePivotDao.KEYWORD_STEP_VALUE));
        return keywordPivot;
    }

    @Override
    public ActionStepPivot actionStepRecordToActionStepPivot(Record record) {
        ActionStepPivot actionStepPivot = new ActionStepPivot();
        actionStepPivot.setPivotId((Long)record.get((Field)Tables.ACTION_TEST_STEP.TEST_STEP_ID));
        actionStepPivot.setAction((String)record.get((Field)Tables.ACTION_TEST_STEP.ACTION));
        actionStepPivot.setExpectedResult((String)record.get((Field)Tables.ACTION_TEST_STEP.EXPECTED_RESULT));
        actionStepPivot.getVerifiedRequirementVersions().addAll(this.getVerifiedRequirementVersionIds((String)record.get(TestCasePivotDao.TEST_STEP_COVERAGE_REQ_VERSION_IDS)));
        return actionStepPivot;
    }

    private List<String> getVerifiedRequirementVersionIds(String verifiedReqVersionIds) {
        if (Objects.nonNull(verifiedReqVersionIds)) {
            return Arrays.stream(verifiedReqVersionIds.split(",")).map(id -> String.format("%s%s", "RQV", id)).toList();
        }
        return List.of();
    }

    @Override
    public DatasetParamPivot datasetParamRecordToDatasetParamPivot(Record record) {
        DatasetParamPivot parameter = new DatasetParamPivot();
        parameter.setPivotId((Long)record.get((Field)Tables.PARAMETER.PARAM_ID));
        parameter.setName((String)record.get((Field)Tables.PARAMETER.NAME));
        parameter.setDescription((String)record.get((Field)Tables.PARAMETER.DESCRIPTION));
        return parameter;
    }

    @Override
    public DatasetPivot datasetRecordToDatasetPivot(Record record) {
        DatasetPivot datasetPivot = new DatasetPivot();
        datasetPivot.setPivotId((Long)record.get((Field)Tables.DATASET.DATASET_ID));
        datasetPivot.setName((String)record.get((Field)Tables.DATASET.NAME));
        return datasetPivot;
    }

    @Override
    public DatasetPivot.ParamValue datasetParamValueRecordToDatasetParamValuePivot(Record record) {
        if (record.get((Field)Tables.DATASET_PARAM_VALUE.PARAM_ID) == null) {
            return null;
        }
        DatasetPivot.ParamValue paramValue = new DatasetPivot.ParamValue();
        paramValue.setId((Long)record.get((Field)Tables.DATASET_PARAM_VALUE.PARAM_ID));
        paramValue.setValue((String)record.get((Field)Tables.DATASET_PARAM_VALUE.PARAM_VALUE));
        return paramValue;
    }

    @Override
    public CalledTestCasesPivot calledTestCaseRecordToCalledTestCasePivot(Record record) {
        CalledTestCasesPivot calledTestCasesPivot = new CalledTestCasesPivot();
        calledTestCasesPivot.setPivotId((Long)record.get((Field)Tables.TEST_CASE_STEPS.STEP_ID));
        calledTestCasesPivot.setIndex((Integer)record.get((Field)Tables.TEST_CASE_STEPS.STEP_ORDER));
        calledTestCasesPivot.setCallerId((Long)record.get((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID));
        calledTestCasesPivot.setCalledId((Long)record.get((Field)Tables.CALL_TEST_STEP.CALLED_TEST_CASE_ID));
        boolean delegateParameterValue = (Boolean)record.get((Field)Tables.CALL_TEST_STEP.DELEGATE_PARAMETER_VALUES);
        Long calledDatasetId = (Long)record.get((Field)Tables.CALL_TEST_STEP.CALLED_DATASET);
        if (calledDatasetId == null) {
            if (delegateParameterValue) {
                calledTestCasesPivot.setParameterAssignationMode(ParameterAssignationMode.DELEGATE);
            } else {
                calledTestCasesPivot.setParameterAssignationMode(ParameterAssignationMode.NOTHING);
            }
        } else {
            calledTestCasesPivot.setDatasetId(calledDatasetId);
            calledTestCasesPivot.setParameterAssignationMode(ParameterAssignationMode.CALLED_DATASET);
        }
        return calledTestCasesPivot;
    }

    static {
        TestCasePivotConverterServiceImpl.ajc$preClinit();
    }

    static final /* synthetic */ String getDescription_aroundBody0(TestCasePivotConverterServiceImpl testCasePivotConverterServiceImpl, TestCasePivot testCasePivot, JoinPoint joinPoint) {
        return testCasePivot.getDescription();
    }

    static final /* synthetic */ String getPrerequisite_aroundBody2(TestCasePivotConverterServiceImpl testCasePivotConverterServiceImpl, TestCasePivot testCasePivot, JoinPoint joinPoint) {
        return testCasePivot.getPrerequisite();
    }

    static final /* synthetic */ String getPrerequisite_aroundBody4(TestCasePivotConverterServiceImpl testCasePivotConverterServiceImpl, TestCasePivot testCasePivot, JoinPoint joinPoint) {
        return testCasePivot.getPrerequisite();
    }

    static final /* synthetic */ String getCharter_aroundBody6(TestCasePivotConverterServiceImpl testCasePivotConverterServiceImpl, TestCasePivot testCasePivot, JoinPoint joinPoint) {
        return testCasePivot.getCharter();
    }

    static final /* synthetic */ String getCharter_aroundBody8(TestCasePivotConverterServiceImpl testCasePivotConverterServiceImpl, TestCasePivot testCasePivot, JoinPoint joinPoint) {
        return testCasePivot.getCharter();
    }

    static final /* synthetic */ String getDescription_aroundBody10(TestCasePivotConverterServiceImpl testCasePivotConverterServiceImpl, DatasetParamPivot datasetParamPivot, JoinPoint joinPoint) {
        return datasetParamPivot.getDescription();
    }

    static final /* synthetic */ String getDescription_aroundBody12(TestCasePivotConverterServiceImpl testCasePivotConverterServiceImpl, DatasetParamPivot datasetParamPivot, JoinPoint joinPoint) {
        return datasetParamPivot.getDescription();
    }

    static final /* synthetic */ String getAction_aroundBody14(TestCasePivotConverterServiceImpl testCasePivotConverterServiceImpl, ActionStepPivot actionStepPivot, JoinPoint joinPoint) {
        return actionStepPivot.getAction();
    }

    static final /* synthetic */ String getAction_aroundBody16(TestCasePivotConverterServiceImpl testCasePivotConverterServiceImpl, ActionStepPivot actionStepPivot, JoinPoint joinPoint) {
        return actionStepPivot.getAction();
    }

    static final /* synthetic */ String getExpectedResult_aroundBody18(TestCasePivotConverterServiceImpl testCasePivotConverterServiceImpl, ActionStepPivot actionStepPivot, JoinPoint joinPoint) {
        return actionStepPivot.getExpectedResult();
    }

    static final /* synthetic */ String getExpectedResult_aroundBody20(TestCasePivotConverterServiceImpl testCasePivotConverterServiceImpl, ActionStepPivot actionStepPivot, JoinPoint joinPoint) {
        return actionStepPivot.getExpectedResult();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("TestCasePivotConverterServiceImpl.java", TestCasePivotConverterServiceImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("1", "getDescription", "org.squashtest.tm.service.internal.dto.pivotdefinition.testcaseworkspace.TestCasePivot", "", "", "", "java.lang.String"), 89);
        ajc$tjp_1 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("1", "getPrerequisite", "org.squashtest.tm.service.internal.dto.pivotdefinition.testcaseworkspace.TestCasePivot", "", "", "", "java.lang.String"), 111);
        ajc$tjp_10 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("1", "getExpectedResult", "org.squashtest.tm.service.internal.dto.pivotdefinition.testcaseworkspace.testcasepart.ActionStepPivot", "", "", "", "java.lang.String"), 187);
        ajc$tjp_2 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("1", "getPrerequisite", "org.squashtest.tm.service.internal.dto.pivotdefinition.testcaseworkspace.TestCasePivot", "", "", "", "java.lang.String"), 112);
        ajc$tjp_3 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("1", "getCharter", "org.squashtest.tm.service.internal.dto.pivotdefinition.testcaseworkspace.TestCasePivot", "", "", "", "java.lang.String"), 136);
        ajc$tjp_4 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("1", "getCharter", "org.squashtest.tm.service.internal.dto.pivotdefinition.testcaseworkspace.TestCasePivot", "", "", "", "java.lang.String"), 137);
        ajc$tjp_5 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("1", "getDescription", "org.squashtest.tm.service.internal.dto.pivotdefinition.testcaseworkspace.testcasepart.DatasetParamPivot", "", "", "", "java.lang.String"), 148);
        ajc$tjp_6 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("1", "getDescription", "org.squashtest.tm.service.internal.dto.pivotdefinition.testcaseworkspace.testcasepart.DatasetParamPivot", "", "", "", "java.lang.String"), 149);
        ajc$tjp_7 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("1", "getAction", "org.squashtest.tm.service.internal.dto.pivotdefinition.testcaseworkspace.testcasepart.ActionStepPivot", "", "", "", "java.lang.String"), 182);
        ajc$tjp_8 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("1", "getAction", "org.squashtest.tm.service.internal.dto.pivotdefinition.testcaseworkspace.testcasepart.ActionStepPivot", "", "", "", "java.lang.String"), 183);
        ajc$tjp_9 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("1", "getExpectedResult", "org.squashtest.tm.service.internal.dto.pivotdefinition.testcaseworkspace.testcasepart.ActionStepPivot", "", "", "", "java.lang.String"), 186);
    }
}

