/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.logging;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.springframework.stereotype.Component;

@Component
public class Log4jLoggerLevelModifier {
    public void setLogLevel(String loggerName, String level) {
        LoggerContext ctxt = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration conf = ctxt.getConfiguration();
        LoggerConfig logConf = conf.getLoggerConfig(loggerName);
        if ("trace".equalsIgnoreCase(level)) {
            logConf.setLevel(Level.TRACE);
        } else if ("debug".equalsIgnoreCase(level)) {
            logConf.setLevel(Level.DEBUG);
        } else if ("info".equalsIgnoreCase(level)) {
            logConf.setLevel(Level.INFO);
        } else if ("error".equalsIgnoreCase(level)) {
            logConf.setLevel(Level.ERROR);
        } else if ("fatal".equalsIgnoreCase(level)) {
            logConf.setLevel(Level.FATAL);
        } else if ("warn".equalsIgnoreCase(level)) {
            logConf.setLevel(Level.WARN);
        }
        ctxt.updateLoggers(conf);
    }

    public void setTraceLevel(String logger) {
        this.setLogLevel(logger, "trace");
    }

    public void setDebugLevel(String logger) {
        this.setLogLevel(logger, "debug");
    }

    public void setInfoLevel(String logger) {
        this.setLogLevel(logger, "info");
    }

    public void setWarnLevel(String logger) {
        this.setLogLevel(logger, "warn");
    }

    public void setErrorLevel(String logger) {
        this.setLogLevel(logger, "error");
    }
}

