/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.library;

import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.hibernate.Session;
import org.squashtest.tm.domain.library.NodeContainer;
import org.squashtest.tm.domain.library.TreeNode;
import org.squashtest.tm.domain.project.GenericLibrary;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.requirement.Requirement;
import org.squashtest.tm.domain.requirement.RequirementCriticality;
import org.squashtest.tm.domain.requirement.RequirementFolder;
import org.squashtest.tm.domain.requirement.RequirementLibraryNode;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestCaseFactory;
import org.squashtest.tm.domain.testcase.TestCaseFolder;
import org.squashtest.tm.domain.testcase.TestCaseImportance;
import org.squashtest.tm.domain.testcase.TestCaseLibrary;
import org.squashtest.tm.service.annotation.CacheScope;
import org.squashtest.tm.service.clipboard.model.ClipboardPayload;
import org.squashtest.tm.service.internal.library.NextLayerFeeder;
import org.squashtest.tm.service.internal.library.NodePairing;
import org.squashtest.tm.service.internal.library.PasteOperation;
import org.squashtest.tm.service.internal.repository.EntityDao;
import org.squashtest.tm.service.testcase.TestCaseLibraryNavigationService;
import org.squashtest.tm.service.testcase.fromreq.ReqToTestCaseConfiguration;

public class PasteStrategy<CONTAINER extends NodeContainer<NODE>, NODE extends TreeNode> {
    private static final Integer WHATEVER_POSITION = null;
    private static final String RAWTYPES = "rawtypes";
    private static final String UNCHECKED = "unchecked";
    private Provider<? extends PasteOperation> nextLayersOperationFactory;
    private Provider<? extends PasteOperation> firstLayerOperationFactory;
    @Inject
    private Provider<NextLayerFeeder> nextLayerFeederOperationFactory;
    private PasteOperation firstOperation;
    private PasteOperation nextsOperation;
    private EntityDao<CONTAINER> containerDao;
    private Class<NODE> nodeType;
    @Inject
    private TestCaseLibraryNavigationService testCaseLibraryNavigationService;
    @PersistenceContext
    private EntityManager em;
    private List<NODE> outputList;
    private Collection<NodePairing> nextLayer;
    private Collection<NodePairing> sourceLayer;
    private boolean isReqMother = false;
    private List<NODE> pastedNodes;
    private ClipboardPayload clipboardPayload;

    public <R extends EntityDao<CONTAINER>> void setContainerDao(R containerDao) {
        this.containerDao = containerDao;
    }

    public void setNextLayersOperationFactory(Provider<? extends PasteOperation> nextLayersOperationFactory) {
        this.nextLayersOperationFactory = nextLayersOperationFactory;
    }

    public void setFirstLayerOperationFactory(Provider<? extends PasteOperation> firstLayerOperationFactory) {
        this.firstLayerOperationFactory = firstLayerOperationFactory;
    }

    public void setNextLayerFeederOperationFactory(Provider<NextLayerFeeder> nextLayerFeederOperationFactory) {
        this.nextLayerFeederOperationFactory = nextLayerFeederOperationFactory;
    }

    @CacheScope
    public List<NODE> pasteNodes(long containerId, ClipboardPayload clipboardPayload) {
        return this.internalPasteNodes(containerId, clipboardPayload, WHATEVER_POSITION);
    }

    @CacheScope
    public List<NODE> pasteReqToTestCasesNodes(long containerId, List<Long> list, ReqToTestCaseConfiguration configuration) {
        return this.internalReqToTestCasesPasteNodes(containerId, list, configuration, WHATEVER_POSITION);
    }

    @CacheScope
    public List<NODE> pasteNodes(long containerId, ClipboardPayload clipboardPayload, Integer position) {
        return this.internalPasteNodes(containerId, clipboardPayload, position);
    }

    private List<NODE> internalReqToTestCasesPasteNodes(long containerId, List<Long> list, ReqToTestCaseConfiguration configuration, Integer position) {
        this.initFromReqToTestCases(containerId, list);
        this.processFirstLayerFromReqToTc(position, configuration);
        while (!this.nextLayer.isEmpty()) {
            this.removeProcessedNodesFromCache();
            this.shiftToNextLayer();
            this.processLayerFromReqToTc(configuration);
        }
        this.reindexAfterCopy();
        return this.outputList;
    }

    private List<NODE> internalPasteNodes(long containerId, ClipboardPayload clipboardPayload, Integer position) {
        this.init(containerId, clipboardPayload);
        this.processFirstLayer(position);
        while (!this.nextLayer.isEmpty()) {
            this.removeProcessedNodesFromCache();
            this.shiftToNextLayer();
            this.processLayer();
        }
        this.reindexAfterCopy();
        return this.outputList;
    }

    private void init(long containerId, ClipboardPayload clipboardPayload) {
        this.firstOperation = this.createFirstLayerOperation();
        this.nextsOperation = this.createNextLayerOperation();
        this.outputList = new ArrayList<NODE>(clipboardPayload.getSelectedNodeIds().size());
        this.nextLayer = new ArrayList<NodePairing>();
        this.pastedNodes = new ArrayList<NODE>();
        this.clipboardPayload = clipboardPayload;
        this.sourceLayer = new HashSet<NodePairing>();
        NodeContainer container = (NodeContainer)this.containerDao.loadContainerForPaste(containerId);
        NodePairing pairing = new NodePairing((NodeContainer<TreeNode>)container);
        for (Long contentId : clipboardPayload.getSelectedNodeIds()) {
            TreeNode srcNode = (TreeNode)this.em.find(this.nodeType, (Object)contentId);
            pairing.addContent(srcNode);
        }
        this.sourceLayer.add(pairing);
    }

    private void initFromReqToTestCases(long containerId, List<Long> list) {
        this.firstOperation = this.createFirstLayerOperation();
        this.nextsOperation = this.createNextLayerOperation();
        this.outputList = new ArrayList<NODE>(list.size());
        this.nextLayer = new ArrayList<NodePairing>();
        this.pastedNodes = new ArrayList<NODE>();
        this.sourceLayer = new HashSet<NodePairing>();
        NodeContainer container = (NodeContainer)this.containerDao.findById(containerId);
        NodePairing pairing = new NodePairing((NodeContainer<TreeNode>)container);
        for (Long contentId : list) {
            RequirementLibraryNode srcNode = (RequirementLibraryNode)this.em.find(RequirementLibraryNode.class, (Object)contentId);
            pairing.addContent((TreeNode)srcNode);
        }
        this.sourceLayer.add(pairing);
    }

    private void shiftToNextLayer() {
        this.sourceLayer = this.nextLayer;
        this.nextLayer = new ArrayList<NodePairing>();
    }

    private void processFirstLayer(Integer position) {
        NodePairing pairing = this.sourceLayer.iterator().next();
        NodeContainer<TreeNode> container = pairing.getContainer();
        List<TreeNode> newContent = pairing.getNewContent();
        for (TreeNode srcNode : newContent) {
            TreeNode outputNode = this.firstOperation.performOperation(srcNode, container, position);
            this.outputList.add(outputNode);
            this.pastedNodes.add(outputNode);
            if (position != null) {
                position = position + 1;
            }
            if (!this.firstOperation.isOkToGoDeeper()) continue;
            this.appendNextLayerNodes(srcNode, outputNode);
        }
    }

    private void processFirstLayerFromReqToTc(Integer position, ReqToTestCaseConfiguration configuration) {
        NodePairing pairing = this.sourceLayer.iterator().next();
        NodeContainer<TreeNode> container = pairing.getContainer();
        List<TreeNode> newContent = pairing.getNewContent();
        for (TreeNode srcNode : newContent) {
            TreeNode transform = this.transform(srcNode, container, configuration);
            TreeNode outputNode = this.firstOperation.performOperationFromReqToTc(srcNode, transform, container, position);
            this.outputList.add(outputNode);
            this.pastedNodes.add(outputNode);
            if (position != null) {
                position = position + 1;
            }
            if (!this.firstOperation.isOkToGoDeeper()) continue;
            if (this.isReqMother) {
                TreeNode transformMother = this.transformReqMotherInReqFolder(srcNode, container);
                TreeNode outputMotherNode = this.firstOperation.performOperationFromReqToTc(srcNode, transformMother, container, position);
                this.outputList.add(outputMotherNode);
                this.pastedNodes.add(outputMotherNode);
                this.appendNextLayerNodesFromReqToTc(srcNode, outputMotherNode);
                continue;
            }
            this.appendNextLayerNodesFromReqToTc(srcNode, outputNode);
        }
    }

    private NODE transform(NODE srcNode, NodeContainer<TreeNode> destination, ReqToTestCaseConfiguration configuration) {
        this.isReqMother = false;
        RequirementLibraryNode reqNode = (RequirementLibraryNode)this.em.find(RequirementLibraryNode.class, (Object)srcNode.getId());
        if (reqNode instanceof Requirement) {
            Requirement req = (Requirement)reqNode;
            TestCase newTestCase = TestCaseFactory.getTestCase((String)configuration.getTestCaseKindAsString(), (String)req.getName());
            newTestCase.setImportanceAuto(Boolean.valueOf(true));
            newTestCase.setImportance(this.deduceImportanceFromRequirementCriticality(req.getCriticality()));
            newTestCase.setDescription(req.getDescription());
            newTestCase.setReference(req.getReference());
            newTestCase.notifyAssociatedWithProject((Project)destination.getProject());
            if (req.hasContent()) {
                this.isReqMother = true;
            }
            if (destination.getClass() == TestCaseLibrary.class) {
                this.testCaseLibraryNavigationService.addFromReqTestCaseToLibrary(destination.getId(), newTestCase, req.getCurrentVersion(), 0);
            } else if (destination.getClass() == TestCaseFolder.class) {
                this.testCaseLibraryNavigationService.addFromReqTestCaseToFolder(destination.getId(), newTestCase, req.getCurrentVersion(), 0);
            }
            return (NODE)newTestCase;
        }
        RequirementFolder folder = (RequirementFolder)reqNode;
        Long copiedAttachmentListId = folder.getAttachmentList().getId();
        TestCaseFolder tcFolder = new TestCaseFolder();
        tcFolder.setDescription(folder.getDescription());
        tcFolder.setName(folder.getName());
        tcFolder.notifyAssociatedWithProject((Project)destination.getProject());
        if (destination.getClass() == TestCaseLibrary.class) {
            this.testCaseLibraryNavigationService.addFromReqFolderToLibrary(destination.getId(), tcFolder, copiedAttachmentListId);
        } else if (destination.getClass() == TestCaseFolder.class) {
            this.testCaseLibraryNavigationService.addReqFolderToTcFolder(destination.getId(), tcFolder, copiedAttachmentListId);
        }
        this.em.flush();
        return (NODE)tcFolder;
    }

    private NODE transformReqMotherInReqFolder(NODE srcNode, NodeContainer<TreeNode> destination) {
        this.isReqMother = false;
        RequirementLibraryNode reqNode = (RequirementLibraryNode)this.em.find(RequirementLibraryNode.class, (Object)srcNode.getId());
        TestCaseFolder node = null;
        if (reqNode instanceof Requirement) {
            Requirement req = (Requirement)reqNode;
            Long attachmentListId = req.getAttachmentList().getId();
            TestCaseFolder tcFolder = new TestCaseFolder();
            tcFolder.setDescription(req.getDescription());
            tcFolder.setName(req.createFolderNameFromRequirement());
            tcFolder.notifyAssociatedWithProject((Project)destination.getProject());
            if (destination.getClass() == TestCaseLibrary.class) {
                this.testCaseLibraryNavigationService.addFromReqFolderToLibrary(destination.getId(), tcFolder, attachmentListId);
            } else if (destination.getClass() == TestCaseFolder.class) {
                this.testCaseLibraryNavigationService.addReqFolderToTcFolder(destination.getId(), tcFolder, attachmentListId);
            }
            node = tcFolder;
            this.em.flush();
        }
        return (NODE)node;
    }

    private void processLayer() {
        for (NodePairing pairing : this.sourceLayer) {
            NodeContainer<TreeNode> destination = pairing.getContainer();
            List<TreeNode> sources = pairing.getNewContent();
            for (TreeNode source : sources) {
                if (this.nodeWasAlreadyPasted(source)) continue;
                TreeNode outputNode = this.nextsOperation.performOperation(source, destination, WHATEVER_POSITION);
                this.pastedNodes.add(outputNode);
                if (!this.nextsOperation.isOkToGoDeeper()) continue;
                this.appendNextLayerNodes(source, outputNode);
            }
        }
    }

    private void processLayerFromReqToTc(ReqToTestCaseConfiguration configuration) {
        for (NodePairing pairing : this.sourceLayer) {
            NodeContainer<TreeNode> destination = pairing.getContainer();
            List<TreeNode> sources = pairing.getNewContent();
            for (TreeNode source : sources) {
                if (this.nodeWasAlreadyPasted(source)) continue;
                TreeNode transform = this.transform(source, destination, configuration);
                TreeNode outputNode = this.nextsOperation.performOperationFromReqToTc(source, transform, destination, WHATEVER_POSITION);
                if (!this.nextsOperation.isOkToGoDeeper()) continue;
                this.handleNextLayerNodesToAppend(destination, source, outputNode);
            }
        }
    }

    private void handleNextLayerNodesToAppend(NodeContainer<TreeNode> destination, TreeNode source, TreeNode outputNode) {
        if (this.isReqMother) {
            TreeNode transformMother = this.transformReqMotherInReqFolder(source, destination);
            TreeNode outputMotherNode = this.nextsOperation.performOperationFromReqToTc(source, transformMother, destination, WHATEVER_POSITION);
            this.appendNextLayerNodesFromReqToTc(source, outputMotherNode);
        } else {
            this.appendNextLayerNodesFromReqToTc(source, outputNode);
        }
    }

    private PasteOperation createNextLayerOperation() {
        return (PasteOperation)this.nextLayersOperationFactory.get();
    }

    private PasteOperation createFirstLayerOperation() {
        return (PasteOperation)this.firstLayerOperationFactory.get();
    }

    private void appendNextLayerNodes(TreeNode sourceNode, TreeNode destNode) {
        NextLayerFeeder feeder = (NextLayerFeeder)this.nextLayerFeederOperationFactory.get();
        feeder.feedNextLayer(destNode, sourceNode, this.nextLayer, this.outputList, this.clipboardPayload);
    }

    private void appendNextLayerNodesFromReqToTc(TreeNode sourceNode, TreeNode destNode) {
        NextLayerFeeder feeder = (NextLayerFeeder)this.nextLayerFeederOperationFactory.get();
        feeder.feedNextLayerFromReqToTc(destNode, sourceNode, this.nextLayer, this.outputList);
    }

    private void reindexAfterCopy() {
        ((Session)this.em.unwrap(Session.class)).flush();
    }

    private void removeProcessedNodesFromCache() {
        this.em.flush();
        HashSet<TreeNode> nextNodes = new HashSet<TreeNode>();
        for (NodePairing nextPairing : this.nextLayer) {
            nextNodes.add((TreeNode)nextPairing.getContainer());
            nextNodes.addAll(nextPairing.getNewContent());
        }
        Session session = (Session)this.em.unwrap(Session.class);
        for (NodePairing processed : this.sourceLayer) {
            HashSet<Object> toEvict = new HashSet<Object>();
            toEvict.add(processed.getContainer());
            toEvict.addAll(processed.getNewContent());
            for (Object e : toEvict) {
                if (nextNodes.contains(e) || GenericLibrary.class.isAssignableFrom(e.getClass())) continue;
                session.evict(e);
            }
        }
    }

    public void setNodeType(Class<NODE> nodeType) {
        this.nodeType = nodeType;
    }

    public TestCaseImportance deduceImportanceFromRequirementCriticality(RequirementCriticality requirementCriticality) {
        TestCaseImportance testCaseImportance = TestCaseImportance.LOW;
        if (RequirementCriticality.CRITICAL.equals((Object)requirementCriticality)) {
            testCaseImportance = TestCaseImportance.HIGH;
        } else if (RequirementCriticality.MAJOR.equals((Object)requirementCriticality)) {
            testCaseImportance = TestCaseImportance.MEDIUM;
        }
        return testCaseImportance;
    }

    private boolean nodeWasAlreadyPasted(NODE node) {
        return this.pastedNodes.stream().anyMatch(item -> {
            boolean sameId = item.getId().equals(node.getId());
            boolean assignableFrom = item.getClass().isAssignableFrom(node.getClass());
            return sameId && assignableFrom;
        });
    }
}

